/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.events;

import ancestris.reports.FilterOptions;
import ancestris.reports.FormatAgeOptions;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingIcsOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.PropUtils;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.PropertySource;
import genj.gedcom.Source;
import genj.gedcom.time.PointInTime;
import genj.option.Multiline;
import genj.option.Sorter;
import genj.report.Report;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.IntStream;
import org.openide.util.NbBundle;

public class ReportEvents
extends Report {
    public MyFormattingOptions formattingOptions = new MyFormattingOptions();
    public ScopeIndiOptions scope = new ScopeIndiOptions();
    @Multiline
    public int[] eventSelector = IntStream.range(0, EVENTS.length).toArray();
    public String[] eventSelectors = EVENTS;
    public boolean reportDesc = true;
    public boolean reportType = true;
    public boolean reportDate = true;
    public boolean reportPlace = true;
    public boolean reportEntity = true;
    public boolean reportAge = true;
    public boolean reportSource = true;
    public Sorter sorter = new Sorter((Object[])SORT_FIELD_NAMES);
    public FilterOptions filterOptions = new FilterOptions();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    public SimpleColorsOptions colors = new SimpleColorsOptions();
    private Document doc;
    private Gedcom gedcom;
    private static final String SPAN_ALL = "number-columns-spanned=";
    private static final String[] EVENTS = (String[])PropUtils.getEventNames().toArray(String[]::new);
    private static final String[] SORT_FIELD_NAMES = new String[]{NbBundle.getMessage(ReportEvents.class, (String)"descriptionLabel"), Gedcom.getName((String)"TYPE"), Gedcom.getName((String)"DATE"), Gedcom.getName((String)"PLAC")};
    private Map<Integer, Integer> map;
    private boolean[] sort_field_displays;

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Fam || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        List<Indi> indis = this.scope.getScope(gedcom, this);
        return indis != null ? this.start((Indi[])indis.toArray(Indi[]::new)) : null;
    }

    public Document start(Entity entity) {
        this.gedcom = entity.getGedcom();
        List<Indi> indis = this.scope.getScope(entity, this);
        return this.start((Indi[])indis.toArray(Indi[]::new));
    }

    public Document start(Indi[] indis) {
        if (indis.length == 0) {
            return null;
        }
        this.gedcom = indis[0].getGedcom();
        ArrayList events = new ArrayList();
        HashSet<Fam> seen = new HashSet<Fam>();
        for (Indi indi : indis) {
            events.addAll(indi.getProperties(PropertyEventDetails.class));
            for (Fam fam : indi.getFamiliesWhereSpouse()) {
                if (seen.contains(fam)) continue;
                events.addAll(fam.getProperties(PropertyEventDetails.class));
                seen.add(fam);
            }
        }
        return this.main(events);
    }

    public Document main(List<? extends Property> events) {
        String entityLabel = this.translate("entityLabel");
        String ageLabel = Gedcom.getName((String)"AGE");
        String sourceLabel = Gedcom.getName((String)"SOUR");
        this.sort_field_displays = new boolean[]{this.reportDesc, this.reportType, this.reportDate, this.reportPlace};
        this.map = this.sorter.getMap((Object[])SORT_FIELD_NAMES);
        String header_row = this.colors.getHeaderRowColor();
        String even_row = this.colors.getEvenRowColor();
        String odd_row = this.colors.getOddRowColor();
        String textColor = this.colors.getTextColor();
        String backColor = this.colors.getBackgroundColor();
        ArrayList<Event> records = new ArrayList<Event>();
        String selectedEventsFilter = PropUtils.getEventTags(this.eventSelector);
        for (Property property : events) {
            Event record;
            if (!property.isEvent() || !(property instanceof PropertyEventDetails)) continue;
            PropertyEventDetails pEvent = (PropertyEventDetails)property;
            if (!property.getTag().matches(selectedEventsFilter) || !this.filterOptions.matchRecord(property, (record = new Event(pEvent)).getEntityString(), record.toString())) continue;
            records.add(record);
        }
        Collections.sort(records);
        if (this.formattingOptions.ics.isOutputICal) {
            this.formattingOptions.ics.createFile(this, "ReportEvents", this.formattingOptions.common.internalOutput, records);
            return null;
        }
        String number = "" + records.size();
        String string = this.translate("title", new Object[]{number, this.gedcom.getDisplayName()});
        this.doc = this.formattingOptions.common.createDocument(this.translate("name"), textColor, backColor);
        this.doc.startSection(string, "title", 1, false, false, "font-size=" + this.formattingOptions.common.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.formattingOptions.common.includeTOC) {
            this.doc.addTOC(2, false, false);
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.scope.isLimited()) {
            this.doc.addText(this.scope.getMainMessage(), "font-weight=bold");
            for (String[] scopeLine : this.scope.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + scopeLine[0]);
                if (scopeLine[1].isBlank()) continue;
                this.doc.addText(" : " + scopeLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.filterOptions.isFilterOn()) {
            this.doc.addText(this.filterOptions.getMainMessage(), "font-weight=bold");
            for (String[] filterLine : this.filterOptions.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + filterLine[0]);
                if (filterLine[1].isBlank()) continue;
                this.doc.addText(" : " + filterLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=1cm, border-color=" + textColor);
        int nbColumns = this.getNbColumns();
        if (nbColumns == 0) {
            DialogManager.createError((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"OptionError"), (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ErrorNoColumnSelected")).show();
            return null;
        }
        String spanAll = SPAN_ALL + nbColumns;
        int row = 0;
        String tag = "";
        for (Event event : records) {
            String newTag = event.getTag();
            if (!newTag.equals(tag)) {
                tag = newTag;
                this.doc.nextTableRow();
                this.doc.nextTableCell(spanAll + ", height=48px");
                int counter = this.getRecordsCount(records, event.getName());
                String eventTitle = event.getName() + " (" + counter + ")";
                if (this.formattingOptions.common.includeTOC) {
                    this.doc.addTOCEntry(eventTitle);
                    this.doc.nextParagraph();
                    this.doc.addLink("^^^", "title");
                }
                this.doc.nextTableRow("font-size=" + (this.formattingOptions.common.getTextSize() + 2) + ", text-align=center, font-weight=bold, background-color=" + header_row);
                this.doc.nextTableCell(spanAll);
                this.doc.addText(eventTitle);
                this.doc.nextTableRow("font-size=" + (this.formattingOptions.common.getTextSize() + 2) + ", text-align=center, font-weight=bold, background-color=" + header_row);
                for (int col = 0; col < this.map.size(); ++col) {
                    if (!this.sort_field_displays[this.map.get(col)]) continue;
                    this.displayLabel(SORT_FIELD_NAMES[this.map.get(col)]);
                }
                if (this.reportEntity) {
                    this.doc.nextTableCell();
                    this.doc.addText(entityLabel);
                }
                if (this.reportAge) {
                    this.doc.nextTableCell();
                    this.doc.addText(ageLabel);
                }
                if (this.reportSource) {
                    this.doc.nextTableCell();
                    this.doc.addText(sourceLabel);
                }
                row = 0;
            }
            String bgColor = row % 2 == 0 ? even_row : odd_row;
            ++row;
            this.doc.nextTableRow("background-color=" + bgColor);
            for (int col = 0; col < this.map.size(); ++col) {
                if (!this.sort_field_displays[this.map.get(col)]) continue;
                this.displayValue(event, this.map.get(col));
            }
            if (this.reportEntity) {
                this.doc.nextTableCell();
                this.doc.addText(event.getEntityString() + " ");
                this.doc.addLink("(" + event.getId() + ")", event.event.getLinkAnchor());
            }
            if (this.reportAge) {
                this.doc.nextTableCell("text-align=center");
                this.doc.addText(event.getAge());
            }
            if (!this.reportSource) continue;
            this.doc.nextTableCell();
            this.doc.addText(event.getSource());
            if (!event.sourceExists()) continue;
            this.doc.addText(" ");
            this.doc.addLink("(" + event.getSourceId() + ")", event.source.getLinkAnchor());
        }
        this.doc.endTable();
        return this.doc;
    }

    private void displayLabel(String label) {
        this.doc.nextTableCell();
        this.doc.addText(label);
    }

    private void displayValue(Event event, int index) {
        switch (index) {
            case 0: {
                this.doc.nextTableCell();
                this.doc.addText(event.getDescription());
                break;
            }
            case 1: {
                this.doc.nextTableCell();
                this.doc.addText(event.getType());
                break;
            }
            case 2: {
                this.doc.nextTableCell("text-align=center");
                this.doc.addText(event.getDate());
                break;
            }
            case 3: {
                this.doc.nextTableCell("text-align=center");
                this.doc.addText(event.getPlace());
                break;
            }
        }
    }

    private int getRecordsCount(List<Event> records, String name) {
        int counter = 0;
        for (Event record : records) {
            if (!record.getName().equals(name)) continue;
            ++counter;
        }
        return counter;
    }

    private int getNbColumns() {
        int ret = 0;
        ret += this.reportDesc ? 1 : 0;
        ret += this.reportType ? 1 : 0;
        ret += this.reportDate ? 1 : 0;
        ret += this.reportPlace ? 1 : 0;
        ret += this.reportEntity ? 1 : 0;
        ret += this.reportAge ? 1 : 0;
        return ret += this.reportSource ? 1 : 0;
    }

    public class MyFormattingOptions {
        public FormattingOptions common = new FormattingOptions();
        public FormattingIcsOptions ics = new FormattingIcsOptions();
    }

    public class MyDataFormatOptions {
        public FormatPlaceOptions place = new FormatPlaceOptions();
        public FormatDateOptions date = new FormatDateOptions();
        public FormatAgeOptions age = new FormatAgeOptions();
    }

    private class Event
    implements Comparable<Event>,
    FormattingIcsOptions.CalendarRecord {
        private final PropertyEventDetails event;
        private final String tag;
        private final String name;
        private final String description;
        private final String type;
        private final String date;
        private final String place;
        private boolean isPrecise;
        private final Entity entity;
        private final Source source;
        private final String age;
        private final PointInTime pit;

        private Event(PropertyEventDetails event) {
            PropertySource pSource;
            this.event = event;
            this.tag = event.getTag();
            this.name = Gedcom.getName((String)this.tag);
            this.description = event.getDisplayValue();
            Property p = event.getProperty("TYPE");
            this.type = p != null ? p.getDisplayValue() : "";
            PropertyDate pDate = event.getDate();
            this.date = ReportEvents.this.dataFormatOptions.date.getDate((Property)pDate);
            if (pDate != null && pDate instanceof PropertyDate) {
                PropertyDate ptyDate = pDate;
                this.pit = ptyDate.getStart();
                this.isPrecise = ptyDate.getFormat().toString().isEmpty();
            } else {
                this.pit = null;
                this.isPrecise = false;
            }
            this.age = ReportEvents.this.dataFormatOptions.age.getAge((Property)event);
            this.place = ReportEvents.this.dataFormatOptions.place.getPlace(event.getProperty("PLAC"));
            this.entity = event.getEntity();
            Property sour = event.getProperty("SOUR");
            this.source = sour instanceof PropertySource && (pSource = (PropertySource)sour).getTarget().isValid() && pSource.getTargetEntity().isPresent() ? (Source)pSource.getTargetEntity().get() : null;
        }

        private String getTag() {
            return this.tag;
        }

        @Override
        public Entity getEntity() {
            return this.entity;
        }

        @Override
        public PropertyEventDetails getProperty() {
            return this.event;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDate() {
            return this.date;
        }

        @Override
        public PointInTime getPit() {
            return this.pit;
        }

        @Override
        public String getPlace() {
            return this.place;
        }

        @Override
        public boolean isDatePrecise() {
            return this.isPrecise;
        }

        private String getDescription() {
            return this.description;
        }

        private String getType() {
            return this.type;
        }

        private String getEntityString() {
            return this.entity.getDisplayTitle(false);
        }

        private String getId() {
            return this.entity.getId();
        }

        private String getAge() {
            return this.age;
        }

        private String getSource() {
            return this.source != null ? this.source.getDisplayTitle(false) : "";
        }

        private boolean sourceExists() {
            return this.source != null;
        }

        private String getSourceId() {
            return this.source != null ? this.source.getId() : "";
        }

        @Override
        public int compareTo(Event other) {
            if (!this.name.equals(other.name)) {
                return Utilities.removeDiacriticsLower((String)this.name).compareTo(Utilities.removeDiacriticsLower((String)other.name));
            }
            for (int col = 0; col < ReportEvents.this.map.size(); ++col) {
                Integer index = ReportEvents.this.map.get(col);
                if (!ReportEvents.this.sort_field_displays[index] || this.getValue(this, index).equals(this.getValue(other, index))) continue;
                return this.sort(this, other, index);
            }
            return Utilities.removeDiacriticsLower((String)this.getEntityString()).compareTo(Utilities.removeDiacriticsLower((String)other.getEntityString()));
        }

        private String getValue(Event event, int index) {
            switch (index) {
                case 0: {
                    return event.getDescription();
                }
                case 1: {
                    return event.getType();
                }
                case 2: {
                    return event.getDate();
                }
                case 3: {
                    return event.getPlace();
                }
            }
            return "";
        }

        private int sort(Event e1, Event e2, int index) {
            switch (index) {
                case 0: {
                    return Utilities.removeDiacriticsLower((String)e1.description).compareTo(Utilities.removeDiacriticsLower((String)e2.description));
                }
                case 1: {
                    return Utilities.removeDiacriticsLower((String)e1.type).compareTo(Utilities.removeDiacriticsLower((String)e2.type));
                }
                case 2: {
                    if (e1.pit == null && e2.pit == null) {
                        return 0;
                    }
                    if (e2.pit == null) {
                        return 1;
                    }
                    if (e1.pit == null) {
                        return -1;
                    }
                    return e1.pit.compareTo(e2.pit);
                }
                case 3: {
                    return Utilities.removeDiacriticsLower((String)e1.place).compareTo(Utilities.removeDiacriticsLower((String)e2.place));
                }
            }
            return 0;
        }

        public boolean equals(Object that) {
            return that instanceof Event ? this.event == ((Event)that).event : false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 19 * hash + Objects.hashCode(this.event);
            hash = 19 * hash + Objects.hashCode(this.tag);
            hash = 19 * hash + Objects.hashCode(this.name);
            hash = 19 * hash + Objects.hashCode(this.description);
            hash = 19 * hash + Objects.hashCode(this.type);
            hash = 19 * hash + Objects.hashCode(this.date);
            hash = 19 * hash + Objects.hashCode(this.place);
            hash = 19 * hash + Objects.hashCode(this.entity);
            return hash;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.name);
            sb.append(" ");
            sb.append(this.description);
            sb.append(" ");
            sb.append(this.type);
            sb.append(" ");
            sb.append(this.date);
            sb.append(" ");
            sb.append(this.place);
            sb.append(" ");
            sb.append(this.entity.getDisplayTitle(true));
            sb.append(" ");
            sb.append(this.source == null ? "" : this.source.getDisplayTitle(true));
            sb.append(" ");
            sb.append(this.age);
            return sb.toString();
        }
    }
}

