/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.linescirc;

import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.linescirc.IndividualData;
import ancestris.reports.utils.ColorUtils;
import ancestris.reports.utils.SvgUtils;
import ancestris.util.Utilities;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ReportLinesCirc
extends Report {
    private static final int RADIUS_LENGTH = 150;
    private static final int SVG_LENGTH = 1800;
    private static final int SVG_WIDTH = 1800;
    private static final int[] FONT_SIZE = new int[]{12, 12, 12, 12, 10, 8, 7, 6, 5, 5, 4};
    private static final int[] MARRIAGE_SIZE = new int[]{10, 10, 10, 10, 8, 7, 6, 5, 4, 4, 3};
    private int maxlevel = 10;
    public FormatOptions formattingOptions = new FormatOptions();
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public MyContent content = new MyContent();
    public MyDataOptions dataFormatOptions = new MyDataOptions();
    public MyColor colorOptions = new MyColor();
    private Document document;
    private SVGGraphics2D svgGenerator;
    private final Map<Integer, IndividualData> data = new HashMap<Integer, IndividualData>();
    private final List<Element> texts = new ArrayList<Element>();
    private final Map<String, Color> geoColor = new HashMap<String, Color>();
    private final Set<Color> colorUsed = new HashSet<Color>();

    public File start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.start(indi) : null;
    }

    public File start(Indi indi) {
        File file;
        this.initUserOptions();
        try {
            file = File.createTempFile("ancestris_svg", ".svg");
            file.deleteOnExit();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
            return null;
        }
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        this.document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        this.svgGenerator = new SVGGraphics2D(this.document);
        this.svgGenerator.getGeneratorContext().setComment("Generated by Ancestris with Batik SVG Generator");
        Font myFont = new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, 12);
        this.svgGenerator.setFont(myFont);
        this.mainSvg(indi);
        try {
            PrintWriter writer = SvgUtils.getWriter(new FileOutputStream(file));
            this.svgGenerator.stream((Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException | SVGGraphics2DIOException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
            return null;
        }
        try {
            SAXSVGDocumentFactory factory = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
            Document doc = factory.createDocument(file.getAbsolutePath(), (InputStream)new FileInputStream(file));
            doc.getDocumentElement().normalize();
            doc.getDocumentElement().setAttribute("font-family", this.formattingOptions.fontNames[this.formattingOptions.fontName]);
            for (Element ele : this.texts) {
                Node node = doc.importNode(ele, true);
                doc.getDocumentElement().appendChild(node);
            }
            PrintWriter writer = SvgUtils.getWriter(new FileOutputStream(file));
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new DOMSource(doc), new StreamResult(writer));
            writer.flush();
            writer.close();
        }
        catch (IOException | TransformerException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
        }
        return file;
    }

    private void initUserOptions() {
        this.maxlevel = this.content.umaxlevel + 5;
        this.data.clear();
        this.texts.clear();
        this.geoColor.clear();
        this.colorUsed.clear();
        this.colorUsed.add(Color.BLACK);
        this.colorUsed.add(Color.WHITE);
    }

    private String putGivenName(Indi person, int length) {
        return this.truncateString(this.givens(person), length);
    }

    private String putFullName(Indi person, int length) {
        return this.fullname(person, length);
    }

    private PropertyDate birth(Indi entity) {
        if (entity == null) {
            return null;
        }
        return entity.getBirthDateOption();
    }

    private PropertyDate death(Indi entity) {
        if (entity == null) {
            return null;
        }
        return entity.getDeathDateOption();
    }

    private String date(PropertyDate date) {
        if (date != null) {
            return date.getReportValue(null, GedcomOptions.GedcomDateFormat.SHORT);
        }
        return "";
    }

    private String year(PropertyDate date) {
        if (date != null) {
            return date.getStart().isValid() ? "" + date.getStart().getYear() : "????";
        }
        return "";
    }

    private PropertyDate marriage(Fam family) {
        if (family == null) {
            return null;
        }
        Property prop = family.getProperty("MARR");
        if (prop == null) {
            return null;
        }
        return (PropertyDate)prop.getProperty("DATE");
    }

    private Indi husband(Fam fam) {
        return fam == null ? null : fam.getHusband();
    }

    private Indi wife(Fam fam) {
        return fam == null ? null : fam.getWife();
    }

    private Fam parents(Indi person) {
        return person == null ? null : person.getFamilyWhereBiologicalChild();
    }

    private Indi father(Indi person) {
        return person == null ? null : this.husband(this.parents(person));
    }

    private Indi mother(Indi person) {
        return person == null ? null : this.wife(this.parents(person));
    }

    private String fullname(Indi indi, int length) {
        if (indi.getName().length() <= length) {
            return indi.getName();
        }
        return this.truncateString(indi.getName(), length);
    }

    String surname(Indi indi, int length) {
        if (indi == null) {
            return "";
        }
        return this.truncateString(indi.getLastName(), length);
    }

    String givens(Indi indi) {
        if (indi == null) {
            return "";
        }
        return indi.getFirstName();
    }

    private String truncateString(String s, int length) {
        if (s.length() <= length) {
            return s;
        }
        return s.substring(0, length);
    }

    private String getDateString(PropertyDate birth, PropertyDate death, int dateformat) {
        Object result = "";
        String birthstr = "";
        String deathstr = "";
        if (birth != null && !birth.isValid()) {
            birth = null;
        }
        if (death != null && !death.isValid()) {
            death = null;
        }
        if (birth == null && death == null) {
            return "";
        }
        switch (dateformat) {
            case 2: {
                birthstr = "    ";
                deathstr = "    ";
            }
            case 1: {
                if (death != null) {
                    deathstr = this.year(death);
                }
                if (birth != null) {
                    birthstr = this.year(birth);
                }
                result = " (" + birthstr + "-" + deathstr + ")";
                break;
            }
            default: {
                if (death != null) {
                    if (birth != null) {
                        result = (String)result + " " + this.year(birth);
                    }
                    result = (String)result + "-" + this.year(death);
                    break;
                }
                if (birth == null) break;
                result = (String)result + this.OPTIONS.getBirthSymbol() + this.date(birth);
            }
        }
        return result;
    }

    private void mainSvg(Indi indi) {
        this.fillIndi(1, indi, null, 0);
        this.nextLevel(2, this.father(indi), this.parents(indi), 1);
        this.nextLevel(3, this.mother(indi), this.parents(indi), 1);
        this.fan();
    }

    private void nextLevel(Integer cell, Indi indi, Fam fam, int level) {
        if (indi != null && level <= this.maxlevel) {
            this.fillIndi(cell, indi, fam, level);
            this.nextLevel(cell * 2, this.father(indi), this.parents(indi), level + 1);
            this.nextLevel(cell * 2 + 1, this.mother(indi), this.parents(indi), level + 1);
        }
    }

    private void fillIndi(Integer cell, Indi indi, Fam fam, int level) {
        if (indi != null) {
            IndividualData pCell = new IndividualData(indi);
            if (level == 0) {
                pCell.setName(this.surname(indi, 25));
                pCell.setSecondLine(this.putGivenName(indi, 25));
                pCell.setThirdLine(this.getDateString(this.birth(indi), this.death(indi), this.dataFormatOptions.dateformat));
            } else if (level > 0 && level < 6) {
                pCell.setName(this.surname(indi, 100));
                pCell.setSecondLine(this.putGivenName(indi, 100));
                pCell.setThirdLine(this.getDateString(this.birth(indi), this.death(indi), this.dataFormatOptions.dateformat));
            } else if (level == 6 || level == 7) {
                pCell.setName(this.putFullName(indi, 100));
                pCell.setSecondLine(this.getDateString(this.birth(indi), this.death(indi), this.dataFormatOptions.dateformat));
            } else if (level >= 8) {
                String name = this.putFullName(indi, 100) + this.getDateString(this.birth(indi), this.death(indi), this.dataFormatOptions.dateformat);
                pCell.setName(name);
            }
            if (this.content.uprintmarr && fam != null && this.marriage(fam) != null && 1 == indi.getSex()) {
                pCell.setMarriageDate(this.date(this.marriage(fam)));
            }
            pCell.setBgColor(this.getColor(cell, indi, true));
            pCell.setFgColor(this.getColor(cell, indi, false));
            pCell.setQuadrant(this.getQuadrant(cell));
            if (cell == 3) {
                pCell.setQuadrant(0);
            }
            this.data.put(cell, pCell);
        }
    }

    private Color getColor(int sosa, Indi indi, boolean bg) {
        switch (this.colorOptions.colorScheme) {
            case 0: {
                switch (indi.getSex()) {
                    case 1: {
                        if (bg) {
                            return this.colorOptions.sexMColor;
                        }
                        return this.colorOptions.sexMText;
                    }
                    case 2: {
                        if (bg) {
                            return this.colorOptions.sexFColor;
                        }
                        return this.colorOptions.sexFText;
                    }
                }
                if (bg) {
                    return Color.WHITE;
                }
                return Color.BLACK;
            }
            case 2: {
                if (bg) {
                    int red = this.colorOptions.gradientColor.getRed();
                    int green = this.colorOptions.gradientColor.getGreen();
                    int blue = this.colorOptions.gradientColor.getBlue();
                    int currentLevel = this.getLevel(sosa);
                    if (currentLevel == 0) {
                        return this.colorOptions.gradientColor;
                    }
                    red = (int)((double)red * (1.0 - (double)currentLevel * 0.1));
                    green = (int)((double)green * (1.0 - (double)currentLevel * 0.1));
                    blue = (int)((double)blue * (1.0 - (double)currentLevel * 0.1));
                    return new Color(red, green, blue);
                }
                return this.colorOptions.gradientText;
            }
            case 3: {
                int quadrant = this.getQuadrant(sosa);
                if (bg) {
                    return this.colorOptions.getQuadrantList().get(quadrant);
                }
                return this.colorOptions.getTextList().get(quadrant);
            }
            case 4: {
                if (bg) {
                    if (indi != null) {
                        return this.getGeoColor(indi);
                    }
                    return Color.WHITE;
                }
                return Color.BLACK;
            }
            case 5: {
                if (bg) {
                    if (indi != null) {
                        return this.getOccuColor(indi);
                    }
                    return Color.WHITE;
                }
                return Color.BLACK;
            }
            case 6: {
                if (bg) {
                    if (indi != null) {
                        return this.getLifeSpanColor(indi);
                    }
                    return Color.WHITE;
                }
                return Color.BLACK;
            }
        }
        if (bg) {
            return Color.WHITE;
        }
        return Color.BLACK;
    }

    private Color getOccuColor(Indi indi) {
        Property occupation = indi.getProperty("OCCU");
        if (occupation == null) {
            return Color.WHITE;
        }
        String value = occupation.getDisplayValue();
        return this.getRandomColor(value);
    }

    private Color getGeoColor(Indi indi) {
        PropertyPlace place = indi.getBirthPlaceOption();
        if (place == null) {
            place = indi.getDeathPlaceOption();
        }
        if (place == null && indi.getFamiliesWhereSpouse()[0] != null) {
            place = indi.getFamiliesWhereSpouse()[0].getMarriagePlace();
        }
        if (place != null) {
            String value = this.dataFormatOptions.place.getPlace((Property)place);
            return this.getRandomColor(value);
        }
        return Color.WHITE;
    }

    private Color getLifeSpanColor(Indi indi) {
        int lifeSpan = this.lifeSpan(indi);
        if (lifeSpan == -100) {
            this.geoColor.put(this.translate("undecidable"), Color.LIGHT_GRAY);
            return Color.LIGHT_GRAY;
        }
        if (lifeSpan < 20) {
            return this.getRandomColor("0 - 20");
        }
        if (lifeSpan < 30) {
            return this.getRandomColor("20 - 30");
        }
        if (lifeSpan < 40) {
            return this.getRandomColor("30 - 40");
        }
        if (lifeSpan < 50) {
            return this.getRandomColor("40 - 50");
        }
        if (lifeSpan < 60) {
            return this.getRandomColor("50 - 60");
        }
        if (lifeSpan < 70) {
            return this.getRandomColor("60 - 70");
        }
        if (lifeSpan < 80) {
            return this.getRandomColor("70 - 80");
        }
        if (lifeSpan < 90) {
            return this.getRandomColor("80 - 90");
        }
        return this.getRandomColor("90+");
    }

    private int lifeSpan(Indi indi) {
        PropertyDate birth = this.birth(indi);
        PropertyDate death = this.death(indi);
        if (birth == null && death == null) {
            return -100;
        }
        if (birth == null || !birth.isValid() || birth.getAnniversary() == null) {
            return -100;
        }
        if (death == null || !death.isValid()) {
            if (((Indi)birth.getEntity()).isDeceased()) {
                return -100;
            }
            return birth.getAnniversary().getYears();
        }
        return Delta.get((PointInTime)birth.getStart(), (PointInTime)death.getStart()).getYears();
    }

    private Color getRandomColor(String value) {
        if ("".equals(value)) {
            return Color.WHITE;
        }
        Color color = this.geoColor.get(value);
        if (color != null) {
            return color;
        }
        color = ColorUtils.getRandomColor();
        while (this.colorUsed.contains(color)) {
            color = ColorUtils.getRandomColor();
        }
        this.geoColor.put(value, color);
        this.colorUsed.add(color);
        return color;
    }

    private double radius(int level) {
        return (level + 1) * 150;
    }

    private void fan() {
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        int width = 1800;
        int height = 1800;
        this.svgGenerator.setSVGCanvasSize(new Dimension(width, height));
        BasicStroke ligne = new BasicStroke(1.0f);
        this.svgGenerator.setColor(Color.BLACK);
        this.svgGenerator.setStroke((Stroke)ligne);
        this.svgGenerator.drawRect(10, 10, width - 20, height - 20);
        double centerX = width / 2;
        double centerY = height / 2;
        int sosa = 0;
        for (int i = 0; i < this.maxlevel + 1; ++i) {
            double angularStep = 360.0 / Math.pow(2.0, i);
            double rInner = this.radius(i - 1);
            double rOuter = this.radius(i);
            boolean female = false;
            for (double ang1 = 450.0; ang1 > 90.0; ang1 -= angularStep) {
                ++sosa;
                double ang2 = ang1 - angularStep;
                if (i == 0) {
                    IndividualData user = this.data.get(sosa);
                    if (user == null) continue;
                    this.svgGenerator.setPaint((Paint)user.getBgColor());
                    this.svgGenerator.fill((Shape)new Ellipse2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter));
                    this.svgGenerator.setPaint((Paint)user.getFgColor());
                    Rectangle2D boundary = metrics.getStringBounds(user.getName(), (Graphics)this.svgGenerator);
                    this.svgGenerator.drawString(user.getName(), (int)(centerX - boundary.getWidth() / 2.0), (int)(centerY - boundary.getHeight()));
                    if (user.getSecondLine() != null && !"".equals(user.getSecondLine())) {
                        boundary = metrics.getStringBounds(user.getSecondLine(), (Graphics)this.svgGenerator);
                        this.svgGenerator.drawString(user.getSecondLine(), (int)(centerX - boundary.getWidth() / 2.0), (int)centerY);
                    }
                    if (user.getThirdLine() == null || "".equals(user.getThirdLine())) continue;
                    boundary = metrics.getStringBounds(user.getThirdLine(), (Graphics)this.svgGenerator);
                    this.svgGenerator.drawString(user.getThirdLine(), (int)(centerX - boundary.getWidth() / 2.0), (int)(centerY + boundary.getHeight()));
                    continue;
                }
                GeneralPath path = new GeneralPath();
                Arc2D.Double inner = new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang1, -angularStep, 0);
                Arc2D.Double outer = new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang2, angularStep, 0);
                path.append(inner, false);
                Point2D point = outer.getStartPoint();
                path.lineTo(point.getX(), point.getY());
                path.append(outer, true);
                path.closePath();
                if (this.colorOptions.colorScheme == 0) {
                    if (female) {
                        this.svgGenerator.setPaint((Paint)this.colorOptions.sexFColor);
                    } else {
                        this.svgGenerator.setPaint((Paint)this.colorOptions.sexMColor);
                    }
                } else {
                    this.svgGenerator.setPaint((Paint)this.getColor(sosa, null, true));
                }
                female = !female;
                IndividualData user = this.data.get(sosa);
                if (user != null) {
                    this.addText(i, rOuter, rInner, centerX, centerY, ang1, ang2, angularStep, sosa, user);
                    if (sosa % 2 == 0) {
                        this.addMariage(i, inner, outer, rOuter - rInner, sosa, user);
                    }
                    this.svgGenerator.setPaint((Paint)user.getBgColor());
                    this.svgGenerator.fill((Shape)path);
                }
                if (this.content.isDrawEmptyBoxes && this.content.isEmptyColor && user == null) {
                    this.svgGenerator.fill((Shape)path);
                }
                if (!this.content.isDrawEmptyBoxes && user == null) continue;
                this.svgGenerator.setColor(Color.BLACK);
                this.svgGenerator.draw((Shape)path);
            }
        }
        if (this.formattingOptions.printdate) {
            this.svgGenerator.setColor(Color.BLACK);
            this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, 8));
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            String date = dtf.format(now);
            this.svgGenerator.drawString(date, width - 120, height - 20);
        }
        if (this.formattingOptions.legende && (this.colorOptions.colorScheme == 4 || this.colorOptions.colorScheme == 5 || this.colorOptions.colorScheme == 6)) {
            double rayon = this.radius(10);
            Ellipse2D.Double cercle = new Ellipse2D.Double(centerX - rayon / 2.0, centerY - rayon / 2.0, rayon, rayon);
            this.drawLegend(cercle);
        }
    }

    private void drawLegend(Ellipse2D cercle) {
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, 9));
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        double maxWidth = 0.0;
        int debutX = 15;
        int debutY = 1775;
        Area areaCercle = new Area(cercle);
        ArrayList<String> values = new ArrayList<String>(this.geoColor.keySet());
        Collections.sort(values, (o1, o2) -> Utilities.removeDiacritics((String)o1).compareTo(Utilities.removeDiacritics((String)o2)));
        Collections.reverse(values);
        for (String value : values) {
            Rectangle2D boundary = metrics.getStringBounds(value, (Graphics)this.svgGenerator);
            Rectangle2D.Double texteRect = new Rectangle2D.Double(debutX, debutY, 12.0 + boundary.getWidth(), 10.0);
            while (areaCercle.intersects(texteRect)) {
                debutY = 1775;
                maxWidth = 0.0;
                texteRect = new Rectangle2D.Double(debutX += (int)maxWidth + 20, debutY, 12.0 + boundary.getWidth(), 10.0);
            }
            maxWidth = Math.max(maxWidth, boundary.getWidth());
            this.svgGenerator.setColor(this.geoColor.get(value));
            this.svgGenerator.fillRect(debutX, debutY, 10, 10);
            this.svgGenerator.setColor(Color.BLACK);
            this.svgGenerator.drawString(value, debutX + 12, debutY + 8);
            debutY -= 12;
        }
    }

    private void addText(int level, double rOuter, double rInner, double centerX, double centerY, double ang1, double ang2, double angularStep, int sosa, IndividualData user) throws DOMException {
        if (level < 6) {
            double diametre;
            double delta = (rOuter - rInner) / 2.0;
            this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, FONT_SIZE[level]));
            FontMetrics metrics = this.svgGenerator.getFontMetrics();
            Rectangle2D bounds = metrics.getStringBounds(user.getName(), (Graphics)this.svgGenerator);
            if (this.content.isTextUp && (user.getQuadrant() == 1 || user.getQuadrant() == 2)) {
                diametre = rInner + delta - 2.0 * bounds.getHeight();
                this.addLine(level, centerX, diametre, centerY, ang2, -angularStep, sosa, bounds, user.getName(), user.getFgColor(), user.getBgColor(), 1);
            } else {
                diametre = rInner + delta + 2.0 * bounds.getHeight();
                this.addLine(level, centerX, diametre, centerY, ang1, angularStep, sosa, bounds, user.getName(), user.getFgColor(), user.getBgColor(), 1);
            }
            if (user.getSecondLine() != null && !"".equals(user.getSecondLine())) {
                bounds = metrics.getStringBounds(user.getSecondLine(), (Graphics)this.svgGenerator);
                diametre = rInner + delta;
                if (this.content.isTextUp && (user.getQuadrant() == 1 || user.getQuadrant() == 2)) {
                    this.addLine(level, centerX, diametre, centerY, ang2, -angularStep, sosa, bounds, user.getSecondLine(), user.getFgColor(), user.getBgColor(), 2);
                } else {
                    this.addLine(level, centerX, diametre, centerY, ang1, angularStep, sosa, bounds, user.getSecondLine(), user.getFgColor(), user.getBgColor(), 2);
                }
            }
            if (user.getThirdLine() != null && !"".equals(user.getThirdLine())) {
                bounds = metrics.getStringBounds(user.getThirdLine(), (Graphics)this.svgGenerator);
                if (this.content.isTextUp && (user.getQuadrant() == 1 || user.getQuadrant() == 2)) {
                    diametre = rInner + delta + 2.0 * bounds.getHeight();
                    this.addLine(level, centerX, diametre, centerY, ang2, -angularStep, sosa, bounds, user.getThirdLine(), user.getFgColor(), user.getBgColor(), 3);
                } else {
                    diametre = rInner + delta - 2.0 * bounds.getHeight();
                    this.addLine(level, centerX, diametre, centerY, ang1, angularStep, sosa, bounds, user.getThirdLine(), user.getFgColor(), user.getBgColor(), 3);
                }
            }
        } else if (level < 8) {
            double size = rOuter - rInner;
            this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, FONT_SIZE[level]));
            FontMetrics metrics = this.svgGenerator.getFontMetrics();
            Rectangle2D bounds = metrics.getStringBounds(user.getName(), (Graphics)this.svgGenerator);
            Arc2D.Double inner1 = new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang1 - angularStep / 3.0, -angularStep, 0);
            Arc2D.Double outer1 = new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang1 - angularStep / 3.0, -angularStep, 0);
            Arc2D.Double inner2 = new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang1 - 2.0 * angularStep / 3.0, -angularStep, 0);
            Arc2D.Double outer2 = new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang1 - 2.0 * angularStep / 3.0, -angularStep, 0);
            if (this.content.isTextUp && user.getQuadrant() > 1) {
                this.addLine(level, outer2.getStartPoint(), inner2.getStartPoint(), size, sosa, bounds, user.getName(), user.getFgColor(), user.getBgColor(), 2);
            } else {
                this.addLine(level, inner1.getStartPoint(), outer1.getStartPoint(), size, sosa, bounds, user.getName(), user.getFgColor(), user.getBgColor(), 1);
            }
            if (user.getSecondLine() != null) {
                bounds = metrics.getStringBounds(user.getSecondLine(), (Graphics)this.svgGenerator);
                if (this.content.isTextUp && user.getQuadrant() > 1) {
                    this.addLine(level, outer1.getStartPoint(), inner1.getStartPoint(), size, sosa, bounds, user.getSecondLine(), user.getFgColor(), user.getBgColor(), 1);
                } else {
                    this.addLine(level, inner2.getStartPoint(), outer2.getStartPoint(), size, sosa, bounds, user.getSecondLine(), user.getFgColor(), user.getBgColor(), 2);
                }
            }
        } else {
            double size = rOuter - rInner;
            this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, FONT_SIZE[level]));
            FontMetrics metrics = this.svgGenerator.getFontMetrics();
            Rectangle2D bounds = metrics.getStringBounds(user.getName(), (Graphics)this.svgGenerator);
            Arc2D.Double inner = new Arc2D.Double(centerX - rInner / 2.0, centerY - rInner / 2.0, rInner, rInner, ang1 - angularStep / 2.0, -angularStep + 0.5, 0);
            Arc2D.Double outer = new Arc2D.Double(centerX - rOuter / 2.0, centerY - rOuter / 2.0, rOuter, rOuter, ang1 - angularStep / 2.0, -angularStep + 0.5, 0);
            if (this.content.isTextUp && user.getQuadrant() > 1) {
                this.addLine(level, outer.getStartPoint(), inner.getStartPoint(), size, sosa, bounds, user.getName(), user.getFgColor(), user.getBgColor(), 1);
            } else {
                this.addLine(level, inner.getStartPoint(), outer.getStartPoint(), size, sosa, bounds, user.getName(), user.getFgColor(), user.getBgColor(), 1);
            }
        }
    }

    private void addLine(int level, Point2D start, Point2D end, double size, int sosa, Rectangle2D bounds, String value, Color fgColor, Color bgColor, int line) throws DOMException {
        Line2D.Double path = new Line2D.Double(start, end);
        GeneralPath inPath = new GeneralPath();
        inPath.append(path, false);
        Element pathElement = this.svgGenerator.getShapeConverter().toSVG((Shape)inPath);
        double offset = (size - 2.0 * bounds.getWidth()) / 4.0;
        this.addLine(level, pathElement, offset, sosa, value, fgColor, bgColor, line);
    }

    private void addLine(int level, double centerX, double diametre, double centerY, double ang1, double angularStep, int sosa, Rectangle2D bounds, String value, Color fgColor, Color bgColor, int line) throws DOMException {
        Arc2D.Double arcText = new Arc2D.Double(centerX - diametre / 2.0, centerY - diametre / 2.0, diametre, diametre, ang1, angularStep > 0.0 ? -angularStep + 0.5 : -angularStep - 0.5, 0);
        Element pathElement = this.svgGenerator.getShapeConverter().toSVG((Shape)arcText);
        double arcLength = diametre * Math.toRadians(Math.abs(angularStep));
        double offset = (arcLength - 2.0 * bounds.getWidth()) / 4.0;
        this.addLine(level, pathElement, offset, sosa, value, fgColor, bgColor, line);
    }

    private void addLine(int level, Element pathElement, double offset, int sosa, String value, Color fgColor, Color bgColor, int line) {
        String ref = String.valueOf(line) + "sosa" + String.valueOf(sosa);
        pathElement.setAttribute("id", String.valueOf(line) + "sosa" + String.valueOf(sosa));
        if (line == 0) {
            pathElement.setAttribute("stroke", String.format("#%06x", bgColor.getRGB() & 0xFFFFFF));
        } else {
            pathElement.setAttribute("visibility", "hidden");
            pathElement.setAttribute("style", "display:none");
        }
        int fontSize = FONT_SIZE[level];
        if (line == 0) {
            fontSize = MARRIAGE_SIZE[level];
        }
        this.texts.add(SvgUtils.drawTextOnPath(this.document, pathElement, offset, false, ref, value, fgColor, fontSize));
    }

    private void addMariage(int level, Arc2D inner, Arc2D outer, double size, int sosa, IndividualData user) {
        Line2D.Double path = this.content.isTextUp && user.getQuadrant() > 1 ? new Line2D.Double(outer.getStartPoint().getX(), outer.getStartPoint().getY(), inner.getEndPoint().getX(), inner.getEndPoint().getY()) : new Line2D.Double(inner.getEndPoint().getX(), inner.getEndPoint().getY(), outer.getStartPoint().getX(), outer.getStartPoint().getY());
        GeneralPath inPath = new GeneralPath();
        inPath.append(path, false);
        Element pathElement = this.svgGenerator.getShapeConverter().toSVG((Shape)inPath);
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, MARRIAGE_SIZE[level]));
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        String marriage = user.getMarriageDate() != null ? user.getMarriageDate() : " ";
        Rectangle2D bounds = metrics.getStringBounds(marriage, (Graphics)this.svgGenerator);
        double offset = (size - 2.0 * bounds.getWidth()) / 4.0;
        this.addLine(level, pathElement, offset, sosa, marriage, user.getFgColor(), user.getBgColor(), 0);
    }

    private int getLevel(int sosa) {
        return (int)(Math.log(sosa) / Math.log(2.0));
    }

    private int getQuadrant(int sosa) {
        if (sosa == 1) {
            return 0;
        }
        if (sosa == 2) {
            return 0;
        }
        if (sosa == 3) {
            return 2;
        }
        String binary = Integer.toBinaryString(sosa);
        if (binary.startsWith("100")) {
            return 0;
        }
        if (binary.startsWith("101")) {
            return 1;
        }
        if (binary.startsWith("110")) {
            return 2;
        }
        return 3;
    }

    public class FormatOptions {
        public int fontName = 0;
        public String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        public boolean printdate = false;
        public boolean legende = true;
    }

    public class MyContent {
        public int umaxlevel = 2;
        public String[] umaxlevels = new String[]{ReportLinesCirc.this.translate("umaxlevel.5"), ReportLinesCirc.this.translate("umaxlevel.6"), ReportLinesCirc.this.translate("umaxlevel.7"), ReportLinesCirc.this.translate("umaxlevel.8"), ReportLinesCirc.this.translate("umaxlevel.9"), ReportLinesCirc.this.translate("umaxlevel.10")};
        public boolean isDrawEmptyBoxes = true;
        public boolean isEmptyColor = false;
        public boolean isTextUp = true;
        public boolean uprintmarr = true;
    }

    public class MyDataOptions {
        public int dateformat = 1;
        public String[] dateformats = new String[]{ReportLinesCirc.this.translate("dateformat.0"), ReportLinesCirc.this.translate("dateformat.1"), ReportLinesCirc.this.translate("dateformat.2")};
        public FormatPlaceOptions place = new FormatPlaceOptions();
    }

    public class MyColor {
        public int colorScheme = 0;
        public String[] colorSchemes = new String[]{ReportLinesCirc.this.translate("colouroption.0"), ReportLinesCirc.this.translate("colouroption.3"), ReportLinesCirc.this.translate("colouroption.2"), ReportLinesCirc.this.translate("colouroption.4"), ReportLinesCirc.this.translate("colouroption.5"), ReportLinesCirc.this.translate("colouroption.6"), ReportLinesCirc.this.translate("colouroption.7")};
        public Color sexMColor = new Color(255, 200, 200);
        public Color sexMText = Color.BLUE;
        public Color sexFColor = new Color(200, 200, 255);
        public Color sexFText = Color.RED;
        public Color gradientColor = new Color(130, 255, 130);
        public Color gradientText = Color.WHITE;
        public Color colourQuadrant1 = new Color(50, 210, 210);
        public Color textQuadrant1 = Color.BLACK;
        public Color colourQuadrant2 = new Color(50, 210, 50);
        public Color textQuadrant2 = Color.BLACK;
        public Color colourQuadrant3 = new Color(210, 50, 210);
        public Color textQuadrant3 = Color.BLACK;
        public Color colourQuadrant4 = new Color(210, 210, 50);
        public Color textQuadrant4 = Color.BLACK;

        public List<Color> getQuadrantList() {
            ArrayList<Color> retour = new ArrayList<Color>(4);
            retour.add(this.colourQuadrant1);
            retour.add(this.colourQuadrant2);
            retour.add(this.colourQuadrant3);
            retour.add(this.colourQuadrant4);
            return retour;
        }

        public List<Color> getTextList() {
            ArrayList<Color> retour = new ArrayList<Color>(4);
            retour.add(this.textQuadrant1);
            retour.add(this.textQuadrant2);
            retour.add(this.textQuadrant3);
            retour.add(this.textQuadrant4);
            return retour;
        }
    }
}

