/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.linesfan;

import ancestris.core.TextOptions;
import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.report.Report;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.LinkedList;

public class ReportLinesFan
extends Report {
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public int genPerPage = 6;
    public int reportMaxGenerations = 999;
    public boolean useColors = true;
    private PrintWriter writer;
    private static final Charset CHARSET = Charset.forName("ISO-8859-1");
    private int pageNo;
    private final LinkedList<Object> indiList = new LinkedList();

    private PrintWriter getWriter(OutputStream out) {
        return new PrintWriter(new OutputStreamWriter(out, CHARSET));
    }

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi) {
            return super.getName();
        }
        return null;
    }

    public File start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.main(indi) : null;
    }

    public File start(Indi indi) {
        return indi != null ? this.main(indi) : null;
    }

    public File main(Indi indi) {
        File file = this.getFileFromUser(this.translate("output.file"), AbstractAncestrisAction.TXT_OK, true, FileChooserBuilder.getPdfFilter().getExtensions()[1], "");
        if (file == null) {
            return null;
        }
        try {
            int c;
            this.writer = this.getWriter(new FileOutputStream(file));
            InputStreamReader in = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ps-fan.ps"));
            if (this.genPerPage == 1) {
                this.genPerPage = 2;
            }
            this.writer.println("%!PS-Adobe-3.0");
            this.writer.println("%%Creator: genj 1.0");
            this.writer.println("%%CreationDate: ");
            this.writer.println("%%PageOrder: Ascend");
            this.writer.println("%%Orientation: Landscape");
            this.writer.println("%%EndComments");
            this.writer.println("/maxlevel " + this.genPerPage + " def");
            this.writer.println("/color " + (this.useColors ? "true" : "false") + " def");
            while ((c = ((Reader)in).read()) != -1) {
                this.writer.write(c);
            }
            ((Reader)in).close();
        }
        catch (IOException ioe) {
            System.err.println("IO Exception!");
            ioe.printStackTrace();
        }
        this.indiList.add(indi);
        this.indiList.add(1);
        this.pageNo = 1;
        while (!this.indiList.isEmpty()) {
            Indi indiIterator = (Indi)this.indiList.removeFirst();
            Integer genIndex = (Integer)this.indiList.removeFirst();
            if (genIndex == null) continue;
            this.writer.println("gsave");
            this.writer.println("%%Page " + this.pageNo);
            this.pedigree(1, genIndex, 1, 1, indiIterator);
            this.writer.println("showpage");
            this.writer.println("%%PageTrailer");
            ++this.pageNo;
            this.writer.println("grestore");
        }
        this.writer.flush();
        this.writer.close();
        return file;
    }

    private void pedigree(int in, int gen, int lev, int ah, Indi indi) {
        if (indi == null) {
            return;
        }
        if (gen > this.reportMaxGenerations) {
            return;
        }
        this.writer.println("(" + this.esc(indi.getFirstName()) + ") (" + this.esc(indi.getLastName()) + ")");
        if (in < 7) {
            this.writer.println(" (" + this.esc(this.getBirth(indi, "{$D}")) + ") (" + this.esc(this.getDeath(indi, "{$D}")) + ")");
        } else if (in == 7) {
            this.writer.println(" (" + this.esc(this.getBirth(indi, "{$y}")) + ") (" + this.esc(this.getDeath(indi, "{$y}")) + ")");
        } else {
            this.writer.println(" () () ");
        }
        Fam famc = indi.getFamilyWhereBiologicalChild();
        if (in < this.genPerPage || famc == null) {
            this.writer.println(" " + (in - 1) + " " + (ah - lev) + " i");
        } else {
            this.indiList.add(indi);
            this.indiList.add(gen);
            this.writer.println(" " + (in - 1) + " " + (ah - lev) + " " + (this.indiList.size() / 2 + this.pageNo) + " j");
        }
        if (in < this.genPerPage) {
            if (famc == null) {
                return;
            }
            Indi father = famc.getHusband();
            Indi mother = famc.getWife();
            this.pedigree(in + 1, gen + 1, lev * 2, ah * 2, father);
            this.pedigree(in + 1, gen + 1, lev * 2, ah * 2 + 1, mother);
        }
    }

    private String fullname(Indi indi, int isUpper, int type, int length) {
        return this.esc(indi.getName());
    }

    private String esc(String s) {
        String result = s.replaceAll("\\\\", "\\\\\\\\");
        result = result.replaceAll("\\(", "\\\\(");
        result = result.replaceAll("\\)", "\\\\)");
        return result;
    }

    private String getBirth(Indi indi, String display) {
        if (indi.getProperty("BIRT") != null) {
            return indi.formatReport("BIRT", this.OPTIONS.getBirthSymbol() + display);
        }
        if (TextOptions.getInstance().isUseChr()) {
            return indi.formatReport("CHR", this.OPTIONS.getBirthSymbol() + display);
        }
        return indi.format("BIRT", this.OPTIONS.getBirthSymbol() + display);
    }

    private String getDeath(Indi indi, String display) {
        if (indi.getProperty("DEAT") != null) {
            return indi.formatReport("DEAT", this.OPTIONS.getDeathSymbol() + display);
        }
        if (TextOptions.getInstance().isUseBuri()) {
            return indi.formatReport("BURI", this.OPTIONS.getDeathSymbol() + display);
        }
        return indi.format("DEAT", this.OPTIONS.getDeathSymbol() + display);
    }
}

