/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.todo;

import ancestris.gedcom.Relative;
import ancestris.modules.notepad.NotePadTopComponent;
import ancestris.modules.notepad.SearchNote;
import ancestris.reports.FilterOptions;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeIndiOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.ColorUtils;
import ancestris.reports.utils.PropUtils;
import ancestris.util.swing.DialogManager;
import genj.fo.Document;
import genj.gedcom.AbstractNote;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomConstants;
import genj.gedcom.GedcomException;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.gedcom.time.PointInTime;
import genj.option.Multiline;
import genj.option.Sorter;
import genj.report.Report;
import java.awt.Color;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.apache.commons.lang.ArrayUtils;
import org.openide.util.NbBundle;

public class ReportToDo
extends Report {
    public MyFormattingOptions formattingOptions = new MyFormattingOptions();
    public MyScopeIndiOptions scope = new MyScopeIndiOptions();
    public String todoTag = ".*|_TODO";
    public String todoStart = "TODO:";
    public boolean outputSummary = true;
    public Sorter sorter = new Sorter((Object[])SORT_FIELD_NAMES);
    public boolean outputWorkingSheet = true;
    public FilterOptions filterOptions = new FilterOptions();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    public MyColorOptions colors = new MyColorOptions();
    private static final String TAG_COMMON = "common";
    private static final String TAG_GEDCOM = "gedcom";
    private static final String NAME_COMMON = NbBundle.getMessage(ReportToDo.class, (String)"common");
    private static final String NAME_GEDCOM = "Gedcom";
    private static final String[] TYPES = (String[])ArrayUtils.addAll((Object[])new String[]{"common", "gedcom"}, (Object[])GedcomConstants.ENTITIES_5);
    private static final String[] TYPE_NAMES = new String[TYPES.length];
    private static final String SPAN_ALL = "number-columns-spanned=";
    private static final String BORDER_NONE = "border=0, border-style=none";
    private static final String BORDER_RIGHT = "border-left-width=0,   border-left-style=none, border-top-width=0,    border-top-style=none, border-bottom-width=0, border-bottom-style=none, border-right-width=1,  border-right-style=dotted, border-right-color=rgb(0,0,0), border-style=dotted";
    private static final String BORDER_BOTTOM = "border-left-width=0,   border-left-style=none, border-top-width=0,    border-top-style=none,  border-right-width=0,  border-right-style=none, border-bottom-width=1, border-bottom-style=dotted, border-bottom-color=rgb(0,0,0), border-style=dotted";
    private static final String FG_TASK = "#DD0000";
    private Document doc;
    private Gedcom gedcom;
    private String gedcomTags;
    private String userDefinedTags;
    private String placeFmt;
    private String dateFmt;
    private static final String[] SORT_FIELD_NAMES;
    private static final String[] SORT_FIELD_STYLES;
    private Map<Integer, Integer> mapSort;
    private String[] columnNames;
    private Set<Integer> borders;
    private String header_row;
    private String even_row;
    private String odd_row;
    private String textColor;
    private String taskColor;
    private String bgColor;
    private String row_format_header;
    private String format_padding;
    private String format_header2;
    private String format_header3;
    private String format_header3_todo;
    private String format_header4;
    private String format_strong;
    private String format_task;

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Fam || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        this.gedcom = gedcom;
        List<Indi> indis = this.scope.common.getScope(gedcom, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Entity entity) {
        this.gedcom = entity.getGedcom();
        List<Indi> indis = this.scope.common.getScope(entity, this);
        return indis != null ? this.main(indis) : null;
    }

    public Document start(Entity[] entities) {
        this.gedcom = entities[0].getGedcom();
        return this.main(Arrays.asList(entities));
    }

    public Document main(List<? extends Entity> entities) {
        Object notepadnotes;
        if (this.scope.typeSelector.length == 0) {
            DialogManager.createError((String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"OptionError"), (String)NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ErrorNoEntitySelected")).show();
            return null;
        }
        this.dateFmt = this.dataFormatOptions.date.getDateFormat();
        this.placeFmt = this.dataFormatOptions.place.getPlaceFormat();
        this.header_row = this.colors.common.getHeaderRowColor();
        this.even_row = this.colors.common.getEvenRowColor();
        this.odd_row = this.colors.common.getOddRowColor();
        this.textColor = this.colors.common.getTextColor();
        this.bgColor = this.colors.common.getBackgroundColor();
        this.taskColor = ColorUtils.color2string(this.colors.fgTask);
        this.mapSort = this.sorter.getMap((Object[])SORT_FIELD_NAMES);
        this.columnNames = this.getColumnNames();
        this.setSearchTags();
        ArrayList<Property> todos = new ArrayList<Property>();
        for (Entity entity : entities) {
            todos.addAll(this.findProperties((Property)entity));
        }
        String selectedTypesFilter = PropUtils.getEventTags(this.scope.typeSelector, TYPES);
        if (this.gedcom.isGrammar7()) {
            selectedTypesFilter = selectedTypesFilter.replace("NOTE", "SNOTE");
        }
        ArrayList<Record> arrayList = new ArrayList<Record>();
        for (Property todo : todos) {
            Record record = new Record(todo);
            if (!record.entity.getTag().matches(selectedTypesFilter) || !this.filterOptions.matchRecord(todo, record.getName(), record.toString())) continue;
            arrayList.add(record);
        }
        ArrayList searchNotes = new ArrayList();
        if (TAG_COMMON.matches(selectedTypesFilter)) {
            notepadnotes = NotePadTopComponent.getStoredNotes(null, (boolean)true);
            searchNotes.addAll(notepadnotes);
        }
        if (TAG_GEDCOM.matches(selectedTypesFilter)) {
            notepadnotes = NotePadTopComponent.getStoredNotes((Gedcom)this.gedcom, (boolean)false);
            searchNotes.addAll(notepadnotes);
        }
        for (SearchNote searchNote : searchNotes) {
            Record record = new Record(searchNote);
            if (!this.filterOptions.matchRecord(null, record.getName(), record.toString())) continue;
            arrayList.add(record);
        }
        Collections.sort(arrayList);
        String number = String.valueOf(arrayList.size());
        String title = this.translate("title", new Object[]{number, this.gedcom.getDisplayName()});
        this.doc = this.formattingOptions.common.createDocument(this.translate("name"), this.textColor, this.bgColor);
        this.doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.common.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        this.doc.setIndexesTitleAttributes("font-size=" + (this.formattingOptions.common.getTitleSize() - 2));
        if (this.formattingOptions.common.includeTOC) {
            this.doc.addTOC(2, false, this.isHorizontal());
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.addText(this.translate("sortKey"), "font-weight=bold");
        this.doc.nextParagraph();
        this.doc.addText("\u2219  " + SORT_FIELD_NAMES[this.mapSort.get(0)]);
        this.doc.nextParagraph("space-before=1cm");
        this.doc.addText(this.scope.common.getMainMessage(), "font-weight=bold");
        this.doc.nextParagraph();
        this.doc.addText("\u2219  " + this.translate("typeSelector"));
        this.doc.addText(" : ");
        for (int i = 0; i < this.scope.typeSelector.length; ++i) {
            this.doc.addText(TYPE_NAMES[this.scope.typeSelector[i]], "font-weight=bold");
            if (i >= this.scope.typeSelector.length - 1) continue;
            this.doc.addText(", ", "font-weight=bold");
        }
        for (String[] scopeLine : this.scope.common.getMessages()) {
            this.doc.nextParagraph();
            this.doc.addText("\u2219  " + scopeLine[0]);
            if (scopeLine[1].isBlank()) continue;
            this.doc.addText(" : " + scopeLine[1], "font-weight=bold");
        }
        this.doc.nextParagraph("space-before=1cm");
        if (this.filterOptions.isFilterOn()) {
            this.doc.addText(this.filterOptions.getMainMessage(), "font-weight=bold");
            for (String[] filterLine : this.filterOptions.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + filterLine[0]);
                if (filterLine[1].isBlank()) continue;
                this.doc.addText(" : " + filterLine[1], "font-weight=bold");
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.addText(this.translate("extractionCriteria"), "font-weight=bold");
        this.doc.nextParagraph();
        this.doc.addText("\u2219  " + this.translate("gedcomTags"));
        this.doc.addText(" : '" + this.gedcomTags + "'", "font-weight=bold");
        this.doc.addText(".   " + this.translate("todoStart"));
        this.doc.addText(" : '" + this.todoStart + "'", "font-weight=bold");
        this.doc.nextParagraph();
        this.doc.addText("\u2219  " + this.translate("userDefinedTags"));
        this.doc.addText(" : " + this.userDefinedTags, "font-weight=bold");
        this.doc.nextParagraph("space-before=1cm");
        if (this.formattingOptions.generatePageBreak) {
            this.doc.nextPage();
        }
        if (this.outputSummary) {
            this.doc.startSection(this.translate("outputSummaryTitle"), "", 1, false, true, "font-size=" + this.formattingOptions.common.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
            this.doc.startTable("genj:csv=true, width=100%, border-style=solid, border=0, space-before=1cm, border-color=" + this.textColor);
            int nbColumns = this.columnNames.length;
            String spanAll = SPAN_ALL + nbColumns;
            this.setColumnsWidth(nbColumns, arrayList);
            int row = 0;
            String key = "";
            for (Record record : arrayList) {
                String newKey = record.getKey();
                if (!newKey.equals(key)) {
                    if (this.formattingOptions.generatePageBreak && !key.isBlank()) {
                        this.doc.nextTableRow("", BORDER_NONE);
                        this.doc.addText("");
                        this.doc.nextPage();
                    }
                    key = newKey;
                    this.doc.nextTableRow();
                    this.doc.nextTableCell((String)spanAll + ", height=48, border-style=none, border-color=" + this.textColor);
                    this.doc.nextParagraph();
                    this.doc.addText("\u00a0");
                    if (this.formattingOptions.common.includeTOC) {
                        this.doc.addTOCEntry(key, 2);
                        this.doc.nextParagraph();
                        this.doc.addLink("^^^", "title");
                    }
                    this.doc.nextTableRow("font-size=" + this.formattingOptions.common.getTextSize() + ", text-align=center, font-weight=bold, background-color=" + this.header_row);
                    this.doc.nextTableCell((String)spanAll + ", border-left-width=0,   border-left-style=none, border-top-width=0,    border-top-style=none,  border-right-width=0,  border-right-style=none, border-bottom-width=1, border-bottom-style=dotted, border-bottom-color=rgb(0,0,0), border-style=dotted");
                    this.doc.addText(SORT_FIELD_NAMES[this.mapSort.get(0)] + " " + key);
                    this.doc.nextTableRow("font-size=" + (this.formattingOptions.common.getTextSize() - 1) + ", text-align=center, background-color=" + this.header_row);
                    for (int col = 0; col < this.columnNames.length; ++col) {
                        this.displayLabel(this.columnNames[col], col);
                    }
                    row = 0;
                }
                String backColor = row % 2 == 0 ? this.even_row : this.odd_row;
                ++row;
                this.doc.nextTableRow("font-size=" + this.formattingOptions.common.getTextSize() + ", background-color=" + backColor);
                for (int col = 0; col < this.columnNames.length; ++col) {
                    this.displayValue(record, col);
                }
            }
            this.doc.endTable();
        }
        if (this.outputSummary && this.outputWorkingSheet && this.formattingOptions.generatePageBreak) {
            this.doc.nextParagraph("space-before=2cm");
            this.doc.addText("\u00a0");
            this.doc.nextPage();
        }
        if (this.outputWorkingSheet) {
            this.doc.startSection(this.translate("outputWorkingSheetTitle"), "", 1, false, true, "font-size=" + this.formattingOptions.common.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
            this.row_format_header = "font-size=larger, font-weight=bold, padding=3, background-color=" + this.header_row;
            this.format_padding = "padding=3";
            this.format_header2 = "font-weight=bold, padding=3, background-color=" + this.even_row;
            this.format_header3 = "padding=3, background-color=" + this.odd_row + ", text-align=right";
            this.format_header3_todo = "font-weight=bold, padding=3, background-color=" + this.odd_row + ", text-align=right";
            this.format_header4 = "padding=3, background-color=" + this.odd_row;
            this.format_strong = "font-weight=bold";
            this.format_task = "color=" + this.taskColor;
            HashMap<String, List> entitySheetsByType = new HashMap<String, List>();
            for (Record record : arrayList) {
                if (record.entity == null) continue;
                String type = record.entity.getTag();
                List list = entitySheetsByType.getOrDefault(type, new ArrayList());
                list.add(record.entity);
                Collections.sort(list);
                entitySheetsByType.put(type, list);
            }
            this.doc.startTable("width=100%, border-style=none, border=0, space-before=1cm, border-color=" + this.textColor);
            this.doc.addTableColumn("column-width=12%");
            this.doc.addTableColumn("column-width=10%");
            this.doc.addTableColumn("column-width=20%");
            this.doc.addTableColumn("column-width=20%");
            this.doc.addTableColumn("column-width=19%");
            this.doc.addTableColumn("column-width=19%");
            boolean noEntity = true;
            for (String type : GedcomConstants.ENTITIES_5) {
                List list;
                if (this.gedcom.isGrammar7() && type.equals("NOTE")) {
                    type = "SNOTE";
                }
                if ((list = (List)entitySheetsByType.get(type)) == null) continue;
                for (Entity entity : list) {
                    noEntity = false;
                    if (this.findProperties((Property)entity).isEmpty()) continue;
                    if (entity instanceof Indi) {
                        Indi indi = (Indi)entity;
                        this.displayEntityWorksheet(indi, this.doc);
                    } else if (entity instanceof Fam) {
                        Fam fam = (Fam)entity;
                        this.displayEntityWorksheet(fam, this.doc);
                    } else if (entity instanceof Media) {
                        Media media = (Media)entity;
                        this.displayEntityWorksheet(media, this.doc);
                    } else if (entity instanceof AbstractNote) {
                        AbstractNote abstractNote = (AbstractNote)entity;
                        this.displayEntityWorksheet(abstractNote, this.doc);
                    } else if (entity instanceof Source) {
                        Source source = (Source)entity;
                        this.displayEntityWorksheet(source, this.doc);
                    } else if (entity instanceof Submitter) {
                        Submitter submitter = (Submitter)entity;
                        this.displayEntityWorksheet(submitter, this.doc);
                    } else if (entity instanceof Repository) {
                        Repository repository = (Repository)entity;
                        this.displayEntityWorksheet(repository, this.doc);
                    }
                    if (!this.formattingOptions.generatePageBreak) continue;
                    this.doc.nextPage();
                }
            }
            if (noEntity) {
                this.doc.nextTableRow();
                this.doc.nextTableCell("number-columns-spanned=6, text-align=center");
                this.doc.addText(this.translate("noEntity"));
            }
            this.doc.endTable();
        }
        return this.doc;
    }

    private void setSearchTags() {
        String[] tags;
        StringBuilder sbGedcomTags = new StringBuilder();
        StringBuilder sbUserDefinedTags = new StringBuilder();
        String searchString = this.todoTag.replaceAll("\\(", "").replaceAll("\\)", "");
        for (String tag : tags = searchString.split("\\|")) {
            if (tag.startsWith("_")) {
                sbUserDefinedTags.append(tag);
                sbUserDefinedTags.append("|");
                continue;
            }
            sbGedcomTags.append(tag);
            sbGedcomTags.append("|");
        }
        this.gedcomTags = sbGedcomTags.toString().replaceAll("\\|$", "");
        this.userDefinedTags = sbUserDefinedTags.toString().replaceAll("\\|$", "");
    }

    private List<Property> findProperties(Property prop) {
        ArrayList<Property> ret = new ArrayList<Property>();
        if (!this.gedcomTags.isBlank() && !this.todoStart.isBlank()) {
            ret.addAll(prop.findProperties(Pattern.compile(this.gedcomTags), Pattern.compile(this.todoStart + ".*", 32)));
        }
        if (!this.userDefinedTags.isBlank()) {
            ret.addAll(prop.findProperties(Pattern.compile(this.userDefinedTags), Pattern.compile(".*", 32)));
        }
        return ret;
    }

    private String[] getColumnNames() {
        this.borders = new HashSet<Integer>();
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < SORT_FIELD_NAMES.length; ++i) {
            ret.add(SORT_FIELD_NAMES[this.mapSort.get(i)]);
        }
        return (String[])ret.toArray(String[]::new);
    }

    private void setColumnsWidth(int nbColumns, List<Record> records) {
        int col;
        int[] widthsPix = new int[nbColumns];
        Arrays.fill(widthsPix, Integer.MIN_VALUE);
        for (Record record : records) {
            for (int col2 = 0; col2 < nbColumns; ++col2) {
                String textValue = record.getColum(col2) + "W";
                int textSize = textValue.length();
                if (textSize <= widthsPix[col2]) continue;
                widthsPix[col2] = Math.min(50, textSize);
            }
        }
        int sumpx = 0;
        for (int col3 = 0; col3 < nbColumns; ++col3) {
            sumpx += widthsPix[col3];
        }
        int minPercent = 5;
        int totalPercentage = 100;
        for (col = nbColumns - 1; col > 0; --col) {
            int w;
            widthsPix[col] = w = Math.max(minPercent, 100 * widthsPix[col] / sumpx);
            if ((totalPercentage -= w) >= 5) continue;
            return;
        }
        widthsPix[0] = Math.max(minPercent, totalPercentage);
        for (col = 0; col < nbColumns; ++col) {
            this.doc.addTableColumn("column-width=" + widthsPix[col] + "%");
        }
    }

    private void displayLabel(String label, int col) {
        this.doc.nextTableCell(this.isBolderColumn(col) ? BORDER_RIGHT : BORDER_NONE);
        this.doc.addText(label);
    }

    private void displayValue(Record record, int col) {
        Object style = SORT_FIELD_STYLES[this.mapSort.get(col)];
        if (!((String)style).isBlank()) {
            style = (String)style + ", ";
        }
        style = this.isBolderColumn(col) ? (String)style + BORDER_RIGHT : (String)style + BORDER_NONE;
        this.doc.nextTableCell((String)style);
        if (this.mapSort.get(col) == 1) {
            this.doc.addText(record.getColum(col) + " ");
            if (!record.entityAnchor.isBlank()) {
                this.doc.addLink("(" + record.id + ")", record.entityAnchor);
            }
            if (this.formattingOptions.generateEntityIndex) {
                this.doc.addIndexTerm(this.translate("index.entity"), record.tag, record.getColum(col));
            }
        } else if (this.mapSort.get(col) == 3 && !record.taskAnchor.isBlank()) {
            this.doc.addLink(record.getColum(col), record.taskAnchor);
        } else {
            this.doc.addText(record.getColum(col));
        }
    }

    private boolean isBolderColumn(int col) {
        return this.borders.contains(col);
    }

    private boolean isHorizontal() {
        return this.mapSort.get(0) == 1 || this.mapSort.get(0) == 4 || this.mapSort.get(0) == 6;
    }

    private String getFamLabel(Fam fam) {
        String date = this.dataFormatOptions.date.getDate((Property)fam.getMarriageDate());
        return fam.getDisplayTitle(false).replace(fam.getMarriageAsString(), date);
    }

    private void displayEntityWorksheet(Indi indi, Document doc) {
        Fam[] fams;
        List<Property> todos = this.findProperties((Property)indi);
        if (todos.isEmpty()) {
            return;
        }
        doc.nextTableRow(this.row_format_header);
        doc.nextTableCell("number-columns-spanned=6, padding=3");
        doc.addText(this.translate("titleentity", new Object[]{indi.getName(), indi.getId()}));
        if (this.formattingOptions.generateEntityIndex) {
            doc.addIndexTerm(this.translate("index.entity"), Gedcom.getName((String)indi.getTag()), indi.getName());
        }
        doc.nextTableRow();
        doc.nextTableCell("number-columns-spanned=6, " + this.format_header2);
        doc.addText(this.translate("titleinfosperso"));
        doc.nextTableRow();
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"NAME"));
        doc.nextTableCell("number-columns-spanned=3," + this.format_padding);
        doc.addText(indi.getLastName() + " ", this.format_strong);
        doc.addText(indi.getFirstName());
        doc.nextTableCell(this.format_padding);
        doc.addText("ID: ", this.format_strong);
        doc.addLink(indi.getId(), indi.getLinkAnchor(), this.format_strong);
        doc.nextTableCell(this.format_padding);
        doc.addText(Gedcom.getName((String)"SEX") + ": " + PropertySex.getLabelForSex((int)indi.getSex()));
        doc.nextTableRow();
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"NICK"));
        doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
        this.outputEventRow((Entity)indi, "BIRT", todos, doc);
        this.outputEventRow((Entity)indi, "BAPM", todos, doc);
        this.outputEventRow((Entity)indi, "DEAT", todos, doc);
        this.outputEventRow((Entity)indi, "BURI", todos, doc);
        doc.nextTableRow();
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"RESN"));
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(this.outputProperty((Property)indi, "INDI:RESN"));
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"CHAN"));
        doc.nextTableCell(this.format_padding);
        doc.addText(this.outputProperty((Property)indi, "INDI:CHAN"));
        Fam fam = indi.getFamilyWhereBiologicalChild();
        if (fam != null) {
            doc.nextTableRow();
            doc.nextTableCell(this.format_header3);
            doc.addText(NbBundle.getMessage(Relative.class, (String)"father"));
            doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
            this.addIndiString(fam.getHusband(), doc);
            doc.nextTableRow();
            doc.nextTableCell(this.format_header3);
            doc.addText(NbBundle.getMessage(Relative.class, (String)"mother"));
            doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
            this.addIndiString(fam.getWife(), doc);
        }
        if ((fams = indi.getFamiliesWhereSpouse()).length > 0) {
            doc.nextTableRow();
            doc.nextTableCell("number-columns-spanned=6," + this.format_header2);
            doc.addText(Gedcom.getName((String)"FAM", (fams.length > 1 ? 1 : 0) != 0));
        }
        for (Fam famc : fams) {
            Indi spouse = famc.getOtherSpouse(indi);
            if (spouse == null) continue;
            Indi[] children = famc.getChildren();
            doc.nextTableRow();
            doc.nextTableCell("number-rows-spanned=" + (children.length + 1) + "," + this.format_header3);
            doc.addText(NbBundle.getMessage(Relative.class, (String)"spouse"));
            doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
            this.addIndiString(spouse, doc);
            doc.nextParagraph();
            doc.addText(Gedcom.getName((String)"MARR") + " : ", this.format_strong);
            doc.addText(famc.format("MARR", this.getEventFormat((Property)famc)));
            if (children.length <= 0) continue;
            doc.nextTableRow();
            doc.nextTableCell("number-rows-spanned=" + children.length + "," + this.format_header4);
            doc.addText(Gedcom.getName((String)"CHIL", (children.length > 1 ? 1 : 0) != 0));
            doc.nextTableCell("number-columns-spanned=4, " + this.format_padding);
            this.addIndiString(children[0], doc);
            for (int c = 1; c < children.length; ++c) {
                doc.nextTableRow();
                doc.nextTableCell("number-columns-spanned=4, " + this.format_padding);
                this.addIndiString(children[c], doc);
            }
        }
        doc.nextTableRow();
        doc.nextTableCell("number-columns-spanned=6," + this.format_header2);
        if (indi.getProperty("OCCU") != null || indi.getProperty("RESI") != null) {
            doc.addText(Gedcom.getName((String)"EVEN", (boolean)true));
            this.outputEventRow((Entity)indi, "OCCU", todos, doc);
            this.outputEventRow((Entity)indi, "RESI", todos, doc);
        }
        this.outputNoteSection(doc, indi.getProperties("NOTE"), todos);
        this.outputTodoSection(doc, todos);
    }

    private void displayEntityWorksheet(Fam fam, Document doc) {
        Fam tempFam;
        List<Property> todos = this.findProperties((Property)fam);
        if (todos.isEmpty()) {
            return;
        }
        doc.nextTableRow(this.row_format_header);
        doc.nextTableCell("number-columns-spanned=6," + this.format_padding);
        doc.addText(this.translate("titleentity", new Object[]{this.getFamLabel(fam), fam.getId()}));
        if (this.formattingOptions.generateEntityIndex) {
            doc.addIndexTerm(this.translate("index.entity"), Gedcom.getName((String)fam.getTag()), this.getFamLabel(fam));
        }
        Indi tempIndi = fam.getHusband();
        doc.nextTableRow(this.format_header2, this.format_padding);
        doc.addText(Gedcom.getName((String)"HUSB"));
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(tempIndi == null ? "" : tempIndi.getName());
        doc.nextTableCell(this.format_padding);
        doc.addText("ID: ");
        if (tempIndi != null) {
            doc.addLink(tempIndi.getId(), tempIndi.getLinkAnchor());
            doc.nextTableCell(this.format_padding);
            this.outputEventRow((Entity)tempIndi, "BIRT", todos, doc);
            this.outputEventRow((Entity)tempIndi, "BAPM", todos, doc);
            this.outputEventRow((Entity)tempIndi, "DEAT", todos, doc);
            this.outputEventRow((Entity)tempIndi, "BURI", todos, doc);
            tempFam = tempIndi.getFamilyWhereBiologicalChild();
            if (tempFam != null) {
                doc.nextTableRow();
                doc.nextTableCell(this.format_header3);
                doc.addText(NbBundle.getMessage(Relative.class, (String)"father"));
                doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
                this.addIndiString(tempFam.getHusband(), doc);
                doc.nextTableRow();
                doc.nextTableCell(this.format_header3);
                doc.addText(NbBundle.getMessage(Relative.class, (String)"mother"));
                doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
                this.addIndiString(tempFam.getWife(), doc);
            }
        }
        tempIndi = fam.getWife();
        doc.nextTableRow(this.format_header2, this.format_padding);
        doc.addText(Gedcom.getName((String)"WIFE"));
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(tempIndi == null ? "" : tempIndi.getName());
        doc.nextTableCell(this.format_padding);
        doc.addText("ID: ");
        if (tempIndi != null) {
            doc.addLink(tempIndi.getId(), tempIndi.getLinkAnchor());
            doc.nextTableCell(this.format_padding);
            this.outputEventRow((Entity)tempIndi, "BIRT", todos, doc);
            this.outputEventRow((Entity)tempIndi, "BAPM", todos, doc);
            this.outputEventRow((Entity)tempIndi, "DEAT", todos, doc);
            this.outputEventRow((Entity)tempIndi, "BURI", todos, doc);
            tempFam = tempIndi.getFamilyWhereBiologicalChild();
            if (tempFam != null) {
                doc.nextTableRow();
                doc.nextTableCell(this.format_header3);
                doc.addText(NbBundle.getMessage(Relative.class, (String)"father"));
                doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
                this.addIndiString(tempFam.getHusband(), doc);
                doc.nextTableRow();
                doc.nextTableCell(this.format_header3);
                doc.addText(NbBundle.getMessage(Relative.class, (String)"mother"));
                doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
                this.addIndiString(tempFam.getWife(), doc);
            }
        }
        this.outputEventRow((Entity)fam, "MARR", todos, doc);
        Indi[] children = fam.getChildren();
        if (children.length > 0) {
            doc.nextTableRow(this.format_header2);
            doc.nextTableCell("number-columns-spanned=4, " + this.format_padding);
            doc.addText(Gedcom.getName((String)"CHIL", (children.length > 1 ? 1 : 0) != 0));
            doc.nextTableCell(this.format_padding);
            doc.addText("ID: ");
            doc.addLink(fam.getId(), fam.getLinkAnchor());
            doc.nextTableCell(this.format_padding);
            for (int c = 0; c < children.length; ++c) {
                doc.nextTableRow();
                doc.nextTableCell(this.format_header3);
                doc.addText("" + (c + 1));
                doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
                this.addIndiString(children[c], doc);
            }
        }
        doc.nextTableRow();
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"RESN"));
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(this.outputProperty((Property)fam, "FAM:RESN"));
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"CHAN"));
        doc.nextTableCell(this.format_padding);
        doc.addText(this.outputProperty((Property)fam, "FAM:CHAN"));
        this.outputNoteSection(doc, fam.getProperties("NOTE"), todos);
        this.outputTodoSection(doc, todos);
    }

    private void displayEntityWorksheet(Media media, Document doc) {
        List<Property> todos = this.findProperties((Property)media);
        if (todos.isEmpty()) {
            return;
        }
        doc.nextTableRow(this.row_format_header);
        doc.nextTableCell("number-columns-spanned=6," + this.format_padding);
        doc.addText(this.translate("titleentity", new Object[]{media.getDisplayTitle(false), media.getId()}));
        if (this.formattingOptions.generateEntityIndex) {
            doc.addIndexTerm(this.translate("index.entity"), Gedcom.getName((String)media.getTag()), media.getDisplayTitle(false));
        }
        doc.nextTableRow(this.format_header2, this.format_padding);
        doc.addText(Gedcom.getName((String)"FILE", (boolean)true));
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText("");
        doc.nextTableCell(this.format_padding);
        doc.addText("ID: ");
        doc.addLink(media.getId(), media.getLinkAnchor());
        doc.nextTableCell(this.format_padding);
        if (this.gedcom.getGrammar().equals(Grammar.V55)) {
            doc.nextTableRow("");
            doc.addText("\u00a0");
            doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
            doc.addText("\u00a0");
            doc.nextTableCell(this.format_header3);
            doc.addText(Gedcom.getName((String)"TITL"));
            doc.nextTableCell("number-columns-spanned=1, " + this.format_padding);
            doc.addText(this.outputProperty((Property)media, "OBJE:TITL"));
        } else {
            Property[] files;
            for (Property f : files = media.getProperties("FILE")) {
                doc.nextTableRow("", this.format_header3);
                doc.addText(Gedcom.getName((String)"FILE"));
                doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
                doc.addText(f.getDisplayValue());
                doc.nextTableCell(this.format_header3);
                doc.addText(Gedcom.getName((String)"TITL"));
                doc.nextTableCell("number-columns-spanned=1, " + this.format_padding);
                doc.addText(this.outputProperty(f, "FILE:TITL"));
            }
        }
        this.outputNoteSection(doc, media.getProperties("NOTE"), todos);
        this.outputSourceSection(doc, media.getProperties("SOUR"));
        doc.nextTableRow();
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"RESN"));
        doc.nextTableCell("number-columns-spanned=3");
        doc.addText(this.outputProperty((Property)media, "OBJE:RESN"));
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"CHAN"));
        doc.nextTableCell(this.format_padding);
        doc.addText(this.outputProperty((Property)media, "OBJE:CHAN"));
        this.outputTodoSection(doc, todos);
    }

    private void displayEntityWorksheet(AbstractNote note, Document doc) {
        List<Property> todos = this.findProperties((Property)note);
        if (todos.isEmpty()) {
            return;
        }
        String sourceTag = this.gedcom.isGrammar7() ? "SNOTE" : "NOTE";
        doc.nextTableRow(this.row_format_header);
        doc.nextTableCell("number-columns-spanned=6," + this.format_padding);
        doc.addText(this.translate("titleentity", new Object[]{note.getDisplayTitle(false), note.getId()}));
        if (this.formattingOptions.generateEntityIndex) {
            doc.addIndexTerm(this.translate("index.entity"), Gedcom.getName((String)note.getTag()), note.getDisplayTitle(false));
        }
        doc.nextTableRow(this.format_header2, this.format_padding);
        doc.addText(Gedcom.getName((String)"NOTE", (boolean)false));
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText("");
        doc.nextTableCell(this.format_padding);
        doc.addText("ID: ");
        doc.addLink(note.getId(), note.getLinkAnchor());
        doc.nextTableCell(this.format_padding);
        doc.nextTableRow("");
        doc.addText("\u00a0");
        doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
        doc.addText(note.getDisplayValue());
        this.outputSourceSection(doc, note.getProperties("SOUR"));
        doc.nextTableRow();
        doc.nextTableCell(this.format_padding);
        doc.addText("\u00a0");
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(this.outputProperty((Property)note, sourceTag + ":RESN"));
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"CHAN"));
        doc.nextTableCell(this.format_padding);
        doc.addText(this.outputProperty((Property)note, sourceTag + ":CHAN"));
        this.outputTodoSection(doc, todos);
    }

    private void displayEntityWorksheet(Source source, Document doc) {
        Property[] events;
        List<Property> todos = this.findProperties((Property)source);
        if (todos.isEmpty()) {
            return;
        }
        doc.nextTableRow(this.row_format_header);
        doc.nextTableCell("number-columns-spanned=6," + this.format_padding);
        doc.addText(this.translate("titleentity", new Object[]{source.getDisplayTitle(false), source.getId()}));
        if (this.formattingOptions.generateEntityIndex) {
            doc.addIndexTerm(this.translate("index.entity"), Gedcom.getName((String)source.getTag()), source.getDisplayTitle(false));
        }
        doc.nextTableRow(this.format_header2, this.format_padding);
        doc.addText(Gedcom.getName((String)"TITL", (boolean)false));
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(source.getTitle());
        doc.nextTableCell(this.format_padding);
        doc.addText("ID: ");
        doc.addLink(source.getId(), source.getLinkAnchor());
        doc.nextTableCell(this.format_padding);
        this.outputEventRow((Entity)source, "AUTH", todos, doc);
        doc.nextTableRow("", this.format_header3);
        doc.addText(Gedcom.getName((String)"PUBL", (boolean)false));
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(source.getPublication());
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"ABBR", (boolean)false));
        doc.nextTableCell(this.format_padding);
        doc.addText(source.getAbbreviation());
        this.outputEventRow((Entity)source, "TEXT", todos, doc);
        Property data = source.getProperty("DATA");
        if (data != null && (events = data.getProperties("EVEN")).length > 0) {
            doc.nextTableRow(this.format_header2);
            doc.nextTableCell("number-columns-spanned=6, " + this.format_padding);
            doc.addText(Gedcom.getName((String)"EVEN", (events.length > 1 ? 1 : 0) != 0));
            for (Property event : events) {
                doc.nextTableRow();
                doc.nextTableCell(this.format_padding);
                doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
                doc.addText(event.format(this.getEventFormat(event)));
                this.outputPropertyValue(event, doc, "");
            }
        }
        this.outputNoteSection(doc, source.getProperties("NOTE"), todos);
        this.outputSourceSection(doc, source.getProperties("SOUR"));
        this.outputMediaSection(doc, source.getProperties("OBJE"));
        doc.nextTableRow();
        doc.nextTableCell(this.format_padding);
        doc.addText("\u00a0");
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(this.outputProperty((Property)source, "SOUR:RESN"));
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"CHAN"));
        doc.nextTableCell(this.format_padding);
        doc.addText(this.outputProperty((Property)source, "SOUR:CHAN"));
        this.outputTodoSection(doc, todos);
    }

    private void displayEntityWorksheet(Submitter submitter, Document doc) {
        List<Property> todos = this.findProperties((Property)submitter);
        if (todos.isEmpty()) {
            return;
        }
        doc.nextTableRow(this.row_format_header);
        doc.nextTableCell("number-columns-spanned=6," + this.format_padding);
        doc.addText(this.translate("titleentity", new Object[]{submitter.getDisplayTitle(false), submitter.getId()}));
        if (this.formattingOptions.generateEntityIndex) {
            doc.addIndexTerm(this.translate("index.entity"), Gedcom.getName((String)submitter.getTag()), submitter.getDisplayTitle(false));
        }
        doc.nextTableRow(this.format_header2, this.format_padding);
        doc.addText(Gedcom.getName((String)"NAME"));
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(submitter.getName());
        doc.nextTableCell(this.format_padding);
        doc.addText("ID: ");
        doc.addLink(submitter.getId(), submitter.getLinkAnchor());
        doc.nextTableCell(this.format_padding);
        this.outputAddressSection(doc, (Entity)submitter);
        this.outputNoteSection(doc, submitter.getProperties("NOTE"), todos);
        this.outputMediaSection(doc, submitter.getProperties("OBJE"));
        doc.nextTableRow();
        doc.nextTableCell(this.format_padding);
        doc.addText("\u00a0");
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(this.outputProperty((Property)submitter, "SUBM:RESN"));
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"CHAN"));
        doc.nextTableCell(this.format_padding);
        doc.addText(this.outputProperty((Property)submitter, "SUBM:CHAN"));
        this.outputTodoSection(doc, todos);
    }

    private void displayEntityWorksheet(Repository repository, Document doc) {
        List<Property> todos = this.findProperties((Property)repository);
        if (todos.isEmpty()) {
            return;
        }
        doc.nextTableRow(this.row_format_header);
        doc.nextTableCell("number-columns-spanned=6," + this.format_padding);
        doc.addText(this.translate("titleentity", new Object[]{repository.getDisplayTitle(false), repository.getId()}));
        if (this.formattingOptions.generateEntityIndex) {
            doc.addIndexTerm(this.translate("index.entity"), Gedcom.getName((String)repository.getTag()), repository.getDisplayTitle(false));
        }
        doc.nextTableRow(this.format_header2, this.format_padding);
        doc.addText(Gedcom.getName((String)"NAME"));
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(repository.getRepositoryName());
        doc.nextTableCell(this.format_padding);
        doc.addText("ID: ");
        doc.addLink(repository.getId(), repository.getLinkAnchor());
        doc.nextTableCell(this.format_padding);
        this.outputAddressSection(doc, (Entity)repository);
        this.outputNoteSection(doc, repository.getProperties("NOTE"), todos);
        doc.nextTableRow();
        doc.nextTableCell(this.format_padding);
        doc.addText("\u00a0");
        doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
        doc.addText(this.outputProperty((Property)repository, "REPO:RESN"));
        doc.nextTableCell(this.format_header3);
        doc.addText(Gedcom.getName((String)"CHAN"));
        doc.nextTableCell(this.format_padding);
        doc.addText(this.outputProperty((Property)repository, "REPO:CHAN"));
        this.outputTodoSection(doc, todos);
    }

    private void outputEventRow(Entity entity, String tag, List<Property> todos, Document doc) {
        if (entity == null) {
            return;
        }
        Property[] props = entity.getProperties(tag);
        if (props.length == 0) {
            return;
        }
        if (props.length == 1) {
            doc.nextTableRow();
            doc.nextTableCell(this.format_header3);
            doc.addText(Gedcom.getName((String)tag));
            doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
            doc.addText(entity.format(tag, this.getEventFormat((Property)entity)));
            doc.nextParagraph(this.format_padding);
            this.outputNotes("Note : ", entity.getProperty(tag), todos, doc);
            return;
        }
        for (Property prop : props) {
            doc.nextTableRow();
            doc.nextTableCell(this.format_header3);
            doc.addText(Gedcom.getName((String)tag));
            doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
            doc.addText(prop.format(this.getEventFormat(prop)));
            doc.nextParagraph();
            this.outputNotes("Note : ", prop, todos, doc);
        }
    }

    private void outputNotes(String prefix, Property prop, List<Property> exclude, Document doc) {
        Property[] props;
        if (prop == null) {
            return;
        }
        for (Property prop1 : props = prop.getProperties("NOTE")) {
            if (exclude.contains(prop1)) continue;
            doc.addText(prefix, this.format_strong);
            this.outputPropertyValue(prop1, doc, "");
        }
    }

    private String outputProperty(Property prop, String tagPath) {
        Property subProp = prop.getPropertyByPath(tagPath);
        return subProp == null ? "" : subProp.toString();
    }

    private void addIndiString(Indi indi, Document doc) {
        if (indi == null) {
            return;
        }
        String birth = indi.format("BIRT", this.OPTIONS.getBirthSymbol() + this.getEventFormat((Property)indi));
        String death = indi.format("DEAT", this.OPTIONS.getDeathSymbol() + this.getEventFormat((Property)indi));
        doc.addText(indi.toString(), this.format_strong);
        doc.addText(" " + birth + " " + death);
    }

    private void outputPropertyValue(Property prop, Document doc, String attr) {
        if (prop instanceof PropertyXRef && prop.isValid()) {
            PropertyXRef xref = (PropertyXRef)prop;
            this.outputPropertyValue((Property)xref.getTargetEntity().get(), doc, attr);
            return;
        }
        if (!(prop instanceof MultiLineProperty)) {
            if (prop instanceof Entity) {
                Entity entity = (Entity)prop;
                doc.addText(entity.getDisplayTitle(true), attr);
            } else {
                doc.addText(prop.getDisplayValue(), attr);
            }
            return;
        }
        StringTokenizer lines = new StringTokenizer(prop.getValue(), "\n");
        while (lines.hasMoreTokens()) {
            doc.nextParagraph();
            doc.addText(lines.nextToken(), attr);
        }
    }

    private void outputNoteSection(Document doc, Property[] notes, List<Property> todos) {
        boolean seenNote = false;
        for (Property prop1 : notes) {
            if (todos.contains(prop1)) continue;
            if (!seenNote) {
                doc.nextTableRow(this.format_header2);
                doc.nextTableCell("number-columns-spanned=6, " + this.format_padding);
                doc.addText(this.translate("main.notes"));
                seenNote = true;
            }
            doc.nextTableRow();
            doc.nextTableCell(this.format_padding);
            doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
            this.outputPropertyValue(prop1, doc, "");
        }
    }

    private void outputSourceSection(Document doc, Property[] sources) {
        if (sources.length > 0) {
            doc.nextTableRow(this.format_header2);
            doc.nextTableCell("number-columns-spanned=6, " + this.format_padding);
            doc.addText(Gedcom.getName((String)"SOUR", (sources.length > 1 ? 1 : 0) != 0));
            for (Property prop1 : sources) {
                doc.nextTableRow();
                doc.nextTableCell(this.format_padding);
                doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
                this.outputPropertyValue(prop1, doc, "");
            }
        }
    }

    private void outputMediaSection(Document doc, Property[] objes) {
        if (objes.length > 0) {
            doc.nextTableRow(this.format_header2);
            doc.nextTableCell("number-columns-spanned=6, " + this.format_padding);
            doc.addText(Gedcom.getName((String)"OBJE", (objes.length > 1 ? 1 : 0) != 0));
            for (Property prop1 : objes) {
                doc.nextTableRow();
                doc.nextTableCell(this.format_padding);
                doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
                this.outputPropertyValue(prop1, doc, "");
            }
        }
    }

    private void outputAddressSection(Document doc, Entity entity) {
        Property pAddr = entity.getProperty("ADDR");
        Property pPhon = entity.getProperty("PHON");
        Property pEmail = entity.getProperty("EMAIL");
        Property pWWW = entity.getProperty("WWW");
        if (pAddr != null || pPhon != null || pEmail != null || pWWW != null) {
            String tag = entity.getTag();
            doc.nextTableRow(this.format_header2);
            doc.nextTableCell("number-columns-spanned=6, " + this.format_padding);
            doc.addText(Gedcom.getName((String)"ADDR"));
            doc.nextTableRow();
            doc.nextTableCell(this.format_header3);
            doc.addText(Gedcom.getName((String)"CITY"));
            doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
            Object street = this.outputProperty((Property)entity, tag + ":ADDR");
            if (!((String)street).isBlank()) {
                street = (String)street + ", \u00a0";
            }
            doc.addText((String)street + this.outputProperty((Property)entity, tag + ":ADDR:CITY"));
            doc.nextTableCell(this.format_header3);
            doc.addText(Gedcom.getName((String)"POST"));
            doc.nextTableCell("number-columns-spanned=1, " + this.format_padding);
            doc.addText(this.outputProperty((Property)entity, tag + ":ADDR:POST"));
            doc.nextTableRow();
            doc.nextTableCell(this.format_header3);
            doc.addText(Gedcom.getName((String)"STAE"));
            doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
            doc.addText(this.outputProperty((Property)entity, tag + ":ADDR:STAE"));
            doc.nextTableCell(this.format_header3);
            doc.addText(Gedcom.getName((String)"CTRY"));
            doc.nextTableCell("number-columns-spanned=1, " + this.format_padding);
            doc.addText(this.outputProperty((Property)entity, tag + ":ADDR:CTRY"));
            doc.nextTableRow();
            doc.nextTableCell(this.format_header3);
            doc.addText(Gedcom.getName((String)"WWW"));
            doc.nextTableCell("number-columns-spanned=3, " + this.format_padding);
            doc.addText(this.outputProperty((Property)entity, tag + ":WWW"));
            doc.nextTableCell(this.format_header3);
            doc.addText(Gedcom.getName((String)"PHON"));
            doc.nextTableCell("number-columns-spanned=1, " + this.format_padding);
            doc.addText(this.outputProperty((Property)entity, tag + ":PHON"));
            doc.nextTableRow();
            doc.nextTableCell(this.format_header3);
            doc.addText(Gedcom.getName((String)"EMAIL"));
            doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
            doc.addText(this.outputProperty((Property)entity, tag + ":EMAIL"));
        }
    }

    private void outputTodoSection(Document doc, List<Property> todos) {
        doc.nextTableRow(this.format_header2);
        doc.nextTableCell("number-columns-spanned=6, " + this.format_padding);
        doc.addText(this.translate("name"));
        for (Property prop1 : todos) {
            Property parent = prop1.getParent();
            doc.nextTableRow();
            if (parent instanceof Entity) {
                doc.nextTableCell(this.format_padding);
                doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
                this.outputPropertyValue(prop1, doc, this.format_task);
                continue;
            }
            doc.nextTableCell(this.format_header3_todo);
            doc.addText(Gedcom.getName((String)parent.getTag()));
            doc.nextTableCell("number-columns-spanned=5, " + this.format_padding);
            doc.addText(parent.format(this.getEventFormat(parent)));
            doc.nextParagraph();
            doc.addText(this.outputProperty((Property)parent.getEntity(), parent.getPath().toString() + ":SOUR:*:.."));
            doc.nextParagraph();
            doc.addText(this.outputProperty((Property)parent.getEntity(), parent.getPath().toString() + ":REPO:*:.."));
            doc.nextParagraph();
            doc.addText(this.outputProperty((Property)parent.getEntity(), parent.getPath().toString() + ":OBJE:*:.."));
            String snote = this.outputProperty((Property)parent.getEntity(), parent.getPath().toString() + ":SNOTE:*:..");
            String note = this.outputProperty((Property)parent.getEntity(), parent.getPath().toString() + ":NOTE:*:..");
            String todo = prop1.getDisplayValue();
            if (!snote.contains(todo)) {
                doc.nextParagraph();
                doc.addText(snote);
            }
            if (!note.contains(todo)) {
                doc.nextParagraph();
                doc.addText(note);
            }
            doc.nextParagraph();
            this.outputPropertyValue(prop1, doc, this.format_task);
        }
        doc.nextTableRow("");
        doc.nextTableCell("number-columns-spanned=6");
        doc.addText(" ");
    }

    private String getEventFormat(Property event) {
        String ret = "{$v }" + this.dateFmt + this.placeFmt;
        if (this.dataFormatOptions.place.isCustom()) {
            ret = "{$v }" + this.dateFmt + this.dataFormatOptions.place.getCustomFormat(event);
        }
        return ret;
    }

    static {
        ReportToDo.TYPE_NAMES[0] = NAME_COMMON;
        ReportToDo.TYPE_NAMES[1] = NAME_GEDCOM;
        for (int i = 2; i < TYPES.length; ++i) {
            ReportToDo.TYPE_NAMES[i] = Gedcom.getName((String)TYPES[i]);
        }
        SORT_FIELD_NAMES = new String[]{NbBundle.getMessage(ReportToDo.class, (String)"entity_type"), NbBundle.getMessage(ReportToDo.class, (String)"entity_desc"), NbBundle.getMessage(ReportToDo.class, (String)"entity_mod_date"), NbBundle.getMessage(ReportToDo.class, (String)"research_task_tag"), NbBundle.getMessage(ReportToDo.class, (String)"research_task_desc"), NbBundle.getMessage(ReportToDo.class, (String)"parent_prop_tag"), NbBundle.getMessage(ReportToDo.class, (String)"parent_prop_desc")};
        SORT_FIELD_STYLES = new String[]{"text-align=left", "text-align=left", "text-align=center", "text-align=center", "text-align=left", "text-align=center", "text-align=left"};
    }

    public class MyFormattingOptions {
        public FormattingOptions common = new FormattingOptions();
        public boolean generatePageBreak = true;
        public boolean generateEntityIndex = true;
    }

    public class MyScopeIndiOptions {
        @Multiline
        public int[] typeSelector = IntStream.range(0, TYPES.length).toArray();
        public String[] typeSelectors = TYPE_NAMES;
        public ScopeIndiOptions common = new ScopeIndiOptions();
    }

    public class MyDataFormatOptions {
        public FormatPlaceOptions place = new FormatPlaceOptions();
        public FormatDateOptions date = new FormatDateOptions();
    }

    public class MyColorOptions {
        public SimpleColorsOptions common = new SimpleColorsOptions();
        public Color fgTask = ColorUtils.string2color("#DD0000");
    }

    private class Record
    implements Comparable<Record> {
        private final int type;
        private final Entity entity;
        private final String tag;
        private final String id;
        private final String entityAnchor;
        private final String taskAnchor;
        private final String task;
        private long time;
        private final String[] columns;

        public Record(Property property) {
            this.entity = property.getEntity();
            this.tag = Gedcom.getName((String)this.entity.getTag());
            this.id = this.entity.getId();
            this.entityAnchor = this.entity.getLinkAnchor();
            this.taskAnchor = property.getLinkAnchor();
            this.task = property.getDisplayValue();
            this.type = ArrayUtils.indexOf((Object[])TYPES, (Object)this.entity.getTag());
            this.time = this.entity.getLastChange() != null ? this.entity.getLastChange().getTime() : 0L;
            this.columns = new String[ReportToDo.this.columnNames.length];
            block9: for (int col = 0; col < ReportToDo.this.columnNames.length; ++col) {
                switch (ReportToDo.this.mapSort.get(col)) {
                    case 0: {
                        this.columns[col] = this.tag;
                        continue block9;
                    }
                    case 1: {
                        Entity entity = this.entity;
                        if (entity instanceof Indi) {
                            Indi indi = (Indi)entity;
                            this.columns[col] = indi.getReportName() + this.getIndiDates(indi);
                            continue block9;
                        }
                        entity = this.entity;
                        if (entity instanceof Fam) {
                            Fam fam = (Fam)entity;
                            this.columns[col] = ReportToDo.this.getFamLabel(fam);
                            continue block9;
                        }
                        if (this.entity instanceof AbstractNote) {
                            String value = this.entity.getDisplayTitle(false);
                            this.columns[col] = value.substring(0, Math.min(value.length(), 12));
                            if (value.length() <= 12) continue block9;
                            int n = col;
                            this.columns[n] = this.columns[n] + "...";
                            continue block9;
                        }
                        this.columns[col] = this.entity.getDisplayTitle(false);
                        continue block9;
                    }
                    case 2: {
                        this.columns[col] = this.entity.getLastChange() != null ? this.entity.getLastChange().getDateDisplayValue() : "";
                        continue block9;
                    }
                    case 3: {
                        this.columns[col] = Gedcom.getName((String)property.getTag());
                        continue block9;
                    }
                    case 4: {
                        this.columns[col] = property.getDisplayValue().replace(ReportToDo.this.todoStart, "").trim();
                        continue block9;
                    }
                    case 5: {
                        this.columns[col] = Gedcom.getName((String)property.getParent().getTag());
                        continue block9;
                    }
                    case 6: {
                        Property parent = property.getParent();
                        if (parent.isEvent()) {
                            this.columns[col] = parent.format(ReportToDo.this.getEventFormat(parent));
                            continue block9;
                        }
                        if (parent instanceof Entity) {
                            this.columns[col] = "";
                            continue block9;
                        }
                        this.columns[col] = parent.getDisplayValue();
                        continue block9;
                    }
                }
            }
        }

        public Record(SearchNote searchNote) {
            this.entity = null;
            this.tag = searchNote.getGedcom() == null ? NAME_COMMON : ReportToDo.NAME_GEDCOM;
            this.id = "";
            this.entityAnchor = "";
            this.taskAnchor = "";
            this.task = searchNote.getContent();
            this.type = ArrayUtils.indexOf((Object[])TYPES, (Object)(searchNote.getGedcom() == null ? ReportToDo.TAG_COMMON : ReportToDo.TAG_GEDCOM));
            LocalDate date = searchNote.getLastModified().toLocalDate();
            PointInTime pit = new PointInTime(date.getDayOfMonth() - 1, date.getMonthValue() - 1, date.getYear());
            try {
                this.time = pit.getTimeMillis();
            }
            catch (GedcomException ex) {
                this.time = -1L;
            }
            this.columns = new String[ReportToDo.this.columnNames.length];
            block11: for (int col = 0; col < ReportToDo.this.columnNames.length; ++col) {
                switch (ReportToDo.this.mapSort.get(col)) {
                    case 0: {
                        this.columns[col] = this.tag;
                        continue block11;
                    }
                    case 1: {
                        this.columns[col] = searchNote.getGedcom() == null ? " " : searchNote.getGedcom().getDisplayName();
                        continue block11;
                    }
                    case 2: {
                        this.columns[col] = pit.toString();
                        continue block11;
                    }
                    case 3: {
                        this.columns[col] = "";
                        continue block11;
                    }
                    case 4: {
                        this.columns[col] = searchNote.getContent();
                        continue block11;
                    }
                    case 5: {
                        this.columns[col] = "";
                        continue block11;
                    }
                    case 6: {
                        this.columns[col] = " ";
                        continue block11;
                    }
                }
            }
        }

        private String getKey() {
            String key = "";
            key = switch (ReportToDo.this.mapSort.get(0)) {
                case 1, 4, 6 -> this.columns[0].substring(0, 1).toUpperCase(Locale.getDefault());
                case 2 -> this.columns[0];
                default -> this.columns[0].toUpperCase(Locale.getDefault());
            };
            return key;
        }

        public String getName() {
            return this.task;
        }

        @Override
        public int compareTo(Record record) {
            int diff = 0;
            for (int col = 0; col < this.columns.length; ++col) {
                switch (ReportToDo.this.mapSort.get(col)) {
                    case 2: {
                        int n = Long.compare(this.time, record.time);
                        break;
                    }
                    case 0: {
                        int n = Integer.compare(this.type, record.type);
                        break;
                    }
                    default: {
                        int n = diff = ReportToDo.this.gedcom.getCollator().compare(this.columns[col].toUpperCase(Locale.getDefault()), record.columns[col].toUpperCase(Locale.getDefault()));
                    }
                }
                if (diff == 0) continue;
                return diff;
            }
            return diff;
        }

        private String getColum(int col) {
            return this.columns[col];
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String column : this.columns) {
                sb.append(column);
                sb.append(" ");
            }
            return sb.toString();
        }

        private String getIndiDates(Indi indi) {
            return " (" + ReportToDo.this.dataFormatOptions.date.getDate((Property)indi.getBirthDate()) + " - " + ReportToDo.this.dataFormatOptions.date.getDate((Property)indi.getDeathDate()) + ")";
        }
    }
}

