/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.file.gexf.GEXF;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXFAttValue
implements GEXFElement {
    GEXF root;
    String forId;
    String value;
    double start;
    double end;

    public GEXFAttValue(GEXF root, String forId, String value) {
        this.root = root;
        this.forId = forId;
        this.value = value;
        this.start = root.step;
        this.end = Double.NaN;
    }

    @Override
    public void export(SmartXMLWriter stream) throws XMLStreamException {
        stream.startElement("attvalue");
        stream.stream.writeAttribute("for", this.forId);
        stream.stream.writeAttribute("value", this.value);
        if (Double.isNaN(this.end)) {
            this.end = this.root.step;
        }
        if (this.root.isExtensionEnable(GEXFElement.Extension.DYNAMICS)) {
            stream.stream.writeAttribute("start", this.root.getTimeFormat().format.format(this.start));
            stream.stream.writeAttribute("end", this.root.getTimeFormat().format.format(this.end));
        }
        stream.endElement();
    }
}

