# Tibetan

## Introduction

*This is unfinished work and only a tentative solution. Please help us improve! (see below)*

During a travel to the Tibetan Autonomous Region of China (TAR) in 2019, I was confronted with a highly complex system of astronomy and calendar computations which has a long tradition in Tibet.

Traditional Tibetan astronomy is largely influenced by the Kalacakra Tantra which has been imported from India, mixed with some Chinese influence.

## Description

<table class="layout">
<tr>
	<td><img src="illustrations/MenTseeKhang_emblem.jpg" height="450" alt="Emblem of Men Tsee Khang"/></td>
	<td><img src="illustrations/StagPhuDisk.jpg" height="450" alt="Stag Phu disk"/></td>
</tr>
<tr>
	<td>Emblem on the door sign of Men Tsee Khang institute in Lhasa</td>
	<td>Stag Phu observatory Platform. The traditional stone for the shadow observation has been embedded in a concrete platform which shows the lunar mansions. The outermost circle shows figures of the 12 Zodiacal signs (barely visible but enlarged below).</td>
</tr>
</table>
 The Men Tsee Khang Institute for Astro and Medicine in Lhasa, TAR, is the central authority for traditional Tibetan medicine and astrology, two fields of research which are closely related in Tibetan tradition. The institute is in charge of editing the annual Tibetan calendar. Although this can be described algorithmically, in 2009 Men Tsee Khang experts have re-erected a calendar observatory in Stag Phu monastery, where a sunrise observation is performed on each March 17th for calibrating the calendar. On this day, just as the sun climbs over a mountain ridge, its first rays are cast through a window in the observatory tower onto a particular rock which has been embedded into a circular platform.

### The Zodiac

The zodiac is partitioned into 12 figures largely identical to the classical figures of the zodiac known in Europe. The following table is from Cornu, with photographs showing the figures illustrated in the circular platform. Note the unexpected appearance of Cancer. Is it a frog?
 <table class="layout">
<tr><th colspan="2">IAU</th><th>Tibetan</th><th>Indian</th><th>Platform Illustration</th>
</tr>
<tr>
	<td><notr> 1</notr></td>
	<td>Ari</td>
	<td>Luk</td>
	<td>Meṣa</td>
	<td><img src="illustrations/StagPhu_01_Ari.jpg" height=150 alt="Ari"/></td>
</tr>
<tr>
	<td><notr> 2</notr></td>
	<td>Tau</td>
	<td>Lang</td>
	<td>Vṛṣa</td>
	<td><img src="illustrations/StagPhu_02_Tau.jpg" height=150 alt="Tau"/></td>
</tr>
<tr>
	<td><notr> 3</notr></td>
	<td>Gem</td>
	<td>Trik</td>
	<td>Mithuna</td>
	<td><img src="illustrations/StagPhu_03_Gem.jpg" height=150 alt="Gem"/></td>
</tr>
<tr>
	<td><notr> 4</notr></td>
	<td>Cnc</td>
	<td>Karkata</td>
	<td>Karka</td>
	<td><img src="illustrations/StagPhu_04_Cnc_Frog.jpg" height=150 alt="Cnc"/></td>
</tr>
<tr>
	<td><notr> 5</notr></td>
	<td>Leo</td>
	<td>Senge</td>
	<td>Simha</td>
	<td><img src="illustrations/StagPhu_05_Leo.jpg" height=150 alt="Leo"/></td>
</tr>
<tr>
	<td><notr> 6</notr></td>
	<td>Vir</td>
	<td>Pumo</td>
	<td>Kanyā</td>
	<td><img src="illustrations/StagPhu_06_Vir.jpg" height=150 alt="Vir"/></td>
</tr>
<tr>
	<td><notr> 7</notr></td>
	<td>Lib</td>
	<td>Sangwa</td>
	<td>Tulā</td>
	<td><img src="illustrations/StagPhu_07_Lib.jpg" height=150 alt="Lib"/></td>
</tr>
<tr>
	<td><notr> 8</notr></td>
	<td>Sco</td>
	<td>Dikpa</td>
	<td>Vṛscika</td>
	<td><img src="illustrations/StagPhu_08_Sco.jpg" height=150 alt="Sco"/></td>
</tr>
<tr>
	<td><notr> 9</notr></td>
	<td>Sgr</td>
	<td>Zhu</td>
	<td>Dhanus</td>
	<td><img src="illustrations/StagPhu_09_Sgr.jpg" height=150 alt="Sgr"/></td>
</tr>
<tr>
	<td><notr>10</notr></td>
	<td>Cap</td>
	<td>Chusin</td>
	<td>Makara</td>
	<td><img src="illustrations/StagPhu_10_Cap.jpg" height=150 alt="Cap"/></td>
</tr>
<tr>
	<td><notr>11</notr></td>
	<td>Aqr</td>
	<td>Bumpa</td>
	<td>Kumbha</td>
	<td><img src="illustrations/StagPhu_11_Aqr.jpg" height=150 alt="Aqr"/></td>
</tr>
<tr>
	<td><notr>12</notr></td>
	<td>Psc</td>
	<td>Nya</td>
	<td>Mīna</td>
	<td><img src="illustrations/StagPhu_12_Psc.jpg" height=150 alt="Psc"/></td>
</tr>
</table>

### The Lunar Mansions

The Men Tsee Khang emblem shows 27 stick figures for the Lunar mansions arranged in a circle around the central figure. The same figures are also laid out in cement with bright stones connected by black lines in the circular platform which has been erected when the observatory was rebuilt. These 27 *gyukar* figures are described as being equal to the Indian *Nakṣatras* and represent sections of 13°20' longitude along the ecliptic. Actually, one of the *gyukars* consists of 2 asterisms, therefore 28 *lunar asterisms* are named.

However, not much is known of the exact identification of the Tibetan Lunar Stations outside of Tibet. Most literature is Tibetan or Chinese only, and there were no Tibetan star maps available. Also our guides could not explain any of the following to us.

The following table was taken from Cornu. Note that Tibetans start counting at zero, while the Indians count from 1.
 <table class="layout">
<tr><th colspan="2">Gyukar</th><th colspan="2">Nakshatra</th><th>Stars</th>
</tr>
<tr>
	<td align="right"><notr> 0</notr></td>
	<td>Takar, Yugu</td>
	<td align="right"><notr> 1</notr></td>
	<td>Aśvini</td>
	<td> &beta; Ari Sheratan</td>
</tr>
<tr>
	<td align="right"><notr> 1</notr></td>
	<td>Dranye</td>
	<td align="right"><notr> 2</notr></td>
	<td>Bharaṇī</td>
	<td> 35 Ari</td>
</tr>
<tr>
	<td align="right"><notr> 2</notr></td>
	<td>Mindruk</td>
	<td align="right"><notr> 3</notr></td>
	<td>Kṛttikā</td>
	<td> Pleiades</td>
</tr>
<tr>
	<td align="right"><notr> 3</notr></td>
	<td>Narma</td>
	<td align="right"><notr> 4</notr></td>
	<td>Rohiṇī</td>
	<td> &alpha; Tau Aldebaran</td>
</tr>
<tr>
	<td align="right"><notr> 4</notr></td>
	<td>Go</td>
	<td align="right"><notr> 5</notr></td>
	<td>Mṛgaśirā</td>
	<td> &lambda; Ori</td>
</tr>
<tr>
	<td align="right"><notr> 5</notr></td>
	<td>Lak</td>
	<td align="right"><notr> 6</notr></td>
	<td>Ārdrā</td>
	<td> &alpha; Ori Betelgeuse</td>
</tr>
<tr>
	<td align="right"><notr> 6</notr></td>
	<td>Nabso, Gyaltö</td>
	<td align="right"><notr> 7</notr></td>
	<td>Punarvasū</td>
	<td> &beta; Gem Pollux</td>
</tr>
<tr>
	<td align="right"><notr> 7</notr></td>
	<td>Gyal, Gyalme</td>
	<td align="right"><notr> 8</notr></td>
	<td>Puṣya</td>
	<td> 5 Cnc</td>
</tr>
<tr>
	<td align="right"><notr> 8</notr></td>
	<td>Kak, Wa</td>
	<td align="right"><notr> 9</notr></td>
	<td>Aśleṣa</td>
	<td> &alpha; Hya</td>
</tr>
<tr>
	<td align="right"><notr> 9</notr></td>
	<td>Chu, Ta chen</td>
	<td align="right"><notr>10</notr></td>
	<td>Maghā</td>
	<td> &alpha; Leo Regulus</td>
</tr>
<tr>
	<td align="right"><notr>10</notr></td>
	<td>Dre, Ta chung</td>
	<td align="right"><notr>11</notr></td>
	<td>Purva-Phālgunī</td>
	<td> &delta; Leo Zosma</td>
</tr>
<tr>
	<td align="right"><notr>11</notr></td>
	<td>Wo</td>
	<td align="right"><notr>12</notr></td>
	<td>Uttara-Phālgunī</td>
	<td> &beta; Leo Denebola</td>
</tr>
<tr>
	<td align="right"><notr>12</notr></td>
	<td>Mezhi</td>
	<td align="right"><notr>13</notr></td>
	<td>Hasta</td>
	<td> &delta; Crv Algorab</td>
</tr>
<tr>
	<td align="right"><notr>13</notr></td>
	<td>Nakpa</td>
	<td align="right"><notr>14</notr></td>
	<td>Citrā</td>
	<td> &alpha; Vir Spica</td>
</tr>
<tr>
	<td align="right"><notr>14</notr></td>
	<td>Sari</td>
	<td align="right"><notr>15</notr></td>
	<td>Svātī</td>
	<td> &alpha; Boo Arcturus</td>
</tr>
<tr>
	<td align="right"><notr>15</notr></td>
	<td>Saga</td>
	<td align="right"><notr>16</notr></td>
	<td>Viśākhā</td>
	<td> &alpha; Lib</td>
</tr>
<tr>
	<td align="right"><notr>16</notr></td>
	<td>Lhatsam</td>
	<td align="right"><notr>17</notr></td>
	<td>Anurādhā</td>
	<td> &delta; Sco</td>
</tr>
<tr>
	<td align="right"><notr>17</notr></td>
	<td>Nrön, Deu</td>
	<td align="right"><notr>18</notr></td>
	<td>Jyeṣṭhā</td>
	<td> &alpha; Sco Antares</td>
</tr>
<tr>
	<td align="right"><notr>18</notr></td>
	<td>Nup</td>
	<td align="right"><notr>19</notr></td>
	<td>Mūla</td>
	<td> &lambda; Sco Shaula</td>
</tr>
<tr>
	<td align="right"><notr>19</notr></td>
	<td>Chutö</td>
	<td align="right"><notr>20</notr></td>
	<td>Purvāṣadhā</td>
	<td> &delta; Sgr</td>
</tr>
<tr>
	<td align="right"><notr>20</notr></td>
	<td>Chume</td>
	<td align="right"><notr>21</notr></td>
	<td>Uttarāṣadhā</td>
	<td> &sigma; Sgr</td>
</tr>
<tr>
	<td align="right"><notr>21</notr></td>
	<td>Drozhin + Jizhin</td>
	<td align="right"><notr>22</notr></td>
	<td>Uttara-Āṣādhā + Śravaṇa</td>
	<td> &alpha; Lyr Vega + &alpha; Aql Altair</td>
</tr>
<tr>
	<td align="right"><notr>22</notr></td>
	<td>Möndre</td>
	<td align="right"><notr>23</notr></td>
	<td>Dhaniāsṭha</td>
	<td> &beta; Del</td>
</tr>
<tr>
	<td align="right"><notr>23</notr></td>
	<td>Möndru</td>
	<td align="right"><notr>24</notr></td>
	<td>Satabhiṣak</td>
	<td> &lambda; Aqr</td>
</tr>
<tr>
	<td align="right"><notr>24</notr></td>
	<td>Trumtö</td>
	<td align="right"><notr>25</notr></td>
	<td>Purvabāadrapada</td>
	<td> &alpha; Peg Markab</td>
</tr>
<tr>
	<td align="right"><notr>25</notr></td>
	<td>Trume</td>
	<td align="right"><notr>26</notr></td>
	<td>Uttarabhādrapada</td>
	<td> &gamma; Peg, &alpha; And</td>
</tr>
<tr>
	<td align="right"><notr>26</notr></td>
	<td>Namdru, Shesa</td>
	<td align="right"><notr>27</notr></td>
	<td>Revati</td>
	<td> &sigma; Psc</td>
</tr>
</table>
The star figures for Lunar Mansions in this skyculture are shown as asterisms among the traditional 12 Ptolemaic zodiacal constellations. It is assumed that most originate from the Indian traditions, esp. Kalacakra Tantra, but it appears that some Chinese influence is also present, e.g. Nr. 11. Only for the Zodiacal constellations artwork is provided. A few more constellations in Ptolemaic tradition are displayed in the northern sky to allow easier orientation, but with their names suppressed. We have no information about their names, relevance or even publicity of these in Tibet.

### Please help us

The figures are my own attempt of identification of the Lunar mansion figures. We can be sure about the placement of only those which can also be found in other sky cultures, e.g. Japanese Moon Stations which stem from Chinese tradition. Many stars are rather dim, and the figures in the emblem apparently have to be rotated in arbitrary ways, like *gyukar 3*=Hyades. Others require considerable liberties to accept a topological match. Alternative matches with stars in similar topology arranged in the orientation shown in the emblem (north=outer circle) have been found only in neighboring areas of the sky, making a match rather unlikely. Others appear to have been taken over from Chinese tradition, e.g. Nr. 11. LM21 can be explained only if we accept two separate figures which are not aligned as shown in the concrete figure. Then they represent Chinese constellations *Ox* and *Girl* (which is also Japanese Lunar station *Woman*).

Alternative figures can be found in the old configuration files. We would like to hear from experts of Tibetan astronomy about both confirmed and corrected identification.

The *zodiac* and *gyukar* bands have been taken over from Indian tradition. The link "Spica=180°" is also set here for both circles, but should be confirmed. 

#### Further reading

This work accompanies a 3D model of the Stag Phu observatory for use with the Scenery3D plugin, downloadable from https://stellarium.org and described in:

Georg Zotti, Guntram Hazod, Martin Gamon and Hubert Feiglstorfer (2024), "A Calendar Observatory in Tibet". In: Marc Fr&icirc;ncu (coordinator), 
Proceedings of the 29th Conference of the European Society for Astronomy in Culture (SEAC) Timisoara 2022,  
Editura Universit&#x103;&#x163;ii de Vest din Timi&#x15F;oara} (pages 123-136).  ISBN 978-630-327-107-1.

## References

 - [#1]: Burgess, E. (1860). Translation of the Surya-Siddhanta, a Text-Book of Hindu Astronomy. New Haven.
 - [#2]: Cornu, P. (2002). Tibetan Astrology. Boston & London: Shambhala.
 - [#3]: [Reingold, Edward M. and Nachum Dershowitz (2018). Calendrical Calculations: The Ultimate Edition. Cambridge: Cambridge University Press. ](https://dx.doi.org/10.1017/9781107415058)

## Authors

Georg Zotti on May 21, 2019, reworked July-October 2023. *Zodiac* and *Gyukars* added in V25.2. 

## License

CC BY-SA
