/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.api;

import java.security.SecureRandom;
import java.util.ServiceLoader;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;

public interface CryptorProvider {
    public static CryptorProvider forScheme(Scheme scheme) {
        for (CryptorProvider provider : ServiceLoader.load(CryptorProvider.class)) {
            if (!provider.scheme().equals((Object)scheme)) continue;
            return provider;
        }
        throw new UnsupportedOperationException("Scheme not supported: " + scheme.name());
    }

    public Scheme scheme();

    public Cryptor provide(Masterkey var1, SecureRandom var2);

    public static enum Scheme {
        SIV_CTRMAC,
        SIV_GCM;

    }
}

