/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.dokany.locks;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class FilePaths {
    private static final char PATH_SEP = '/';
    private static final String ROOT = "";
    private static final Splitter PATH_SPLITTER = Splitter.on((char)'/').omitEmptyStrings();
    private static final Joiner PATH_JOINER = Joiner.on((char)'/');

    FilePaths() {
    }

    public static List<String> toComponents(String pathRelativeToRoot) {
        ArrayList<String> pathComponents = new ArrayList<String>(PATH_SPLITTER.splitToList((CharSequence)pathRelativeToRoot));
        pathComponents.add(0, ROOT);
        return Collections.unmodifiableList(pathComponents);
    }

    public static String toPath(List<String> pathComponents) {
        return PATH_JOINER.join(pathComponents);
    }

    public static List<String> parentPathComponents(List<String> pathComponents) {
        assert (pathComponents.size() > 0);
        return pathComponents.subList(0, pathComponents.size() - 1);
    }

    public static String normalizePath(String path) {
        return "/" + PATH_JOINER.join(PATH_SPLITTER.split((CharSequence)path));
    }
}

