/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cryptomator.frontend.webdav.VersionCompare;
import org.cryptomator.frontend.webdav.mount.MountParams;
import org.cryptomator.frontend.webdav.mount.Mounter;
import org.cryptomator.frontend.webdav.mount.MounterStrategy;
import org.cryptomator.frontend.webdav.mount.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MacAppleScriptMounter
implements MounterStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MacAppleScriptMounter.class);
    private static final boolean IS_OS_MAC = System.getProperty("os.name").contains("Mac OS X");
    private static final String OS_VERSION = System.getProperty("os.version");
    private static final Pattern MOUNT_PATTERN = Pattern.compile(".* on (\\S+) \\(.*\\)");

    MacAppleScriptMounter() {
    }

    @Override
    public boolean isApplicable() {
        try {
            return IS_OS_MAC && VersionCompare.compareVersions(OS_VERSION, "10.10") >= 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public Mounter.Mount mount(URI uri, MountParams mountParams) throws Mounter.CommandFailedException {
        try {
            String mountAppleScript = String.format("mount volume \"%s\"", uri.toASCIIString());
            ProcessBuilder mount = new ProcessBuilder("/usr/bin/osascript", "-e", mountAppleScript);
            Process mountProcess = mount.start();
            ProcessUtil.waitFor(mountProcess, 60L, TimeUnit.SECONDS);
            ProcessUtil.assertExitValue(mountProcess, 0);
            ProcessBuilder verifyMount = new ProcessBuilder("/bin/sh", "-c", "mount | grep \"" + uri.toASCIIString() + "\"");
            Process verifyProcess = verifyMount.start();
            String stdout = ProcessUtil.toString(verifyProcess.getInputStream(), StandardCharsets.UTF_8);
            ProcessUtil.waitFor(verifyProcess, 10L, TimeUnit.SECONDS);
            ProcessUtil.assertExitValue(mountProcess, 0);
            Matcher mountPointMatcher = MOUNT_PATTERN.matcher(stdout);
            if (mountPointMatcher.find()) {
                String mountPoint = mountPointMatcher.group(1);
                LOG.debug("Mounted {} on {}.", (Object)uri.toASCIIString(), (Object)mountPoint);
                return new MountImpl(uri, Paths.get(mountPoint, new String[0]));
            }
            throw new Mounter.CommandFailedException("Mount succeeded, but failed to determine mount point in string: " + stdout);
        }
        catch (IOException e) {
            throw new Mounter.CommandFailedException(e);
        }
    }

    private static class MountImpl
    implements Mounter.Mount {
        private final Path mountPath;
        private final ProcessBuilder revealCommand;
        private final ProcessBuilder unmountCommand;
        private final URI uri;
        private final ProcessBuilder forcedUnmountCommand;

        private MountImpl(URI uri, Path mountPath) {
            this.mountPath = mountPath;
            this.uri = uri;
            this.revealCommand = new ProcessBuilder("open", mountPath.toString());
            this.unmountCommand = new ProcessBuilder("sh", "-c", "diskutil umount \"" + mountPath + "\"");
            this.forcedUnmountCommand = new ProcessBuilder("sh", "-c", "diskutil umount force \"" + mountPath + "\"");
        }

        @Override
        public void unmount() throws Mounter.CommandFailedException {
            this.unmount(this.unmountCommand);
        }

        @Override
        public Optional<Mounter.UnmountOperation> forced() {
            return Optional.of(() -> this.unmount(this.forcedUnmountCommand));
        }

        private void unmount(ProcessBuilder command) throws Mounter.CommandFailedException {
            if (!Files.isDirectory(this.mountPath, new LinkOption[0])) {
                LOG.debug("Volume already unmounted.");
                return;
            }
            ProcessUtil.assertExitValue(ProcessUtil.startAndWaitFor(command, 10L, TimeUnit.SECONDS), 0);
        }

        @Override
        public Optional<Path> getMountPoint() {
            return Optional.of(this.mountPath);
        }

        @Override
        public URI getWebDavUri() {
            return this.uri;
        }

        @Override
        public void reveal() throws Mounter.CommandFailedException {
            ProcessUtil.assertExitValue(ProcessUtil.startAndWaitFor(this.revealCommand, 10L, TimeUnit.SECONDS), 0);
        }

        @Override
        public void reveal(Mounter.Revealer revealer) throws Exception {
            revealer.reveal(this.mountPath);
        }
    }
}

