/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.util.concurrent.atomic.LongAdder;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;

@CryptoFileSystemScoped
public class CryptoFileSystemStats {
    private final LongAdder bytesRead = new LongAdder();
    private final LongAdder bytesWritten = new LongAdder();
    private final LongAdder bytesDecrypted = new LongAdder();
    private final LongAdder bytesEncrypted = new LongAdder();
    private final LongAdder totalBytesRead = new LongAdder();
    private final LongAdder totalBytesWritten = new LongAdder();
    private final LongAdder totalBytesDecrypted = new LongAdder();
    private final LongAdder totalBytesEncrypted = new LongAdder();
    private final LongAdder chunkCacheAccesses = new LongAdder();
    private final LongAdder chunkCacheMisses = new LongAdder();
    private final LongAdder chunkCacheHits = new LongAdder();
    private final LongAdder amountOfAccessesRead = new LongAdder();
    private final LongAdder amountOfAccessesWritten = new LongAdder();

    @Inject
    CryptoFileSystemStats() {
    }

    public long pollBytesRead() {
        return this.bytesRead.sumThenReset();
    }

    public long pollTotalBytesRead() {
        return this.totalBytesRead.sum();
    }

    public void addBytesRead(long numBytes) {
        this.bytesRead.add(numBytes);
        this.totalBytesRead.add(numBytes);
    }

    public long pollBytesWritten() {
        return this.bytesWritten.sumThenReset();
    }

    public long pollTotalBytesWritten() {
        return this.totalBytesWritten.sum();
    }

    public void addBytesWritten(long numBytes) {
        this.bytesWritten.add(numBytes);
        this.totalBytesWritten.add(numBytes);
    }

    public long pollBytesDecrypted() {
        return this.bytesDecrypted.sumThenReset();
    }

    public long pollTotalBytesDecrypted() {
        return this.totalBytesDecrypted.sum();
    }

    public void addBytesDecrypted(long numBytes) {
        this.bytesDecrypted.add(numBytes);
        this.totalBytesDecrypted.add(numBytes);
    }

    public long pollBytesEncrypted() {
        return this.bytesEncrypted.sumThenReset();
    }

    public long pollTotalBytesEncrypted() {
        return this.totalBytesEncrypted.sum();
    }

    public void addBytesEncrypted(long numBytes) {
        this.bytesEncrypted.add(numBytes);
        this.totalBytesEncrypted.add(numBytes);
    }

    public long pollChunkCacheAccesses() {
        return this.chunkCacheAccesses.sumThenReset();
    }

    public void addChunkCacheAccess() {
        this.chunkCacheAccesses.increment();
        this.chunkCacheHits.increment();
    }

    public long pollChunkCacheHits() {
        return Math.max(0L, this.chunkCacheHits.sumThenReset());
    }

    public long pollChunkCacheMisses() {
        return this.chunkCacheMisses.sumThenReset();
    }

    public void addChunkCacheMiss() {
        this.chunkCacheMisses.increment();
        this.chunkCacheHits.decrement();
    }

    public long pollAmountOfAccessesRead() {
        return this.amountOfAccessesRead.sum();
    }

    public void incrementAccessesRead() {
        this.amountOfAccessesRead.increment();
    }

    public long pollAmountOfAccessesWritten() {
        return this.amountOfAccessesWritten.sum();
    }

    public void incrementAccessesWritten() {
        this.amountOfAccessesWritten.increment();
    }
}

