/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.dir;

import java.io.IOException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream;
import org.cryptomator.cryptofs.dir.DirectoryStreamComponent;

@CryptoFileSystemScoped
public class DirectoryStreamFactory {
    private final CryptoPathMapper cryptoPathMapper;
    private final DirectoryStreamComponent.Builder directoryStreamComponentBuilder;
    private final Map<CryptoDirectoryStream, DirectoryStream> streams = new HashMap<CryptoDirectoryStream, DirectoryStream>();
    private volatile boolean closed = false;

    @Inject
    public DirectoryStreamFactory(CryptoPathMapper cryptoPathMapper, DirectoryStreamComponent.Builder directoryStreamComponentBuilder) {
        this.cryptoPathMapper = cryptoPathMapper;
        this.directoryStreamComponentBuilder = directoryStreamComponentBuilder;
    }

    public synchronized CryptoDirectoryStream newDirectoryStream(CryptoPath cleartextDir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        CryptoPathMapper.CiphertextDirectory ciphertextDir = this.cryptoPathMapper.getCiphertextDir(cleartextDir);
        DirectoryStream<Path> ciphertextDirStream = Files.newDirectoryStream(ciphertextDir.path);
        CryptoDirectoryStream cleartextDirStream = this.directoryStreamComponentBuilder.dirId(ciphertextDir.dirId).ciphertextDirectoryStream(ciphertextDirStream).cleartextPath(cleartextDir).filter(filter).onClose(this.streams::remove).build().directoryStream();
        this.streams.put(cleartextDirStream, ciphertextDirStream);
        return cleartextDirStream;
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        IOException exception = new IOException("Close failed");
        Iterator<Map.Entry<CryptoDirectoryStream, DirectoryStream>> iter = this.streams.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<CryptoDirectoryStream, DirectoryStream> entry = iter.next();
            iter.remove();
            try {
                entry.getKey().close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
        }
        if (exception.getSuppressed().length > 0) {
            throw exception;
        }
    }
}

