/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.dirid;

import java.nio.file.Path;
import java.util.Map;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;

public class ObeseDirFile
implements DiagnosticResult {
    final Path dirFile;
    final long size;

    ObeseDirFile(Path dirFile, long size) {
        this.dirFile = dirFile;
        this.size = size;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.CRITICAL;
    }

    @Override
    public String toString() {
        return String.format("Unexpected file size of %s: %d should be \u2264 %d", this.dirFile, this.size, 36);
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Directory ID File", this.dirFile.toString(), "Size", Long.toString(this.size));
    }
}

