/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.lock;

import javafx.fxml.FXML;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.UserInteractionLock;
import org.cryptomator.ui.lock.LockModule;
import org.cryptomator.ui.lock.LockScoped;
import org.cryptomator.ui.lock.LockWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LockScoped
public class LockForcedController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(LockForcedController.class);
    private final Stage window;
    private final Vault vault;
    private final UserInteractionLock<LockModule.ForceLockDecision> forceLockDecisionLock;

    @Inject
    public LockForcedController(@LockWindow Stage window, @LockWindow Vault vault, UserInteractionLock<LockModule.ForceLockDecision> forceLockDecisionLock) {
        this.window = window;
        this.vault = vault;
        this.forceLockDecisionLock = forceLockDecisionLock;
        this.window.setOnHiding(this::windowClosed);
    }

    @FXML
    public void cancel() {
        this.forceLockDecisionLock.interacted(LockModule.ForceLockDecision.CANCEL);
        this.window.close();
    }

    @FXML
    public void confirmForcedLock() {
        this.forceLockDecisionLock.interacted(LockModule.ForceLockDecision.FORCE);
        this.window.close();
    }

    private void windowClosed(WindowEvent windowEvent) {
        if (this.forceLockDecisionLock.awaitingInteraction().get()) {
            LOG.debug("Lock canceled in force-lock-phase by user.");
            this.forceLockDecisionLock.interacted(LockModule.ForceLockDecision.CANCEL);
        }
    }

    public String getVaultName() {
        return this.vault.getDisplayName();
    }
}

