/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.traymenu;

import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.EventObject;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.fxapp.FxApplication;
import org.cryptomator.ui.launcher.AppLifecycleListener;
import org.cryptomator.ui.launcher.FxApplicationStarter;
import org.cryptomator.ui.preferences.SelectedPreferencesTab;
import org.cryptomator.ui.traymenu.TrayMenuScoped;

@TrayMenuScoped
class TrayMenuController {
    private final ResourceBundle resourceBundle;
    private final AppLifecycleListener appLifecycle;
    private final FxApplicationStarter fxApplicationStarter;
    private final ObservableList<Vault> vaults;
    private final PopupMenu menu;

    @Inject
    TrayMenuController(ResourceBundle resourceBundle, AppLifecycleListener appLifecycle, FxApplicationStarter fxApplicationStarter, ObservableList<Vault> vaults) {
        this.resourceBundle = resourceBundle;
        this.appLifecycle = appLifecycle;
        this.fxApplicationStarter = fxApplicationStarter;
        this.vaults = vaults;
        this.menu = new PopupMenu();
    }

    public PopupMenu getMenu() {
        return this.menu;
    }

    public void initTrayMenu() {
        this.vaults.addListener(this::vaultListChanged);
        this.vaults.forEach(v -> v.displayNameProperty().addListener(this::vaultListChanged));
        this.rebuildMenu();
    }

    private void vaultListChanged(Observable observable) {
        assert (Platform.isFxApplicationThread());
        this.rebuildMenu();
    }

    private void rebuildMenu() {
        this.menu.removeAll();
        MenuItem showMainWindowItem = new MenuItem(this.resourceBundle.getString("traymenu.showMainWindow"));
        showMainWindowItem.addActionListener(this::showMainWindow);
        this.menu.add(showMainWindowItem);
        MenuItem showPreferencesItem = new MenuItem(this.resourceBundle.getString("traymenu.showPreferencesWindow"));
        showPreferencesItem.addActionListener(this::showPreferencesWindow);
        this.menu.add(showPreferencesItem);
        this.menu.addSeparator();
        for (Vault v : this.vaults) {
            Menu submenu = this.buildSubmenu(v);
            this.menu.add(submenu);
        }
        this.menu.addSeparator();
        MenuItem lockAllItem = new MenuItem(this.resourceBundle.getString("traymenu.lockAllVaults"));
        lockAllItem.addActionListener(this::lockAllVaults);
        lockAllItem.setEnabled(!this.vaults.filtered(Vault::isUnlocked).isEmpty());
        this.menu.add(lockAllItem);
        MenuItem quitApplicationItem = new MenuItem(this.resourceBundle.getString("traymenu.quitApplication"));
        quitApplicationItem.addActionListener(this::quitApplication);
        this.menu.add(quitApplicationItem);
    }

    private Menu buildSubmenu(Vault vault) {
        Menu submenu = new Menu(vault.getDisplayName());
        if (vault.isLocked()) {
            MenuItem unlockItem = new MenuItem(this.resourceBundle.getString("traymenu.vault.unlock"));
            unlockItem.addActionListener(this.createActionListenerForVault(vault, this::unlockVault));
            submenu.add(unlockItem);
        } else if (vault.isUnlocked()) {
            MenuItem lockItem = new MenuItem(this.resourceBundle.getString("traymenu.vault.lock"));
            lockItem.addActionListener(this.createActionListenerForVault(vault, this::lockVault));
            submenu.add(lockItem);
            MenuItem revealItem = new MenuItem(this.resourceBundle.getString("traymenu.vault.reveal"));
            revealItem.addActionListener(this.createActionListenerForVault(vault, this::revealVault));
            submenu.add(revealItem);
        }
        return submenu;
    }

    private ActionListener createActionListenerForVault(Vault vault, Consumer<Vault> consumer) {
        return actionEvent -> consumer.accept(vault);
    }

    private void quitApplication(EventObject actionEvent) {
        this.appLifecycle.quit();
    }

    private void unlockVault(Vault vault) {
        this.showMainAppAndThen(app -> app.startUnlockWorkflow(vault, Optional.empty()));
    }

    private void lockVault(Vault vault) {
        this.showMainAppAndThen(app -> app.startLockWorkflow(vault, Optional.empty()));
    }

    private void lockAllVaults(ActionEvent actionEvent) {
        this.showMainAppAndThen(app -> app.getVaultService().lockAll((Collection<Vault>)this.vaults.filtered(Vault::isUnlocked), false));
    }

    private void revealVault(Vault vault) {
        this.showMainAppAndThen(app -> app.getVaultService().reveal(vault));
    }

    void showMainWindow(ActionEvent actionEvent) {
        this.showMainAppAndThen(app -> app.showMainWindow());
    }

    private void showPreferencesWindow(EventObject actionEvent) {
        this.showMainAppAndThen(app -> app.showPreferencesWindow(SelectedPreferencesTab.ANY));
    }

    private void showMainAppAndThen(Consumer<FxApplication> action) {
        this.fxApplicationStarter.get().thenAccept(action);
    }
}

