/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.handlers;

import java.util.Arrays;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.errors.Error;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.types.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHandler {
    private Logger log = LoggerFactory.getLogger(MessageHandler.class);
    private DBusConnection connection;

    public MessageHandler(DBusConnection connection) {
        this.connection = connection;
        if (this.connection != null) {
            this.connection.setWeakReferences(true);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.connection.disconnect()));
        }
    }

    public Object[] send(String service, String path, String iface, String method, String signature, Object ... args) {
        try {
            MethodCall message = new MethodCall(service, path, iface, method, 0, signature, args);
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.valueOf(message));
            }
            this.connection.sendMessage((Message)message);
            Message response = message.getReply(2000L);
            if (this.log.isTraceEnabled()) {
                this.log.trace(String.valueOf(response));
            }
            Object[] parameters = null;
            if (response != null) {
                parameters = response.getParameters();
                this.log.debug(Arrays.deepToString(parameters));
            }
            if (response instanceof Error) {
                String error;
                switch (error = response.getName()) {
                    case "org.freedesktop.DBus.Error.NoReply": 
                    case "org.freedesktop.DBus.Error.UnknownMethod": 
                    case "org.freedesktop.dbus.exceptions.NotConnected": {
                        this.log.debug(error);
                        return null;
                    }
                }
                throw new DBusException(error);
            }
            return parameters;
        }
        catch (DBusException e) {
            this.log.error("Unexpected D-Bus response:", (Throwable)e);
            return null;
        }
    }

    public Variant getProperty(String service, String path, String iface, String property) {
        Object[] response = this.send(service, path, "org.freedesktop.DBus.Properties", "Get", "ss", iface, property);
        if (response == null) {
            return null;
        }
        return (Variant)response[0];
    }

    public Variant getAllProperties(String service, String path, String iface) {
        Object[] response = this.send(service, path, "org.freedesktop.DBus.Properties", "GetAll", "ss", iface);
        if (response == null) {
            return null;
        }
        return (Variant)response[0];
    }

    public void setProperty(String service, String path, String iface, String property, Variant value) {
        this.send(service, path, "org.freedesktop.DBus.Properties", "Set", "ssv", iface, property, value);
    }

    public DBusConnection getConnection() {
        return this.connection;
    }
}

