/*
 * Decompiled with CFR 0.152.
 */
package gde.device.powerbox;

import gde.GDE;
import gde.config.Settings;
import gde.data.AbstractRecord;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.device.MeasurementPropertyTypes;
import gde.device.MeasurementType;
import gde.device.PropertyType;
import gde.device.powerbox.CoreAdapterDialog;
import gde.device.powerbox.CoreDataReader;
import gde.exception.DataInconsitsentException;
import gde.io.FileHandler;
import gde.io.LogViewReader;
import gde.io.NMEAParser;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.StringHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class CoreAdapter
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(CoreAdapter.class.getName());
    final DataExplorer application;
    final Channels channels;
    final CoreAdapterDialog dialog;

    public CoreAdapter(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        Messages.setDeviceResourceBundle((String)"gde.device.powerbox.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new CoreAdapterDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2954"), Messages.getString((String)"GDE_MSGT2954"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public CoreAdapter(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        Messages.setDeviceResourceBundle((String)"gde.device.powerbox.messages", (Locale)Settings.getInstance().getLocale(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        this.application = DataExplorer.getInstance();
        this.channels = Channels.getInstance();
        this.dialog = new CoreAdapterDialog(this.application.getShell(), this);
        if (this.application.getMenuToolBar() != null) {
            this.configureSerialPortMenu(2, Messages.getString((String)"GDE_MSGT2954"), Messages.getString((String)"GDE_MSGT2954"));
            this.updateFileMenu(this.application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(this.application.getMenuBar().getImportMenu());
        }
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return lov2osdMap;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return "";
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public synchronized void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        block6: {
            NMEAParser data = new NMEAParser(this.getDataBlockLeader(), this.getDataBlockSeparator().value(), this.getDataBlockCheckSumType(), Math.abs(this.getDataBlockSize(InputTypes.FILE_IO)), (IDevice)this, this.channels.getActiveChannelNumber(), this.getUTCdelta());
            String sThreadId = String.format("%06d", Thread.currentThread().getId());
            int progressCycle = 0;
            if (doUpdateProgressBar) {
                this.application.setProgress(progressCycle, sThreadId);
            }
            try {
                int lastLength = 0;
                for (int i = 0; i < recordDataSize; ++i) {
                    byte[] subLengthBytes = new byte[4];
                    System.arraycopy(dataBuffer, lastLength, subLengthBytes, 0, 4);
                    int subLenght = LogViewReader.parse2Int((byte[])subLengthBytes) - 8;
                    byte[] lineBuffer = new byte[subLenght];
                    System.arraycopy(dataBuffer, 4 + lastLength, lineBuffer, 0, subLenght);
                    String textInput = new String(lineBuffer, "ISO-8859-1");
                    StringTokenizer st = new StringTokenizer(textInput);
                    Vector<String> vec = new Vector<String>();
                    while (st.hasMoreTokens()) {
                        vec.add(st.nextToken("\r\n"));
                    }
                    data.parse(vec, vec.size());
                    lastLength += subLenght + 12;
                    recordSet.addNoneCalculationRecordsPoints(data.getValues(), (double)data.getTime_ms());
                    if (!doUpdateProgressBar || i % 50 != 0) continue;
                    this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
                }
                this.updateVisibilityStatus(recordSet, true);
                if (doUpdateProgressBar) {
                    this.application.setProgress(100, sThreadId);
                }
            }
            catch (Exception e) {
                String msg = e.getMessage() + Messages.getString((String)"GDE_MSGW0543");
                log.log(Level.WARNING, msg, e);
                this.application.openMessageDialog(msg);
                if (!doUpdateProgressBar) break block6;
                this.application.setProgress(0, sThreadId);
            }
        }
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int i;
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        byte[] convertBuffer = new byte[dataBufferSize];
        int[] points = new int[recordSet.size()];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 0;
        Vector<Integer> timeStamps = new Vector<Integer>(1, 1);
        if (doUpdateProgressBar) {
            this.application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        byte[] timeStampBuffer = new byte[timeStampBufferSize];
        if (!recordSet.isTimeStepConstant()) {
            System.arraycopy(dataBuffer, 0, timeStampBuffer, 0, timeStampBufferSize);
            for (i = 0; i < recordDataSize; ++i) {
                timeStamps.add(((timeStampBuffer[0 + i * 4] & 0xFF) << 24) + ((timeStampBuffer[1 + i * 4] & 0xFF) << 16) + ((timeStampBuffer[2 + i * 4] & 0xFF) << 8) + ((timeStampBuffer[3 + i * 4] & 0xFF) << 0));
            }
        }
        log.log(Level.FINE, timeStamps.size() + " timeStamps = " + timeStamps.toString());
        for (i = 0; i < recordDataSize; ++i) {
            log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + i * dataBufferSize + timeStampBufferSize);
            System.arraycopy(dataBuffer, i * dataBufferSize + timeStampBufferSize, convertBuffer, 0, dataBufferSize);
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((convertBuffer[0 + j * 4] & 0xFF) << 24) + ((convertBuffer[1 + j * 4] & 0xFF) << 16) + ((convertBuffer[2 + j * 4] & 0xFF) << 8) + ((convertBuffer[3 + j * 4] & 0xFF) << 0);
            }
            if (recordSet.isTimeStepConstant()) {
                recordSet.addPoints(points);
            } else {
                recordSet.addPoints(points, (double)((Integer)timeStamps.get(i)).intValue() / 10.0);
            }
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            this.application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            this.application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public boolean isGPSCoordinates(Record record) {
        return record.getDataType() == Record.DataType.GPS_LATITUDE || record.getDataType() == Record.DataType.GPS_LONGITUDE || record.getDataType() == Record.DataType.GPS_LATITUDE_DEGREE || record.getDataType() == Record.DataType.GPS_LONGITUDE_DEGREE;
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                switch (record.getDataType()) {
                    case GPS_LATITUDE: 
                    case GPS_LONGITUDE: 
                    case GPS_LATITUDE_DEGREE: 
                    case GPS_LONGITUDE_DEGREE: {
                        dataTableRow[index + 1] = String.format("%.6f", (double)record.get(rowIndex).intValue() / 1000000.0);
                        break;
                    }
                    default: {
                        double offset = record.getOffset();
                        double reduction = record.getReduction();
                        double factor = record.getFactor();
                        dataTableRow[index + 1] = record.getDecimalFormat().format(offset + ((double)record.realGet(rowIndex).intValue() / 1000.0 - reduction) * factor);
                    }
                }
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public double translateValue(Record record, double value) {
        double newValue = 0.0;
        switch (record.getDataType()) {
            case GPS_LATITUDE: 
            case GPS_LONGITUDE: 
            case GPS_LATITUDE_DEGREE: 
            case GPS_LONGITUDE_DEGREE: {
                newValue = value / 1000.0;
                break;
            }
            default: {
                double factor = record.getFactor();
                double offset = record.getOffset();
                double reduction = record.getReduction();
                PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
                boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
                boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                try {
                    if (subtractFirst) {
                        reduction = (double)record.getFirst().intValue() / 1000.0;
                    } else if (subtractLast) {
                        reduction = (double)record.getLast().intValue() / 1000.0;
                    }
                }
                catch (Throwable e) {
                    reduction = 0.0;
                }
                newValue = (value - reduction) * factor + offset;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double newValue = 0.0;
        switch (record.getDataType()) {
            case GPS_LATITUDE: 
            case GPS_LONGITUDE: 
            case GPS_LATITUDE_DEGREE: 
            case GPS_LONGITUDE_DEGREE: {
                newValue = value * 1000.0;
                break;
            }
            default: {
                double factor = record.getFactor();
                double offset = record.getOffset();
                double reduction = record.getReduction();
                PropertyType property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_FIRST.value());
                boolean subtractFirst = property != null ? Boolean.valueOf(property.getValue()) : false;
                property = record.getProperty(MeasurementPropertyTypes.DO_SUBTRACT_LAST.value());
                boolean subtractLast = property != null ? Boolean.valueOf(property.getValue()) : false;
                try {
                    if (subtractFirst) {
                        reduction = (double)record.getFirst().intValue() / 1000.0;
                    } else if (subtractLast) {
                        reduction = (double)record.getLast().intValue() / 1000.0;
                    }
                }
                catch (Throwable e) {
                    reduction = 0.0;
                }
                newValue = (value - offset) / factor + reduction;
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int displayableCounter = 0;
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, record.getName() + " = " + this.getMeasurementNameReplacement(recordSet.getChannelConfigNumber(), i));
            }
            if (includeReasonableDataCheck) {
                record.setDisplayable(record.hasReasonableData());
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, record.getName() + " hasReasonableData = " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "add to displayable counter: " + record.getName());
            }
            ++displayableCounter;
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        this.application.updateStatisticsData();
    }

    public CoreAdapterDialog getDialog() {
        return this.dialog;
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{IDevice.OFFSET, IDevice.FACTOR, IDevice.REDUCTION};
    }

    public void open_closeCommPort() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT2950"), (String[])new String[]{this.getDataBlockPreferredFileExtention()});
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    CoreAdapter.this.application.setPortConnected(true);
                    HashSet<String> filteredFileList = new HashSet<String>();
                    for (String selectedFilename : fd.getFileNames()) {
                        String selectedImportFile = (fd.getFilterPath() + "/" + selectedFilename).replace("\\", "/");
                        if ((selectedImportFile = selectedImportFile.replace("/", GDE.FILE_SEPARATOR)).endsWith("_Tele.log")) {
                            String string = selectedImportFile = selectedImportFile.endsWith("00_Tele.log") ? selectedImportFile : selectedImportFile.replace(selectedImportFile.substring(selectedImportFile.lastIndexOf(95) - 2), "00_Tele.log");
                            if (new File(selectedImportFile).exists()) {
                                filteredFileList.add(selectedImportFile);
                                continue;
                            }
                            String message = "No Core log file available, ending with _00_Tele.log  " + selectedImportFile;
                            log.log(Level.WARNING, message);
                            GDE.getUiNotification().setStatusMessage(message);
                            continue;
                        }
                        log.log(Level.WARNING, "No Core log file, ending with _Tele.log  " + selectedImportFile);
                    }
                    for (String tmpFileName : filteredFileList) {
                        log.log(Level.INFO, "selectedImportFile = " + tmpFileName);
                        if (tmpFileName.length() <= 22) continue;
                        try {
                            Integer channelConfigNumber = CoreAdapter.this.dialog != null && !CoreAdapter.this.dialog.isDisposed() ? CoreAdapter.this.dialog.getTabFolderSelectionIndex() + 1 : 1;
                            String recordNameExtend = tmpFileName.substring(tmpFileName.lastIndexOf(95) - 11, tmpFileName.lastIndexOf(95) - 3);
                            CoreDataReader.read(tmpFileName, CoreAdapter.this, recordNameExtend, channelConfigNumber, true);
                        }
                        catch (Throwable e) {
                            log.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    CoreAdapter.this.application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public void updateFileMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT2955"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKLM3DRelativeItem action performed! " + String.valueOf(e));
                    CoreAdapter.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2956"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + String.valueOf(e));
                    CoreAdapter.this.export2KMZ3D(1);
                }
            });
            convertKMZ3DAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZ3DAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT2957"));
            convertKMZ3DAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "convertKLM3DAbsoluteItem action performed! " + String.valueOf(e));
                    CoreAdapter.this.export2KMZ3D(2);
                }
            });
        }
    }

    public void export2KMZ3D(int type) {
        RecordSet activeRecordSet;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && activeRecordSet.containsGPSdata()) {
            int ordinalLongitude = activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE);
            ordinalLongitude = ordinalLongitude == -1 ? activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE_DEGREE) : ordinalLongitude;
            int ordinalLatitude = activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE);
            ordinalLatitude = ordinalLatitude == -1 ? activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE_DEGREE) : ordinalLongitude;
            new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT2953"), ordinalLongitude, ordinalLatitude, activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_ALTITUDE), activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_SPEED), activeRecordSet.findRecordOrdinalByUnit(new String[]{"m/s"}), activeRecordSet.findRecordOrdinalByUnit(new String[]{"km"}), -1, type == 0, type == 2);
        }
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && !(containsGPSdata = activeRecordSet.containsGPSdata())) {
            containsGPSdata = activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE) >= 0 && activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE) >= 0 || activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE_DEGREE) >= 0 && activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE_DEGREE) >= 0;
        }
        return containsGPSdata;
    }

    public String exportFile(String fileEndingType, boolean isExportTmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz") && this.isActualRecordSetWithGpsData()) {
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            int ordinalLongitude = activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE);
            ordinalLongitude = ordinalLongitude == -1 ? activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LONGITUDE_DEGREE) : ordinalLongitude;
            int ordinalLatitude = activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE);
            ordinalLatitude = ordinalLatitude == -1 ? activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_LATITUDE_DEGREE) : ordinalLongitude;
            exportFileName = new FileHandler().exportFileKMZ(ordinalLongitude, ordinalLatitude, activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_ALTITUDE), additionalMeasurementOrdinal, activeRecordSet.findRecordOrdinalByUnit(new String[]{"m/s"}), activeRecordSet.findRecordOrdinalByUnit(new String[]{"km"}), -1, true, isExportTmpDir);
        }
        return exportFileName;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        RecordSet activeRecordSet;
        Channel activeChannel = this.channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && this.isActualRecordSetWithGpsData()) {
            if (this.kmzMeasurementOrdinal == null) {
                return activeRecordSet.getRecordOrdinalOfType(Record.DataType.GPS_SPEED);
            }
            return this.kmzMeasurementOrdinal != null ? this.kmzMeasurementOrdinal : -1;
        }
        return -1;
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT2958", (Object[])GDE.MOD1));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT2958"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    CoreAdapter.this.open_closeCommPort();
                }
            });
        }
    }

    public String[] crossCheckMeasurements(String[] fileRecordsProperties, RecordSet recordSet) {
        String[] recordNames = recordSet.getRecordNames();
        Vector<String> cleanedRecordNames = new Vector<String>();
        if (recordNames.length != fileRecordsProperties.length) {
            for (String recordProps : fileRecordsProperties) {
                cleanedRecordNames.add((String)StringHelper.splitString((String)recordProps, (String)"|-|", (String[])Record.propertyKeys).get(Record.propertyKeys[0]));
            }
            recordNames = cleanedRecordNames.toArray(new String[1]);
            recordSet.clear();
            for (int j = 0; j < recordNames.length; ++j) {
                MeasurementType measurement = this.getMeasurement(recordSet.getChannelConfigNumber(), j);
                recordSet.addRecordName(recordNames[j]);
                recordSet.put(recordNames[j], (AbstractRecord)new Record((IDevice)this, j, recordNames[j], measurement.getSymbol(), measurement.getUnit(), measurement.isActive(), measurement.getStatistics(), measurement.getProperty(), 5));
            }
        }
        return recordNames;
    }

    public void matchModelNameObjectKey(String modelName) {
        Object[] tmpResult = null;
        for (String tmpObjectKey : this.application.getObjectKeys()) {
            if (tmpObjectKey.equals(modelName)) {
                tmpResult = new Object[]{tmpObjectKey, 100};
                break;
            }
            String[] nameParts = modelName.split(" |-|_");
            int hitCount = 0;
            for (String namePart : nameParts) {
                if (namePart.length() <= 1 || !tmpObjectKey.contains(namePart)) continue;
                ++hitCount;
            }
            if (hitCount <= 0 || tmpResult != null && hitCount <= (Integer)tmpResult[1]) continue;
            tmpResult = new Object[]{tmpObjectKey, hitCount};
            log.log(Level.FINE, "result updated = " + tmpObjectKey + " hitCount = " + hitCount);
        }
        if (tmpResult != null) {
            this.application.selectObjectKey((String)tmpResult[0]);
        }
    }
}

