/*
 * Decompiled with CFR 0.152.
 */
package gde.histo.transitions;

import gde.Analyzer;
import gde.data.Record;
import gde.device.TransitionClassTypes;
import gde.device.TransitionType;
import gde.device.TransitionValueTypes;
import gde.log.Logger;
import gde.utils.StringHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class AbstractDetector {
    static final String $CLASS_NAME = AbstractDetector.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    protected SettlementDeque referenceDeque;
    protected SettlementDeque thresholdDeque;
    protected SettlementDeque recoveryDeque;
    protected TriggerState previousTriggerState;
    protected TriggerState triggerState;
    protected final Analyzer analyzer;
    protected final double minmaxQuantileDistance;

    public AbstractDetector(Analyzer analyzer) {
        this.analyzer = analyzer;
        this.minmaxQuantileDistance = analyzer.getSettings().getMinmaxQuantileDistance();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.referenceDeque != null && this.thresholdDeque != null && this.recoveryDeque != null && this.recoveryDeque != null && this.previousTriggerState != null) {
            sb.append(String.format("%s > %s ", new Object[]{this.previousTriggerState, this.triggerState}));
            sb.append(this.previousTriggerState != null && this.previousTriggerState == TriggerState.WAITING && !this.thresholdDeque.isEmpty() ? this.referenceDeque.getFormatedDuration(this.referenceDeque.size() - 1) : (this.previousTriggerState == TriggerState.TRIGGERED && !this.thresholdDeque.isEmpty() ? this.thresholdDeque.getFormatedDuration(this.thresholdDeque.size() - 1) : (this.previousTriggerState == TriggerState.RECOVERING && !this.recoveryDeque.isEmpty() ? this.recoveryDeque.getFormatedDuration(this.recoveryDeque.size() - 1) : "null")));
            sb.append(String.format(": referenceDequeSize=%d  thresholdDequeSize=%d  recoveryDequeSize=%d", this.referenceDeque.size(), this.thresholdDeque.size(), this.recoveryDeque.size())).append("\n");
            sb.append(String.format("%38s reference bench=%.1f extreme=", "", this.referenceDeque.getBenchmarkValue()) + this.referenceDeque.getExtremeValue() + String.valueOf(this.referenceDeque.getTranslatedValues()));
            sb.append(" @ " + String.valueOf(this.referenceDeque.getTimestamps_100ns())).append("\n");
            sb.append(String.format("%38s threshold bench=%.1f extreme=", "", this.thresholdDeque.getBenchmarkValue()) + this.thresholdDeque.getExtremeValue() + String.valueOf(this.thresholdDeque.getTranslatedValues()));
            sb.append(" @ " + String.valueOf(this.thresholdDeque.getTimestamps_100ns()));
            if (!this.recoveryDeque.isEmpty()) {
                sb.append("\n");
                sb.append(String.format("%38s recovery  bench=%.1f extreme=", "", this.recoveryDeque.getBenchmarkValue()) + this.recoveryDeque.getExtremeValue() + String.valueOf(this.recoveryDeque.getTranslatedValues()));
                sb.append(" @ " + String.valueOf(this.recoveryDeque.getTimestamps_100ns()));
            }
        }
        return sb.toString();
    }

    protected class SettlementDeque
    extends ArrayDeque<Double> {
        private static final long serialVersionUID = 915484098600135376L;
        private static final int CAPACITY_SURPLUS = 11;
        private boolean isMinimumExtremum;
        private long timePeriod_100ns;
        protected double extremeValue;
        protected int startIndex;
        private ArrayDeque<Long> timeStampDeque;
        private List<Double> sortedValues;

        public SettlementDeque(int numElements, boolean isMinimumExtremum, long timePeriod_100ns) {
            super(numElements + 11);
            this.isMinimumExtremum = isMinimumExtremum;
            this.timePeriod_100ns = timePeriod_100ns;
            this.timeStampDeque = new ArrayDeque(numElements);
            this.sortedValues = null;
            this.clear();
        }

        @Override
        @Deprecated
        public boolean add(Double translatedValue) {
            throw new UnsupportedOperationException();
        }

        public void addFirst(double translatedValue, long timeStamp_100ns) {
            super.addFirst(translatedValue);
            this.extremeValue = this.isMinimumExtremum ? Math.min(this.extremeValue, translatedValue) : Math.max(this.extremeValue, translatedValue);
            this.sortedValues = null;
            this.timeStampDeque.addFirst(timeStamp_100ns);
            this.ensureTimePeriod();
        }

        public void addLast(double translatedValue, long timeStamp_100ns) {
            super.addLast(translatedValue);
            this.extremeValue = this.isMinimumExtremum ? Math.min(this.extremeValue, translatedValue) : Math.max(this.extremeValue, translatedValue);
            this.sortedValues = null;
            this.timeStampDeque.addLast(timeStamp_100ns);
            this.ensureTimePeriod();
        }

        @Override
        @Deprecated
        public void addLast(Double translatedValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            super.clear();
            this.timeStampDeque.clear();
            this.extremeValue = this.isMinimumExtremum ? Double.MAX_VALUE : -1.7976931348623157E308;
            this.sortedValues = null;
        }

        public void initialize(int newStartIndex) {
            this.clear();
            this.startIndex = newStartIndex;
        }

        public void reInitialize(int removedCount) {
            if (this.isEmpty()) {
                this.clear();
            } else {
                this.startIndex -= removedCount;
                this.sortedValues = null;
                if (this.isMinimumExtremum) {
                    this.extremeValue = Double.MAX_VALUE;
                    for (Double value : this) {
                        this.extremeValue = Math.min(this.extremeValue, value);
                    }
                } else {
                    this.extremeValue = -1.7976931348623157E308;
                    for (Double value : this) {
                        this.extremeValue = Math.max(this.extremeValue, value);
                    }
                }
            }
        }

        @Override
        @Deprecated
        public SettlementDeque clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean offer(Double translatedValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean offerFirst(Double translatedValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean offerLast(Double translatedValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double poll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Double pollFirst() {
            Double removedItem = (Double)super.pollFirst();
            this.timeStampDeque.pollFirst();
            this.setExtremeValue(removedItem);
            this.sortedValues = null;
            return removedItem;
        }

        @Override
        public Double pollLast() {
            Double removedItem = (Double)super.pollLast();
            this.timeStampDeque.pollLast();
            this.setExtremeValue(removedItem);
            this.sortedValues = null;
            return removedItem;
        }

        @Override
        @Deprecated
        public void push(Double translatedValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double pop() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double removeFirst() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Double removeLast() {
            throw new UnsupportedOperationException();
        }

        public void addLastByMoving(SettlementDeque settlementDeque) {
            Iterator<Long> iteratorTimeStamp = settlementDeque.timeStampDeque.iterator();
            for (Double value : settlementDeque) {
                this.addLast(value, iteratorTimeStamp.next());
            }
            settlementDeque.clear();
        }

        public int tryAddLastByMoving(SettlementDeque settlementDeque) {
            long nextTimeStamp_100ns;
            int movedCount = 0;
            Iterator iterator = settlementDeque.iterator();
            Iterator<Long> iteratorTimeStamp = settlementDeque.timeStampDeque.iterator();
            while (iterator.hasNext() && this.isAddableInTimePeriod(nextTimeStamp_100ns = iteratorTimeStamp.next().longValue())) {
                this.addLast((Double)iterator.next(), nextTimeStamp_100ns);
                iterator.remove();
                iteratorTimeStamp.remove();
                ++movedCount;
            }
            if (movedCount > 0) {
                settlementDeque.reInitialize(movedCount);
            }
            return movedCount;
        }

        public boolean isAddableInTimePeriod(long timeStamp_100ns) {
            return !this.timeStampDeque.isEmpty() ? timeStamp_100ns - this.timeStampDeque.peekFirst() <= this.timePeriod_100ns : true;
        }

        private void ensureTimePeriod() {
            if (!this.timeStampDeque.isEmpty()) {
                for (int i = 0; i < this.timeStampDeque.size() && this.getDuration_ms() > this.timePeriod_100ns; ++i) {
                    this.pollFirst();
                }
            }
        }

        public long getDuration_ms() {
            return !this.timeStampDeque.isEmpty() ? this.timeStampDeque.peekLast() - this.timeStampDeque.peekFirst() : 0L;
        }

        public List<Double> getSortedValues() {
            if (this.sortedValues == null) {
                this.sortedValues = new ArrayList<Double>(this);
                Collections.sort(this.sortedValues);
            }
            return this.sortedValues;
        }

        public double getQuantileValue(double probabilityCutPoint) {
            int realSize = this.getSortedValues().size();
            if (realSize > 0) {
                if (probabilityCutPoint >= 1.0 / (double)(realSize + 1) && probabilityCutPoint < (double)realSize / (double)(realSize + 1)) {
                    double position = (double)(realSize + 1) * probabilityCutPoint;
                    return this.getSortedValues().get((int)position - 1) + (position - (double)((int)position)) * (this.getSortedValues().get((int)position) - this.getSortedValues().get((int)position - 1));
                }
                if (probabilityCutPoint < 1.0 / (double)(realSize + 1)) {
                    return this.getSortedValues().get(0);
                }
                return this.getSortedValues().get(realSize - 1);
            }
            throw new UnsupportedOperationException();
        }

        public double getBenchmarkValue() {
            if (AbstractDetector.this.minmaxQuantileDistance == 0.0) {
                return this.extremeValue;
            }
            return this.isMinimumExtremum ? this.getQuantileValue(AbstractDetector.this.minmaxQuantileDistance) : this.getQuantileValue(1.0 - AbstractDetector.this.minmaxQuantileDistance);
        }

        public double getSecurityValue() {
            if (this.isEmpty()) {
                return Double.NaN;
            }
            return this.isMinimumExtremum ? this.getQuantileValue(1.0 - AbstractDetector.this.minmaxQuantileDistance) : this.getQuantileValue(AbstractDetector.this.minmaxQuantileDistance);
        }

        public double getAverageValue() {
            double averageValue = 0.0;
            int i = 0;
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                double translatedValue = (Double)iterator.next();
                averageValue += (translatedValue - averageValue) / (double)(++i);
            }
            log.log(Level.FINEST, "averageValue=", averageValue);
            return averageValue;
        }

        private void setExtremeValue(double removedValue) {
            if (this.isEmpty()) {
                this.extremeValue = this.isMinimumExtremum ? Double.MAX_VALUE : -1.7976931348623157E308;
            } else if (removedValue == this.extremeValue && removedValue != (Double)this.peekFirst()) {
                log.finest(() -> String.format("removedValue=%f extremeValue=%f", removedValue, this.extremeValue));
                this.extremeValue = this.isMinimumExtremum ? this.getQuantileValue(0.0) : this.getQuantileValue(1.0);
                log.finest(() -> String.format("extremeValue=%f", this.extremeValue));
            }
        }

        public List<Double> getTranslatedValues() {
            return Arrays.asList(this.toArray(new Double[0]));
        }

        public List<Long> getTimestamps_100ns() {
            return Arrays.asList(this.timeStampDeque.toArray(new Long[0]));
        }

        public String getFormatedDuration(int index) {
            return StringHelper.getFormatedDuration("HH:mm:ss.SSS", this.getTimestamps_100ns().get(index) / 10L);
        }

        public boolean isMinimumExtremum() {
            return this.isMinimumExtremum;
        }

        public long getTimePeriod_100ns() {
            return this.timePeriod_100ns;
        }

        public double getExtremeValue() {
            return this.extremeValue;
        }

        public int getStartIndex() {
            return this.startIndex;
        }
    }

    protected static enum TriggerState {
        WAITING,
        TRIGGERED,
        RECOVERING;

    }

    protected class LevelChecker {
        private final TransitionType transitionType;
        private final double absoluteDelta;
        private final double translatedThresholdValue;
        private final double translatedRecoveryValue;
        private final boolean isDeltaFactor;
        private final boolean isDeltaValue;

        LevelChecker(Record transitionRecord, TransitionType transitionType) {
            this.transitionType = transitionType;
            this.isDeltaFactor = this.transitionType.getValueType() == TransitionValueTypes.DELTA_FACTOR;
            this.isDeltaValue = this.transitionType.getValueType() == TransitionValueTypes.DELTA_VALUE;
            double translatedMaxValue = AbstractDetector.this.analyzer.getActiveDevice().translateValue(transitionRecord, (double)transitionRecord.getMaxValue() / 1000.0);
            double translatedMinValue = AbstractDetector.this.analyzer.getActiveDevice().translateValue(transitionRecord, (double)transitionRecord.getMinValue() / 1000.0);
            this.absoluteDelta = AbstractDetector.this.analyzer.getSettings().getAbsoluteTransitionLevel() * (translatedMaxValue - translatedMinValue);
            this.translatedThresholdValue = transitionType.getThresholdValue();
            this.translatedRecoveryValue = transitionType.getClassType() != TransitionClassTypes.SLOPE ? transitionType.getRecoveryValue().orElseThrow(() -> new UnsupportedOperationException("recovery value. transitionID=" + transitionType.getTransitionId())) : 0.0;
        }

        boolean isBeyondThresholdLevel(double translatedValue) {
            boolean isBeyond;
            if (AbstractDetector.this.referenceDeque.isEmpty()) {
                isBeyond = false;
            } else if (this.isDeltaFactor) {
                double baseValue = AbstractDetector.this.referenceDeque.getBenchmarkValue();
                isBeyond = this.transitionType.isGreater() ? translatedValue > baseValue + this.absoluteDelta && translatedValue > baseValue + this.transitionType.getThresholdValue() * Math.abs(baseValue) : translatedValue < baseValue - this.absoluteDelta && translatedValue < baseValue + this.transitionType.getThresholdValue() * Math.abs(baseValue);
            } else if (this.isDeltaValue) {
                double baseValue = AbstractDetector.this.referenceDeque.getBenchmarkValue();
                isBeyond = this.transitionType.isGreater() ? translatedValue > baseValue + this.translatedThresholdValue : translatedValue < baseValue + this.translatedThresholdValue;
            } else if (this.transitionType.getValueType() == TransitionValueTypes.UPPER_THRESHOLD) {
                isBeyond = translatedValue > this.translatedThresholdValue;
            } else if (this.transitionType.getValueType() == TransitionValueTypes.LOWER_THRESHOLD) {
                isBeyond = translatedValue < this.translatedThresholdValue;
            } else {
                throw new UnsupportedOperationException();
            }
            return isBeyond;
        }

        boolean isBeyondRecoveryLevel(double translatedValue) {
            boolean isBeyond;
            if (this.isDeltaFactor) {
                double baseValue = AbstractDetector.this.referenceDeque.getBenchmarkValue();
                isBeyond = this.transitionType.isGreater() ? translatedValue < baseValue + (Double)this.transitionType.getRecoveryValue().orElse(null) * baseValue : translatedValue > baseValue + (Double)this.transitionType.getRecoveryValue().orElse(null) * baseValue;
            } else if (this.isDeltaValue) {
                double baseValue = AbstractDetector.this.referenceDeque.getBenchmarkValue();
                isBeyond = this.transitionType.isGreater() ? translatedValue < baseValue + this.translatedRecoveryValue : translatedValue > baseValue + this.translatedRecoveryValue;
            } else {
                isBeyond = this.transitionType.isGreater() ? translatedValue < this.translatedRecoveryValue : translatedValue > this.translatedRecoveryValue;
            }
            return isBeyond;
        }
    }
}

