/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.Field;
import org.apache.commons.math3.RealFieldElement;
import org.apache.commons.math3.analysis.RealFieldUnivariateFunction;
import org.apache.commons.math3.analysis.solvers.AllowedSolution;
import org.apache.commons.math3.analysis.solvers.BracketedRealFieldUnivariateSolver;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.apache.commons.math3.util.IntegerSequence;
import org.apache.commons.math3.util.MathArrays;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldBracketingNthOrderBrentSolver<T extends RealFieldElement<T>>
implements BracketedRealFieldUnivariateSolver<T> {
    private static final int MAXIMAL_AGING = 2;
    private final Field<T> field;
    private final int maximalOrder;
    private final T functionValueAccuracy;
    private final T absoluteAccuracy;
    private final T relativeAccuracy;
    private IntegerSequence.Incrementor evaluations;

    public FieldBracketingNthOrderBrentSolver(T relativeAccuracy, T absoluteAccuracy, T functionValueAccuracy, int maximalOrder) throws NumberIsTooSmallException {
        if (maximalOrder < 2) {
            throw new NumberIsTooSmallException(maximalOrder, (Number)2, true);
        }
        this.field = relativeAccuracy.getField();
        this.maximalOrder = maximalOrder;
        this.absoluteAccuracy = absoluteAccuracy;
        this.relativeAccuracy = relativeAccuracy;
        this.functionValueAccuracy = functionValueAccuracy;
        this.evaluations = IntegerSequence.Incrementor.create();
    }

    public int getMaximalOrder() {
        return this.maximalOrder;
    }

    @Override
    public int getMaxEvaluations() {
        return this.evaluations.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.evaluations.getCount();
    }

    @Override
    public T getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    @Override
    public T getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public T getFunctionValueAccuracy() {
        return this.functionValueAccuracy;
    }

    @Override
    public T solve(int maxEval, RealFieldUnivariateFunction<T> f2, T min, T max, AllowedSolution allowedSolution) throws NullArgumentException, NoBracketingException {
        return (T)this.solve(maxEval, f2, min, max, (RealFieldElement)((RealFieldElement)min.add(max)).divide(2.0), allowedSolution);
    }

    @Override
    public T solve(int maxEval, RealFieldUnivariateFunction<T> f2, T min, T max, T startValue, AllowedSolution allowedSolution) throws NullArgumentException, NoBracketingException {
        int signChangeIndex;
        int nbPoints;
        MathUtils.checkNotNull(f2);
        this.evaluations = this.evaluations.withMaximalCount(maxEval).withStart(0);
        RealFieldElement zero = (RealFieldElement)this.field.getZero();
        RealFieldElement nan = (RealFieldElement)zero.add(Double.NaN);
        RealFieldElement[] x2 = (RealFieldElement[])MathArrays.buildArray(this.field, this.maximalOrder + 1);
        RealFieldElement[] y2 = (RealFieldElement[])MathArrays.buildArray(this.field, this.maximalOrder + 1);
        x2[0] = min;
        x2[1] = startValue;
        x2[2] = max;
        this.evaluations.increment();
        y2[1] = f2.value(x2[1]);
        if (Precision.equals(y2[1].getReal(), 0.0, 1)) {
            return (T)x2[1];
        }
        this.evaluations.increment();
        y2[0] = f2.value(x2[0]);
        if (Precision.equals(y2[0].getReal(), 0.0, 1)) {
            return (T)x2[0];
        }
        if (y2[0].multiply(y2[1]).getReal() < 0.0) {
            nbPoints = 2;
            signChangeIndex = 1;
        } else {
            this.evaluations.increment();
            y2[2] = f2.value(x2[2]);
            if (Precision.equals(y2[2].getReal(), 0.0, 1)) {
                return (T)x2[2];
            }
            if (y2[1].multiply(y2[2]).getReal() < 0.0) {
                nbPoints = 3;
                signChangeIndex = 2;
            } else {
                throw new NoBracketingException(x2[0].getReal(), x2[2].getReal(), y2[0].getReal(), y2[2].getReal());
            }
        }
        RealFieldElement[] tmpX = (RealFieldElement[])MathArrays.buildArray(this.field, x2.length);
        RealFieldElement xA = x2[signChangeIndex - 1];
        RealFieldElement yA = y2[signChangeIndex - 1];
        RealFieldElement absXA = (RealFieldElement)xA.abs();
        RealFieldElement absYA = (RealFieldElement)yA.abs();
        int agingA = 0;
        RealFieldElement xB = x2[signChangeIndex];
        RealFieldElement yB = y2[signChangeIndex];
        RealFieldElement absXB = (RealFieldElement)xB.abs();
        RealFieldElement absYB = (RealFieldElement)yB.abs();
        int agingB = 0;
        while (true) {
            RealFieldElement nextX;
            RealFieldElement maxX = absXA.subtract(absXB).getReal() < 0.0 ? absXB : absXA;
            RealFieldElement maxY = absYA.subtract(absYB).getReal() < 0.0 ? absYB : absYA;
            RealFieldElement xTol = this.absoluteAccuracy.add((RealFieldElement)this.relativeAccuracy.multiply((RealFieldElement)maxX));
            if (xB.subtract(xA).subtract(xTol).getReal() <= 0.0 || ((RealFieldElement)maxY.subtract(this.functionValueAccuracy)).getReal() < 0.0) {
                switch (allowedSolution) {
                    case ANY_SIDE: {
                        return (T)(absYA.subtract(absYB).getReal() < 0.0 ? xA : xB);
                    }
                    case LEFT_SIDE: {
                        return (T)xA;
                    }
                    case RIGHT_SIDE: {
                        return (T)xB;
                    }
                    case BELOW_SIDE: {
                        return (T)(yA.getReal() <= 0.0 ? xA : xB);
                    }
                    case ABOVE_SIDE: {
                        return (T)(yA.getReal() < 0.0 ? xB : xA);
                    }
                }
                throw new MathInternalError(null);
            }
            RealFieldElement targetY = agingA >= 2 ? (RealFieldElement)((RealFieldElement)yB.divide(16.0)).negate() : (agingB >= 2 ? (RealFieldElement)((RealFieldElement)yA.divide(16.0)).negate() : zero);
            int start = 0;
            int end = nbPoints;
            do {
                System.arraycopy(x2, start, tmpX, start, end - start);
                nextX = this.guessX(targetY, tmpX, y2, start, end);
                if (nextX.subtract(xA).getReal() > 0.0 && nextX.subtract(xB).getReal() < 0.0) continue;
                if (signChangeIndex - start >= end - signChangeIndex) {
                    ++start;
                } else {
                    --end;
                }
                nextX = nan;
            } while (Double.isNaN(nextX.getReal()) && end - start > 1);
            if (Double.isNaN(nextX.getReal())) {
                nextX = (RealFieldElement)xA.add(xB.subtract(xA).divide(2.0));
                start = signChangeIndex - 1;
                end = signChangeIndex;
            }
            this.evaluations.increment();
            RealFieldElement nextY = f2.value(nextX);
            if (Precision.equals(nextY.getReal(), 0.0, 1)) {
                return (T)nextX;
            }
            if (nbPoints > 2 && end - start != nbPoints) {
                nbPoints = end - start;
                System.arraycopy(x2, start, x2, 0, nbPoints);
                System.arraycopy(y2, start, y2, 0, nbPoints);
                signChangeIndex -= start;
            } else if (nbPoints == x2.length) {
                --nbPoints;
                if (signChangeIndex >= (x2.length + 1) / 2) {
                    System.arraycopy(x2, 1, x2, 0, nbPoints);
                    System.arraycopy(y2, 1, y2, 0, nbPoints);
                    --signChangeIndex;
                }
            }
            System.arraycopy(x2, signChangeIndex, x2, signChangeIndex + 1, nbPoints - signChangeIndex);
            x2[signChangeIndex] = nextX;
            System.arraycopy(y2, signChangeIndex, y2, signChangeIndex + 1, nbPoints - signChangeIndex);
            y2[signChangeIndex] = nextY;
            ++nbPoints;
            if (nextY.multiply(yA).getReal() <= 0.0) {
                xB = nextX;
                yB = nextY;
                absYB = (RealFieldElement)yB.abs();
                ++agingA;
                agingB = 0;
                continue;
            }
            xA = nextX;
            yA = nextY;
            absYA = (RealFieldElement)yA.abs();
            agingA = 0;
            ++agingB;
            ++signChangeIndex;
        }
    }

    private T guessX(T targetY, T[] x2, T[] y2, int start, int end) {
        for (int i2 = start; i2 < end - 1; ++i2) {
            int delta = i2 + 1 - start;
            for (int j2 = end - 1; j2 > i2; --j2) {
                x2[j2] = (RealFieldElement)((RealFieldElement)x2[j2].subtract(x2[j2 - 1])).divide(y2[j2].subtract(y2[j2 - delta]));
            }
        }
        RealFieldElement x0 = (RealFieldElement)this.field.getZero();
        for (int j3 = end - 1; j3 >= start; --j3) {
            x0 = (RealFieldElement)x2[j3].add(x0.multiply(targetY.subtract(y2[j3])));
        }
        return (T)x0;
    }
}

