/*
 * Decompiled with CFR 0.152.
 */
package gde.device.ardupilot;

import gde.device.ardupilot.ArduPilot;
import gde.log.Level;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class LogFMT {
    static final Logger log = Logger.getLogger(LogFMT.class.getName());
    String name;
    List<String> fmts;
    List<String> measurementNames;
    List<String> symbols;
    List<String> units;
    List<Double> mults;

    public LogFMT(String fmtEntry, String separator) {
        int i;
        String[] entries = fmtEntry.split(", ");
        this.name = entries[3];
        this.measurementNames = new ArrayList<String>();
        for (String string : entries[5].split(separator)) {
            this.measurementNames.add(String.format("%s_%s", this.name, string));
        }
        this.fmts = new ArrayList<String>();
        block73: for (i = 0; i < this.measurementNames.size(); ++i) {
            String measurementName = this.measurementNames.get(i).contains("_") ? this.measurementNames.get(i).split("_")[1] : this.measurementNames.get(i);
            byte fmt = entries[4].getBytes()[i];
            switch (ArduPilot.LogEntry.getLogEntry(this.name)) {
                case ACC: {
                    String defined_fmt = ArduPilot.ACC.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case ARSP: {
                    String defined_fmt = ArduPilot.ARSP.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case BARO: {
                    String defined_fmt = ArduPilot.BARO.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case CURR: {
                    String defined_fmt = ArduPilot.CURR.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case CURR_CELL: {
                    String defined_fmt = ArduPilot.CURR_CELL.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case ESC: {
                    String defined_fmt = ArduPilot.ESC.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case GPA: {
                    String defined_fmt = ArduPilot.GPA.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case GPS: {
                    String defined_fmt = ArduPilot.GPS.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case GYR: {
                    String defined_fmt = ArduPilot.GYR.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case IMT: {
                    String defined_fmt = ArduPilot.IMT.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case IMU: {
                    String defined_fmt = ArduPilot.IMU.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case ISBD: {
                    String defined_fmt = ArduPilot.ISBD.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case ISBH: {
                    String defined_fmt = ArduPilot.ISBH.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case MAG: {
                    String defined_fmt = ArduPilot.MAG.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case PID: {
                    String defined_fmt = ArduPilot.PID.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                case QUAT: {
                    String defined_fmt = ArduPilot.QUAT.getFmt(measurementName);
                    if (defined_fmt.getBytes()[0] != fmt) {
                        log.log(Level.WARNING, String.format("%s missmatch fmt log vs definition -> %c vs %c", this.measurementNames.get(i), fmt, defined_fmt.getBytes()[0]));
                    }
                    this.fmts.add("" + fmt);
                    continue block73;
                }
                default: {
                    this.fmts.add("");
                }
            }
        }
        this.symbols = new ArrayList<String>();
        block74: for (i = 0; i < this.measurementNames.size(); ++i) {
            String measurementName = this.measurementNames.get(i).contains("_") ? this.measurementNames.get(i).split("_")[1] : this.measurementNames.get(i);
            switch (ArduPilot.LogEntry.getLogEntry(this.name)) {
                case ACC: {
                    this.symbols.add(ArduPilot.ACC.getSymbol(measurementName));
                    continue block74;
                }
                case ARSP: {
                    this.symbols.add(ArduPilot.ARSP.getSymbol(measurementName));
                    continue block74;
                }
                case BARO: {
                    this.symbols.add(ArduPilot.BARO.getSymbol(measurementName));
                    continue block74;
                }
                case CURR: {
                    this.symbols.add(ArduPilot.CURR.getSymbol(measurementName));
                    continue block74;
                }
                case CURR_CELL: {
                    this.symbols.add(ArduPilot.CURR_CELL.getSymbol(measurementName));
                    continue block74;
                }
                case ESC: {
                    this.symbols.add(ArduPilot.ESC.getSymbol(measurementName));
                    continue block74;
                }
                case GPA: {
                    this.symbols.add(ArduPilot.GPA.getSymbol(measurementName));
                    continue block74;
                }
                case GPS: {
                    this.symbols.add(ArduPilot.GPS.getSymbol(measurementName));
                    continue block74;
                }
                case GYR: {
                    this.symbols.add(ArduPilot.GYR.getSymbol(measurementName));
                    continue block74;
                }
                case IMT: {
                    this.symbols.add(ArduPilot.IMT.getSymbol(measurementName));
                    continue block74;
                }
                case IMU: {
                    this.symbols.add(ArduPilot.IMU.getSymbol(measurementName));
                    continue block74;
                }
                case ISBD: {
                    this.symbols.add(ArduPilot.ISBD.getSymbol(measurementName));
                    continue block74;
                }
                case ISBH: {
                    this.symbols.add(ArduPilot.ISBH.getSymbol(measurementName));
                    continue block74;
                }
                case MAG: {
                    this.symbols.add(ArduPilot.MAG.getSymbol(measurementName));
                    continue block74;
                }
                case PID: {
                    this.symbols.add(ArduPilot.PID.getSymbol(measurementName));
                    continue block74;
                }
                case QUAT: {
                    this.symbols.add(ArduPilot.QUAT.getSymbol(measurementName));
                    continue block74;
                }
                default: {
                    this.symbols.add("");
                }
            }
        }
        this.units = new ArrayList<String>();
        block75: for (i = 0; i < this.measurementNames.size(); ++i) {
            String measurementName = this.measurementNames.get(i).contains("_") ? this.measurementNames.get(i).split("_")[1] : this.measurementNames.get(i);
            switch (ArduPilot.LogEntry.getLogEntry(this.name)) {
                case ACC: {
                    this.units.add(ArduPilot.ACC.getUnit(measurementName));
                    continue block75;
                }
                case ARSP: {
                    this.units.add(ArduPilot.ARSP.getUnit(measurementName));
                    continue block75;
                }
                case BARO: {
                    this.units.add(ArduPilot.BARO.getUnit(measurementName));
                    continue block75;
                }
                case CURR: {
                    this.units.add(ArduPilot.CURR.getUnit(measurementName));
                    continue block75;
                }
                case CURR_CELL: {
                    this.units.add(ArduPilot.CURR_CELL.getUnit(measurementName));
                    continue block75;
                }
                case ESC: {
                    this.units.add(ArduPilot.ESC.getUnit(measurementName));
                    continue block75;
                }
                case GPA: {
                    this.units.add(ArduPilot.GPA.getUnit(measurementName));
                    continue block75;
                }
                case GPS: {
                    this.units.add(ArduPilot.GPS.getUnit(measurementName));
                    continue block75;
                }
                case GYR: {
                    this.units.add(ArduPilot.GYR.getUnit(measurementName));
                    continue block75;
                }
                case IMT: {
                    this.units.add(ArduPilot.IMT.getUnit(measurementName));
                    continue block75;
                }
                case IMU: {
                    this.units.add(ArduPilot.IMU.getUnit(measurementName));
                    continue block75;
                }
                case ISBD: {
                    this.units.add(ArduPilot.ISBD.getUnit(measurementName));
                    continue block75;
                }
                case ISBH: {
                    this.units.add(ArduPilot.ISBH.getUnit(measurementName));
                    continue block75;
                }
                case MAG: {
                    this.units.add(ArduPilot.MAG.getUnit(measurementName));
                    continue block75;
                }
                case PID: {
                    this.units.add(ArduPilot.PID.getUnit(measurementName));
                    continue block75;
                }
                case QUAT: {
                    this.units.add(ArduPilot.QUAT.getUnit(measurementName));
                    continue block75;
                }
                default: {
                    this.units.add("");
                }
            }
        }
        this.mults = new ArrayList<Double>();
        block76: for (i = 0; i < this.measurementNames.size(); ++i) {
            switch (ArduPilot.LogEntry.getLogEntry(this.name)) {
                case ACC: {
                    this.mults.add(ArduPilot.ACC.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case ARSP: {
                    this.mults.add(ArduPilot.ARSP.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case BARO: {
                    this.mults.add(ArduPilot.BARO.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case CURR: {
                    this.mults.add(ArduPilot.CURR.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case CURR_CELL: {
                    this.mults.add(ArduPilot.CURR_CELL.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case ESC: {
                    this.mults.add(ArduPilot.ESC.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case GPA: {
                    this.mults.add(ArduPilot.GPA.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case GPS: {
                    this.mults.add(ArduPilot.GPS.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case GYR: {
                    this.mults.add(ArduPilot.GYR.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case IMT: {
                    this.mults.add(ArduPilot.IMT.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case IMU: {
                    this.mults.add(ArduPilot.IMU.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case ISBD: {
                    this.mults.add(ArduPilot.ISBD.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case ISBH: {
                    this.mults.add(ArduPilot.ISBH.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case MAG: {
                    this.mults.add(ArduPilot.MAG.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case PID: {
                    this.mults.add(ArduPilot.PID.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                case QUAT: {
                    this.mults.add(ArduPilot.QUAT.getMults(this.measurementNames.get(i).split("_")[1]));
                    continue block76;
                }
                default: {
                    this.mults.add(1.0);
                }
            }
        }
    }

    public String getFmt(int index) {
        return this.fmts.get(index);
    }

    public List<String> getMeasurementNames() {
        return this.measurementNames;
    }

    public List<String> getSymbols() {
        return this.symbols;
    }

    public List<String> getUnits() {
        return this.units;
    }

    public List<Double> getMults() {
        return this.mults;
    }
}

