/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.codec.CCITTG4Encoder;
import com.itextpdf.text.pdf.qrcode.ByteMatrix;
import com.itextpdf.text.pdf.qrcode.EncodeHintType;
import com.itextpdf.text.pdf.qrcode.QRCodeWriter;
import com.itextpdf.text.pdf.qrcode.WriterException;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.image.MemoryImageSource;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarcodeQRCode {
    ByteMatrix bm;

    public BarcodeQRCode(String content, int width, int height, Map<EncodeHintType, Object> hints) {
        try {
            QRCodeWriter qc = new QRCodeWriter();
            this.bm = qc.encode(content, width, height, hints);
        }
        catch (WriterException ex) {
            throw new ExceptionConverter(ex);
        }
    }

    private byte[] getBitMatrix() {
        int width = this.bm.getWidth();
        int height = this.bm.getHeight();
        int stride = (width + 7) / 8;
        byte[] b2 = new byte[stride * height];
        byte[][] mt = this.bm.getArray();
        for (int y2 = 0; y2 < height; ++y2) {
            byte[] line2 = mt[y2];
            for (int x2 = 0; x2 < width; ++x2) {
                int offset;
                if (line2[x2] == 0) continue;
                int n2 = offset = stride * y2 + x2 / 8;
                b2[n2] = (byte)(b2[n2] | (byte)(128 >> x2 % 8));
            }
        }
        return b2;
    }

    public Image getImage() throws BadElementException {
        byte[] b2 = this.getBitMatrix();
        byte[] g4 = CCITTG4Encoder.compress(b2, this.bm.getWidth(), this.bm.getHeight());
        return Image.getInstance(this.bm.getWidth(), this.bm.getHeight(), false, 256, 1, g4, null);
    }

    public java.awt.Image createAwtImage(Color foreground, Color background) {
        int f2 = foreground.getRGB();
        int g2 = background.getRGB();
        Canvas canvas2 = new Canvas();
        int width = this.bm.getWidth();
        int height = this.bm.getHeight();
        int[] pix = new int[width * height];
        byte[][] mt = this.bm.getArray();
        for (int y2 = 0; y2 < height; ++y2) {
            byte[] line2 = mt[y2];
            for (int x2 = 0; x2 < width; ++x2) {
                pix[y2 * width + x2] = line2[x2] == 0 ? f2 : g2;
            }
        }
        java.awt.Image img = canvas2.createImage(new MemoryImageSource(width, height, pix, 0, width));
        return img;
    }

    public void placeBarcode(PdfContentByte cb, BaseColor foreground, float moduleSide) {
        int width = this.bm.getWidth();
        int height = this.bm.getHeight();
        byte[][] mt = this.bm.getArray();
        cb.setColorFill(foreground);
        for (int y2 = 0; y2 < height; ++y2) {
            byte[] line2 = mt[y2];
            for (int x2 = 0; x2 < width; ++x2) {
                if (line2[x2] != 0) continue;
                cb.rectangle((float)x2 * moduleSide, (float)(height - y2 - 1) * moduleSide, moduleSide, moduleSide);
            }
        }
        cb.fill();
    }

    public Rectangle getBarcodeSize() {
        return new Rectangle(0.0f, 0.0f, this.bm.getWidth(), this.bm.getHeight());
    }
}

