/*
 * Decompiled with CFR 0.152.
 */
package gde.utils;

import gde.data.Record;
import gde.log.Level;
import gde.log.Logger;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;

public class MathUtils {
    private static Logger log = Logger.getLogger(MathUtils.class.getName());

    private static double checkRoundReq(double value) {
        double roundValue = 0.0;
        roundValue = value > 0.0 ? (value <= 0.1 ? value - value * 100.0 % 5.0 / 100.0 : (value <= 0.5 ? value - value * 100.0 % 1.0 / 100.0 : (value <= 1.0 ? value - value * 10.0 % 1.0 / 10.0 : (value <= 10.0 ? value - value % 1.0 : (value <= 50.0 ? value - value % 10.0 : (value <= 500.0 ? value - value % 50.0 : value - value % 100.0)))))) : (value >= -0.1 ? value - value * 100.0 % 5.0 / 100.0 : (value >= -0.5 ? value - value * 100.0 % 1.0 / 100.0 : (value >= -1.0 ? value - value * 10.0 % 1.0 / 10.0 : (value >= -10.0 ? value - value % 1.0 : (value >= -50.0 ? value - value % 10.0 : (value >= -500.0 ? value - value % 50.0 : value - value % 100.0))))));
        return roundValue;
    }

    public static double roundUp(double value, double delta) {
        double roundValue = MathUtils.checkRoundReq(value);
        if (value != roundValue) {
            roundValue = value > 0.0 ? (delta < 0.001 ? value + (5.0E-4 - value % 5.0E-4) : (delta < 0.005 ? value + (0.001 - value % 0.001) : (delta < 0.01 ? value + (0.0025 - value % 0.0025) : (delta < 0.025 ? value + (0.005 - value % 0.005) : (delta < 0.05 ? value + (0.01 - value % 0.01) : (delta < 0.25 ? value + (0.0175 - value % 0.0175) : (delta < 0.5 ? value + (0.025 - value % 0.025) : (delta < 1.0 ? value + (0.05 - value % 0.05) : (delta < 2.5 ? value + (0.1 - value % 0.1) : (delta < 5.0 ? value + (0.25 - value % 0.25) : (delta < 10.0 ? value + (0.5 - value % 0.5) : (delta < 25.0 ? value + (1.0 - value % 1.0) : (delta < 50.0 ? value + (2.5 - value % 2.5) : (delta < 100.0 ? value + (5.0 - value % 5.0) : (delta < 500.0 ? value + (10.0 - value % 10.0) : (delta < 1000.0 ? value + (50.0 - value % 50.0) : value + (100.0 - value % 100.0))))))))))))))))) : (delta < 0.001 ? value - value % 5.0E-4 : (delta < 0.005 ? value - value % 0.001 : (delta < 0.01 ? value - value % 0.0025 : (delta < 0.025 ? value - value % 0.005 : (delta < 0.05 ? value - value % 0.01 : (delta < 0.25 ? value - value % 0.0175 : (delta < 0.5 ? value - value % 0.025 : (delta < 1.0 ? value - value % 0.05 : (delta < 2.5 ? value - value % 0.1 : (delta < 5.0 ? value - value % 0.25 : (delta < 10.0 ? value - value % 0.5 : (delta < 25.0 ? value - value % 1.0 : (delta < 50.0 ? value - value % 2.5 : (delta < 100.0 ? value - value % 5.0 : (delta < 500.0 ? value - value % 10.0 : (delta < 1000.0 ? value - value % 50.0 : value - value % 100.0))))))))))))))));
        } else if (delta == 0.0) {
            roundValue = value > 0.0 ? value + 0.05 : value - 0.05;
        }
        return roundValue;
    }

    public static double roundDown(double value, double delta) {
        double roundValue = MathUtils.checkRoundReq(value);
        if (value != roundValue) {
            roundValue = value > 0.0 ? (delta < 0.001 ? value - value % 5.0E-4 : (delta < 0.005 ? value - value % 0.001 : (delta < 0.01 ? value - value % 0.0025 : (delta < 0.025 ? value - value % 0.005 : (delta < 0.05 ? value - value % 0.01 : (delta < 0.25 ? value - value % 0.0175 : (delta < 0.5 ? value - value % 0.025 : (delta < 1.0 ? value - value % 0.05 : (delta < 2.5 ? value - value % 0.1 : (delta < 5.0 ? value - value % 0.25 : (delta < 10.0 ? value - value % 0.5 : (delta < 25.0 ? value - value % 1.0 : (delta < 50.0 ? value - value % 2.5 : (delta < 100.0 ? value - value % 5.0 : (delta < 500.0 ? value - value % 10.0 : (delta < 1000.0 ? value - value % 50.0 : value - value % 100.0)))))))))))))))) : (delta < 0.001 ? value - (5.0E-4 + value % 5.0E-4) : (delta < 0.005 ? value - (0.001 + value % 1.0E-4) : (delta < 0.01 ? value - (0.0025 + value % 0.0025) : (delta < 0.025 ? value - (0.005 + value % 0.005) : (delta < 0.05 ? value - (0.01 + value % 0.01) : (delta < 0.25 ? value - (0.05 + value % 0.0175) : (delta < 0.5 ? value - (0.025 + value % 0.025) : (delta < 1.0 ? value - (0.05 + value % 0.05) : (delta < 2.5 ? value - (0.1 + value % 0.1) : (delta < 5.0 ? value - (0.25 + value % 0.25) : (delta < 10.0 ? value - (0.5 + value % 0.5) : (delta < 25.0 ? value - (1.0 + value % 1.0) : (delta < 50.0 ? value - (2.5 + value % 2.5) : (delta < 100.0 ? value - (5.0 + value % 5.0) : (delta < 500.0 ? value - (10.0 + value % 10.0) : (delta < 1000.0 ? value - (50.0 + value % 50.0) : value - (100.0 + value % 100.0)))))))))))))))));
        } else if (delta == 0.0) {
            roundValue = value > 0.0 ? value - 0.05 : value + 0.05;
        }
        return roundValue;
    }

    public static double roundUpAuto(double value, double delta) {
        double roundValue = MathUtils.checkRoundReq(value);
        if (value != roundValue) {
            roundValue = value > 0.0 ? (delta < 0.01 ? value + (2.5E-4 - value % 2.5E-4) : (delta < 0.025 ? value + (5.0E-4 - value % 5.0E-4) : (delta < 0.05 ? value + (0.001 - value % 0.001) : (delta < 0.1 ? value + (0.0025 - value % 0.0025) : (delta < 0.25 ? value + (0.005 - value % 0.005) : (delta < 0.5 ? value + (0.01 - value % 0.01) : (delta < 1.0 ? value + (0.025 - value % 0.025) : (delta < 2.5 ? value + (0.05 - value % 0.05) : (delta < 5.0 ? value + (0.1 - value % 0.1) : (delta < 10.0 ? value + (0.25 - value % 0.25) : (delta < 25.0 ? value + (0.5 - value % 0.5) : (delta < 50.0 ? value + (1.0 - value % 1.0) : (delta < 100.0 ? value + (2.5 - value % 2.5) : (delta < 500.0 ? value + (5.0 - value % 5.0) : (delta < 1000.0 ? value + (10.0 - value % 10.0) : (delta < 2000.0 ? value + (50.0 - value % 50.0) : value + (100.0 - value % 100.0))))))))))))))))) : (delta < 0.01 ? value - value % 2.5E-4 : (delta < 0.025 ? value - value % 5.0E-4 : (delta < 0.05 ? value - value % 0.001 : (delta < 0.1 ? value - value % 0.0025 : (delta < 0.25 ? value - value % 0.005 : (delta < 0.5 ? value - value % 0.01 : (delta < 1.0 ? value - value % 0.025 : (delta < 2.5 ? value - value % 0.05 : (delta < 5.0 ? value - value % 0.1 : (delta < 10.0 ? value - value % 0.25 : (delta < 25.0 ? value - value % 0.5 : (delta < 50.0 ? value - value % 1.0 : (delta < 100.0 ? value - value % 2.5 : (delta < 500.0 ? value - value % 5.0 : (delta < 1000.0 ? value - value % 10.0 : (delta < 2000.0 ? value - value % 50.0 : value - value % 100.0))))))))))))))));
        }
        return roundValue;
    }

    public static double roundDownAuto(double value, double delta) {
        double roundValue = MathUtils.checkRoundReq(value);
        if (value != roundValue) {
            roundValue = value > 0.0 ? (delta < 0.01 ? value - value % 2.5E-4 : (delta < 0.025 ? value - value % 5.0E-4 : (delta < 0.05 ? value - value % 0.001 : (delta < 0.1 ? value - value % 0.0025 : (delta < 0.25 ? value - value % 0.005 : (delta < 0.5 ? value - value % 0.01 : (delta < 1.0 ? value - value % 0.025 : (delta < 2.5 ? value - value % 0.05 : (delta < 5.0 ? value - value % 0.1 : (delta < 10.0 ? value - value % 0.25 : (delta < 25.0 ? value - value % 0.5 : (delta < 50.0 ? value - value % 1.0 : (delta < 100.0 ? value - value % 2.5 : (delta < 500.0 ? value - value % 5.0 : (delta < 1000.0 ? value - value % 10.0 : (delta < 2000.0 ? value - value % 50.0 : value - value % 100.0)))))))))))))))) : (delta < 0.01 ? value - (2.5E-4 + value % 2.5E-4) : (delta < 0.025 ? value - (5.0E-4 + value % 5.0E-4) : (delta < 0.05 ? value - (0.001 + value % 0.001) : (delta < 0.1 ? value - (0.0025 + value % 0.0025) : (delta < 0.25 ? value - (0.005 + value % 0.005) : (delta < 0.5 ? value - (0.01 + value % 0.01) : (delta < 1.0 ? value - (0.025 + value % 0.025) : (delta < 2.5 ? value - (0.025 + value % 0.05) : (delta < 5.0 ? value - (0.05 + value % 0.1) : (delta < 10.0 ? value - (0.25 + value % 0.25) : (delta < 25.0 ? value - (0.5 + value % 0.5) : (delta < 50.0 ? value - (1.0 + value % 1.0) : (delta < 100.0 ? value - (2.5 + value % 2.5) : (delta < 500.0 ? value - (5.0 + value % 5.0) : (delta < 1000.0 ? value - (10.0 + value % 10.0) : (delta < 2000.0 ? value - (50.0 + value % 50.0) : value - (100.0 + value % 100.0)))))))))))))))));
        }
        return roundValue;
    }

    public static Object[] adaptRounding(double minValue, double maxValue, boolean isAuto, int maxNumberTicks) {
        Object[] results = null;
        double tmpMinValue = 0.0;
        double tmpMaxValue = 0.0;
        double tmpDeltaScale = maxValue - minValue;
        if (isAuto) {
            tmpMinValue = minValue;
            tmpMaxValue = maxValue;
        } else {
            if (minValue != 0.0) {
                tmpMinValue = MathUtils.roundDown(minValue, tmpDeltaScale);
            }
            if (maxValue != 0.0) {
                tmpMaxValue = MathUtils.roundUp(maxValue, tmpDeltaScale);
            }
        }
        tmpDeltaScale = tmpMaxValue - tmpMinValue;
        if (isAuto) {
            if (tmpDeltaScale <= 1.0E-6) {
                results = MathUtils.evaluateNumTicksAuto(tmpMinValue - 0.05, tmpMaxValue + 0.05, maxNumberTicks, 1000.0);
            } else if (tmpDeltaScale <= 2.5E-4) {
                results = MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 50000.0);
                results[2] = 1;
            } else {
                results = tmpDeltaScale <= 0.0025 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 50000.0) : (tmpDeltaScale <= 0.005 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 20000.0) : (tmpDeltaScale <= 0.01 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 10000.0) : (tmpDeltaScale <= 0.05 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 2000.0) : (tmpDeltaScale <= 0.1 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 1000.0) : (tmpDeltaScale <= 0.5 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 200.0) : (tmpDeltaScale <= 1.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 100.0) : (tmpDeltaScale <= 5.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 20.0) : (tmpDeltaScale <= 10.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 10.0) : (tmpDeltaScale <= 25.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 4.0) : (tmpDeltaScale <= 50.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 2.0) : (tmpDeltaScale <= 100.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 1.0) : (tmpDeltaScale <= 500.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 0.2) : (tmpDeltaScale <= 1000.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 0.1) : (tmpDeltaScale <= 5000.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 0.02) : (tmpDeltaScale <= 10000.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 0.01) : (tmpDeltaScale <= 50000.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 0.02) : (tmpDeltaScale <= 500000.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 0.002) : (tmpDeltaScale <= 5000000.0 ? MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 2.0E-4) : MathUtils.evaluateNumTicksAuto(tmpMinValue, tmpMaxValue, maxNumberTicks, 1.0E-4)))))))))))))))))));
            }
        } else {
            results = tmpDeltaScale <= 0.0 ? MathUtils.evaluateNumTicks(tmpMinValue - 0.05, tmpMaxValue + 0.05, maxNumberTicks, 1000.0) : (tmpDeltaScale <= 0.0025 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 50000.0) : (tmpDeltaScale <= 0.005 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 20000.0) : (tmpDeltaScale <= 0.01 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 10000.0) : (tmpDeltaScale <= 0.05 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 2000.0) : (tmpDeltaScale <= 0.1 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 1000.0) : (tmpDeltaScale <= 0.5 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 200.0) : (tmpDeltaScale <= 1.0 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 100.0) : (tmpDeltaScale <= 5.0 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 50.0) : (tmpDeltaScale <= 10.0 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 10.0) : (tmpDeltaScale <= 25.0 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 4.0) : (tmpDeltaScale <= 50.0 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 2.0) : (tmpDeltaScale <= 100.0 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 1.0) : (tmpDeltaScale <= 500.0 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 0.2) : (tmpDeltaScale <= 1000.0 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 0.1) : (tmpDeltaScale <= 5000.0 ? MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 0.02) : MathUtils.evaluateNumTicks(tmpMinValue, tmpMaxValue, maxNumberTicks, 0.01))))))))))))))));
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, minValue + " --> " + tmpMinValue + " " + maxValue + " --> " + tmpMaxValue);
        }
        return results;
    }

    private static Object[] evaluateNumTicksAuto(double tmpMinValue, double tmpMaxValue, int maxNumberTicks, double raise) {
        boolean isMaxNegative;
        int newNumberTicks = 2;
        int newNumberMiniTicks = 5;
        double newMinValue = 0.0;
        double newMaxValue = 0.0;
        boolean isMinNegative = tmpMinValue < 0.0;
        boolean bl = isMaxNegative = tmpMaxValue < 0.0;
        if (!isMinNegative && !isMaxNegative) {
            newMinValue = tmpMinValue * raise % 2.0 != 0.0 ? tmpMinValue + (2.0 - tmpMinValue * raise % 2.0) / raise : tmpMinValue;
            newMaxValue = tmpMaxValue * raise % 2.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 2.0 / raise : tmpMaxValue;
            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 2.0 + 0.5);
            newNumberMiniTicks = 4;
            if (newNumberTicks > maxNumberTicks) {
                newMinValue = tmpMinValue * raise % 4.0 != 0.0 ? tmpMinValue + (4.0 - tmpMinValue * raise % 4.0) / raise : tmpMinValue;
                newMaxValue = tmpMaxValue * raise % 4.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 4.0 / raise : tmpMaxValue;
                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 4.0 + 0.5);
                newNumberMiniTicks = 4;
                if (newNumberTicks > maxNumberTicks) {
                    newMinValue = tmpMinValue * raise % 5.0 != 0.0 ? tmpMinValue + (5.0 - tmpMinValue * raise % 5.0) / raise : tmpMinValue;
                    newMaxValue = tmpMaxValue * raise % 5.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 5.0 / raise : tmpMaxValue;
                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 5.0 + 0.5);
                    newNumberMiniTicks = 5;
                    if (newNumberTicks > maxNumberTicks) {
                        newMinValue = tmpMinValue * raise % 8.0 != 0.0 ? tmpMinValue + (8.0 - tmpMinValue * raise % 8.0) / raise : tmpMinValue;
                        newMaxValue = tmpMaxValue * raise % 8.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 8.0 / raise : tmpMaxValue;
                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 8.0 + 0.5);
                        newNumberMiniTicks = 4;
                        if (newNumberTicks > maxNumberTicks) {
                            newMinValue = tmpMinValue * raise % 10.0 != 0.0 ? tmpMinValue + (10.0 - tmpMinValue * raise % 10.0) / raise : tmpMinValue;
                            newMaxValue = tmpMaxValue * raise % 10.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 10.0 / raise : tmpMaxValue;
                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 10.0 + 0.5);
                            newNumberMiniTicks = 5;
                            if (newNumberTicks > maxNumberTicks) {
                                newMinValue = tmpMinValue * raise % 16.0 != 0.0 ? tmpMinValue + (16.0 - tmpMinValue * raise % 16.0) / raise : tmpMinValue;
                                newMaxValue = tmpMaxValue * raise % 16.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 16.0 / raise : tmpMaxValue;
                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 16.0 + 0.5);
                                newNumberMiniTicks = 4;
                                if (newNumberTicks > maxNumberTicks) {
                                    newMinValue = tmpMinValue * raise % 20.0 != 0.0 ? tmpMinValue + (20.0 - tmpMinValue * raise % 20.0) / raise : tmpMinValue;
                                    newMaxValue = tmpMaxValue * raise % 20.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 20.0 / raise : tmpMaxValue;
                                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 20.0 + 0.5);
                                    newNumberMiniTicks = 5;
                                    if (newNumberTicks > maxNumberTicks) {
                                        newMinValue = tmpMinValue * raise % 32.0 != 0.0 ? tmpMinValue + (32.0 - tmpMinValue * raise % 32.0) / raise : tmpMinValue;
                                        newMaxValue = tmpMaxValue * raise % 32.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 32.0 / raise : tmpMaxValue;
                                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 32.0 + 0.5);
                                        newNumberMiniTicks = 4;
                                        if (newNumberTicks > maxNumberTicks) {
                                            newMinValue = tmpMinValue * raise % 40.0 != 0.0 ? tmpMinValue + (40.0 - tmpMinValue * raise % 40.0) / raise : tmpMinValue;
                                            newMaxValue = tmpMaxValue * raise % 40.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 40.0 / raise : tmpMaxValue;
                                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 40.0 + 0.5);
                                            newNumberMiniTicks = 5;
                                            if (newNumberTicks > maxNumberTicks) {
                                                newMinValue = tmpMinValue * raise % 80.0 != 0.0 ? tmpMinValue + (80.0 - tmpMinValue * raise % 80.0) / raise : tmpMinValue;
                                                newMaxValue = tmpMaxValue * raise % 80.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 80.0 / raise : tmpMaxValue;
                                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 80.0 + 0.5);
                                                newNumberMiniTicks = 5;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (isMinNegative && !isMaxNegative) {
            newMinValue = tmpMinValue * raise % 2.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 2.0 / raise : tmpMinValue;
            newMaxValue = tmpMaxValue * raise % 2.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 2.0 / raise : tmpMaxValue;
            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 2.0 + 0.5);
            newNumberMiniTicks = 4;
            if (newNumberTicks > maxNumberTicks) {
                newMinValue = tmpMinValue * raise % 4.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 4.0 / raise : tmpMinValue;
                newMaxValue = tmpMaxValue * raise % 4.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 4.0 / raise : tmpMaxValue;
                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 4.0 + 0.5);
                newNumberMiniTicks = 4;
                if (newNumberTicks > maxNumberTicks) {
                    newMinValue = tmpMinValue * raise % 5.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 5.0 / raise : tmpMinValue;
                    newMaxValue = tmpMaxValue * raise % 5.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 5.0 / raise : tmpMaxValue;
                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 5.0 + 0.5);
                    newNumberMiniTicks = 5;
                    if (newNumberTicks > maxNumberTicks) {
                        newMinValue = tmpMinValue * raise % 8.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 8.0 / raise : tmpMinValue;
                        newMaxValue = tmpMaxValue * raise % 8.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 8.0 / raise : tmpMaxValue;
                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 8.0 + 0.5);
                        newNumberMiniTicks = 4;
                        if (newNumberTicks > maxNumberTicks) {
                            newMinValue = tmpMinValue * raise % 10.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 10.0 / raise : tmpMinValue;
                            newMaxValue = tmpMaxValue * raise % 10.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 10.0 / raise : tmpMaxValue;
                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 10.0 + 0.5);
                            newNumberMiniTicks = 5;
                            if (newNumberTicks > maxNumberTicks) {
                                newMinValue = tmpMinValue * raise % 16.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 16.0 / raise : tmpMinValue;
                                newMaxValue = tmpMaxValue * raise % 16.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 16.0 / raise : tmpMaxValue;
                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 16.0 + 0.5);
                                newNumberMiniTicks = 4;
                                if (newNumberTicks > maxNumberTicks) {
                                    newMinValue = tmpMinValue * raise % 20.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 20.0 / raise : tmpMinValue;
                                    newMaxValue = tmpMaxValue * raise % 20.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 20.0 / raise : tmpMaxValue;
                                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 20.0 + 0.5);
                                    newNumberMiniTicks = 5;
                                    if (newNumberTicks > maxNumberTicks) {
                                        newMinValue = tmpMinValue * raise % 32.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 32.0 / raise : tmpMinValue;
                                        newMaxValue = tmpMaxValue * raise % 32.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 32.0 / raise : tmpMaxValue;
                                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 32.0 + 0.5);
                                        newNumberMiniTicks = 4;
                                        if (newNumberTicks > maxNumberTicks) {
                                            newMinValue = tmpMinValue * raise % 40.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 40.0 / raise : tmpMinValue;
                                            newMaxValue = tmpMaxValue * raise % 40.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 40.0 / raise : tmpMaxValue;
                                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 40.0 + 0.5);
                                            newNumberMiniTicks = 5;
                                            if (newNumberTicks > maxNumberTicks) {
                                                newMinValue = tmpMinValue * raise % 80.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 80.0 / raise : tmpMinValue;
                                                newMaxValue = tmpMaxValue * raise % 80.0 != 0.0 ? tmpMaxValue - tmpMaxValue * raise % 80.0 / raise : tmpMaxValue;
                                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 80.0 + 0.5);
                                                newNumberMiniTicks = 5;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (isMinNegative && isMaxNegative) {
            newMinValue = tmpMinValue * raise % 2.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 2.0 / raise : tmpMinValue;
            newMaxValue = tmpMaxValue * raise % 2.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 2.0 / raise : tmpMaxValue;
            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 2.0 + 0.5);
            newNumberMiniTicks = 4;
            if (newNumberTicks > maxNumberTicks) {
                newMinValue = tmpMinValue * raise % 4.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 4.0 / raise : tmpMinValue;
                newMaxValue = tmpMaxValue * raise % 4.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 4.0 / raise : tmpMaxValue;
                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 4.0 + 0.5);
                newNumberMiniTicks = 4;
                if (newNumberTicks > maxNumberTicks) {
                    newMinValue = tmpMinValue * raise % 5.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 5.0 / raise : tmpMinValue;
                    newMaxValue = tmpMaxValue * raise % 5.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 5.0 / raise : tmpMaxValue;
                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 5.0 + 0.5);
                    newNumberMiniTicks = 5;
                    if (newNumberTicks > maxNumberTicks) {
                        newMinValue = tmpMinValue * raise % 8.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 8.0 / raise : tmpMinValue;
                        newMaxValue = tmpMaxValue * raise % 8.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 8.0 / raise : tmpMaxValue;
                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 8.0 + 0.5);
                        newNumberMiniTicks = 4;
                        if (newNumberTicks > maxNumberTicks) {
                            newMinValue = tmpMinValue * raise % 10.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 10.0 / raise : tmpMinValue;
                            newMaxValue = tmpMaxValue * raise % 10.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 10.0 / raise : tmpMaxValue;
                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 10.0 + 0.5);
                            newNumberMiniTicks = 5;
                            if (newNumberTicks > maxNumberTicks) {
                                newMinValue = tmpMinValue * raise % 16.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 16.0 / raise : tmpMinValue;
                                newMaxValue = tmpMaxValue * raise % 16.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 16.0 / raise : tmpMaxValue;
                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 16.0 + 0.5);
                                newNumberMiniTicks = 4;
                                if (newNumberTicks > maxNumberTicks) {
                                    newMinValue = tmpMinValue * raise % 20.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 20.0 / raise : tmpMinValue;
                                    newMaxValue = tmpMaxValue * raise % 20.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 20.0 / raise : tmpMaxValue;
                                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 20.0 + 0.5);
                                    newNumberMiniTicks = 5;
                                    if (newNumberTicks > maxNumberTicks) {
                                        newMinValue = tmpMinValue * raise % 32.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 32.0 / raise : tmpMinValue;
                                        newMaxValue = tmpMaxValue * raise % 32.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 32.0 / raise : tmpMaxValue;
                                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 32.0 + 0.5);
                                        newNumberMiniTicks = 4;
                                        if (newNumberTicks > maxNumberTicks) {
                                            newMinValue = tmpMinValue * raise % 40.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 40.0 / raise : tmpMinValue;
                                            newMaxValue = tmpMaxValue * raise % 40.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 40.0 / raise : tmpMaxValue;
                                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 40.0 + 0.5);
                                            newNumberMiniTicks = 5;
                                            if (newNumberTicks > maxNumberTicks) {
                                                newMinValue = tmpMinValue * raise % 80.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 80.0 / raise : tmpMinValue;
                                                newMaxValue = tmpMaxValue * raise % 80.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 80.0 / raise : tmpMaxValue;
                                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 80.0 + 0.5);
                                                newNumberMiniTicks = 5;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return new Object[]{Double.parseDouble(String.format(Locale.ENGLISH, "%.4f", newMinValue)), Double.parseDouble(String.format(Locale.ENGLISH, "%.4f", newMaxValue)), newNumberTicks, newNumberMiniTicks, new Object()};
    }

    private static Object[] evaluateNumTicks(double tmpMinValue, double tmpMaxValue, int maxNumberTicks, double raise) {
        boolean isMaxNegative;
        int newNumberTicks = 2;
        int newNumberMiniTicks = 5;
        double newMinValue = 0.0;
        double newMaxValue = 0.0;
        boolean isMinNegative = tmpMinValue < 0.0;
        boolean bl = isMaxNegative = tmpMaxValue < 0.0;
        if (!isMinNegative && !isMaxNegative) {
            newMinValue = tmpMinValue * raise % 2.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 2.0 / raise : tmpMinValue;
            newMaxValue = tmpMaxValue * raise % 2.0 != 0.0 ? tmpMaxValue + (2.0 - tmpMaxValue * raise % 2.0) / raise : tmpMaxValue;
            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 2.0 + 0.5);
            newNumberMiniTicks = 4;
            if (newNumberTicks > maxNumberTicks) {
                newMinValue = tmpMinValue * raise % 4.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 4.0 / raise : tmpMinValue;
                newMaxValue = tmpMaxValue * raise % 4.0 != 0.0 ? tmpMaxValue + (4.0 - tmpMaxValue * raise % 4.0) / raise : tmpMaxValue;
                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 4.0 + 0.5);
                newNumberMiniTicks = 4;
                if (newNumberTicks > maxNumberTicks) {
                    newMinValue = tmpMinValue * raise % 5.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 5.0 / raise : tmpMinValue;
                    newMaxValue = tmpMaxValue * raise % 5.0 != 0.0 ? tmpMaxValue + (5.0 - tmpMaxValue * raise % 5.0) / raise : tmpMaxValue;
                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 5.0 + 0.5);
                    newNumberMiniTicks = 5;
                    if (newNumberTicks > maxNumberTicks) {
                        newMinValue = tmpMinValue * raise % 6.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 6.0 / raise : tmpMinValue;
                        newMaxValue = tmpMaxValue * raise % 6.0 != 0.0 ? tmpMaxValue + (6.0 - tmpMaxValue * raise % 6.0) / raise : tmpMaxValue;
                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 6.0 + 0.5);
                        newNumberMiniTicks = 5;
                        if (newNumberTicks > maxNumberTicks) {
                            newMinValue = tmpMinValue * raise % 7.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 7.0 / raise : tmpMinValue;
                            newMaxValue = tmpMaxValue * raise % 7.0 != 0.0 ? tmpMaxValue + (7.0 - tmpMaxValue * raise % 7.0) / raise : tmpMaxValue;
                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 7.0 + 0.5);
                            newNumberMiniTicks = 5;
                            if (newNumberTicks > maxNumberTicks) {
                                newMinValue = tmpMinValue * raise % 8.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 8.0 / raise : tmpMinValue;
                                newMaxValue = tmpMaxValue * raise % 8.0 != 0.0 ? tmpMaxValue + (8.0 - tmpMaxValue * raise % 8.0) / raise : tmpMaxValue;
                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 8.0 + 0.5);
                                newNumberMiniTicks = 4;
                                if (newNumberTicks > maxNumberTicks) {
                                    newMinValue = tmpMinValue * raise % 10.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 10.0 / raise : tmpMinValue;
                                    newMaxValue = tmpMaxValue * raise % 10.0 != 0.0 ? tmpMaxValue + (10.0 - tmpMaxValue * raise % 10.0) / raise : tmpMaxValue;
                                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 10.0 + 0.5);
                                    newNumberMiniTicks = 5;
                                    if (newNumberTicks > maxNumberTicks) {
                                        newMinValue = tmpMinValue * raise % 16.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 16.0 / raise : tmpMinValue;
                                        newMaxValue = tmpMaxValue * raise % 16.0 != 0.0 ? tmpMaxValue + (16.0 - tmpMaxValue * raise % 16.0) / raise : tmpMaxValue;
                                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 16.0 + 0.5);
                                        newNumberMiniTicks = 4;
                                        if (newNumberTicks > maxNumberTicks) {
                                            newMinValue = tmpMinValue * raise % 20.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 20.0 / raise : tmpMinValue;
                                            newMaxValue = tmpMaxValue * raise % 20.0 != 0.0 ? tmpMaxValue + (20.0 - tmpMaxValue * raise % 20.0) / raise : tmpMaxValue;
                                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 20.0 + 0.5);
                                            newNumberMiniTicks = 5;
                                            if (newNumberTicks > maxNumberTicks) {
                                                newMinValue = tmpMinValue * raise % 32.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 32.0 / raise : tmpMinValue;
                                                newMaxValue = tmpMaxValue * raise % 32.0 != 0.0 ? tmpMaxValue + (32.0 - tmpMaxValue * raise % 32.0) / raise : tmpMaxValue;
                                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 32.0 + 0.5);
                                                newNumberMiniTicks = 4;
                                                if (newNumberTicks > maxNumberTicks) {
                                                    newMinValue = tmpMinValue * raise % 40.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 40.0 / raise : tmpMinValue;
                                                    newMaxValue = tmpMaxValue * raise % 40.0 != 0.0 ? tmpMaxValue + (40.0 - tmpMaxValue * raise % 40.0) / raise : tmpMaxValue;
                                                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 40.0 + 0.5);
                                                    newNumberMiniTicks = 5;
                                                    if (newNumberTicks > maxNumberTicks) {
                                                        newMinValue = tmpMinValue * raise % 80.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 80.0 / raise : tmpMinValue;
                                                        newMaxValue = tmpMaxValue * raise % 80.0 != 0.0 ? tmpMaxValue + (80.0 - tmpMaxValue * raise % 80.0) / raise : tmpMaxValue;
                                                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 80.0 + 0.5);
                                                        newNumberMiniTicks = 5;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (isMinNegative && !isMaxNegative) {
            newMinValue = tmpMinValue * raise % 2.0 != 0.0 ? tmpMinValue - (2.0 + tmpMinValue * raise % 2.0) / raise : tmpMinValue;
            newMaxValue = tmpMaxValue * raise % 2.0 != 0.0 ? tmpMaxValue + (2.0 - tmpMaxValue * raise % 2.0) / raise : tmpMaxValue;
            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 2.0 + 0.5);
            newNumberMiniTicks = 4;
            if (newNumberTicks > maxNumberTicks) {
                newMinValue = tmpMinValue * raise % 4.0 != 0.0 ? tmpMinValue - (4.0 + tmpMinValue * raise % 4.0) / raise : tmpMinValue;
                newMaxValue = tmpMaxValue * raise % 4.0 != 0.0 ? tmpMaxValue + (4.0 - tmpMaxValue * raise % 4.0) / raise : tmpMaxValue;
                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 4.0 + 0.5);
                newNumberMiniTicks = 4;
                if (newNumberTicks > maxNumberTicks) {
                    newMinValue = tmpMinValue * raise % 5.0 != 0.0 ? tmpMinValue - (5.0 + tmpMinValue * raise % 5.0) / raise : tmpMinValue;
                    newMaxValue = tmpMaxValue * raise % 5.0 != 0.0 ? tmpMaxValue + (5.0 - tmpMaxValue * raise % 5.0) / raise : tmpMaxValue;
                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 5.0 + 0.5);
                    newNumberMiniTicks = 5;
                    if (newNumberTicks > maxNumberTicks) {
                        newMinValue = tmpMinValue * raise % 8.0 != 0.0 ? tmpMinValue - (8.0 + tmpMinValue * raise % 8.0) / raise : tmpMinValue;
                        newMaxValue = tmpMaxValue * raise % 8.0 != 0.0 ? tmpMaxValue + (8.0 - tmpMaxValue * raise % 8.0) / raise : tmpMaxValue;
                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 8.0 + 0.5);
                        newNumberMiniTicks = 4;
                        if (newNumberTicks > maxNumberTicks) {
                            newMinValue = tmpMinValue * raise % 10.0 != 0.0 ? tmpMinValue - (10.0 + tmpMinValue * raise % 10.0) / raise : tmpMinValue;
                            newMaxValue = tmpMaxValue * raise % 10.0 != 0.0 ? tmpMaxValue + (10.0 - tmpMaxValue * raise % 10.0) / raise : tmpMaxValue;
                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 10.0 + 0.5);
                            newNumberMiniTicks = 5;
                            if (newNumberTicks > maxNumberTicks) {
                                newMinValue = tmpMinValue * raise % 16.0 != 0.0 ? tmpMinValue - (16.0 + tmpMinValue * raise % 16.0) / raise : tmpMinValue;
                                newMaxValue = tmpMaxValue * raise % 16.0 != 0.0 ? tmpMaxValue + (16.0 - tmpMaxValue * raise % 16.0) / raise : tmpMaxValue;
                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 16.0 + 0.5);
                                newNumberMiniTicks = 4;
                                if (newNumberTicks > maxNumberTicks) {
                                    newMinValue = tmpMinValue * raise % 20.0 != 0.0 ? tmpMinValue - (20.0 + tmpMinValue * raise % 20.0) / raise : tmpMinValue;
                                    newMaxValue = tmpMaxValue * raise % 20.0 != 0.0 ? tmpMaxValue + (20.0 - tmpMaxValue * raise % 20.0) / raise : tmpMaxValue;
                                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 20.0 + 0.5);
                                    newNumberMiniTicks = 5;
                                    if (newNumberTicks > maxNumberTicks) {
                                        newMinValue = tmpMinValue * raise % 32.0 != 0.0 ? tmpMinValue - (32.0 + tmpMinValue * raise % 32.0) / raise : tmpMinValue;
                                        newMaxValue = tmpMaxValue * raise % 32.0 != 0.0 ? tmpMaxValue + (32.0 - tmpMaxValue * raise % 32.0) / raise : tmpMaxValue;
                                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 32.0 + 0.5);
                                        newNumberMiniTicks = 4;
                                        if (newNumberTicks > maxNumberTicks) {
                                            newMinValue = tmpMinValue * raise % 40.0 != 0.0 ? tmpMinValue - (40.0 + tmpMinValue * raise % 40.0) / raise : tmpMinValue;
                                            newMaxValue = tmpMaxValue * raise % 40.0 != 0.0 ? tmpMaxValue + (40.0 - tmpMaxValue * raise % 40.0) / raise : tmpMaxValue;
                                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 40.0 + 0.5);
                                            newNumberMiniTicks = 5;
                                            if (newNumberTicks > maxNumberTicks) {
                                                newMinValue = tmpMinValue * raise % 80.0 != 0.0 ? tmpMinValue - (80.0 + tmpMinValue * raise % 80.0) / raise : tmpMinValue;
                                                newMaxValue = tmpMaxValue * raise % 80.0 != 0.0 ? tmpMaxValue + (80.0 - tmpMaxValue * raise % 80.0) / raise : tmpMaxValue;
                                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 80.0 + 0.5);
                                                newNumberMiniTicks = 5;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } else if (isMinNegative && isMaxNegative) {
            newMinValue = tmpMinValue * raise % 2.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 2.0 / raise : tmpMinValue;
            newMaxValue = tmpMaxValue * raise % 2.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 2.0 / raise : tmpMaxValue;
            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 2.0 + 0.5);
            newNumberMiniTicks = 4;
            if (newNumberTicks > maxNumberTicks) {
                newMinValue = tmpMinValue * raise % 4.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 4.0 / raise : tmpMinValue;
                newMaxValue = tmpMaxValue * raise % 4.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 4.0 / raise : tmpMaxValue;
                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 4.0 + 0.5);
                newNumberMiniTicks = 4;
                if (newNumberTicks > maxNumberTicks) {
                    newMinValue = tmpMinValue * raise % 5.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 5.0 / raise : tmpMinValue;
                    newMaxValue = tmpMaxValue * raise % 5.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 5.0 / raise : tmpMaxValue;
                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 5.0 + 0.5);
                    newNumberMiniTicks = 5;
                    if (newNumberTicks > maxNumberTicks) {
                        newMinValue = tmpMinValue * raise % 8.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 8.0 / raise : tmpMinValue;
                        newMaxValue = tmpMaxValue * raise % 8.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 8.0 / raise : tmpMaxValue;
                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 8.0 + 0.5);
                        newNumberMiniTicks = 4;
                        if (newNumberTicks > maxNumberTicks) {
                            newMinValue = tmpMinValue * raise % 10.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 10.0 / raise : tmpMinValue;
                            newMaxValue = tmpMaxValue * raise % 10.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 10.0 / raise : tmpMaxValue;
                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 10.0 + 0.5);
                            newNumberMiniTicks = 5;
                            if (newNumberTicks > maxNumberTicks) {
                                newMinValue = tmpMinValue * raise % 16.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 16.0 / raise : tmpMinValue;
                                newMaxValue = tmpMaxValue * raise % 16.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 16.0 / raise : tmpMaxValue;
                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 16.0 + 0.5);
                                newNumberMiniTicks = 4;
                                if (newNumberTicks > maxNumberTicks) {
                                    newMinValue = tmpMinValue * raise % 20.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 20.0 / raise : tmpMinValue;
                                    newMaxValue = tmpMaxValue * raise % 20.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 20.0 / raise : tmpMaxValue;
                                    newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 20.0 + 0.5);
                                    newNumberMiniTicks = 5;
                                    if (newNumberTicks > maxNumberTicks) {
                                        newMinValue = tmpMinValue * raise % 32.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 32.0 / raise : tmpMinValue;
                                        newMaxValue = tmpMaxValue * raise % 32.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 32.0 / raise : tmpMaxValue;
                                        newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 32.0 + 0.5);
                                        newNumberMiniTicks = 4;
                                        if (newNumberTicks > maxNumberTicks) {
                                            newMinValue = tmpMinValue * raise % 40.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 40.0 / raise : tmpMinValue;
                                            newMaxValue = tmpMaxValue * raise % 40.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 40.0 / raise : tmpMaxValue;
                                            newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 40.0 + 0.5);
                                            newNumberMiniTicks = 5;
                                            if (newNumberTicks > maxNumberTicks) {
                                                newMinValue = tmpMinValue * raise % 80.0 != 0.0 ? tmpMinValue - tmpMinValue * raise % 80.0 / raise : tmpMinValue;
                                                newMaxValue = tmpMaxValue * raise % 80.0 != 0.0 ? tmpMaxValue + tmpMaxValue * raise % 80.0 / raise : tmpMaxValue;
                                                newNumberTicks = (int)((newMaxValue - newMinValue) * raise / 80.0 + 0.5);
                                                newNumberMiniTicks = 5;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return new Object[]{Double.parseDouble(String.format(Locale.ENGLISH, "%.4f", newMinValue)), Double.parseDouble(String.format(Locale.ENGLISH, "%.4f", newMaxValue)), newNumberTicks, newNumberMiniTicks, new Object()};
    }

    public static double ceilStepwise(double value, double delta) {
        BigDecimal threshold;
        if (value == 0.0) {
            return 0.0;
        }
        MathContext mC = new MathContext(13 - (int)Math.log10(value), RoundingMode.DOWN);
        BigDecimal decValue = new BigDecimal(value, mC);
        BigDecimal remainder = decValue.remainder(threshold = new BigDecimal(MathUtils.determineThreshold(value, delta), mC));
        BigDecimal toAdd = remainder.compareTo(new BigDecimal(0.0)) > 0 ? threshold.subtract(remainder) : remainder.abs();
        log.finest(() -> String.format("value=%f delta=%f threshold=%f result=%f", value, delta, threshold, decValue.add(toAdd).doubleValue()));
        return decValue.add(toAdd).doubleValue();
    }

    public static double floorStepwise(double value, double delta) {
        BigDecimal threshold;
        if (value == 0.0) {
            return 0.0;
        }
        MathContext mC = new MathContext(13 - (int)Math.log10(value), RoundingMode.DOWN);
        BigDecimal decValue = new BigDecimal(value, mC);
        BigDecimal remainder = decValue.remainder(threshold = new BigDecimal(MathUtils.determineThreshold(value, delta), mC));
        BigDecimal toSubtract = remainder.compareTo(new BigDecimal(0.0)) < 0 ? threshold.add(remainder) : remainder;
        log.finest(() -> String.format("value=%f delta=%f threshold=%f result=%f", value, delta, threshold, decValue.subtract(toSubtract).doubleValue()));
        return decValue.subtract(toSubtract).doubleValue();
    }

    private static double determineThreshold(double value, double delta) {
        double logReference;
        double d = logReference = delta != 0.0 ? Math.log10(Math.abs(delta)) : Math.log10(Math.abs(value));
        int roundConstant = logReference % 1.0 < 0.3 ? 5 : (logReference % 1.0 < 0.7 ? 10 : 20);
        return (double)roundConstant * Math.pow(10.0, Math.floor(logReference) - 2.0);
    }

    public static double calculateAverage(Record record, int start, int end) {
        int startIndex = start;
        int endIndex = end;
        if (start > end) {
            startIndex = end;
            endIndex = start;
        }
        return record.getDevice().translateValue(record, (double)record.getAvgValue(startIndex, endIndex) / 1000.0);
    }

    public static double calculateMedian(Record record, int start, int end) {
        int startIndex = start;
        int endIndex = end;
        if (start > end) {
            startIndex = end;
            endIndex = start;
        }
        int indexDelta = endIndex - startIndex + 1;
        log.log(Level.OFF, String.format("%d %d %d", startIndex, endIndex, indexDelta));
        ArrayList<Integer> array = new ArrayList<Integer>();
        for (int i = startIndex; i <= endIndex; ++i) {
            array.add(record.realGet(i));
        }
        Collections.sort(array);
        if (indexDelta == 0 || indexDelta == 1) {
            return record.getDevice().translateValue(record, (double)((Integer)array.get(0)).intValue() / 1000.0);
        }
        if (indexDelta == 2) {
            return record.getDevice().translateValue(record, (double)((Integer)array.get(0) + (Integer)array.get(1)) / 2000.0);
        }
        if (indexDelta % 2 == 0) {
            return record.getDevice().translateValue(record, (double)((Integer)array.get(indexDelta / 2) + (Integer)array.get(indexDelta / 2 + 1)) / 2000.0);
        }
        return record.getDevice().translateValue(record, (double)((Integer)array.get(indexDelta / 2 + 1)).intValue() / 1000.0);
    }
}

