/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.render;

import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.xhtmlrenderer.css.constants.CSSName;
import org.xhtmlrenderer.css.constants.IdentValue;
import org.xhtmlrenderer.css.parser.FSRGBColor;
import org.xhtmlrenderer.css.style.CalculatedStyle;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.layout.BoxCollector;
import org.xhtmlrenderer.layout.InlineBoxing;
import org.xhtmlrenderer.layout.InlinePaintable;
import org.xhtmlrenderer.layout.Layer;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.layout.PaintingInfo;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.CharCounts;
import org.xhtmlrenderer.render.ContentLimitContainer;
import org.xhtmlrenderer.render.FloatDistances;
import org.xhtmlrenderer.render.InlineLayoutBox;
import org.xhtmlrenderer.render.InlineText;
import org.xhtmlrenderer.render.JustificationInfo;
import org.xhtmlrenderer.render.MarkerData;
import org.xhtmlrenderer.render.PageBox;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.util.XRRuntimeException;

public class LineBox
extends Box
implements InlinePaintable {
    private static final float JUSTIFY_NON_SPACE_SHARE = 0.2f;
    private static final float JUSTIFY_SPACE_SHARE = 0.8f;
    private boolean _endsOnNL;
    private boolean _containsContent;
    private boolean _containsBlockLevelContent;
    private FloatDistances _floatDistances;
    private List _textDecorations;
    private int _paintingTop;
    private int _paintingHeight;
    private List _nonFlowContent;
    private MarkerData _markerData;
    private boolean _containsDynamicFunction;
    private int _contentStart;
    private int _baseline;
    private JustificationInfo _justificationInfo;

    @Override
    public String dump(LayoutContext c2, String indent, int which) {
        if (which != 2) {
            throw new IllegalArgumentException();
        }
        StringBuffer result2 = new StringBuffer(indent);
        result2.append(this);
        result2.append('\n');
        this.dumpBoxes(c2, indent, this.getNonFlowContent(), 2, result2);
        if (this.getNonFlowContent().size() > 0) {
            result2.append('\n');
        }
        this.dumpBoxes(c2, indent, this.getChildren(), 2, result2);
        return result2.toString();
    }

    @Override
    public String toString() {
        return "LineBox: (" + this.getAbsX() + "," + this.getAbsY() + ")->(" + this.getWidth() + "," + this.getHeight() + ")";
    }

    @Override
    public Rectangle getMarginEdge(CssContext cssCtx, int tx, int ty) {
        Rectangle result2 = new Rectangle(this.getX(), this.getY(), this.getContentWidth(), this.getHeight());
        result2.translate(tx, ty);
        return result2;
    }

    @Override
    public void paintInline(RenderingContext c2) {
        if (!this.getParent().getStyle().isVisible()) {
            return;
        }
        if (this.isContainsDynamicFunction()) {
            this.lookForDynamicFunctions(c2);
            int totalLineWidth = InlineBoxing.positionHorizontally((CssContext)c2, this, 0);
            this.setContentWidth(totalLineWidth);
            this.calcChildLocations();
            this.align(true);
            this.calcPaintingInfo(c2, false);
        }
        if (this._textDecorations != null) {
            c2.getOutputDevice().drawTextDecoration(c2, this);
        }
        if (c2.debugDrawLineBoxes()) {
            c2.getOutputDevice().drawDebugOutline(c2, this, FSRGBColor.GREEN);
        }
    }

    private void lookForDynamicFunctions(RenderingContext c2) {
        if (this.getChildCount() > 0) {
            for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
                Box b2 = this.getChild(i2);
                if (!(b2 instanceof InlineLayoutBox)) continue;
                ((InlineLayoutBox)b2).lookForDynamicFunctions(c2);
            }
        }
    }

    public boolean isFirstLine() {
        Box parent = this.getParent();
        return parent != null && parent.getChildCount() > 0 && parent.getChild(0) == this;
    }

    public void prunePendingInlineBoxes() {
        if (this.getChildCount() > 0) {
            Box b2;
            for (int i2 = this.getChildCount() - 1; i2 >= 0 && (b2 = this.getChild(i2)) instanceof InlineLayoutBox; --i2) {
                InlineLayoutBox iB = (InlineLayoutBox)b2;
                iB.prunePending();
                if (!iB.isPending()) continue;
                this.removeChild(i2);
            }
        }
    }

    public boolean isContainsContent() {
        return this._containsContent;
    }

    public void setContainsContent(boolean containsContent) {
        this._containsContent = containsContent;
    }

    public boolean isEndsOnNL() {
        return this._endsOnNL;
    }

    public void setEndsOnNL(boolean endsOnNL) {
        this._endsOnNL = endsOnNL;
    }

    public void align(boolean dynamic) {
        IdentValue align = this.getParent().getStyle().getIdent(CSSName.TEXT_ALIGN);
        int calcX = 0;
        if (align == IdentValue.LEFT || align == IdentValue.JUSTIFY) {
            int floatDistance = this.getFloatDistances().getLeftFloatDistance();
            calcX = this.getContentStart() + floatDistance;
            if (align == IdentValue.JUSTIFY && dynamic) {
                this.justify();
            }
        } else if (align == IdentValue.CENTER) {
            int leftFloatDistance = this.getFloatDistances().getLeftFloatDistance();
            int rightFloatDistance = this.getFloatDistances().getRightFloatDistance();
            int midpoint = leftFloatDistance + (this.getParent().getContentWidth() - leftFloatDistance - rightFloatDistance) / 2;
            calcX = midpoint - (this.getContentWidth() + this.getContentStart()) / 2;
        } else if (align == IdentValue.RIGHT) {
            int floatDistance = this.getFloatDistances().getRightFloatDistance();
            calcX = this.getParent().getContentWidth() - floatDistance - this.getContentWidth();
        }
        if (calcX != this.getX()) {
            this.setX(calcX);
            this.calcCanvasLocation();
            this.calcChildLocations();
        }
    }

    public void justify() {
        if (!this.isLastLineWithContent()) {
            int leftFloatDistance = this.getFloatDistances().getLeftFloatDistance();
            int rightFloatDistance = this.getFloatDistances().getRightFloatDistance();
            int available = this.getParent().getContentWidth() - leftFloatDistance - rightFloatDistance - this.getContentStart();
            if (available > this.getContentWidth()) {
                int toAdd = available - this.getContentWidth();
                CharCounts counts = this.countJustifiableChars();
                JustificationInfo info = new JustificationInfo();
                if (!this.getParent().getStyle().isIdent(CSSName.LETTER_SPACING, IdentValue.NORMAL)) {
                    info.setNonSpaceAdjust(0.0f);
                    info.setSpaceAdjust((float)toAdd / (float)counts.getSpaceCount());
                } else {
                    if (counts.getNonSpaceCount() > 1) {
                        info.setNonSpaceAdjust((float)toAdd * 0.2f / (float)(counts.getNonSpaceCount() - 1));
                    } else {
                        info.setNonSpaceAdjust(0.0f);
                    }
                    if (counts.getSpaceCount() > 0) {
                        info.setSpaceAdjust((float)toAdd * 0.8f / (float)counts.getSpaceCount());
                    } else {
                        info.setSpaceAdjust(0.0f);
                    }
                }
                this.adjustChildren(info);
                this.setJustificationInfo(info);
            }
        }
    }

    private void adjustChildren(JustificationInfo info) {
        float adjust = 0.0f;
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            Box b2 = (Box)i2.next();
            b2.setX(b2.getX() + Math.round(adjust));
            if (!(b2 instanceof InlineLayoutBox)) continue;
            adjust += ((InlineLayoutBox)b2).adjustHorizontalPosition(info, adjust);
        }
        this.calcChildLocations();
    }

    private boolean isLastLineWithContent() {
        if (!this._endsOnNL) {
            for (LineBox current = (LineBox)this.getNextSibling(); current != null; current = (LineBox)current.getNextSibling()) {
                if (!current.isContainsContent()) continue;
                return false;
            }
        }
        return true;
    }

    private CharCounts countJustifiableChars() {
        CharCounts result2 = new CharCounts();
        Iterator i2 = this.getChildIterator();
        while (i2.hasNext()) {
            Box b2 = (Box)i2.next();
            if (!(b2 instanceof InlineLayoutBox)) continue;
            ((InlineLayoutBox)b2).countJustifiableChars(result2);
        }
        return result2;
    }

    public FloatDistances getFloatDistances() {
        return this._floatDistances;
    }

    public void setFloatDistances(FloatDistances floatDistances) {
        this._floatDistances = floatDistances;
    }

    public boolean isContainsBlockLevelContent() {
        return this._containsBlockLevelContent;
    }

    public void setContainsBlockLevelContent(boolean containsBlockLevelContent) {
        this._containsBlockLevelContent = containsBlockLevelContent;
    }

    @Override
    public boolean intersects(CssContext cssCtx, Shape clip) {
        return clip == null || this.intersectsLine(cssCtx, clip) || this.isContainsBlockLevelContent() && this.intersectsInlineBlocks(cssCtx, clip);
    }

    private boolean intersectsLine(CssContext cssCtx, Shape clip) {
        Rectangle result2 = this.getPaintingClipEdge(cssCtx);
        return clip.intersects(result2);
    }

    @Override
    public Rectangle getPaintingClipEdge(CssContext cssCtx) {
        Box parent = this.getParent();
        Rectangle result2 = null;
        result2 = parent.getStyle().isIdent(CSSName.FS_TEXT_DECORATION_EXTENT, IdentValue.BLOCK) || this.getJustificationInfo() != null ? new Rectangle(this.getAbsX(), this.getAbsY() + this._paintingTop, parent.getAbsX() + parent.getTx() + parent.getContentWidth() - this.getAbsX(), this._paintingHeight) : new Rectangle(this.getAbsX(), this.getAbsY() + this._paintingTop, this.getContentWidth(), this._paintingHeight);
        return result2;
    }

    private boolean intersectsInlineBlocks(CssContext cssCtx, Shape clip) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            BoxCollector collector;
            boolean possibleResult;
            Box child = this.getChild(i2);
            if (!(child instanceof InlineLayoutBox ? (possibleResult = ((InlineLayoutBox)child).intersectsInlineBlocks(cssCtx, clip)) : (collector = new BoxCollector()).intersectsAny(cssCtx, clip, child))) continue;
            return true;
        }
        return false;
    }

    public List getTextDecorations() {
        return this._textDecorations;
    }

    public void setTextDecorations(List textDecorations) {
        this._textDecorations = textDecorations;
    }

    public int getPaintingHeight() {
        return this._paintingHeight;
    }

    public void setPaintingHeight(int paintingHeight) {
        this._paintingHeight = paintingHeight;
    }

    public int getPaintingTop() {
        return this._paintingTop;
    }

    public void setPaintingTop(int paintingTop) {
        this._paintingTop = paintingTop;
    }

    public void addAllChildren(List list2, Layer layer) {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box child = this.getChild(i2);
            if (this.getContainingLayer() != layer) continue;
            list2.add(child);
            if (!(child instanceof InlineLayoutBox)) continue;
            ((InlineLayoutBox)child).addAllChildren(list2, layer);
        }
    }

    public List getNonFlowContent() {
        return this._nonFlowContent == null ? Collections.EMPTY_LIST : this._nonFlowContent;
    }

    public void addNonFlowContent(BlockBox box) {
        if (this._nonFlowContent == null) {
            this._nonFlowContent = new ArrayList();
        }
        this._nonFlowContent.add(box);
    }

    @Override
    public void reset(LayoutContext c2) {
        for (int i2 = 0; i2 < this.getNonFlowContent().size(); ++i2) {
            Box content = (Box)this.getNonFlowContent().get(i2);
            content.reset(c2);
        }
        if (this._markerData != null) {
            this._markerData.restorePreviousReferenceLine(this);
        }
        super.reset(c2);
    }

    @Override
    public void calcCanvasLocation() {
        Box parent = this.getParent();
        if (parent == null) {
            throw new XRRuntimeException("calcCanvasLocation() called with no parent");
        }
        this.setAbsX(parent.getAbsX() + parent.getTx() + this.getX());
        this.setAbsY(parent.getAbsY() + parent.getTy() + this.getY());
    }

    @Override
    public void calcChildLocations() {
        super.calcChildLocations();
        for (int i2 = 0; i2 < this.getNonFlowContent().size(); ++i2) {
            Box content = (Box)this.getNonFlowContent().get(i2);
            if (!content.getStyle().isAbsolute()) continue;
            content.calcCanvasLocation();
            content.calcChildLocations();
        }
    }

    public MarkerData getMarkerData() {
        return this._markerData;
    }

    public void setMarkerData(MarkerData markerData) {
        this._markerData = markerData;
    }

    public boolean isContainsDynamicFunction() {
        return this._containsDynamicFunction;
    }

    public void setContainsDynamicFunction(boolean containsPageCounter) {
        this._containsDynamicFunction |= containsPageCounter;
    }

    public int getContentStart() {
        return this._contentStart;
    }

    public void setContentStart(int contentOffset) {
        this._contentStart = contentOffset;
    }

    public InlineText findTrailingText() {
        if (this.getChildCount() == 0) {
            return null;
        }
        for (int offset = this.getChildCount() - 1; offset >= 0; --offset) {
            Box child = this.getChild(offset);
            if (child instanceof InlineLayoutBox) {
                InlineText result2 = ((InlineLayoutBox)child).findTrailingText();
                if (result2 != null && result2.isEmpty()) continue;
                return result2;
            }
            return null;
        }
        return null;
    }

    public void trimTrailingSpace(LayoutContext c2) {
        InlineLayoutBox iB;
        IdentValue whitespace;
        InlineText text2 = this.findTrailingText();
        if (text2 != null && ((whitespace = (iB = text2.getParent()).getStyle().getWhitespace()) == IdentValue.NORMAL || whitespace == IdentValue.NOWRAP)) {
            text2.trimTrailingSpace(c2);
        }
    }

    @Override
    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        PaintingInfo pI = this.getPaintingInfo();
        if (pI != null && !pI.getAggregateBounds().contains(absX, absY)) {
            return null;
        }
        Box result2 = null;
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box child = this.getChild(i2);
            result2 = child.find(cssCtx, absX, absY, findAnonymous);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public int getBaseline() {
        return this._baseline;
    }

    public void setBaseline(int baseline) {
        this._baseline = baseline;
    }

    public boolean isContainsOnlyBlockLevelContent() {
        if (!this.isContainsBlockLevelContent()) {
            return false;
        }
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            Box b2 = this.getChild(i2);
            if (b2 instanceof BlockBox) continue;
            return false;
        }
        return true;
    }

    @Override
    public Box getRestyleTarget() {
        return this.getParent();
    }

    @Override
    public void restyle(LayoutContext c2) {
        Box parent = this.getParent();
        Element e2 = parent.getElement();
        if (e2 != null) {
            CalculatedStyle style = c2.getSharedContext().getStyle(e2, true);
            this.setStyle(style.createAnonymousStyle(IdentValue.BLOCK));
        }
        this.restyleChildren(c2);
    }

    public boolean isContainsVisibleContent() {
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            boolean maybeResult;
            Box b2 = this.getChild(i2);
            if (!(b2 instanceof BlockBox ? b2.getWidth() > 0 || b2.getHeight() > 0 : (maybeResult = ((InlineLayoutBox)b2).isContainsVisibleContent()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearSelection(List modified) {
        for (Box b2 : this.getNonFlowContent()) {
            b2.clearSelection(modified);
        }
        super.clearSelection(modified);
    }

    @Override
    public void selectAll() {
        for (BlockBox box : this.getNonFlowContent()) {
            box.selectAll();
        }
        super.selectAll();
    }

    @Override
    public void collectText(RenderingContext c2, StringBuffer buffer) throws IOException {
        for (Box b2 : this.getNonFlowContent()) {
            b2.collectText(c2, buffer);
        }
        if (this.isContainsDynamicFunction()) {
            this.lookForDynamicFunctions(c2);
        }
        super.collectText(c2, buffer);
    }

    @Override
    public void exportText(RenderingContext c2, Writer writer) throws IOException {
        int baselinePos = this.getAbsY() + this.getBaseline();
        if (baselinePos >= c2.getPage().getBottom() && this.isInDocumentFlow()) {
            this.exportPageBoxText(c2, writer, baselinePos);
        }
        for (Box b2 : this.getNonFlowContent()) {
            b2.exportText(c2, writer);
        }
        if (this.isContainsContent()) {
            StringBuffer result2 = new StringBuffer();
            this.collectText(c2, result2);
            writer.write(result2.toString().trim());
            writer.write(LINE_SEPARATOR);
        }
    }

    @Override
    public void analyzePageBreaks(LayoutContext c2, ContentLimitContainer container) {
        container.updateTop(c2, this.getAbsY());
        container.updateBottom(c2, this.getAbsY() + this.getHeight());
    }

    public void checkPagePosition(LayoutContext c2, boolean alwaysBreak) {
        if (!c2.isPageBreaksAllowed()) {
            return;
        }
        PageBox pageBox = c2.getRootLayer().getFirstPage(c2, this);
        if (pageBox != null) {
            boolean needsPageBreak;
            boolean bl = needsPageBreak = alwaysBreak || this.getAbsY() + this.getHeight() >= pageBox.getBottom() - c2.getExtraSpaceBottom();
            if (needsPageBreak) {
                this.forcePageBreakBefore(c2, IdentValue.ALWAYS, false);
                this.calcCanvasLocation();
            } else if (pageBox.getTop() + c2.getExtraSpaceTop() > this.getAbsY()) {
                int diff = pageBox.getTop() + c2.getExtraSpaceTop() - this.getAbsY();
                this.setY(this.getY() + diff);
                this.calcCanvasLocation();
            }
        }
    }

    public JustificationInfo getJustificationInfo() {
        return this._justificationInfo;
    }

    private void setJustificationInfo(JustificationInfo justificationInfo) {
        this._justificationInfo = justificationInfo;
    }
}

