/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.fonts.otf;

import com.itextpdf.text.pdf.Glyph;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.fonts.otf.FontReadingException;
import com.itextpdf.text.pdf.fonts.otf.OpenTypeFontTableReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlyphSubstitutionTableReader
extends OpenTypeFontTableReader {
    private final int[] glyphWidthsByIndex;
    private final Map<Integer, Character> glyphToCharacterMap;
    private Map<Integer, List<Integer>> rawLigatureSubstitutionMap;

    public GlyphSubstitutionTableReader(RandomAccessFileOrArray rf, int gsubTableLocation, Map<Integer, Character> glyphToCharacterMap, int[] glyphWidthsByIndex) throws IOException {
        super(rf, gsubTableLocation);
        this.glyphWidthsByIndex = glyphWidthsByIndex;
        this.glyphToCharacterMap = glyphToCharacterMap;
    }

    public void read() throws FontReadingException {
        this.rawLigatureSubstitutionMap = new LinkedHashMap<Integer, List<Integer>>();
        this.startReadingTable();
    }

    public Map<String, Glyph> getGlyphSubstitutionMap() throws FontReadingException {
        LinkedHashMap<String, Glyph> glyphSubstitutionMap = new LinkedHashMap<String, Glyph>();
        for (Integer glyphIdToReplace : this.rawLigatureSubstitutionMap.keySet()) {
            List<Integer> constituentGlyphs = this.rawLigatureSubstitutionMap.get(glyphIdToReplace);
            StringBuilder chars = new StringBuilder(constituentGlyphs.size());
            for (Integer constituentGlyphId : constituentGlyphs) {
                chars.append(this.getTextFromGlyph(constituentGlyphId, this.glyphToCharacterMap));
            }
            Glyph glyph = new Glyph(glyphIdToReplace, this.glyphWidthsByIndex[glyphIdToReplace], chars.toString());
            glyphSubstitutionMap.put(glyph.chars, glyph);
        }
        return Collections.unmodifiableMap(glyphSubstitutionMap);
    }

    private String getTextFromGlyph(int glyphId, Map<Integer, Character> glyphToCharacterMap) throws FontReadingException {
        StringBuilder chars = new StringBuilder(1);
        Character c2 = glyphToCharacterMap.get(glyphId);
        if (c2 == null) {
            List<Integer> constituentGlyphs = this.rawLigatureSubstitutionMap.get(glyphId);
            if (constituentGlyphs == null || constituentGlyphs.isEmpty()) {
                throw new FontReadingException("No corresponding character or simple glyphs found for GlyphID=" + glyphId);
            }
            for (int constituentGlyphId : constituentGlyphs) {
                chars.append(this.getTextFromGlyph(constituentGlyphId, glyphToCharacterMap));
            }
        } else {
            chars.append(c2.charValue());
        }
        return chars.toString();
    }

    @Override
    protected void readSubTable(int lookupType, int subTableLocation) throws IOException {
        if (lookupType == 1) {
            this.readSingleSubstitutionSubtable(subTableLocation);
        } else if (lookupType == 4) {
            this.readLigatureSubstitutionSubtable(subTableLocation);
        } else {
            System.err.println("LookupType " + lookupType + " is not yet handled for " + GlyphSubstitutionTableReader.class.getSimpleName());
        }
    }

    private void readSingleSubstitutionSubtable(int subTableLocation) throws IOException {
        this.rf.seek(subTableLocation);
        short substFormat = this.rf.readShort();
        LOG.debug("substFormat=" + substFormat);
        if (substFormat == 1) {
            short coverage = this.rf.readShort();
            LOG.debug("coverage=" + coverage);
            short deltaGlyphID = this.rf.readShort();
            LOG.debug("deltaGlyphID=" + deltaGlyphID);
            List<Integer> coverageGlyphIds = this.readCoverageFormat(subTableLocation + coverage);
            for (int coverageGlyphId : coverageGlyphIds) {
                int substituteGlyphId = coverageGlyphId + deltaGlyphID;
                this.rawLigatureSubstitutionMap.put(substituteGlyphId, Arrays.asList(coverageGlyphId));
            }
        } else if (substFormat == 2) {
            short coverage = this.rf.readShort();
            LOG.debug("coverage=" + coverage);
            int glyphCount = this.rf.readUnsignedShort();
            int[] substitute = new int[glyphCount];
            for (int k2 = 0; k2 < glyphCount; ++k2) {
                substitute[k2] = this.rf.readUnsignedShort();
            }
            List<Integer> coverageGlyphIds = this.readCoverageFormat(subTableLocation + coverage);
            for (int k3 = 0; k3 < glyphCount; ++k3) {
                this.rawLigatureSubstitutionMap.put(substitute[k3], Arrays.asList(coverageGlyphIds.get(k3)));
            }
        } else {
            throw new IllegalArgumentException("Bad substFormat: " + substFormat);
        }
    }

    private void readLigatureSubstitutionSubtable(int ligatureSubstitutionSubtableLocation) throws IOException {
        this.rf.seek(ligatureSubstitutionSubtableLocation);
        short substFormat = this.rf.readShort();
        LOG.debug("substFormat=" + substFormat);
        if (substFormat != 1) {
            throw new IllegalArgumentException("The expected SubstFormat is 1");
        }
        short coverage = this.rf.readShort();
        LOG.debug("coverage=" + coverage);
        int ligSetCount = this.rf.readShort();
        ArrayList<Integer> ligatureOffsets = new ArrayList<Integer>(ligSetCount);
        for (int i2 = 0; i2 < ligSetCount; ++i2) {
            short ligatureOffset = this.rf.readShort();
            ligatureOffsets.add(Integer.valueOf(ligatureOffset));
        }
        List<Integer> coverageGlyphIds = this.readCoverageFormat(ligatureSubstitutionSubtableLocation + coverage);
        if (ligSetCount != coverageGlyphIds.size()) {
            throw new IllegalArgumentException("According to the OpenTypeFont specifications, the coverage count should be equal to the no. of LigatureSetTables");
        }
        for (int i3 = 0; i3 < ligSetCount; ++i3) {
            int coverageGlyphId = coverageGlyphIds.get(i3);
            int ligatureOffset = (Integer)ligatureOffsets.get(i3);
            LOG.debug("ligatureOffset=" + ligatureOffset);
            this.readLigatureSetTable(ligatureSubstitutionSubtableLocation + ligatureOffset, coverageGlyphId);
        }
    }

    private void readLigatureSetTable(int ligatureSetTableLocation, int coverageGlyphId) throws IOException {
        int ligatureOffset;
        this.rf.seek(ligatureSetTableLocation);
        int ligatureCount = this.rf.readShort();
        LOG.debug("ligatureCount=" + ligatureCount);
        ArrayList<Integer> ligatureOffsets = new ArrayList<Integer>(ligatureCount);
        for (int i2 = 0; i2 < ligatureCount; ++i2) {
            ligatureOffset = this.rf.readShort();
            ligatureOffsets.add(ligatureOffset);
        }
        Iterator i$ = ligatureOffsets.iterator();
        while (i$.hasNext()) {
            ligatureOffset = (Integer)i$.next();
            this.readLigatureTable(ligatureSetTableLocation + ligatureOffset, coverageGlyphId);
        }
    }

    private void readLigatureTable(int ligatureTableLocation, int coverageGlyphId) throws IOException {
        this.rf.seek(ligatureTableLocation);
        short ligGlyph = this.rf.readShort();
        LOG.debug("ligGlyph=" + ligGlyph);
        short compCount = this.rf.readShort();
        ArrayList<Integer> glyphIdList = new ArrayList<Integer>();
        glyphIdList.add(coverageGlyphId);
        for (int i2 = 0; i2 < compCount - 1; ++i2) {
            short glyphId = this.rf.readShort();
            glyphIdList.add(Integer.valueOf(glyphId));
        }
        LOG.debug("glyphIdList=" + glyphIdList);
        List previousValue = this.rawLigatureSubstitutionMap.put(Integer.valueOf(ligGlyph), glyphIdList);
        if (previousValue != null) {
            LOG.warn("!!!!!!!!!!glyphId=" + ligGlyph + ",\npreviousValue=" + previousValue + ",\ncurrentVal=" + glyphIdList);
        }
    }
}

