/*
 * Decompiled with CFR 0.152.
 */
package gde.io;

import gde.GDE;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.IDevice;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.StringHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;

public class GPXWriter {
    static Logger log = Logger.getLogger(GPXWriter.class.getName());
    static String lineSep = GDE.LINE_SEPARATOR;
    static DecimalFormat df3 = new DecimalFormat("0.000");
    static final DataExplorer application = DataExplorer.getInstance();
    static final Channels channels = Channels.getInstance();
    static final String ALTITUDE_ABSOLUTE = "absolute";
    static final String ALTITUDE_RELATIVE2GROUND = "relativeToGround";
    static final String ALTITUDE_CLAMP2GROUNDE = "clampToGround";
    static final String header_xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>" + GDE.LINE_SEPARATOR;
    static final String header_gpx = "<gpx version=\"1.1\" creator=\"GNU DataExplorer\">" + GDE.LINE_SEPARATOR;
    static final String header_garmin = "<gpx xmlns=\"https://www.topografix.com/GPX/1/1\" xmlns:gpxx=\"https://www.garmin.com/xmlschemas/GpxExtensions/v3\" xmlns:gpxtrkx=\"https://www.garmin.com/xmlschemas/TrackStatsExtension/v1\" xmlns:wptx1=\"https://www.garmin.com/xmlschemas/WaypointExtension/v1\" xmlns:gpxtpx=\"https://www.garmin.com/xmlschemas/TrackPointExtension/v1\" xmlns:gpxacc=\"https://www.garmin.com/xmlschemas/AccelerationExtension/v1\" creator=\"GNU DataExplorer\" version=\"1.1\" xmlns:xsi=\"https://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"https://www.topografix.com/GPX/1/1 https://www.topografix.com/GPX/1/1/gpx.xsd https://www.garmin.com/xmlschemas/GpxExtensions/v3 https://www8.garmin.com/xmlschemas/GpxExtensionsv3.xsd https://www.garmin.com/xmlschemas/TrackStatsExtension/v1 https://www8.garmin.com/xmlschemas/TrackStatsExtension.xsd https://www.garmin.com/xmlschemas/WaypointExtension/v1 https://www8.garmin.com/xmlschemas/WaypointExtensionv1.xsd https://www.garmin.com/xmlschemas/TrackPointExtension/v1 https://www.garmin.com/xmlschemas/TrackPointExtensionv1.xsd https://www.garmin.com/xmlschemas/AccelerationExtension/v1 https://www.garmin.com/xmlschemas/AccelerationExtensionv1.xsd\">" + GDE.LINE_SEPARATOR;
    static final String footer = "</gpx>" + GDE.LINE_SEPARATOR;
    static final String metadata = "  <metadata>" + GDE.LINE_SEPARATOR + "    <link href=\"https://www.nongnu.org/dataexplorer\">" + GDE.LINE_SEPARATOR + "      <text>DataExplorer</text>" + GDE.LINE_SEPARATOR + "    </link>" + GDE.LINE_SEPARATOR + "    <time>%sT%sZ</time>" + GDE.LINE_SEPARATOR + "  </metadata>" + GDE.LINE_SEPARATOR;
    static final String track_begin = "  <trk>" + GDE.LINE_SEPARATOR + "    <name>%s</name>" + GDE.LINE_SEPARATOR + "    <desc>%s</desc>" + GDE.LINE_SEPARATOR + "    <trkseg>" + GDE.LINE_SEPARATOR;
    static final String track_begin_garmin = "  <trk>" + GDE.LINE_SEPARATOR + "    <name>%s %s</name>" + GDE.LINE_SEPARATOR + "    <link href=\"\\DCIM\\100_VIRB\\VIRB0001.MP4\"></link>" + GDE.LINE_SEPARATOR + "    <extensions>" + GDE.LINE_SEPARATOR + "       <gpxx:TrackExtension>" + GDE.LINE_SEPARATOR + "         <gpxx:DisplayColor>Cyan</gpxx:DisplayColor>" + GDE.LINE_SEPARATOR + "       </gpxx:TrackExtension>" + GDE.LINE_SEPARATOR + "       <gpxtrkx:TrackStatsExtension>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:Distance>100</gpxtrkx:Distance>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:TimerTime>100</gpxtrkx:TimerTime>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:TotalElapsedTime>%d</gpxtrkx:TotalElapsedTime>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:MovingTime>%d</gpxtrkx:MovingTime>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:StoppedTime>%d</gpxtrkx:StoppedTime>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:MovingSpeed>%d</gpxtrkx:MovingSpeed>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:MaxSpeed>%d</gpxtrkx:MaxSpeed>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:MaxElevation>%d</gpxtrkx:MaxElevation>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:MinElevation>%d</gpxtrkx:MinElevation>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:Ascent>5</gpxtrkx:Ascent>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:Descent>8</gpxtrkx:Descent>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:AvgAscentRate>2</gpxtrkx:AvgAscentRate>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:MaxAscentRate>0</gpxtrkx:MaxAscentRate>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:AvgDescentRate>1</gpxtrkx:AvgDescentRate>" + GDE.LINE_SEPARATOR + "         <gpxtrkx:MaxDescentRate>0</gpxtrkx:MaxDescentRate>" + GDE.LINE_SEPARATOR + "       </gpxtrkx:TrackStatsExtension>" + GDE.LINE_SEPARATOR + "    </extensions>" + GDE.LINE_SEPARATOR + "    <trkseg>" + GDE.LINE_SEPARATOR;
    static final String track_end = "    </trkseg>" + GDE.LINE_SEPARATOR + "    </trk>" + GDE.LINE_SEPARATOR;
    static final String track_point_begin = "      <trkpt lat=\"%.10f\" lon=\"%.10f\">" + GDE.LINE_SEPARATOR + "        <ele>%.3f</ele>" + GDE.LINE_SEPARATOR + "        <time>%sT%s</time>" + GDE.LINE_SEPARATOR + "        <sat>%d</sat>" + GDE.LINE_SEPARATOR + "        <hdop>%.1f</hdop>" + GDE.LINE_SEPARATOR + "        <vdop>%.1f</vdop>" + GDE.LINE_SEPARATOR + "        <pdop>%.1f</pdop>" + GDE.LINE_SEPARATOR;
    static final String track_point_end = "      </trkpt>" + GDE.LINE_SEPARATOR;
    static final String extension_begin = "        <extensions>" + GDE.LINE_SEPARATOR;
    static final String extension_end = "        </extensions>" + GDE.LINE_SEPARATOR;
    static final String garmin_acc_ext_begin = "        <gpxacc:AccelerationExtension>" + GDE.LINE_SEPARATOR;
    static final String garmin_acc_ext = "          <gpxacc:accel offset=\"%d\" x=\"%.1f\" y=\"%.1f\" z=\"%.1f\" />" + GDE.LINE_SEPARATOR;
    static final String garmin_acc_ext_end = "        </gpxacc:AccelerationExtension>" + GDE.LINE_SEPARATOR;
    static final String extension = "<%s>%.3f</%s>" + GDE.LINE_SEPARATOR;

    public static void write(String fullQualifiedPathName, RecordSet recordSet, int latitudeOrdinal, int longitudeOrdinal, int altitudeOrdinal, int speedOrdinal, int satellitesOrdinal, int hdopOrdinal, int vdopOrdinal, int pdodOrdinal, int[] accelerationXYZ) throws Exception {
        long startTime = new Date().getTime();
        IDevice device = DataExplorer.getInstance().getActiveDevice();
        BufferedWriter writer = null;
        try {
            Record recordPDOP;
            Record recordVDOP;
            Record recordHDOP;
            Record recordSatellites;
            HashMap<Integer, Boolean> usedOrdinals = new HashMap<Integer, Boolean>();
            Record recordLongitude = recordSet.get(longitudeOrdinal);
            usedOrdinals.put(longitudeOrdinal, true);
            Record recordLatitude = recordSet.get(latitudeOrdinal);
            usedOrdinals.put(latitudeOrdinal, true);
            Record recordHeight = recordSet.get(altitudeOrdinal);
            usedOrdinals.put(altitudeOrdinal, true);
            Record recordSpeed = recordSet.get(speedOrdinal);
            Record record = recordSatellites = satellitesOrdinal == -1 ? null : recordSet.get(satellitesOrdinal);
            if (recordSatellites != null) {
                usedOrdinals.put(satellitesOrdinal, true);
            }
            Record record2 = recordHDOP = hdopOrdinal == -1 ? null : recordSet.get(hdopOrdinal);
            if (recordHDOP != null) {
                usedOrdinals.put(hdopOrdinal, true);
            }
            Record record3 = recordVDOP = vdopOrdinal == -1 ? null : recordSet.get(vdopOrdinal);
            if (recordVDOP != null) {
                usedOrdinals.put(vdopOrdinal, true);
            }
            Record record4 = recordPDOP = pdodOrdinal == -1 ? null : recordSet.get(pdodOrdinal);
            if (recordPDOP != null) {
                usedOrdinals.put(pdodOrdinal, true);
            }
            String dateString = new SimpleDateFormat("yyyy-MM-dd").format(recordSet.getStartTimeStamp());
            GDE.getUiNotification().setStatusMessage(Messages.getString("GDE_MSGT0138", new String[]{"gpx", fullQualifiedPathName}));
            File targetFile = new File(fullQualifiedPathName);
            if (targetFile.exists()) {
                if (!targetFile.delete()) {
                    log.log(Level.WARNING, fullQualifiedPathName + " could not deleted!");
                }
                if (!targetFile.createNewFile()) {
                    log.log(Level.WARNING, fullQualifiedPathName + " could not created!");
                }
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fullQualifiedPathName), "UTF-8"));
            writer.write(header_xml);
            if (accelerationXYZ != null && accelerationXYZ.length == 3) {
                writer.write(header_garmin);
            } else {
                writer.write(header_gpx);
            }
            long lastTimeStep_sec = recordSet.getStartTimeStamp() / 1000L;
            long startTimeStep_msec = recordSet.getStartTimeStamp();
            writer.write(String.format(Locale.ENGLISH, metadata, new SimpleDateFormat("yyyy-MM-dd").format(startTimeStep_msec), new SimpleDateFormat("HH:mm:ss").format(startTimeStep_msec)));
            if (accelerationXYZ != null && accelerationXYZ.length == 3) {
                writer.write(String.format(Locale.ENGLISH, track_begin_garmin, new SimpleDateFormat("yyyy-MM-dd").format(startTimeStep_msec), new SimpleDateFormat("HH:mm:ss").format(startTimeStep_msec), recordSet.getTime(recordSet.getRecordDataSize(true) - 1) / 1000L, recordSet.getTime(recordSet.getRecordDataSize(true) - 1) / 1000L, recordSet.getTime(recordSet.getRecordDataSize(true) - 1) / 1000L, recordSpeed.getAvgValue() / 1000, recordSpeed.getMaxValue() / 1000, (int)recordHeight.getMaxDisplayValue(), (int)recordHeight.getMinDisplayValue()));
            } else {
                writer.write(String.format(Locale.ENGLISH, track_begin, recordSet.getName(), recordSet.getRecordSetDescription().contains("\n") ? recordSet.getRecordSetDescription().substring(0, recordSet.getRecordSetDescription().indexOf(10)) : recordSet.getRecordSetDescription()));
            }
            int realDataSize = recordSet.getRecordDataSize(true);
            int dataSize = recordSet.getRecordDataSize(false);
            int progressCycle = 0;
            GDE.getUiNotification().setProgress(progressCycle);
            double positionLongitude = device.translateValue(recordLongitude, (double)recordLongitude.realGet(0).intValue() / 1000.0);
            double positionLatitude = device.translateValue(recordLongitude, (double)recordLatitude.realGet(0).intValue() / 1000.0);
            double altitude = device.translateValue(recordHeight, (double)recordHeight.realGet(0).intValue() / 1000.0);
            boolean isGarminExtensionWritten = false;
            int i = 0;
            while (i < realDataSize) {
                if (recordLongitude.realGet(i) == 0 || recordLatitude.realGet(i) == 0) continue;
                positionLatitude = device.translateValue(recordLongitude, (double)recordLatitude.realGet(i).intValue() / 1000.0);
                positionLongitude = device.translateValue(recordLongitude, (double)recordLongitude.realGet(i).intValue() / 1000.0);
                altitude = device.translateValue(recordHeight, (double)recordHeight.realGet(i).intValue() / 1000.0);
                if (accelerationXYZ != null && accelerationXYZ.length == 3) {
                    writer.write(String.format(Locale.ENGLISH, track_point_begin, positionLatitude, positionLongitude, altitude, dateString, new SimpleDateFormat("HH:mm:ss").format(startTimeStep_msec + recordSet.getTime(i) / 10L), recordSatellites != null ? recordSatellites.realGet(i) / 1000 : 0, recordHDOP != null ? (double)recordHDOP.realGet(i).intValue() / 1000.0 : 0.0, recordVDOP != null ? (double)recordVDOP.realGet(i).intValue() / 1000.0 : 0.0, recordPDOP != null ? (double)recordPDOP.realGet(i).intValue() / 1000.0 : 0.0));
                } else {
                    writer.write(String.format(Locale.ENGLISH, track_point_begin, positionLatitude, positionLongitude, altitude, dateString, new SimpleDateFormat("HH:mm:ss.SSS").format(startTimeStep_msec + recordSet.getTime(i) / 10L), recordSatellites != null ? recordSatellites.realGet(i) / 1000 : 0, recordHDOP != null ? (double)recordHDOP.realGet(i).intValue() / 1000.0 : 0.0, recordVDOP != null ? (double)recordVDOP.realGet(i).intValue() / 1000.0 : 0.0, recordPDOP != null ? (double)recordPDOP.realGet(i).intValue() / 1000.0 : 0.0));
                }
                writer.write(extension_begin);
                if (accelerationXYZ != null && accelerationXYZ.length == 3) {
                    writer.write(garmin_acc_ext_begin);
                    while (i < realDataSize && (startTimeStep_msec + recordSet.getTime(i) / 10L) / 1000L <= lastTimeStep_sec) {
                        writer.write(String.format(Locale.ENGLISH, garmin_acc_ext, startTimeStep_msec + recordSet.getTime(i) / 10L - lastTimeStep_sec * 1000L, recordSet.get(accelerationXYZ[0]) != null ? (double)recordSet.get(accelerationXYZ[0]).realGet(i).intValue() / 1000.0 : 0.0, recordSet.get(accelerationXYZ[1]) != null ? (double)recordSet.get(accelerationXYZ[1]).realGet(i).intValue() / 1000.0 : 0.0, recordSet.get(accelerationXYZ[2]) != null ? (double)recordSet.get(accelerationXYZ[2]).realGet(i).intValue() / 1000.0 : 0.0));
                        isGarminExtensionWritten = true;
                        ++i;
                    }
                    writer.write(garmin_acc_ext_end);
                    if (isGarminExtensionWritten) {
                        isGarminExtensionWritten = false;
                        --i;
                    }
                } else {
                    for (int j = 0; j < recordSet.size(); ++j) {
                        Record record5;
                        if (usedOrdinals.get(j) != null || !recordSet.get(j).hasReasonableData() || (record5 = recordSet.get(j)) == null) continue;
                        String name = record5.getName().replace(' ', '_').replace("(", "").replace(")", "");
                        writer.write(String.format(Locale.ENGLISH, "          <%s>%.3f</%s>\n", name, (double)record5.realGet(i).intValue() / 1000.0, name));
                    }
                }
                writer.write(extension_end);
                writer.write(track_point_end);
                if (i % 50 == 0) {
                    GDE.getUiNotification().setProgress(++progressCycle * 5000 / dataSize);
                }
                if (i < realDataSize - 1 && accelerationXYZ != null && accelerationXYZ.length == 3) {
                    lastTimeStep_sec = (startTimeStep_msec + recordSet.getTime(i + 1) / 10L) / 1000L;
                }
                ++i;
            }
            writer.write(track_end);
            writer.write(footer);
            writer.flush();
            writer.close();
            writer = null;
        }
        catch (IOException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString("GDE_MSGE0006", new Object[]{"kmz", fullQualifiedPathName, e.getMessage()}));
        }
        catch (Exception e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
            throw new Exception(Messages.getString("GDE_MSGE0007") + e.getClass().getSimpleName() + " - " + e.getMessage());
        }
        finally {
            GDE.getUiNotification().setStatusMessage("");
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.log(Level.WARNING, e.getMessage(), e);
                }
                writer = null;
            }
        }
        GDE.getUiNotification().setProgress(100);
        GDE.getUiNotification().setStatusMessage("");
        if (log.isLoggable(Level.TIME)) {
            log.log(Level.TIME, "GPX file = " + fullQualifiedPathName + " written successfulywrite time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - startTime));
        }
    }
}

