/*
 * Decompiled with CFR 0.152.
 */
package gde.device.skyrc;

import gde.comm.DeviceCommPort;
import gde.comm.IDeviceCommPort;
import gde.device.IDevice;
import gde.device.InputTypes;
import gde.log.Level;
import gde.ui.DataExplorer;
import gde.utils.Checksum;
import gde.utils.StringHelper;
import java.util.logging.Logger;
import javax.usb.UsbInterface;

public class Q200UsbPort
extends DeviceCommPort
implements IDeviceCommPort {
    static final String $CLASS_NAME = Q200UsbPort.class.getName();
    static final Logger log = Logger.getLogger($CLASS_NAME);
    protected static final short VENDOR_ID = 0;
    protected static final short PRODUCT_ID = 1;
    protected static final byte INTERFACE_ID = 1;
    protected static final byte IN_ENDPOINT = -127;
    protected static final byte OUT_ENDPOINT = 1;
    protected static final int TIMEOUT = 1000;
    protected final byte interfaceId;
    protected final byte endpointIn;
    protected final byte endpointOut;
    final int dataSize = this.deviceConfig.getDataBlockSize(InputTypes.SERIAL_IO);
    int retrys = 1;

    public Q200UsbPort(IDevice currentDevice, DataExplorer currentApplication) {
        super(currentDevice, currentApplication);
        this.interfaceId = this.device.getUsbInterface();
        this.endpointIn = this.device.getUsbEndpointIn();
        this.endpointOut = this.device.getUsbEndpointOut();
        byte[] tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QueryOperationData.CHANNEL_A.value(), 0, tmpData, 0, QueryOperationData.CHANNEL_A.value().length);
        QueryOperationData.CHANNEL_A.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QueryOperationData.CHANNEL_B.value(), 0, tmpData, 0, QueryOperationData.CHANNEL_B.value().length);
        QueryOperationData.CHANNEL_B.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QueryOperationData.CHANNEL_C.value(), 0, tmpData, 0, QueryOperationData.CHANNEL_C.value().length);
        QueryOperationData.CHANNEL_C.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QueryOperationData.CHANNEL_D.value(), 0, tmpData, 0, QueryOperationData.CHANNEL_D.value().length);
        QueryOperationData.CHANNEL_D.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QueryChannelData.CHANNEL_A.value(), 0, tmpData, 0, QueryChannelData.CHANNEL_A.value().length);
        QueryChannelData.CHANNEL_A.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QueryChannelData.CHANNEL_B.value(), 0, tmpData, 0, QueryChannelData.CHANNEL_B.value().length);
        QueryChannelData.CHANNEL_B.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QueryChannelData.CHANNEL_C.value(), 0, tmpData, 0, QueryChannelData.CHANNEL_C.value().length);
        QueryChannelData.CHANNEL_C.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QueryChannelData.CHANNEL_D.value(), 0, tmpData, 0, QueryChannelData.CHANNEL_D.value().length);
        QueryChannelData.CHANNEL_D.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySystemInfo.CHANNEL_A.value(), 0, tmpData, 0, QuerySystemInfo.CHANNEL_A.value().length);
        QuerySystemInfo.CHANNEL_A.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySystemInfo.CHANNEL_B.value(), 0, tmpData, 0, QuerySystemInfo.CHANNEL_B.value().length);
        QuerySystemInfo.CHANNEL_B.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySystemInfo.CHANNEL_C.value(), 0, tmpData, 0, QuerySystemInfo.CHANNEL_C.value().length);
        QuerySystemInfo.CHANNEL_C.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySystemInfo.CHANNEL_D.value(), 0, tmpData, 0, QuerySystemInfo.CHANNEL_D.value().length);
        QuerySystemInfo.CHANNEL_D.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySystemSetting.CHANNEL_A.value(), 0, tmpData, 0, QuerySystemSetting.CHANNEL_A.value().length);
        QuerySystemSetting.CHANNEL_A.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySystemSetting.CHANNEL_B.value(), 0, tmpData, 0, QuerySystemSetting.CHANNEL_B.value().length);
        QuerySystemSetting.CHANNEL_B.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySystemSetting.CHANNEL_C.value(), 0, tmpData, 0, QuerySystemSetting.CHANNEL_C.value().length);
        QuerySystemSetting.CHANNEL_C.setValue(tmpData);
        tmpData = new byte[Math.abs(this.dataSize)];
        System.arraycopy(QuerySystemSetting.CHANNEL_D.value(), 0, tmpData, 0, QuerySystemSetting.CHANNEL_D.value().length);
        QuerySystemSetting.CHANNEL_D.setValue(tmpData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getSystemInfo(UsbInterface usbInterface, byte[] systemInfoCmd) throws Exception {
        String $METHOD_NAME = "getSystemInfo";
        byte[] data = new byte[Math.abs(this.dataSize)];
        UsbInterface iface = null;
        boolean isPortOpenedByCall = false;
        try {
            if (usbInterface == null) {
                iface = this.openUsbPort(this.device);
                isPortOpenedByCall = true;
            }
            UsbInterface usbInterface2 = iface = usbInterface == null ? this.openUsbPort(this.device) : usbInterface;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSystemInfo", StringHelper.byte2Hex2CharString((byte[])systemInfoCmd, (int)systemInfoCmd.length));
            }
            this.write(iface, this.endpointIn, systemInfoCmd);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.read(iface, this.endpointOut, data);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSystemInfo", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
            if (!this.isChecksumOK(data) && this.retrys-- <= 0) {
                log.logp(Level.WARNING, $CLASS_NAME, "getSystemInfo", String.format("Error: Checksum = 0x%02X != 0x%02X", Q200UsbPort.calculateCheckSum(data, data[1] - 1), data[data[1] + 2]));
                byte[] byArray = this.getSystemInfo(iface, systemInfoCmd);
                return byArray;
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, $CLASS_NAME, "getSystemInfo", e.getMessage(), e);
        }
        finally {
            if (isPortOpenedByCall) {
                this.closeUsbPort(iface);
            }
        }
        this.retrys = 1;
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getSystemSetting(UsbInterface usbInterface, byte[] systemSettingCmd) throws Exception {
        String $METHOD_NAME = "getSystemSetting";
        byte[] data = new byte[Math.abs(this.dataSize)];
        UsbInterface iface = null;
        boolean isPortOpenedByCall = false;
        try {
            if (usbInterface == null) {
                iface = this.openUsbPort(this.device);
                isPortOpenedByCall = true;
            }
            UsbInterface usbInterface2 = iface = usbInterface == null ? this.openUsbPort(this.device) : usbInterface;
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSystemSetting", StringHelper.byte2Hex2CharString((byte[])systemSettingCmd, (int)systemSettingCmd.length));
            }
            this.write(iface, this.endpointIn, systemSettingCmd);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.read(iface, this.endpointOut, data);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getSystemSetting", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
            if (!this.isChecksumOK(data) && this.retrys-- <= 0) {
                log.logp(Level.WARNING, $CLASS_NAME, "getSystemSetting", String.format("Error: Checksum = 0x%02X != 0x%02X", Q200UsbPort.calculateCheckSum(data, data[1] - 1), data[data[1] + 2]));
                byte[] byArray = this.getSystemInfo(iface, systemSettingCmd);
                return byArray;
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, $CLASS_NAME, "getSystemSetting", e.getMessage(), e);
        }
        finally {
            if (isPortOpenedByCall) {
                this.closeUsbPort(iface);
            }
        }
        this.retrys = 1;
        return data;
    }

    public synchronized byte[] getData(UsbInterface iface, byte[] request) throws Exception {
        String $METHOD_NAME = "getData";
        byte[] data = new byte[Math.abs(this.dataSize)];
        try {
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getData", StringHelper.byte2Hex2CharString((byte[])request, (int)request.length));
            }
            this.write(iface, this.endpointIn, request);
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.read(iface, this.endpointOut, data);
            if (log.isLoggable(Level.FINE)) {
                log.logp(Level.FINE, $CLASS_NAME, "getData", StringHelper.byte2Hex2CharString((byte[])data, (int)data.length));
            }
            if (!this.isChecksumOK(data) && this.retrys-- <= 0) {
                log.logp(Level.WARNING, $CLASS_NAME, "getData", String.format("Error: Checksum = 0x%02X == 0x%02X", Q200UsbPort.calculateCheckSum(data, data[1] - 1), data[data[1] + 2]));
                return this.getData(iface, request);
            }
        }
        catch (Exception e) {
            log.logp(Level.WARNING, $CLASS_NAME, "getData", e.getMessage(), e);
            throw e;
        }
        this.retrys = 1;
        return data;
    }

    public static byte calculateCheckSum(byte[] buffer, int length) {
        return (byte)(Checksum.ADD((byte[])buffer, (int)2, (int)length) % 256);
    }

    private boolean isChecksumOK(byte[] buffer) {
        String $METHOD_NAME = "isChecksumOK";
        byte chkSum = Q200UsbPort.calculateCheckSum(buffer, buffer[1]);
        if (log.isLoggable(Level.FINER)) {
            log.logp(Level.FINER, $CLASS_NAME, "isChecksumOK", String.format("Checksum = 0x%02X == 0x%02X", chkSum, buffer[buffer[1] + 1]));
        }
        return chkSum == buffer[buffer[1] + 1];
    }

    public static enum QueryOperationData {
        CHANNEL_A(new byte[]{15, 3, 85, 1, 86}),
        CHANNEL_B(new byte[]{15, 3, 85, 2, 87}),
        CHANNEL_C(new byte[]{15, 3, 85, 4, 89}),
        CHANNEL_D(new byte[]{15, 3, 85, 8, 93});

        private byte[] value;

        private QueryOperationData(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }

    public static enum QueryChannelData {
        CHANNEL_A(new byte[]{15, 3, 95, 1, 96}),
        CHANNEL_B(new byte[]{15, 3, 95, 2, 97}),
        CHANNEL_C(new byte[]{15, 3, 95, 4, 99}),
        CHANNEL_D(new byte[]{15, 3, 95, 8, 103});

        private byte[] value;

        private QueryChannelData(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }

    public static enum QuerySystemInfo {
        CHANNEL_A(new byte[]{15, 3, 87, 1, 88}),
        CHANNEL_B(new byte[]{15, 3, 87, 2, 89}),
        CHANNEL_C(new byte[]{15, 3, 87, 4, 91}),
        CHANNEL_D(new byte[]{15, 3, 87, 8, 95});

        private byte[] value;

        private QuerySystemInfo(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }

    public static enum QuerySystemSetting {
        CHANNEL_A(new byte[]{15, 3, 90, 1, 91}),
        CHANNEL_B(new byte[]{15, 3, 90, 2, 92}),
        CHANNEL_C(new byte[]{15, 3, 90, 4, 94}),
        CHANNEL_D(new byte[]{15, 3, 90, 8, 98});

        private byte[] value;

        private QuerySystemSetting(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }

    public static enum ModifySystemSetting {
        CHANNEL_A(new byte[]{15, 3, 17, 1, 0, 0, 0, 0, 0}),
        CHANNEL_B(new byte[]{15, 3, 17, 2, 0, 0, 0, 0, 0}),
        CHANNEL_C(new byte[]{15, 3, 17, 4, 0, 0, 0, 0, 0}),
        CHANNEL_D(new byte[]{15, 3, 17, 8, 2, 0, 0, 0, 0});

        private byte[] value;

        private ModifySystemSetting(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }

    public static enum StopProcessing {
        CHANNEL_A(new byte[]{15, 3, -2, 1, -1}),
        CHANNEL_B(new byte[]{15, 3, -2, 2, 1}),
        CHANNEL_C(new byte[]{15, 3, -2, 4, 3}),
        CHANNEL_D(new byte[]{15, 3, -2, 8, 7});

        private byte[] value;

        private StopProcessing(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }

    public static enum StartProcessing {
        CHANNEL_A(new byte[]{15, 3, 95, 1, 96}),
        CHANNEL_B(new byte[]{15, 3, 95, 2, 97}),
        CHANNEL_C(new byte[]{15, 3, 95, 4, 99}),
        CHANNEL_D(new byte[]{15, 3, 95, 8, 103});

        private byte[] value;

        private StartProcessing(byte[] v) {
            this.value = v;
        }

        public byte[] value() {
            return this.value;
        }

        public void setValue(byte[] newValue) {
            this.value = newValue;
        }
    }
}

