/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import com.sun.javafx.binding.StringFormatter;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;

public abstract class StringExpression
implements ObservableStringValue {
    @Override
    public String getValue() {
        return (String)this.get();
    }

    public final String getValueSafe() {
        String string2 = (String)this.get();
        return string2 == null ? "" : string2;
    }

    public static StringExpression stringExpression(ObservableValue<?> observableValue) {
        if (observableValue == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return StringFormatter.convert(observableValue);
    }

    public StringExpression concat(Object object) {
        return Bindings.concat(this, object);
    }

    public BooleanBinding isEqualTo(ObservableStringValue observableStringValue) {
        return Bindings.equal((ObservableStringValue)this, observableStringValue);
    }

    public BooleanBinding isEqualTo(String string2) {
        return Bindings.equal((ObservableStringValue)this, string2);
    }

    public BooleanBinding isNotEqualTo(ObservableStringValue observableStringValue) {
        return Bindings.notEqual((ObservableStringValue)this, observableStringValue);
    }

    public BooleanBinding isNotEqualTo(String string2) {
        return Bindings.notEqual((ObservableStringValue)this, string2);
    }

    public BooleanBinding isEqualToIgnoreCase(ObservableStringValue observableStringValue) {
        return Bindings.equalIgnoreCase((ObservableStringValue)this, observableStringValue);
    }

    public BooleanBinding isEqualToIgnoreCase(String string2) {
        return Bindings.equalIgnoreCase((ObservableStringValue)this, string2);
    }

    public BooleanBinding isNotEqualToIgnoreCase(ObservableStringValue observableStringValue) {
        return Bindings.notEqualIgnoreCase((ObservableStringValue)this, observableStringValue);
    }

    public BooleanBinding isNotEqualToIgnoreCase(String string2) {
        return Bindings.notEqualIgnoreCase((ObservableStringValue)this, string2);
    }

    public BooleanBinding greaterThan(ObservableStringValue observableStringValue) {
        return Bindings.greaterThan((ObservableStringValue)this, observableStringValue);
    }

    public BooleanBinding greaterThan(String string2) {
        return Bindings.greaterThan((ObservableStringValue)this, string2);
    }

    public BooleanBinding lessThan(ObservableStringValue observableStringValue) {
        return Bindings.lessThan((ObservableStringValue)this, observableStringValue);
    }

    public BooleanBinding lessThan(String string2) {
        return Bindings.lessThan((ObservableStringValue)this, string2);
    }

    public BooleanBinding greaterThanOrEqualTo(ObservableStringValue observableStringValue) {
        return Bindings.greaterThanOrEqual((ObservableStringValue)this, observableStringValue);
    }

    public BooleanBinding greaterThanOrEqualTo(String string2) {
        return Bindings.greaterThanOrEqual((ObservableStringValue)this, string2);
    }

    public BooleanBinding lessThanOrEqualTo(ObservableStringValue observableStringValue) {
        return Bindings.lessThanOrEqual((ObservableStringValue)this, observableStringValue);
    }

    public BooleanBinding lessThanOrEqualTo(String string2) {
        return Bindings.lessThanOrEqual((ObservableStringValue)this, string2);
    }

    public BooleanBinding isNull() {
        return Bindings.isNull(this);
    }

    public BooleanBinding isNotNull() {
        return Bindings.isNotNull(this);
    }

    public IntegerBinding length() {
        return Bindings.length(this);
    }

    public BooleanBinding isEmpty() {
        return Bindings.isEmpty(this);
    }

    public BooleanBinding isNotEmpty() {
        return Bindings.isNotEmpty(this);
    }
}

