/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.awt.geom.Point;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Image;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.Version;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.exceptions.BadPasswordException;
import com.itextpdf.text.log.Counter;
import com.itextpdf.text.log.CounterFactory;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.ByteBuffer;
import com.itextpdf.text.pdf.FdfReader;
import com.itextpdf.text.pdf.ICC_Profile;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.NumberArray;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PageResources;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfAppearance;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfContents;
import com.itextpdf.text.pdf.PdfDate;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfDocument;
import com.itextpdf.text.pdf.PdfEncryption;
import com.itextpdf.text.pdf.PdfException;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfIndirectObject;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfLayer;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNameTree;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfOCG;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfRectangle;
import com.itextpdf.text.pdf.PdfStamper;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfTransition;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.StampContent;
import com.itextpdf.text.pdf.collection.PdfCollection;
import com.itextpdf.text.pdf.internal.PdfViewerPreferencesImp;
import com.itextpdf.text.xml.xmp.PdfProperties;
import com.itextpdf.text.xml.xmp.XmpBasicProperties;
import com.itextpdf.text.xml.xmp.XmpWriter;
import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.XMPMeta;
import com.itextpdf.xmp.XMPMetaFactory;
import com.itextpdf.xmp.options.SerializeOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfStamperImp
extends PdfWriter {
    HashMap<PdfReader, IntHashtable> readers2intrefs = new HashMap();
    HashMap<PdfReader, RandomAccessFileOrArray> readers2file = new HashMap();
    protected RandomAccessFileOrArray file;
    PdfReader reader;
    IntHashtable myXref = new IntHashtable();
    HashMap<PdfDictionary, PageStamp> pagesToContent = new HashMap();
    protected boolean closed = false;
    private boolean rotateContents = true;
    protected AcroFields acroFields;
    protected boolean flat = false;
    protected boolean flatFreeText = false;
    protected boolean flatannotations = false;
    protected int[] namePtr = new int[]{0};
    protected HashSet<String> partialFlattening = new HashSet();
    protected boolean useVp = false;
    protected PdfViewerPreferencesImp viewerPreferences = new PdfViewerPreferencesImp();
    protected HashSet<PdfTemplate> fieldTemplates = new HashSet();
    protected boolean fieldsAdded = false;
    protected int sigFlags = 0;
    protected boolean append;
    protected IntHashtable marked;
    protected int initialXrefSize;
    protected PdfAction openAction;
    protected HashMap<Object, PdfObject> namedDestinations = new HashMap();
    protected Counter COUNTER = CounterFactory.getCounter(PdfStamper.class);
    private boolean originalLayersAreRead = false;
    private double[] DEFAULT_MATRIX = new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0};

    @Override
    protected Counter getCounter() {
        return this.COUNTER;
    }

    protected PdfStamperImp(PdfReader reader, OutputStream os, char pdfVersion, boolean append2) throws DocumentException, IOException {
        super(new PdfDocument(), os);
        if (!reader.isOpenedWithFullPermissions()) {
            throw new BadPasswordException(MessageLocalization.getComposedMessage("pdfreader.not.opened.with.owner.password", new Object[0]));
        }
        if (reader.isTampered()) {
            throw new DocumentException(MessageLocalization.getComposedMessage("the.original.document.was.reused.read.it.again.from.file", new Object[0]));
        }
        reader.setTampered(true);
        this.reader = reader;
        this.file = reader.getSafeFile();
        this.append = append2;
        if (reader.isEncrypted() && (append2 || PdfReader.unethicalreading)) {
            this.crypto = new PdfEncryption(reader.getDecrypt());
        }
        if (append2) {
            int n2;
            if (reader.isRebuilt()) {
                throw new DocumentException(MessageLocalization.getComposedMessage("append.mode.requires.a.document.without.errors.even.if.recovery.was.possible", new Object[0]));
            }
            this.pdf_version.setAppendmode(true);
            if (pdfVersion == '\u0000') {
                this.pdf_version.setPdfVersion(reader.getPdfVersion());
            } else {
                this.pdf_version.setPdfVersion(pdfVersion);
            }
            byte[] buf = new byte[8192];
            while ((n2 = this.file.read(buf)) > 0) {
                this.os.write(buf, 0, n2);
            }
            this.prevxref = reader.getLastXref();
            reader.setAppendable(true);
        } else if (pdfVersion == '\u0000') {
            super.setPdfVersion(reader.getPdfVersion());
        } else {
            super.setPdfVersion(pdfVersion);
        }
        if (reader.isTagged()) {
            this.setTagged();
        }
        super.open();
        this.pdf.addWriter(this);
        if (append2) {
            this.body.setRefnum(reader.getXrefSize());
            this.marked = new IntHashtable();
            if (reader.isNewXrefType()) {
                this.fullCompression = true;
            }
            if (reader.isHybridXref()) {
                this.fullCompression = false;
            }
        }
        this.initialXrefSize = reader.getXrefSize();
        this.readColorProfile();
    }

    protected void readColorProfile() {
        PdfArray outputIntents = this.reader.getCatalog().getAsArray(PdfName.OUTPUTINTENTS);
        if (outputIntents != null && outputIntents.size() > 0) {
            PdfDictionary outputIntentDictionary;
            PdfStream iccProfileStream = null;
            for (int i2 = 0; i2 < outputIntents.size() && ((outputIntentDictionary = outputIntents.getAsDict(i2)) == null || (iccProfileStream = outputIntentDictionary.getAsStream(PdfName.DESTOUTPUTPROFILE)) == null); ++i2) {
            }
            if (iccProfileStream instanceof PRStream) {
                try {
                    this.colorProfile = ICC_Profile.getInstance(PdfReader.getStreamBytes((PRStream)iccProfileStream));
                }
                catch (IOException exc) {
                    throw new ExceptionConverter(exc);
                }
            }
        }
    }

    protected void setViewerPreferences() {
        this.reader.setViewerPreferences(this.viewerPreferences);
        this.markUsed(this.reader.getTrailer().get(PdfName.ROOT));
    }

    /*
     * WARNING - void declaration
     */
    protected void close(Map<String, String> moreInfo) throws IOException {
        void var12_21;
        ByteArrayOutputStream baos;
        if (this.closed) {
            return;
        }
        if (this.useVp) {
            this.setViewerPreferences();
        }
        if (this.flat) {
            this.flatFields();
        }
        if (this.flatFreeText) {
            this.flatFreeTextFields();
        }
        if (this.flatannotations) {
            this.flattenAnnotations();
        }
        this.addFieldResources();
        PdfDictionary catalog = this.reader.getCatalog();
        this.getPdfVersion().addToCatalog(catalog);
        PdfDictionary acroForm = (PdfDictionary)PdfReader.getPdfObject(catalog.get(PdfName.ACROFORM), this.reader.getCatalog());
        if (this.acroFields != null && this.acroFields.getXfa().isChanged()) {
            this.markUsed(acroForm);
            if (!this.flat) {
                this.acroFields.getXfa().setXfa(this);
            }
        }
        if (this.sigFlags != 0 && acroForm != null) {
            acroForm.put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
            this.markUsed(acroForm);
            this.markUsed(catalog);
        }
        this.closed = true;
        this.addSharedObjectsToBody();
        this.setOutlines();
        this.setJavaScript();
        this.addFileAttachments();
        if (this.extraCatalog != null) {
            catalog.mergeDifferent(this.extraCatalog);
        }
        if (this.openAction != null) {
            catalog.put(PdfName.OPENACTION, this.openAction);
        }
        if (this.pdf.pageLabels != null) {
            catalog.put(PdfName.PAGELABELS, this.pdf.pageLabels.getDictionary(this));
        }
        if (!this.documentOCG.isEmpty()) {
            this.fillOCProperties(false);
            PdfDictionary ocdict = catalog.getAsDict(PdfName.OCPROPERTIES);
            if (ocdict == null) {
                this.reader.getCatalog().put(PdfName.OCPROPERTIES, this.OCProperties);
            } else {
                ocdict.put(PdfName.OCGS, this.OCProperties.get(PdfName.OCGS));
                PdfDictionary ddict = ocdict.getAsDict(PdfName.D);
                if (ddict == null) {
                    ddict = new PdfDictionary();
                    ocdict.put(PdfName.D, ddict);
                }
                ddict.put(PdfName.ORDER, this.OCProperties.getAsDict(PdfName.D).get(PdfName.ORDER));
                ddict.put(PdfName.RBGROUPS, this.OCProperties.getAsDict(PdfName.D).get(PdfName.RBGROUPS));
                ddict.put(PdfName.OFF, this.OCProperties.getAsDict(PdfName.D).get(PdfName.OFF));
                ddict.put(PdfName.AS, this.OCProperties.getAsDict(PdfName.D).get(PdfName.AS));
            }
            PdfWriter.checkPdfIsoConformance(this, 7, this.OCProperties);
        }
        int skipInfo = -1;
        PdfIndirectReference iInfo = this.reader.getTrailer().getAsIndirectObject(PdfName.INFO);
        if (iInfo != null) {
            skipInfo = iInfo.getNumber();
        }
        PdfDictionary oldInfo = this.reader.getTrailer().getAsDict(PdfName.INFO);
        String producer = null;
        if (oldInfo != null && oldInfo.get(PdfName.PRODUCER) != null) {
            producer = oldInfo.getAsString(PdfName.PRODUCER).toUnicodeString();
        }
        Version version = Version.getInstance();
        if (producer == null || version.getVersion().indexOf(version.getProduct()) == -1) {
            producer = version.getVersion();
        } else {
            int idx = producer.indexOf("; modified using");
            StringBuffer buf = idx == -1 ? new StringBuffer(producer) : new StringBuffer(producer.substring(0, idx));
            buf.append("; modified using ");
            buf.append(version.getVersion());
            producer = buf.toString();
        }
        PdfIndirectReference info = null;
        PdfDictionary newInfo = new PdfDictionary();
        if (oldInfo != null) {
            Iterator<Object> i$ = oldInfo.getKeys().iterator();
            while (i$.hasNext()) {
                PdfName pdfName;
                PdfName key2 = pdfName = (PdfName)i$.next();
                PdfObject value = PdfReader.getPdfObject(oldInfo.get(key2));
                newInfo.put(key2, value);
            }
        }
        if (moreInfo != null) {
            for (Map.Entry entry : moreInfo.entrySet()) {
                String key2 = (String)entry.getKey();
                PdfName keyName = new PdfName(key2);
                String value = (String)entry.getValue();
                if (value == null) {
                    newInfo.remove(keyName);
                    continue;
                }
                newInfo.put(keyName, new PdfString(value, "UnicodeBig"));
            }
        }
        PdfDate date = new PdfDate();
        newInfo.put(PdfName.MODDATE, date);
        newInfo.put(PdfName.PRODUCER, new PdfString(producer, "UnicodeBig"));
        info = this.append ? (iInfo == null ? this.addToBody((PdfObject)newInfo, false).getIndirectReference() : this.addToBody((PdfObject)newInfo, iInfo.getNumber(), false).getIndirectReference()) : this.addToBody((PdfObject)newInfo, false).getIndirectReference();
        Object var12_17 = null;
        PdfObject xmpo = PdfReader.getPdfObject(catalog.get(PdfName.METADATA));
        if (xmpo != null && xmpo.isStream()) {
            byte[] byArray = PdfReader.getStreamBytesRaw((PRStream)xmpo);
            PdfReader.killIndirect(catalog.get(PdfName.METADATA));
        }
        PdfDictionary xmp = null;
        if (this.xmpMetadata != null) {
            byte[] byArray = this.xmpMetadata;
        } else if (this.xmpWriter != null) {
            try {
                baos = new ByteArrayOutputStream();
                PdfProperties.setProducer(this.xmpWriter.getXmpMeta(), producer);
                XmpBasicProperties.setModDate(this.xmpWriter.getXmpMeta(), date.getW3CDate());
                XmpBasicProperties.setMetaDataDate(this.xmpWriter.getXmpMeta(), date.getW3CDate());
                this.xmpWriter.serialize(baos);
                this.xmpWriter.close();
                xmp = new PdfStream(baos.toByteArray());
            }
            catch (XMPException exc) {
                this.xmpWriter = null;
            }
        }
        if (xmp == null && var12_21 != null) {
            try {
                baos = new ByteArrayOutputStream();
                if (moreInfo == null || this.xmpMetadata != null) {
                    XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer((byte[])var12_21);
                    PdfProperties.setProducer(xmpMeta, producer);
                    XmpBasicProperties.setModDate(xmpMeta, date.getW3CDate());
                    XmpBasicProperties.setMetaDataDate(xmpMeta, date.getW3CDate());
                    SerializeOptions serializeOptions = new SerializeOptions();
                    serializeOptions.setPadding(2000);
                    XMPMetaFactory.serialize(xmpMeta, baos, serializeOptions);
                } else {
                    XmpWriter xmpw = this.createXmpWriter(baos, newInfo);
                    xmpw.close();
                }
                xmp = new PdfStream(baos.toByteArray());
            }
            catch (XMPException e2) {
                xmp = new PdfStream((byte[])var12_21);
            }
            catch (IOException e3) {
                xmp = new PdfStream((byte[])var12_21);
            }
        }
        if (xmp != null) {
            xmp.put(PdfName.TYPE, PdfName.METADATA);
            xmp.put(PdfName.SUBTYPE, PdfName.XML);
            if (this.crypto != null && !this.crypto.isMetadataEncrypted()) {
                PdfArray ar = new PdfArray();
                ar.add(PdfName.CRYPT);
                xmp.put(PdfName.FILTER, ar);
            }
            if (this.append && xmpo != null) {
                this.body.add((PdfObject)xmp, xmpo.getIndRef());
            } else {
                catalog.put(PdfName.METADATA, this.body.add(xmp).getIndirectReference());
                this.markUsed(catalog);
            }
        }
        if (!this.namedDestinations.isEmpty()) {
            this.updateNamedDestinations();
        }
        this.close(info, skipInfo);
    }

    protected void close(PdfIndirectReference info, int skipInfo) throws IOException {
        this.alterContents();
        int rootN = ((PRIndirectReference)this.reader.trailer.get(PdfName.ROOT)).getNumber();
        if (this.append) {
            int k2;
            int[] keys2 = this.marked.getKeys();
            for (k2 = 0; k2 < keys2.length; ++k2) {
                int j2 = keys2[k2];
                PdfObject obj = this.reader.getPdfObjectRelease(j2);
                if (obj == null || skipInfo == j2 || j2 >= this.initialXrefSize) continue;
                this.addToBody(obj, obj.getIndRef(), j2 != rootN);
            }
            for (k2 = this.initialXrefSize; k2 < this.reader.getXrefSize(); ++k2) {
                PdfObject obj = this.reader.getPdfObject(k2);
                if (obj == null) continue;
                this.addToBody(obj, this.getNewObjectNumber(this.reader, k2, 0));
            }
        } else {
            for (int k3 = 1; k3 < this.reader.getXrefSize(); ++k3) {
                PdfObject obj = this.reader.getPdfObjectRelease(k3);
                if (obj == null || skipInfo == k3) continue;
                this.addToBody(obj, this.getNewObjectNumber(this.reader, k3, 0), k3 != rootN);
            }
        }
        PdfIndirectReference encryption = null;
        PdfObject fileID = null;
        if (this.crypto != null) {
            if (this.append) {
                encryption = this.reader.getCryptoRef();
            } else {
                PdfIndirectObject encryptionObject = this.addToBody((PdfObject)this.crypto.getEncryptionDictionary(), false);
                encryption = encryptionObject.getIndirectReference();
            }
            fileID = this.crypto.getFileID(true);
        } else {
            PdfArray IDs = this.reader.trailer.getAsArray(PdfName.ID);
            fileID = IDs != null && IDs.getAsString(0) != null ? PdfEncryption.createInfoId(IDs.getAsString(0).getBytes(), true) : PdfEncryption.createInfoId(PdfEncryption.createDocumentId(), true);
        }
        PRIndirectReference iRoot = (PRIndirectReference)this.reader.trailer.get(PdfName.ROOT);
        PdfIndirectReference root2 = new PdfIndirectReference(0, this.getNewObjectNumber(this.reader, iRoot.getNumber(), 0));
        this.body.writeCrossReferenceTable(this.os, root2, info, encryption, fileID, this.prevxref);
        if (this.fullCompression) {
            PdfStamperImp.writeKeyInfo(this.os);
            this.os.write(PdfStamperImp.getISOBytes("startxref\n"));
            this.os.write(PdfStamperImp.getISOBytes(String.valueOf(this.body.offset())));
            this.os.write(PdfStamperImp.getISOBytes("\n%%EOF\n"));
        } else {
            PdfWriter.PdfTrailer trailer = new PdfWriter.PdfTrailer(this.body.size(), this.body.offset(), root2, info, encryption, fileID, this.prevxref);
            trailer.toPdf(this, this.os);
        }
        this.os.flush();
        if (this.isCloseStream()) {
            this.os.close();
        }
        this.getCounter().written(this.os.getCounter());
    }

    void applyRotation(PdfDictionary pageN, ByteBuffer out) {
        if (!this.rotateContents) {
            return;
        }
        Rectangle page = this.reader.getPageSizeWithRotation(pageN);
        int rotation = page.getRotation();
        switch (rotation) {
            case 90: {
                out.append(PdfContents.ROTATE90);
                out.append(page.getTop());
                out.append(' ').append('0').append(PdfContents.ROTATEFINAL);
                break;
            }
            case 180: {
                out.append(PdfContents.ROTATE180);
                out.append(page.getRight());
                out.append(' ');
                out.append(page.getTop());
                out.append(PdfContents.ROTATEFINAL);
                break;
            }
            case 270: {
                out.append(PdfContents.ROTATE270);
                out.append('0').append(' ');
                out.append(page.getRight());
                out.append(PdfContents.ROTATEFINAL);
            }
        }
    }

    protected void alterContents() throws IOException {
        Iterator<PageStamp> i$ = this.pagesToContent.values().iterator();
        while (i$.hasNext()) {
            PageStamp element;
            PageStamp ps = element = i$.next();
            PdfDictionary pageN = ps.pageN;
            this.markUsed(pageN);
            PdfArray ar = null;
            PdfObject content = PdfReader.getPdfObject(pageN.get(PdfName.CONTENTS), pageN);
            if (content == null) {
                ar = new PdfArray();
                pageN.put(PdfName.CONTENTS, ar);
            } else if (content.isArray()) {
                ar = new PdfArray((PdfArray)content);
                pageN.put(PdfName.CONTENTS, ar);
            } else if (content.isStream()) {
                ar = new PdfArray();
                ar.add(pageN.get(PdfName.CONTENTS));
                pageN.put(PdfName.CONTENTS, ar);
            } else {
                ar = new PdfArray();
                pageN.put(PdfName.CONTENTS, ar);
            }
            ByteBuffer out = new ByteBuffer();
            if (ps.under != null) {
                out.append(PdfContents.SAVESTATE);
                this.applyRotation(pageN, out);
                out.append(ps.under.getInternalBuffer());
                out.append(PdfContents.RESTORESTATE);
            }
            if (ps.over != null) {
                out.append(PdfContents.SAVESTATE);
            }
            PdfStream stream = new PdfStream(out.toByteArray());
            stream.flateCompress(this.compressionLevel);
            ar.addFirst(this.addToBody(stream).getIndirectReference());
            out.reset();
            if (ps.over != null) {
                out.append(' ');
                out.append(PdfContents.RESTORESTATE);
                ByteBuffer buf = ps.over.getInternalBuffer();
                out.append(buf.getBuffer(), 0, ps.replacePoint);
                out.append(PdfContents.SAVESTATE);
                this.applyRotation(pageN, out);
                out.append(buf.getBuffer(), ps.replacePoint, buf.size() - ps.replacePoint);
                out.append(PdfContents.RESTORESTATE);
                stream = new PdfStream(out.toByteArray());
                stream.flateCompress(this.compressionLevel);
                ar.add(this.addToBody(stream).getIndirectReference());
            }
            this.alterResources(ps);
        }
    }

    void alterResources(PageStamp ps) {
        ps.pageN.put(PdfName.RESOURCES, ps.pageResources.getResources());
    }

    @Override
    protected int getNewObjectNumber(PdfReader reader, int number, int generation) {
        IntHashtable ref = this.readers2intrefs.get(reader);
        if (ref != null) {
            int n2 = ref.get(number);
            if (n2 == 0) {
                n2 = this.getIndirectReferenceNumber();
                ref.put(number, n2);
            }
            return n2;
        }
        if (this.currentPdfReaderInstance == null) {
            if (this.append && number < this.initialXrefSize) {
                return number;
            }
            int n3 = this.myXref.get(number);
            if (n3 == 0) {
                n3 = this.getIndirectReferenceNumber();
                this.myXref.put(number, n3);
            }
            return n3;
        }
        return this.currentPdfReaderInstance.getNewObjectNumber(number, generation);
    }

    @Override
    RandomAccessFileOrArray getReaderFile(PdfReader reader) {
        if (this.readers2intrefs.containsKey(reader)) {
            RandomAccessFileOrArray raf = this.readers2file.get(reader);
            if (raf != null) {
                return raf;
            }
            return reader.getSafeFile();
        }
        if (this.currentPdfReaderInstance == null) {
            return this.file;
        }
        return this.currentPdfReaderInstance.getReaderFile();
    }

    public void registerReader(PdfReader reader, boolean openFile) throws IOException {
        if (this.readers2intrefs.containsKey(reader)) {
            return;
        }
        this.readers2intrefs.put(reader, new IntHashtable());
        if (openFile) {
            RandomAccessFileOrArray raf = reader.getSafeFile();
            this.readers2file.put(reader, raf);
            raf.reOpen();
        }
    }

    public void unRegisterReader(PdfReader reader) {
        if (!this.readers2intrefs.containsKey(reader)) {
            return;
        }
        this.readers2intrefs.remove(reader);
        RandomAccessFileOrArray raf = this.readers2file.get(reader);
        if (raf == null) {
            return;
        }
        this.readers2file.remove(reader);
        try {
            raf.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void findAllObjects(PdfReader reader, PdfObject obj, IntHashtable hits) {
        if (obj == null) {
            return;
        }
        switch (obj.type()) {
            case 10: {
                PRIndirectReference iref = (PRIndirectReference)obj;
                if (reader != iref.getReader()) {
                    return;
                }
                if (hits.containsKey(iref.getNumber())) {
                    return;
                }
                hits.put(iref.getNumber(), 1);
                PdfStamperImp.findAllObjects(reader, PdfReader.getPdfObject(obj), hits);
                return;
            }
            case 5: {
                PdfArray a2 = (PdfArray)obj;
                for (int k2 = 0; k2 < a2.size(); ++k2) {
                    PdfStamperImp.findAllObjects(reader, a2.getPdfObject(k2), hits);
                }
                return;
            }
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                Iterator<PdfName> i$ = dic.getKeys().iterator();
                while (i$.hasNext()) {
                    PdfName element;
                    PdfName name = element = i$.next();
                    PdfStamperImp.findAllObjects(reader, dic.get(name), hits);
                }
                return;
            }
        }
    }

    public void addComments(FdfReader fdf) throws IOException {
        int k2;
        if (this.readers2intrefs.containsKey(fdf)) {
            return;
        }
        PdfDictionary catalog = fdf.getCatalog();
        if ((catalog = catalog.getAsDict(PdfName.FDF)) == null) {
            return;
        }
        PdfArray annots = catalog.getAsArray(PdfName.ANNOTS);
        if (annots == null || annots.size() == 0) {
            return;
        }
        this.registerReader(fdf, false);
        IntHashtable hits = new IntHashtable();
        HashMap<String, PdfObject> irt = new HashMap<String, PdfObject>();
        ArrayList<PdfObject> an = new ArrayList<PdfObject>();
        for (int k3 = 0; k3 < annots.size(); ++k3) {
            PdfObject nm;
            PdfObject obj = annots.getPdfObject(k3);
            PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject(obj);
            PdfNumber page = annot.getAsNumber(PdfName.PAGE);
            if (page == null || page.intValue() >= this.reader.getNumberOfPages()) continue;
            PdfStamperImp.findAllObjects(fdf, obj, hits);
            an.add(obj);
            if (obj.type() != 10 || (nm = PdfReader.getPdfObject(annot.get(PdfName.NM))) == null || nm.type() != 3) continue;
            irt.put(nm.toString(), obj);
        }
        int[] arhits = hits.getKeys();
        for (k2 = 0; k2 < arhits.length; ++k2) {
            PdfObject i2;
            PdfObject str;
            int n2 = arhits[k2];
            PdfObject obj = fdf.getPdfObject(n2);
            if (obj.type() == 6 && (str = PdfReader.getPdfObject(((PdfDictionary)obj).get(PdfName.IRT))) != null && str.type() == 3 && (i2 = (PdfObject)irt.get(str.toString())) != null) {
                PdfDictionary dic2 = new PdfDictionary();
                dic2.merge((PdfDictionary)obj);
                dic2.put(PdfName.IRT, i2);
                obj = dic2;
            }
            this.addToBody(obj, this.getNewObjectNumber(fdf, n2, 0));
        }
        for (k2 = 0; k2 < an.size(); ++k2) {
            PdfObject obj = (PdfObject)an.get(k2);
            PdfDictionary annot = (PdfDictionary)PdfReader.getPdfObject(obj);
            PdfNumber page = annot.getAsNumber(PdfName.PAGE);
            PdfDictionary dic = this.reader.getPageN(page.intValue() + 1);
            PdfArray annotsp = (PdfArray)PdfReader.getPdfObject(dic.get(PdfName.ANNOTS), dic);
            if (annotsp == null) {
                annotsp = new PdfArray();
                dic.put(PdfName.ANNOTS, annotsp);
                this.markUsed(dic);
            }
            this.markUsed(annotsp);
            annotsp.add(obj);
        }
    }

    PageStamp getPageStamp(int pageNum) {
        PdfDictionary pageN = this.reader.getPageN(pageNum);
        PageStamp ps = this.pagesToContent.get(pageN);
        if (ps == null) {
            ps = new PageStamp(this, this.reader, pageN);
            this.pagesToContent.put(pageN, ps);
        }
        ps.pageN.setIndRef(this.reader.getPageOrigRef(pageNum));
        return ps;
    }

    PdfContentByte getUnderContent(int pageNum) {
        if (pageNum < 1 || pageNum > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp ps = this.getPageStamp(pageNum);
        if (ps.under == null) {
            ps.under = new StampContent(this, ps);
        }
        return ps.under;
    }

    PdfContentByte getOverContent(int pageNum) {
        if (pageNum < 1 || pageNum > this.reader.getNumberOfPages()) {
            return null;
        }
        PageStamp ps = this.getPageStamp(pageNum);
        if (ps.over == null) {
            ps.over = new StampContent(this, ps);
        }
        return ps.over;
    }

    void correctAcroFieldPages(int page) {
        if (this.acroFields == null) {
            return;
        }
        if (page > this.reader.getNumberOfPages()) {
            return;
        }
        Map<String, AcroFields.Item> fields2 = this.acroFields.getFields();
        for (AcroFields.Item item2 : fields2.values()) {
            for (int k2 = 0; k2 < item2.size(); ++k2) {
                int p2 = item2.getPage(k2);
                if (p2 < page) continue;
                item2.forcePage(k2, p2 + 1);
            }
        }
    }

    private static void moveRectangle(PdfDictionary dic2, PdfReader r2, int pageImported, PdfName key2, String name) {
        Rectangle m2 = r2.getBoxSize(pageImported, name);
        if (m2 == null) {
            dic2.remove(key2);
        } else {
            dic2.put(key2, new PdfRectangle(m2));
        }
    }

    void replacePage(PdfReader r2, int pageImported, int pageReplaced) {
        PdfDictionary pageN = this.reader.getPageN(pageReplaced);
        if (this.pagesToContent.containsKey(pageN)) {
            throw new IllegalStateException(MessageLocalization.getComposedMessage("this.page.cannot.be.replaced.new.content.was.already.added", new Object[0]));
        }
        PdfImportedPage p2 = this.getImportedPage(r2, pageImported);
        PdfDictionary dic2 = this.reader.getPageNRelease(pageReplaced);
        dic2.remove(PdfName.RESOURCES);
        dic2.remove(PdfName.CONTENTS);
        PdfStamperImp.moveRectangle(dic2, r2, pageImported, PdfName.MEDIABOX, "media");
        PdfStamperImp.moveRectangle(dic2, r2, pageImported, PdfName.CROPBOX, "crop");
        PdfStamperImp.moveRectangle(dic2, r2, pageImported, PdfName.TRIMBOX, "trim");
        PdfStamperImp.moveRectangle(dic2, r2, pageImported, PdfName.ARTBOX, "art");
        PdfStamperImp.moveRectangle(dic2, r2, pageImported, PdfName.BLEEDBOX, "bleed");
        dic2.put(PdfName.ROTATE, new PdfNumber(r2.getPageRotation(pageImported)));
        PdfContentByte cb = this.getOverContent(pageReplaced);
        cb.addTemplate((PdfTemplate)p2, 0.0f, 0.0f);
        PageStamp ps = this.pagesToContent.get(pageN);
        ps.replacePoint = ps.over.getInternalBuffer().size();
    }

    void insertPage(int pageNumber, Rectangle mediabox) {
        PdfDictionary parent;
        PRIndirectReference parentRef;
        Rectangle media = new Rectangle(mediabox);
        int rotation = media.getRotation() % 360;
        PdfDictionary page = new PdfDictionary(PdfName.PAGE);
        page.put(PdfName.RESOURCES, new PdfDictionary());
        page.put(PdfName.ROTATE, new PdfNumber(rotation));
        page.put(PdfName.MEDIABOX, new PdfRectangle(media, rotation));
        PRIndirectReference pref = this.reader.addPdfObject(page);
        if (pageNumber > this.reader.getNumberOfPages()) {
            PdfDictionary lastPage = this.reader.getPageNRelease(this.reader.getNumberOfPages());
            parentRef = (PRIndirectReference)lastPage.get(PdfName.PARENT);
            parentRef = new PRIndirectReference(this.reader, parentRef.getNumber());
            parent = (PdfDictionary)PdfReader.getPdfObject(parentRef);
            PdfArray kids = (PdfArray)PdfReader.getPdfObject(parent.get(PdfName.KIDS), parent);
            kids.add(pref);
            this.markUsed(kids);
            this.reader.pageRefs.insertPage(pageNumber, pref);
        } else {
            if (pageNumber < 1) {
                pageNumber = 1;
            }
            PdfDictionary firstPage = this.reader.getPageN(pageNumber);
            PRIndirectReference firstPageRef = this.reader.getPageOrigRef(pageNumber);
            this.reader.releasePage(pageNumber);
            parentRef = (PRIndirectReference)firstPage.get(PdfName.PARENT);
            parentRef = new PRIndirectReference(this.reader, parentRef.getNumber());
            parent = (PdfDictionary)PdfReader.getPdfObject(parentRef);
            PdfArray kids = (PdfArray)PdfReader.getPdfObject(parent.get(PdfName.KIDS), parent);
            int len = kids.size();
            int num = firstPageRef.getNumber();
            for (int k2 = 0; k2 < len; ++k2) {
                PRIndirectReference cur = (PRIndirectReference)kids.getPdfObject(k2);
                if (num != cur.getNumber()) continue;
                kids.add(k2, pref);
                break;
            }
            if (len == kids.size()) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("internal.inconsistence", new Object[0]));
            }
            this.markUsed(kids);
            this.reader.pageRefs.insertPage(pageNumber, pref);
            this.correctAcroFieldPages(pageNumber);
        }
        page.put(PdfName.PARENT, parentRef);
        while (parent != null) {
            this.markUsed(parent);
            PdfNumber count = (PdfNumber)PdfReader.getPdfObjectRelease(parent.get(PdfName.COUNT));
            parent.put(PdfName.COUNT, new PdfNumber(count.intValue() + 1));
            parent = parent.getAsDict(PdfName.PARENT);
        }
    }

    boolean isRotateContents() {
        return this.rotateContents;
    }

    void setRotateContents(boolean rotateContents) {
        this.rotateContents = rotateContents;
    }

    boolean isContentWritten() {
        return this.body.size() > 1;
    }

    AcroFields getAcroFields() {
        if (this.acroFields == null) {
            this.acroFields = new AcroFields(this.reader, this);
        }
        return this.acroFields;
    }

    void setFormFlattening(boolean flat) {
        this.flat = flat;
    }

    void setFreeTextFlattening(boolean flat) {
        this.flatFreeText = flat;
    }

    boolean partialFormFlattening(String name) {
        this.getAcroFields();
        if (this.acroFields.getXfa().isXfaPresent()) {
            throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("partial.form.flattening.is.not.supported.with.xfa.forms", new Object[0]));
        }
        if (!this.acroFields.getFields().containsKey(name)) {
            return false;
        }
        this.partialFlattening.add(name);
        return true;
    }

    protected void flatFields() {
        if (this.append) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("field.flattening.is.not.supported.in.append.mode", new Object[0]));
        }
        this.getAcroFields();
        Map<String, AcroFields.Item> fields2 = this.acroFields.getFields();
        if (this.fieldsAdded && this.partialFlattening.isEmpty()) {
            for (String s2 : fields2.keySet()) {
                this.partialFlattening.add(s2);
            }
        }
        PdfDictionary acroForm = this.reader.getCatalog().getAsDict(PdfName.ACROFORM);
        PdfArray acroFds = null;
        if (acroForm != null) {
            acroFds = (PdfArray)PdfReader.getPdfObject(acroForm.get(PdfName.FIELDS), acroForm);
        }
        for (Map.Entry<String, AcroFields.Item> entry : fields2.entrySet()) {
            String name = entry.getKey();
            if (!this.partialFlattening.isEmpty() && !this.partialFlattening.contains(name)) continue;
            AcroFields.Item item2 = entry.getValue();
            for (int k2 = 0; k2 < item2.size(); ++k2) {
                PdfDictionary pageDic;
                PdfArray annots;
                int page;
                PdfDictionary merged = item2.getMerged(k2);
                PdfNumber ff = merged.getAsNumber(PdfName.F);
                int flags = 0;
                if (ff != null) {
                    flags = ff.intValue();
                }
                if ((page = item2.getPage(k2).intValue()) < 1) continue;
                PdfDictionary appDic = merged.getAsDict(PdfName.AP);
                PdfDictionary as_n = null;
                if (appDic != null && (as_n = appDic.getAsStream(PdfName.N)) == null) {
                    as_n = appDic.getAsDict(PdfName.N);
                }
                if (this.acroFields.isGenerateAppearances()) {
                    if (appDic == null || as_n == null) {
                        try {
                            this.acroFields.regenerateField(name);
                            appDic = this.acroFields.getFieldItem(name).getMerged(k2).getAsDict(PdfName.AP);
                        }
                        catch (IOException e2) {
                        }
                        catch (DocumentException e3) {}
                    } else if (as_n.isStream()) {
                        PdfDictionary stream = as_n;
                        PdfArray bbox = stream.getAsArray(PdfName.BBOX);
                        PdfArray rect = merged.getAsArray(PdfName.RECT);
                        if (bbox != null && rect != null) {
                            float rectWidth = rect.getAsNumber(2).floatValue() - rect.getAsNumber(0).floatValue();
                            float bboxWidth = bbox.getAsNumber(2).floatValue() - bbox.getAsNumber(0).floatValue();
                            float rectHeight = rect.getAsNumber(3).floatValue() - rect.getAsNumber(1).floatValue();
                            float bboxHeight = bbox.getAsNumber(3).floatValue() - bbox.getAsNumber(1).floatValue();
                            double fieldRotation = 0.0;
                            if (merged.getAsDict(PdfName.MK) != null && merged.getAsDict(PdfName.MK).get(PdfName.R) != null) {
                                fieldRotation = merged.getAsDict(PdfName.MK).getAsNumber(PdfName.R).floatValue();
                            }
                            fieldRotation = fieldRotation * Math.PI / 180.0;
                            if ((fieldRotation %= Math.PI * 2) % Math.PI != 0.0) {
                                float temp = rectWidth;
                                rectWidth = rectHeight;
                                rectHeight = temp;
                            }
                            float widthCoef = Math.abs(bboxWidth != 0.0f ? rectWidth / bboxWidth : Float.MAX_VALUE);
                            float heightCoef = Math.abs(bboxHeight != 0.0f ? rectHeight / bboxHeight : Float.MAX_VALUE);
                            NumberArray array = new NumberArray(widthCoef, 0.0f, 0.0f, heightCoef, 0.0f, 0.0f);
                            stream.put(PdfName.MATRIX, array);
                            this.markUsed(stream);
                        }
                    }
                } else if (appDic != null && as_n != null) {
                    PdfArray bbox = ((PdfDictionary)as_n).getAsArray(PdfName.BBOX);
                    PdfArray rect = merged.getAsArray(PdfName.RECT);
                    if (bbox != null && rect != null) {
                        float widthDiff = bbox.getAsNumber(2).floatValue() - bbox.getAsNumber(0).floatValue() - (rect.getAsNumber(2).floatValue() - rect.getAsNumber(0).floatValue());
                        float heightDiff = bbox.getAsNumber(3).floatValue() - bbox.getAsNumber(1).floatValue() - (rect.getAsNumber(3).floatValue() - rect.getAsNumber(1).floatValue());
                        if (Math.abs(widthDiff) > 1.0f || Math.abs(heightDiff) > 1.0f) {
                            try {
                                this.acroFields.setGenerateAppearances(true);
                                this.acroFields.regenerateField(name);
                                this.acroFields.setGenerateAppearances(false);
                                appDic = this.acroFields.getFieldItem(name).getMerged(k2).getAsDict(PdfName.AP);
                            }
                            catch (IOException e4) {
                            }
                            catch (DocumentException e5) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (appDic != null && (flags & 4) != 0 && (flags & 2) == 0) {
                    PdfObject obj = appDic.get(PdfName.N);
                    PdfAppearance app = null;
                    if (obj != null) {
                        PdfIndirectReference iref;
                        PdfName as;
                        PdfObject objReal = PdfReader.getPdfObject(obj);
                        if (obj instanceof PdfIndirectReference && !obj.isIndirect()) {
                            app = new PdfAppearance((PdfIndirectReference)obj);
                        } else if (objReal instanceof PdfStream) {
                            ((PdfDictionary)objReal).put(PdfName.SUBTYPE, PdfName.FORM);
                            app = new PdfAppearance((PdfIndirectReference)obj);
                        } else if (objReal != null && objReal.isDictionary() && (as = merged.getAsName(PdfName.AS)) != null && (iref = (PdfIndirectReference)((PdfDictionary)objReal).get(as)) != null) {
                            app = new PdfAppearance(iref);
                            if (iref.isIndirect()) {
                                objReal = PdfReader.getPdfObject(iref);
                                ((PdfDictionary)objReal).put(PdfName.SUBTYPE, PdfName.FORM);
                            }
                        }
                    }
                    if (app != null) {
                        Rectangle box = PdfReader.getNormalizedRectangle(merged.getAsArray(PdfName.RECT));
                        PdfContentByte cb = this.getOverContent(page);
                        cb.setLiteral("Q ");
                        AffineTransform tf = new AffineTransform();
                        double fieldRotation = 0.0;
                        if (merged.getAsDict(PdfName.MK) != null && merged.getAsDict(PdfName.MK).get(PdfName.R) != null) {
                            fieldRotation = merged.getAsDict(PdfName.MK).getAsNumber(PdfName.R).floatValue();
                        }
                        fieldRotation = fieldRotation * Math.PI / 180.0;
                        tf = this.calculateTemplateTransformationMatrix(tf, fieldRotation %= Math.PI * 2, box);
                        cb.addTemplate((PdfTemplate)app, tf);
                        cb.setLiteral("q ");
                    }
                }
                if (this.partialFlattening.isEmpty() || (annots = (pageDic = this.reader.getPageN(page)).getAsArray(PdfName.ANNOTS)) == null) continue;
                block9: for (int idx = 0; idx < annots.size(); ++idx) {
                    PdfIndirectReference ran2;
                    PdfObject ran = annots.getPdfObject(idx);
                    if (!ran.isIndirect() || !(ran2 = item2.getWidgetRef(k2)).isIndirect() || ((PRIndirectReference)ran).getNumber() != ((PRIndirectReference)ran2).getNumber()) continue;
                    annots.remove(idx--);
                    PRIndirectReference wdref = (PRIndirectReference)ran2;
                    while (true) {
                        PdfDictionary wd = (PdfDictionary)PdfReader.getPdfObject(wdref);
                        PRIndirectReference parentRef = (PRIndirectReference)wd.get(PdfName.PARENT);
                        PdfReader.killIndirect(wdref);
                        if (parentRef == null) {
                            for (int fr = 0; fr < acroFds.size(); ++fr) {
                                PdfObject h2 = acroFds.getPdfObject(fr);
                                if (!h2.isIndirect() || ((PRIndirectReference)h2).getNumber() != wdref.getNumber()) continue;
                                acroFds.remove(fr);
                                --fr;
                            }
                            continue block9;
                        }
                        PdfDictionary parent = (PdfDictionary)PdfReader.getPdfObject(parentRef);
                        PdfArray kids = parent.getAsArray(PdfName.KIDS);
                        for (int fr = 0; fr < kids.size(); ++fr) {
                            PdfObject h3 = kids.getPdfObject(fr);
                            if (!h3.isIndirect() || ((PRIndirectReference)h3).getNumber() != wdref.getNumber()) continue;
                            kids.remove(fr);
                            --fr;
                        }
                        if (!kids.isEmpty()) continue block9;
                        wdref = parentRef;
                    }
                }
                if (!annots.isEmpty()) continue;
                PdfReader.killIndirect(pageDic.get(PdfName.ANNOTS));
                pageDic.remove(PdfName.ANNOTS);
            }
        }
        if (!this.fieldsAdded && this.partialFlattening.isEmpty()) {
            for (int page = 1; page <= this.reader.getNumberOfPages(); ++page) {
                PdfDictionary pageDic = this.reader.getPageN(page);
                PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
                if (annots == null) continue;
                for (int idx = 0; idx < annots.size(); ++idx) {
                    PdfObject annoto = annots.getDirectObject(idx);
                    if (annoto instanceof PdfIndirectReference && !annoto.isIndirect() || annoto.isDictionary() && !PdfName.WIDGET.equals(((PdfDictionary)annoto).get(PdfName.SUBTYPE))) continue;
                    annots.remove(idx);
                    --idx;
                }
                if (!annots.isEmpty()) continue;
                PdfReader.killIndirect(pageDic.get(PdfName.ANNOTS));
                pageDic.remove(PdfName.ANNOTS);
            }
            this.eliminateAcroformObjects();
        }
    }

    void eliminateAcroformObjects() {
        PdfObject acro = this.reader.getCatalog().get(PdfName.ACROFORM);
        if (acro == null) {
            return;
        }
        PdfDictionary acrodic = (PdfDictionary)PdfReader.getPdfObject(acro);
        this.reader.killXref(acrodic.get(PdfName.XFA));
        acrodic.remove(PdfName.XFA);
        PdfObject iFields = acrodic.get(PdfName.FIELDS);
        if (iFields != null) {
            PdfDictionary kids = new PdfDictionary();
            kids.put(PdfName.KIDS, iFields);
            this.sweepKids(kids);
            PdfReader.killIndirect(iFields);
            acrodic.put(PdfName.FIELDS, new PdfArray());
        }
        acrodic.remove(PdfName.SIGFLAGS);
        acrodic.remove(PdfName.NEEDAPPEARANCES);
        acrodic.remove(PdfName.DR);
    }

    private AffineTransform calculateTemplateTransformationMatrix(AffineTransform currentMatrix, double fieldRotation, Rectangle box) {
        AffineTransform templateTransform = new AffineTransform(currentMatrix);
        double x2 = box.getLeft();
        double y2 = box.getBottom();
        if (fieldRotation % 1.5707963267948966 == 0.0 && fieldRotation % 4.71238898038469 != 0.0 && fieldRotation != 0.0) {
            x2 += (double)box.getWidth();
        }
        if ((fieldRotation % 4.71238898038469 == 0.0 || fieldRotation % Math.PI == 0.0) && fieldRotation != 0.0) {
            y2 += (double)box.getHeight();
        }
        templateTransform.translate(x2, y2);
        templateTransform.rotate(fieldRotation);
        return templateTransform;
    }

    void sweepKids(PdfObject obj) {
        PdfObject oo = PdfReader.killIndirect(obj);
        if (oo == null || !oo.isDictionary()) {
            return;
        }
        PdfDictionary dic = (PdfDictionary)oo;
        PdfArray kids = (PdfArray)PdfReader.killIndirect(dic.get(PdfName.KIDS));
        if (kids == null) {
            return;
        }
        for (int k2 = 0; k2 < kids.size(); ++k2) {
            this.sweepKids(kids.getPdfObject(k2));
        }
    }

    public void setFlatAnnotations(boolean flatAnnotations) {
        this.flatannotations = flatAnnotations;
    }

    protected void flattenAnnotations() {
        this.flattenAnnotations(false);
    }

    private void flattenAnnotations(boolean flattenFreeTextAnnotations) {
        if (this.append) {
            if (flattenFreeTextAnnotations) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("freetext.flattening.is.not.supported.in.append.mode", new Object[0]));
            }
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("annotation.flattening.is.not.supported.in.append.mode", new Object[0]));
        }
        for (int page = 1; page <= this.reader.getNumberOfPages(); ++page) {
            PdfDictionary pageDic = this.reader.getPageN(page);
            PdfArray annots = pageDic.getAsArray(PdfName.ANNOTS);
            if (annots == null) continue;
            for (int idx = 0; idx < annots.size(); ++idx) {
                PdfIndirectReference iref;
                PdfName as_p;
                PdfObject obj1;
                int flags;
                PdfObject annoto = annots.getDirectObject(idx);
                if (annoto instanceof PdfIndirectReference && !annoto.isIndirect() || !(annoto instanceof PdfDictionary)) continue;
                PdfDictionary annDic = (PdfDictionary)annoto;
                if (!flattenFreeTextAnnotations ? annDic.get(PdfName.SUBTYPE).equals(PdfName.WIDGET) : !annDic.get(PdfName.SUBTYPE).equals(PdfName.FREETEXT)) continue;
                PdfNumber ff = annDic.getAsNumber(PdfName.F);
                int n2 = flags = ff != null ? ff.intValue() : 0;
                if ((flags & 4) == 0 || (flags & 2) != 0 || (obj1 = annDic.get(PdfName.AP)) == null) continue;
                PdfDictionary appDic = obj1 instanceof PdfIndirectReference ? (PdfDictionary)PdfReader.getPdfObject(obj1) : (PdfDictionary)obj1;
                PdfObject obj = appDic.get(PdfName.N);
                PdfStream objDict = appDic.getAsStream(PdfName.N);
                PdfAppearance app = null;
                PdfObject objReal = PdfReader.getPdfObject(obj);
                if (obj instanceof PdfIndirectReference && !obj.isIndirect()) {
                    app = new PdfAppearance((PdfIndirectReference)obj);
                } else if (objReal instanceof PdfStream) {
                    ((PdfDictionary)objReal).put(PdfName.SUBTYPE, PdfName.FORM);
                    app = new PdfAppearance((PdfIndirectReference)obj);
                } else if (objReal.isDictionary() && (as_p = appDic.getAsName(PdfName.AS)) != null && (iref = (PdfIndirectReference)((PdfDictionary)objReal).get(as_p)) != null) {
                    app = new PdfAppearance(iref);
                    if (iref.isIndirect()) {
                        objReal = PdfReader.getPdfObject(iref);
                        ((PdfDictionary)objReal).put(PdfName.SUBTYPE, PdfName.FORM);
                    }
                }
                if (app == null) continue;
                Rectangle rect = PdfReader.getNormalizedRectangle(annDic.getAsArray(PdfName.RECT));
                Rectangle bBox = PdfReader.getNormalizedRectangle(objDict.getAsArray(PdfName.BBOX));
                PdfContentByte cb = this.getOverContent(page);
                cb.setLiteral("Q ");
                if (objDict.getAsArray(PdfName.MATRIX) != null && !Arrays.equals(this.DEFAULT_MATRIX, objDict.getAsArray(PdfName.MATRIX).asDoubleArray())) {
                    double[] matrix = objDict.getAsArray(PdfName.MATRIX).asDoubleArray();
                    Rectangle transformBBox = this.transformBBoxByMatrix(bBox, matrix);
                    cb.addTemplate((PdfTemplate)app, rect.getWidth() / transformBBox.getWidth(), 0.0f, 0.0f, rect.getHeight() / transformBBox.getHeight(), rect.getLeft(), rect.getBottom());
                } else {
                    cb.addTemplate((PdfTemplate)app, rect.getWidth() / bBox.getWidth(), 0.0f, 0.0f, rect.getHeight() / bBox.getHeight(), rect.getLeft(), rect.getBottom());
                }
                cb.setLiteral("q ");
                annots.remove(idx);
                --idx;
            }
            if (!annots.isEmpty()) continue;
            PdfReader.killIndirect(pageDic.get(PdfName.ANNOTS));
            pageDic.remove(PdfName.ANNOTS);
        }
    }

    private Rectangle transformBBoxByMatrix(Rectangle bBox, double[] matrix) {
        ArrayList<Double> xArr = new ArrayList<Double>();
        ArrayList<Double> yArr = new ArrayList<Double>();
        Point p1 = this.transformPoint(bBox.getLeft(), bBox.getBottom(), matrix);
        xArr.add(p1.x);
        yArr.add(p1.y);
        Point p2 = this.transformPoint(bBox.getRight(), bBox.getTop(), matrix);
        xArr.add(p2.x);
        yArr.add(p2.y);
        Point p3 = this.transformPoint(bBox.getLeft(), bBox.getTop(), matrix);
        xArr.add(p3.x);
        yArr.add(p3.y);
        Point p4 = this.transformPoint(bBox.getRight(), bBox.getBottom(), matrix);
        xArr.add(p4.x);
        yArr.add(p4.y);
        return new Rectangle(((Double)Collections.min(xArr)).floatValue(), ((Double)Collections.min(yArr)).floatValue(), ((Double)Collections.max(xArr)).floatValue(), ((Double)Collections.max(yArr)).floatValue());
    }

    private Point transformPoint(double x2, double y2, double[] matrix) {
        Point point = new Point();
        point.x = matrix[0] * x2 + matrix[2] * y2 + matrix[4];
        point.y = matrix[1] * x2 + matrix[3] * y2 + matrix[5];
        return point;
    }

    protected void flatFreeTextFields() {
        this.flattenAnnotations(true);
    }

    @Override
    public PdfIndirectReference getPageReference(int page) {
        PRIndirectReference ref = this.reader.getPageOrigRef(page);
        if (ref == null) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("invalid.page.number.1", page));
        }
        return ref;
    }

    @Override
    public void addAnnotation(PdfAnnotation annot) {
        throw new RuntimeException(MessageLocalization.getComposedMessage("unsupported.in.this.context.use.pdfstamper.addannotation", new Object[0]));
    }

    void addDocumentField(PdfIndirectReference ref) {
        PdfArray fields2;
        PdfDictionary catalog = this.reader.getCatalog();
        PdfDictionary acroForm = (PdfDictionary)PdfReader.getPdfObject(catalog.get(PdfName.ACROFORM), catalog);
        if (acroForm == null) {
            acroForm = new PdfDictionary();
            catalog.put(PdfName.ACROFORM, acroForm);
            this.markUsed(catalog);
        }
        if ((fields2 = (PdfArray)PdfReader.getPdfObject(acroForm.get(PdfName.FIELDS), acroForm)) == null) {
            fields2 = new PdfArray();
            acroForm.put(PdfName.FIELDS, fields2);
            this.markUsed(acroForm);
        }
        if (!acroForm.contains(PdfName.DA)) {
            acroForm.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(acroForm);
        }
        fields2.add(ref);
        this.markUsed(fields2);
    }

    protected void addFieldResources() throws IOException {
        PdfDictionary dic;
        PdfDictionary dr;
        if (this.fieldTemplates.isEmpty()) {
            return;
        }
        PdfDictionary catalog = this.reader.getCatalog();
        PdfDictionary acroForm = (PdfDictionary)PdfReader.getPdfObject(catalog.get(PdfName.ACROFORM), catalog);
        if (acroForm == null) {
            acroForm = new PdfDictionary();
            catalog.put(PdfName.ACROFORM, acroForm);
            this.markUsed(catalog);
        }
        if ((dr = (PdfDictionary)PdfReader.getPdfObject(acroForm.get(PdfName.DR), acroForm)) == null) {
            dr = new PdfDictionary();
            acroForm.put(PdfName.DR, dr);
            this.markUsed(acroForm);
        }
        this.markUsed(dr);
        for (PdfTemplate template : this.fieldTemplates) {
            PdfFormField.mergeResources(dr, (PdfDictionary)template.getResources(), this);
        }
        PdfDictionary fonts = dr.getAsDict(PdfName.FONT);
        if (fonts == null) {
            fonts = new PdfDictionary();
            dr.put(PdfName.FONT, fonts);
        }
        if (!fonts.contains(PdfName.HELV)) {
            dic = new PdfDictionary(PdfName.FONT);
            dic.put(PdfName.BASEFONT, PdfName.HELVETICA);
            dic.put(PdfName.ENCODING, PdfName.WIN_ANSI_ENCODING);
            dic.put(PdfName.NAME, PdfName.HELV);
            dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
            fonts.put(PdfName.HELV, this.addToBody(dic).getIndirectReference());
        }
        if (!fonts.contains(PdfName.ZADB)) {
            dic = new PdfDictionary(PdfName.FONT);
            dic.put(PdfName.BASEFONT, PdfName.ZAPFDINGBATS);
            dic.put(PdfName.NAME, PdfName.ZADB);
            dic.put(PdfName.SUBTYPE, PdfName.TYPE1);
            fonts.put(PdfName.ZADB, this.addToBody(dic).getIndirectReference());
        }
        if (acroForm.get(PdfName.DA) == null) {
            acroForm.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
            this.markUsed(acroForm);
        }
    }

    void expandFields(PdfFormField field2, ArrayList<PdfAnnotation> allAnnots) {
        allAnnots.add(field2);
        ArrayList<PdfFormField> kids = field2.getKids();
        if (kids != null) {
            for (int k2 = 0; k2 < kids.size(); ++k2) {
                this.expandFields(kids.get(k2), allAnnots);
            }
        }
    }

    void addAnnotation(PdfAnnotation annot, PdfDictionary pageN) {
        try {
            ArrayList<PdfAnnotation> allAnnots = new ArrayList<PdfAnnotation>();
            if (annot.isForm()) {
                this.fieldsAdded = true;
                this.getAcroFields();
                PdfFormField field2 = (PdfFormField)annot;
                if (field2.getParent() != null) {
                    return;
                }
                this.expandFields(field2, allAnnots);
            } else {
                allAnnots.add(annot);
            }
            for (int k2 = 0; k2 < allAnnots.size(); ++k2) {
                annot = (PdfAnnotation)allAnnots.get(k2);
                if (annot.getPlaceInPage() > 0) {
                    pageN = this.reader.getPageN(annot.getPlaceInPage());
                }
                if (annot.isForm()) {
                    PdfFormField field3;
                    HashSet<PdfTemplate> templates;
                    if (!annot.isUsed() && (templates = annot.getTemplates()) != null) {
                        this.fieldTemplates.addAll(templates);
                    }
                    if ((field3 = (PdfFormField)annot).getParent() == null) {
                        this.addDocumentField(field3.getIndirectReference());
                    }
                }
                if (annot.isAnnotation()) {
                    PdfRectangle rect;
                    PdfObject pdfobj = PdfReader.getPdfObject(pageN.get(PdfName.ANNOTS), pageN);
                    PdfArray annots = null;
                    if (pdfobj == null || !pdfobj.isArray()) {
                        annots = new PdfArray();
                        pageN.put(PdfName.ANNOTS, annots);
                        this.markUsed(pageN);
                    } else {
                        annots = (PdfArray)pdfobj;
                    }
                    annots.add(annot.getIndirectReference());
                    this.markUsed(annots);
                    if (!(annot.isUsed() || (rect = (PdfRectangle)annot.get(PdfName.RECT)) == null || rect.left() == 0.0f && rect.right() == 0.0f && rect.top() == 0.0f && rect.bottom() == 0.0f)) {
                        int rotation = this.reader.getPageRotation(pageN);
                        Rectangle pageSize = this.reader.getPageSizeWithRotation(pageN);
                        switch (rotation) {
                            case 90: {
                                annot.put(PdfName.RECT, new PdfRectangle(pageSize.getTop() - rect.top(), rect.right(), pageSize.getTop() - rect.bottom(), rect.left()));
                                break;
                            }
                            case 180: {
                                annot.put(PdfName.RECT, new PdfRectangle(pageSize.getRight() - rect.left(), pageSize.getTop() - rect.bottom(), pageSize.getRight() - rect.right(), pageSize.getTop() - rect.top()));
                                break;
                            }
                            case 270: {
                                annot.put(PdfName.RECT, new PdfRectangle(rect.bottom(), pageSize.getRight() - rect.left(), rect.top(), pageSize.getRight() - rect.right()));
                            }
                        }
                    }
                }
                if (annot.isUsed()) continue;
                annot.setUsed();
                this.addToBody((PdfObject)annot, annot.getIndirectReference());
            }
        }
        catch (IOException e2) {
            throw new ExceptionConverter(e2);
        }
    }

    @Override
    void addAnnotation(PdfAnnotation annot, int page) {
        if (annot.isAnnotation()) {
            annot.setPage(page);
        }
        this.addAnnotation(annot, this.reader.getPageN(page));
    }

    private void outlineTravel(PRIndirectReference outline) {
        while (outline != null) {
            PdfDictionary outlineR = (PdfDictionary)PdfReader.getPdfObjectRelease(outline);
            PRIndirectReference first = (PRIndirectReference)outlineR.get(PdfName.FIRST);
            if (first != null) {
                this.outlineTravel(first);
            }
            PdfReader.killIndirect(outlineR.get(PdfName.DEST));
            PdfReader.killIndirect(outlineR.get(PdfName.A));
            PdfReader.killIndirect(outline);
            outline = (PRIndirectReference)outlineR.get(PdfName.NEXT);
        }
    }

    void deleteOutlines() {
        PdfDictionary catalog = this.reader.getCatalog();
        PdfObject obj = catalog.get(PdfName.OUTLINES);
        if (obj == null) {
            return;
        }
        if (obj instanceof PRIndirectReference) {
            PRIndirectReference outlines = (PRIndirectReference)obj;
            this.outlineTravel(outlines);
            PdfReader.killIndirect(outlines);
        }
        catalog.remove(PdfName.OUTLINES);
        this.markUsed(catalog);
    }

    protected void setJavaScript() throws IOException {
        HashMap<String, PdfObject> djs = this.pdf.getDocumentLevelJS();
        if (djs.isEmpty()) {
            return;
        }
        PdfDictionary catalog = this.reader.getCatalog();
        PdfDictionary names = (PdfDictionary)PdfReader.getPdfObject(catalog.get(PdfName.NAMES), catalog);
        if (names == null) {
            names = new PdfDictionary();
            catalog.put(PdfName.NAMES, names);
            this.markUsed(catalog);
        }
        this.markUsed(names);
        PdfDictionary tree = PdfNameTree.writeTree(djs, this);
        names.put(PdfName.JAVASCRIPT, this.addToBody(tree).getIndirectReference());
    }

    protected void addFileAttachments() throws IOException {
        HashMap<String, PdfObject> fs = this.pdf.getDocumentFileAttachment();
        if (fs.isEmpty()) {
            return;
        }
        PdfDictionary catalog = this.reader.getCatalog();
        PdfDictionary names = (PdfDictionary)PdfReader.getPdfObject(catalog.get(PdfName.NAMES), catalog);
        if (names == null) {
            names = new PdfDictionary();
            catalog.put(PdfName.NAMES, names);
            this.markUsed(catalog);
        }
        this.markUsed(names);
        HashMap<String, PdfObject> old = PdfNameTree.readTree((PdfDictionary)PdfReader.getPdfObjectRelease(names.get(PdfName.EMBEDDEDFILES)));
        for (Map.Entry<String, PdfObject> entry : fs.entrySet()) {
            String name = entry.getKey();
            int k2 = 0;
            StringBuilder nn = new StringBuilder(name);
            while (old.containsKey(nn.toString())) {
                nn.append(" ").append(++k2);
            }
            old.put(nn.toString(), entry.getValue());
        }
        PdfDictionary tree = PdfNameTree.writeTree(old, this);
        PdfObject oldEmbeddedFiles = names.get(PdfName.EMBEDDEDFILES);
        if (oldEmbeddedFiles != null) {
            PdfReader.killIndirect(oldEmbeddedFiles);
        }
        names.put(PdfName.EMBEDDEDFILES, this.addToBody(tree).getIndirectReference());
    }

    void makePackage(PdfCollection collection) {
        PdfDictionary catalog = this.reader.getCatalog();
        catalog.put(PdfName.COLLECTION, collection);
    }

    protected void setOutlines() throws IOException {
        if (this.newBookmarks == null) {
            return;
        }
        this.deleteOutlines();
        if (this.newBookmarks.isEmpty()) {
            return;
        }
        PdfDictionary catalog = this.reader.getCatalog();
        boolean namedAsNames = catalog.get(PdfName.DESTS) != null;
        this.writeOutlines(catalog, namedAsNames);
        this.markUsed(catalog);
    }

    @Override
    public void setViewerPreferences(int preferences) {
        this.useVp = true;
        this.viewerPreferences.setViewerPreferences(preferences);
    }

    @Override
    public void addViewerPreference(PdfName key2, PdfObject value) {
        this.useVp = true;
        this.viewerPreferences.addViewerPreference(key2, value);
    }

    @Override
    public void setSigFlags(int f2) {
        this.sigFlags |= f2;
    }

    @Override
    public void setPageAction(PdfName actionType, PdfAction action2) throws PdfException {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("use.setpageaction.pdfname.actiontype.pdfaction.action.int.page", new Object[0]));
    }

    void setPageAction(PdfName actionType, PdfAction action2, int page) throws PdfException {
        if (!actionType.equals(PAGE_OPEN) && !actionType.equals(PAGE_CLOSE)) {
            throw new PdfException(MessageLocalization.getComposedMessage("invalid.page.additional.action.type.1", actionType.toString()));
        }
        PdfDictionary pg = this.reader.getPageN(page);
        PdfDictionary aa = (PdfDictionary)PdfReader.getPdfObject(pg.get(PdfName.AA), pg);
        if (aa == null) {
            aa = new PdfDictionary();
            pg.put(PdfName.AA, aa);
            this.markUsed(pg);
        }
        aa.put(actionType, action2);
        this.markUsed(aa);
    }

    @Override
    public void setDuration(int seconds) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("use.setpageaction.pdfname.actiontype.pdfaction.action.int.page", new Object[0]));
    }

    @Override
    public void setTransition(PdfTransition transition) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("use.setpageaction.pdfname.actiontype.pdfaction.action.int.page", new Object[0]));
    }

    void setDuration(int seconds, int page) {
        PdfDictionary pg = this.reader.getPageN(page);
        if (seconds < 0) {
            pg.remove(PdfName.DUR);
        } else {
            pg.put(PdfName.DUR, new PdfNumber(seconds));
        }
        this.markUsed(pg);
    }

    void setTransition(PdfTransition transition, int page) {
        PdfDictionary pg = this.reader.getPageN(page);
        if (transition == null) {
            pg.remove(PdfName.TRANS);
        } else {
            pg.put(PdfName.TRANS, transition.getTransitionDictionary());
        }
        this.markUsed(pg);
    }

    protected void markUsed(PdfObject obj) {
        if (this.append && obj != null) {
            PRIndirectReference ref = null;
            ref = obj.type() == 10 ? (PRIndirectReference)obj : obj.getIndRef();
            if (ref != null) {
                this.marked.put(ref.getNumber(), 1);
            }
        }
    }

    protected void markUsed(int num) {
        if (this.append) {
            this.marked.put(num, 1);
        }
    }

    boolean isAppend() {
        return this.append;
    }

    public PdfReader getPdfReader() {
        return this.reader;
    }

    @Override
    public void setAdditionalAction(PdfName actionType, PdfAction action2) throws PdfException {
        if (!(actionType.equals(DOCUMENT_CLOSE) || actionType.equals(WILL_SAVE) || actionType.equals(DID_SAVE) || actionType.equals(WILL_PRINT) || actionType.equals(DID_PRINT))) {
            throw new PdfException(MessageLocalization.getComposedMessage("invalid.additional.action.type.1", actionType.toString()));
        }
        PdfDictionary aa = this.reader.getCatalog().getAsDict(PdfName.AA);
        if (aa == null) {
            if (action2 == null) {
                return;
            }
            aa = new PdfDictionary();
            this.reader.getCatalog().put(PdfName.AA, aa);
        }
        this.markUsed(aa);
        if (action2 == null) {
            aa.remove(actionType);
        } else {
            aa.put(actionType, action2);
        }
    }

    @Override
    public void setOpenAction(PdfAction action2) {
        this.openAction = action2;
    }

    @Override
    public void setOpenAction(String name) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("open.actions.by.name.are.not.supported", new Object[0]));
    }

    @Override
    public void setThumbnail(Image image) {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("use.pdfstamper.setthumbnail", new Object[0]));
    }

    void setThumbnail(Image image, int page) throws PdfException, DocumentException {
        PdfIndirectReference thumb = this.getImageReference(this.addDirectImageSimple(image));
        this.reader.resetReleasePage();
        PdfDictionary dic = this.reader.getPageN(page);
        dic.put(PdfName.THUMB, thumb);
        this.reader.resetReleasePage();
    }

    @Override
    public PdfContentByte getDirectContentUnder() {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("use.pdfstamper.getundercontent.or.pdfstamper.getovercontent", new Object[0]));
    }

    @Override
    public PdfContentByte getDirectContent() {
        throw new UnsupportedOperationException(MessageLocalization.getComposedMessage("use.pdfstamper.getundercontent.or.pdfstamper.getovercontent", new Object[0]));
    }

    protected void readOCProperties() {
        PdfArray order;
        PdfLayer layer;
        PdfIndirectReference ref;
        if (!this.documentOCG.isEmpty()) {
            return;
        }
        PdfDictionary dict = this.reader.getCatalog().getAsDict(PdfName.OCPROPERTIES);
        if (dict == null) {
            return;
        }
        PdfArray ocgs = dict.getAsArray(PdfName.OCGS);
        if (ocgs == null) {
            ocgs = new PdfArray();
            dict.put(PdfName.OCGS, ocgs);
        }
        HashMap<String, PdfLayer> ocgmap = new HashMap<String, PdfLayer>();
        ListIterator<PdfObject> i2 = ocgs.listIterator();
        while (i2.hasNext()) {
            ref = (PdfIndirectReference)i2.next();
            layer = new PdfLayer(null);
            layer.setRef(ref);
            layer.setOnPanel(false);
            layer.merge((PdfDictionary)PdfReader.getPdfObject(ref));
            ocgmap.put(ref.toString(), layer);
        }
        PdfDictionary d2 = dict.getAsDict(PdfName.D);
        PdfArray off = d2.getAsArray(PdfName.OFF);
        if (off != null) {
            ListIterator<PdfObject> i3 = off.listIterator();
            while (i3.hasNext()) {
                ref = (PdfIndirectReference)i3.next();
                layer = ocgmap.get(ref.toString());
                layer.setOn(false);
            }
        }
        if ((order = d2.getAsArray(PdfName.ORDER)) != null) {
            this.addOrder(null, order, ocgmap);
        }
        this.documentOCG.addAll(ocgmap.values());
        this.OCGRadioGroup = d2.getAsArray(PdfName.RBGROUPS);
        if (this.OCGRadioGroup == null) {
            this.OCGRadioGroup = new PdfArray();
        }
        this.OCGLocked = d2.getAsArray(PdfName.LOCKED);
        if (this.OCGLocked == null) {
            this.OCGLocked = new PdfArray();
        }
    }

    private void addOrder(PdfLayer parent, PdfArray arr, Map<String, PdfLayer> ocgmap) {
        for (int i2 = 0; i2 < arr.size(); ++i2) {
            PdfLayer layer;
            PdfObject obj = arr.getPdfObject(i2);
            if (obj.isIndirect()) {
                layer = ocgmap.get(obj.toString());
                if (layer == null) continue;
                layer.setOnPanel(true);
                this.registerLayer(layer);
                if (parent != null) {
                    parent.addChild(layer);
                }
                if (arr.size() <= i2 + 1 || !arr.getPdfObject(i2 + 1).isArray()) continue;
                this.addOrder(layer, (PdfArray)arr.getPdfObject(++i2), ocgmap);
                continue;
            }
            if (!obj.isArray()) continue;
            PdfArray sub = (PdfArray)obj;
            if (sub.isEmpty()) {
                return;
            }
            obj = sub.getPdfObject(0);
            if (obj.isString()) {
                layer = new PdfLayer(obj.toString());
                layer.setOnPanel(true);
                this.registerLayer(layer);
                if (parent != null) {
                    parent.addChild(layer);
                }
                PdfArray array = new PdfArray();
                ListIterator<PdfObject> j2 = sub.listIterator();
                while (j2.hasNext()) {
                    array.add((PdfObject)j2.next());
                }
                this.addOrder(layer, array, ocgmap);
                continue;
            }
            this.addOrder(parent, (PdfArray)obj, ocgmap);
        }
    }

    public Map<String, PdfLayer> getPdfLayers() {
        if (!this.originalLayersAreRead) {
            this.originalLayersAreRead = true;
            this.readOCProperties();
        }
        HashMap<String, PdfLayer> map2 = new HashMap<String, PdfLayer>();
        for (PdfOCG pdfOCG : this.documentOCG) {
            PdfLayer layer = (PdfLayer)pdfOCG;
            String key2 = layer.getTitle() == null ? layer.getAsString(PdfName.NAME).toString() : layer.getTitle();
            if (map2.containsKey(key2)) {
                int seq = 2;
                String tmp = key2 + "(" + seq + ")";
                while (map2.containsKey(tmp)) {
                    tmp = key2 + "(" + ++seq + ")";
                }
                key2 = tmp;
            }
            map2.put(key2, layer);
        }
        return map2;
    }

    @Override
    void registerLayer(PdfOCG layer) {
        if (!this.originalLayersAreRead) {
            this.originalLayersAreRead = true;
            this.readOCProperties();
        }
        super.registerLayer(layer);
    }

    @Override
    public void createXmpMetadata() {
        try {
            this.xmpWriter = this.createXmpWriter(null, this.reader.getInfo());
            this.xmpMetadata = null;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected HashMap<Object, PdfObject> getNamedDestinations() {
        return this.namedDestinations;
    }

    protected void updateNamedDestinations() throws IOException {
        PdfDictionary dic = this.reader.getCatalog().getAsDict(PdfName.NAMES);
        if (dic != null) {
            dic = dic.getAsDict(PdfName.DESTS);
        }
        if (dic == null) {
            dic = this.reader.getCatalog().getAsDict(PdfName.DESTS);
        }
        if (dic == null) {
            dic = new PdfDictionary();
            PdfDictionary dests = new PdfDictionary();
            dic.put(PdfName.NAMES, new PdfArray());
            dests.put(PdfName.DESTS, dic);
            this.reader.getCatalog().put(PdfName.NAMES, dests);
        }
        PdfArray names = this.getLastChildInNameTree(dic);
        for (Object name : this.namedDestinations.keySet()) {
            names.add(new PdfString(name.toString()));
            names.add(this.addToBody(this.namedDestinations.get(name), this.getPdfIndirectReference()).getIndirectReference());
        }
    }

    private PdfArray getLastChildInNameTree(PdfDictionary dic) {
        PdfArray names;
        PdfArray childNode = dic.getAsArray(PdfName.KIDS);
        if (childNode != null) {
            PdfDictionary lastKid = childNode.getAsDict(childNode.size() - 1);
            names = this.getLastChildInNameTree(lastKid);
        } else {
            names = dic.getAsArray(PdfName.NAMES);
        }
        return names;
    }

    static class PageStamp {
        PdfDictionary pageN;
        StampContent under;
        StampContent over;
        PageResources pageResources;
        int replacePoint = 0;

        PageStamp(PdfStamperImp stamper, PdfReader reader, PdfDictionary pageN) {
            this.pageN = pageN;
            this.pageResources = new PageResources();
            PdfDictionary resources2 = pageN.getAsDict(PdfName.RESOURCES);
            this.pageResources.setOriginalResources(resources2, stamper.namePtr);
        }
    }
}

