/*
 * Decompiled with CFR 0.152.
 */
package de.treichels.hott.voice;

import de.treichels.hott.voice.ADPCMCodec;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0002J\b\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lde/treichels/hott/voice/EncodingInputStream;", "Ljava/io/InputStream;", "inputStream", "volume", "", "(Ljava/io/InputStream;D)V", "buffer", "", "codec", "Lde/treichels/hott/voice/ADPCMCodec;", "available", "", "close", "", "mark", "readlimit", "markSupported", "", "read", "readShort", "reset", "skip", "", "n", "HoTT-Voice"})
public final class EncodingInputStream
extends InputStream {
    private final ADPCMCodec codec;
    private final byte[] buffer;
    private final InputStream inputStream;
    private final double volume;

    @Override
    public int available() {
        return (this.inputStream.available() + 3) / 4;
    }

    @Override
    public void close() {
        this.inputStream.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read() {
        int pcm = this.readShort();
        int adpcm = -1;
        if (pcm != -1) {
            short signed = (short)((double)((short)pcm / 16) * this.volume);
            adpcm = this.codec.encode(signed);
            pcm = this.readShort();
            if (pcm != -1) {
                signed = (short)((double)((short)pcm / 16) * this.volume);
                adpcm |= this.codec.encode(signed) << 4;
            }
        }
        return adpcm;
    }

    private final int readShort() {
        int len = this.inputStream.read(this.buffer);
        return len == -1 ? -1 : this.buffer[0] & 0xFF | (this.buffer[1] & 0xFF) << 8;
    }

    @Override
    public synchronized void reset() {
        this.inputStream.reset();
    }

    @Override
    public long skip(long n2) {
        return this.inputStream.skip(n2);
    }

    public EncodingInputStream(@NotNull InputStream inputStream2, double volume) {
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        this.inputStream = inputStream2;
        this.volume = volume;
        this.codec = new ADPCMCodec();
        this.buffer = new byte[2];
    }

    public /* synthetic */ EncodingInputStream(InputStream inputStream2, double d2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            d2 = 1.0;
        }
        this(inputStream2, d2);
    }
}

