/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNameTree;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.xml.XMLUtil;
import com.itextpdf.text.xml.simpleparser.IanaEncodings;
import com.itextpdf.text.xml.simpleparser.SimpleXMLDocHandler;
import com.itextpdf.text.xml.simpleparser.SimpleXMLParser;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleNamedDestination
implements SimpleXMLDocHandler {
    private HashMap<String, String> xmlNames;
    private HashMap<String, String> xmlLast;

    private SimpleNamedDestination() {
    }

    public static HashMap<String, String> getNamedDestination(PdfReader reader, boolean fromNames) {
        IntHashtable pages = new IntHashtable();
        int numPages = reader.getNumberOfPages();
        for (int k2 = 1; k2 <= numPages; ++k2) {
            pages.put(reader.getPageOrigRef(k2).getNumber(), k2);
        }
        HashMap<String, PdfObject> names = fromNames ? reader.getNamedDestinationFromNames() : reader.getNamedDestinationFromStrings();
        HashMap<String, String> n2 = new HashMap<String, String>(names.size());
        for (Map.Entry<String, PdfObject> entry : names.entrySet()) {
            PdfArray arr = (PdfArray)entry.getValue();
            StringBuffer s2 = new StringBuffer();
            try {
                s2.append(pages.get(arr.getAsIndirectObject(0).getNumber()));
                s2.append(' ').append(arr.getPdfObject(1).toString().substring(1));
                for (int k3 = 2; k3 < arr.size(); ++k3) {
                    s2.append(' ').append(arr.getPdfObject(k3).toString());
                }
                n2.put(entry.getKey(), s2.toString());
            }
            catch (Exception e2) {}
        }
        return n2;
    }

    public static void exportToXML(HashMap<String, String> names, OutputStream out, String encoding, boolean onlyASCII) throws IOException {
        String jenc = IanaEncodings.getJavaEncoding(encoding);
        BufferedWriter wrt = new BufferedWriter(new OutputStreamWriter(out, jenc));
        SimpleNamedDestination.exportToXML(names, wrt, encoding, onlyASCII);
    }

    public static void exportToXML(HashMap<String, String> names, Writer wrt, String encoding, boolean onlyASCII) throws IOException {
        wrt.write("<?xml version=\"1.0\" encoding=\"");
        wrt.write(XMLUtil.escapeXML(encoding, onlyASCII));
        wrt.write("\"?>\n<Destination>\n");
        for (Map.Entry<String, String> entry : names.entrySet()) {
            String key2 = entry.getKey();
            String value = entry.getValue();
            wrt.write("  <Name Page=\"");
            wrt.write(XMLUtil.escapeXML(value, onlyASCII));
            wrt.write("\">");
            wrt.write(XMLUtil.escapeXML(SimpleNamedDestination.escapeBinaryString(key2), onlyASCII));
            wrt.write("</Name>\n");
        }
        wrt.write("</Destination>\n");
        wrt.flush();
    }

    public static HashMap<String, String> importFromXML(InputStream in) throws IOException {
        SimpleNamedDestination names = new SimpleNamedDestination();
        SimpleXMLParser.parse((SimpleXMLDocHandler)names, in);
        return names.xmlNames;
    }

    public static HashMap<String, String> importFromXML(Reader in) throws IOException {
        SimpleNamedDestination names = new SimpleNamedDestination();
        SimpleXMLParser.parse((SimpleXMLDocHandler)names, in);
        return names.xmlNames;
    }

    static PdfArray createDestinationArray(String value, PdfWriter writer) {
        PdfArray ar = new PdfArray();
        StringTokenizer tk = new StringTokenizer(value);
        int n2 = Integer.parseInt(tk.nextToken());
        ar.add(writer.getPageReference(n2));
        if (!tk.hasMoreTokens()) {
            ar.add(PdfName.XYZ);
            ar.add(new float[]{0.0f, 10000.0f, 0.0f});
        } else {
            String fn = tk.nextToken();
            if (fn.startsWith("/")) {
                fn = fn.substring(1);
            }
            ar.add(new PdfName(fn));
            for (int k2 = 0; k2 < 4 && tk.hasMoreTokens(); ++k2) {
                fn = tk.nextToken();
                if (fn.equals("null")) {
                    ar.add(PdfNull.PDFNULL);
                    continue;
                }
                ar.add(new PdfNumber(fn));
            }
        }
        return ar;
    }

    public static PdfDictionary outputNamedDestinationAsNames(HashMap<String, String> names, PdfWriter writer) {
        PdfDictionary dic = new PdfDictionary();
        for (Map.Entry<String, String> entry : names.entrySet()) {
            try {
                String key2 = entry.getKey();
                String value = entry.getValue();
                PdfArray ar = SimpleNamedDestination.createDestinationArray(value, writer);
                PdfName kn = new PdfName(key2);
                dic.put(kn, ar);
            }
            catch (Exception e2) {}
        }
        return dic;
    }

    public static PdfDictionary outputNamedDestinationAsStrings(HashMap<String, String> names, PdfWriter writer) throws IOException {
        HashMap<String, PdfIndirectReference> n2 = new HashMap<String, PdfIndirectReference>(names.size());
        for (Map.Entry<String, String> entry : names.entrySet()) {
            try {
                String value = entry.getValue();
                PdfArray ar = SimpleNamedDestination.createDestinationArray(value, writer);
                n2.put(entry.getKey(), writer.addToBody(ar).getIndirectReference());
            }
            catch (Exception e2) {}
        }
        return PdfNameTree.writeTree(n2, writer);
    }

    public static String escapeBinaryString(String s2) {
        StringBuffer buf = new StringBuffer();
        for (char c2 : s2.toCharArray()) {
            if (c2 < ' ') {
                buf.append('\\');
                String octal = "00" + Integer.toOctalString(c2);
                buf.append(octal.substring(octal.length() - 3));
                continue;
            }
            if (c2 == '\\') {
                buf.append("\\\\");
                continue;
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    public static String unEscapeBinaryString(String s2) {
        StringBuffer buf = new StringBuffer();
        char[] cc = s2.toCharArray();
        int len = cc.length;
        for (int k2 = 0; k2 < len; ++k2) {
            char c2 = cc[k2];
            if (c2 == '\\') {
                if (++k2 >= len) {
                    buf.append('\\');
                    break;
                }
                c2 = cc[k2];
                if (c2 >= '0' && c2 <= '7') {
                    int n2 = c2 - 48;
                    ++k2;
                    for (int j2 = 0; j2 < 2 && k2 < len && (c2 = cc[k2]) >= '0' && c2 <= '7'; ++k2, ++j2) {
                        n2 = n2 * 8 + c2 - 48;
                    }
                    --k2;
                    buf.append((char)n2);
                    continue;
                }
                buf.append(c2);
                continue;
            }
            buf.append(c2);
        }
        return buf.toString();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void endElement(String tag) {
        if (tag.equals("Destination")) {
            if (this.xmlLast == null && this.xmlNames != null) {
                return;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("destination.end.tag.out.of.place", new Object[0]));
        }
        if (!tag.equals("Name")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("invalid.end.tag.1", tag));
        }
        if (this.xmlLast == null || this.xmlNames == null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("name.end.tag.out.of.place", new Object[0]));
        }
        if (!this.xmlLast.containsKey("Page")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("page.attribute.missing", new Object[0]));
        }
        this.xmlNames.put(SimpleNamedDestination.unEscapeBinaryString(this.xmlLast.get("Name")), this.xmlLast.get("Page"));
        this.xmlLast = null;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String tag, Map<String, String> h2) {
        if (this.xmlNames == null) {
            if (tag.equals("Destination")) {
                this.xmlNames = new HashMap();
                return;
            }
            throw new RuntimeException(MessageLocalization.getComposedMessage("root.element.is.not.destination", new Object[0]));
        }
        if (!tag.equals("Name")) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("tag.1.not.allowed", tag));
        }
        if (this.xmlLast != null) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("nested.tags.are.not.allowed", new Object[0]));
        }
        this.xmlLast = new HashMap<String, String>(h2);
        this.xmlLast.put("Name", "");
    }

    @Override
    public void text(String str) {
        if (this.xmlLast == null) {
            return;
        }
        String name = this.xmlLast.get("Name");
        name = name + str;
        this.xmlLast.put("Name", name);
    }
}

