/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.LEDataOutputStream;

public abstract class FileFormat {
    static final String FORMAT_PACKAGE = "org.eclipse.swt.internal.image";
    static final String FORMAT_SUFFIX = "FileFormat";
    static final String[] FORMATS = new String[]{"WinBMP", "WinBMP", "GIF", "WinICO", "JPEG", "PNG", "TIFF", "OS2BMP"};
    LEDataInputStream inputStream;
    LEDataOutputStream outputStream;
    ImageLoader loader;
    int compression;

    static FileFormat getFileFormat(LEDataInputStream stream, String format) throws Exception {
        Class<?> clazz = Class.forName("org.eclipse.swt.internal.image." + format + FORMAT_SUFFIX);
        FileFormat fileFormat = (FileFormat)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (fileFormat.isFileFormat(stream)) {
            return fileFormat;
        }
        return null;
    }

    abstract boolean isFileFormat(LEDataInputStream var1);

    abstract ImageData[] loadFromByteStream();

    public ImageData[] loadFromStream(LEDataInputStream stream) {
        try {
            this.inputStream = stream;
            return this.loadFromByteStream();
        }
        catch (Exception e2) {
            if (e2 instanceof IOException) {
                SWT.error(39, e2);
            } else {
                SWT.error(40, e2);
            }
            return null;
        }
    }

    public static ImageData[] load(InputStream is, ImageLoader loader2) {
        FileFormat fileFormat = null;
        LEDataInputStream stream = new LEDataInputStream(is);
        int i2 = 1;
        while (i2 < FORMATS.length) {
            if (FORMATS[i2] != null) {
                try {
                    fileFormat = FileFormat.getFileFormat(stream, FORMATS[i2]);
                    if (fileFormat != null) {
                        break;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FileFormat.FORMATS[i2] = null;
                }
                catch (Exception exception) {}
            }
            ++i2;
        }
        if (fileFormat == null) {
            SWT.error(42);
        }
        fileFormat.loader = loader2;
        return fileFormat.loadFromStream(stream);
    }

    public static void save(OutputStream os, int format, ImageLoader loader2) {
        if (format < 0 || format >= FORMATS.length) {
            SWT.error(42);
        }
        if (FORMATS[format] == null) {
            SWT.error(42);
        }
        if (loader2.data == null || loader2.data.length < 1) {
            SWT.error(5);
        }
        LEDataOutputStream stream = new LEDataOutputStream(os);
        FileFormat fileFormat = null;
        try {
            Class<?> clazz = Class.forName("org.eclipse.swt.internal.image." + FORMATS[format] + FORMAT_SUFFIX);
            fileFormat = (FileFormat)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            SWT.error(42);
        }
        if (format == 1) {
            switch (loader2.data[0].depth) {
                case 8: {
                    fileFormat.compression = 1;
                    break;
                }
                case 4: {
                    fileFormat.compression = 2;
                }
            }
        }
        fileFormat.unloadIntoStream(loader2, stream);
    }

    abstract void unloadIntoByteStream(ImageLoader var1);

    public void unloadIntoStream(ImageLoader loader2, LEDataOutputStream stream) {
        try {
            this.outputStream = stream;
            this.unloadIntoByteStream(loader2);
            this.outputStream.flush();
        }
        catch (Exception e2) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {}
            SWT.error(39, e2);
        }
    }
}

