/*
 * Decompiled with CFR 0.152.
 */
package gde.device.spektrum;

import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.data.Channel;
import gde.data.Channels;
import gde.data.Record;
import gde.data.RecordSet;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.device.MeasurementType;
import gde.device.resource.DeviceXmlResource;
import gde.device.spektrum.TlmReader;
import gde.exception.DataInconsitsentException;
import gde.io.FileHandler;
import gde.log.Level;
import gde.messages.Messages;
import gde.ui.DataExplorer;
import gde.utils.FileUtils;
import gde.utils.GPSHelper;
import gde.utils.ObjectKeyCompliance;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.bind.JAXBException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class SpektrumAdapter
extends DeviceConfiguration
implements IDevice {
    static final Logger log = Logger.getLogger(SpektrumAdapter.class.getName());
    static final Analyzer analyser = Analyzer.getInstance();
    static final DataExplorer application = DataExplorer.getInstance();
    final Settings settings = Settings.getInstance();
    static final Channels channels = Channels.getInstance();

    public SpektrumAdapter(String deviceProperties) throws FileNotFoundException, JAXBException {
        super(deviceProperties);
        if (application.getMenuToolBar() != null) {
            String toolTipText = SpektrumAdapter.getImportToolTip();
            this.configureSerialPortMenu(2, toolTipText, toolTipText);
            this.updateFileExportMenu(application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(application.getMenuBar().getImportMenu());
        }
    }

    public SpektrumAdapter(DeviceConfiguration deviceConfig) {
        super(deviceConfig);
        if (application.getMenuToolBar() != null) {
            String toolTipText = SpektrumAdapter.getImportToolTip();
            this.configureSerialPortMenu(2, toolTipText, toolTipText);
            this.updateFileExportMenu(application.getMenuBar().getExportMenu());
            this.updateFileImportMenu(application.getMenuBar().getImportMenu());
        }
    }

    public static String getImportToolTip() {
        DeviceConfiguration hoTTConfiguration = Analyzer.getInstance().getDeviceConfigurations().get("HoTTAdapter");
        String fileExtentions = hoTTConfiguration != null ? hoTTConfiguration.getDataBlockPreferredFileExtention() : "?";
        return Messages.getString((String)"GDE_MSGT0964", (Object[])new Object[]{fileExtentions});
    }

    public String exportFile(String fileEndingType, boolean isExport2TmpDir) {
        RecordSet activeRecordSet;
        String exportFileName = "";
        Channel activeChannel = channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null && fileEndingType.contains("kmz")) {
            int latOrdinal = 21;
            int lonOrdinal = 22;
            int altOrdinal = 20;
            int climbOrdinal = 13;
            int tripOrdinal = 28;
            int additionalMeasurementOrdinal = this.getGPS2KMZMeasurementOrdinal();
            exportFileName = new FileHandler().exportFileKMZ(22, 21, 20, additionalMeasurementOrdinal, 13, 28, -1, true, isExport2TmpDir);
        }
        return exportFileName;
    }

    public void export2KMZ3D(int type) {
        new FileHandler().exportFileKMZ(Messages.getString((String)"GDE_MSGT0963"), 21, 22, 20, 23, 13, -1, -1, type == 0, type == 2);
    }

    public void updateFileExportMenu(Menu exportMenue) {
        if (exportMenue.getItem(exportMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0732"))) {
            new MenuItem(exportMenue, 2);
            MenuItem convertKMZ3DRelativeItem = new MenuItem(exportMenue, 8);
            convertKMZ3DRelativeItem.setText(Messages.getString((String)"GDE_MSGT0965"));
            convertKMZ3DRelativeItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZ3DRelativeItem action performed! " + String.valueOf(e));
                    SpektrumAdapter.this.export2KMZ3D(0);
                }
            });
            MenuItem convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT0966"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZDAbsoluteItem action performed! " + String.valueOf(e));
                    SpektrumAdapter.this.export2KMZ3D(1);
                }
            });
            convertKMZDAbsoluteItem = new MenuItem(exportMenue, 8);
            convertKMZDAbsoluteItem.setText(Messages.getString((String)"GDE_MSGT0967"));
            convertKMZDAbsoluteItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "convertKMZDAbsoluteItem action performed! " + String.valueOf(e));
                    SpektrumAdapter.this.export2KMZ3D(2);
                }
            });
        }
    }

    public void updateFileImportMenu(Menu importMenue) {
        if (importMenue.getItem(importMenue.getItemCount() - 1).getText().equals(Messages.getString((String)"GDE_MSGT0018"))) {
            new MenuItem(importMenue, 2);
            MenuItem importDeviceLogItem = new MenuItem(importMenue, 8);
            Object[] messageParams = new String[GDE.MOD1.length + 1];
            System.arraycopy(GDE.MOD1, 0, messageParams, 1, GDE.MOD1.length);
            messageParams[0] = this.getDeviceConfiguration().getDataBlockPreferredFileExtention();
            importDeviceLogItem.setText(Messages.getString((String)"GDE_MSGT0962", (Object[])messageParams));
            importDeviceLogItem.setAccelerator(SWT.MOD1 + Messages.getAcceleratorChar((String)"GDE_MSGT0962"));
            importDeviceLogItem.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    log.log(java.util.logging.Level.FINEST, "importDeviceLogItem action performed! " + String.valueOf(e));
                    SpektrumAdapter.this.importDeviceData();
                }
            });
        }
    }

    protected void importDeviceData() {
        final FileDialog fd = FileUtils.getImportDirectoryFileDialog((IDevice)this, (String)Messages.getString((String)"GDE_MSGT0961"), (String)"LogData");
        Thread reader = new Thread("reader"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    application.setPortConnected(true);
                    for (String tmpFileName : fd.getFileNames()) {
                        String selectedImportFile = fd.getFilterPath() + "/" + tmpFileName;
                        if (!selectedImportFile.toLowerCase().endsWith(".tlm") && !selectedImportFile.toLowerCase().endsWith(".log")) {
                            log.log(Level.WARNING, String.format("skip selectedImportFile %s since it has not a supported file ending", selectedImportFile));
                        }
                        log.log(java.util.logging.Level.FINE, "selectedImportFile = " + selectedImportFile);
                        if (fd.getFileName().length() <= 4) continue;
                        String directoryName = ObjectKeyCompliance.getUpcomingObjectKey((Path)Paths.get(selectedImportFile, new String[0]));
                        if (!directoryName.isEmpty()) {
                            ObjectKeyCompliance.createObjectKey((String)directoryName);
                        }
                        try {
                            if (!selectedImportFile.toLowerCase().endsWith(".tlm")) continue;
                            TlmReader.read(selectedImportFile);
                        }
                        catch (Exception e) {
                            log.log(java.util.logging.Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                finally {
                    application.setPortConnected(false);
                }
            }
        };
        reader.start();
    }

    public HashMap<String, String> getLovKeyMappings(HashMap<String, String> lov2osdMap) {
        return null;
    }

    public String getConvertedRecordConfigurations(HashMap<String, String> header, HashMap<String, String> lov2osdMap, int channelNumber) {
        return null;
    }

    public int getLovDataByteSize() {
        return 0;
    }

    public int[] convertDataBytes(int[] points, byte[] dataBuffer) {
        return points;
    }

    public void addDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
        int dataBufferSize = 4 * recordSet.getNoneCalculationRecordNames().length;
        int[] points = new int[recordSet.getNoneCalculationRecordNames().length];
        String sThreadId = String.format("%06d", Thread.currentThread().getId());
        int progressCycle = 1;
        if (doUpdateProgressBar) {
            application.setProgress(progressCycle, sThreadId);
        }
        int timeStampBufferSize = 4 * recordDataSize;
        int index = 0;
        for (int i = 0; i < recordDataSize; ++i) {
            index = i * dataBufferSize + timeStampBufferSize;
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, i + " i*dataBufferSize+timeStampBufferSize = " + index);
            }
            for (int j = 0; j < points.length; ++j) {
                points[j] = ((dataBuffer[0 + j * 4 + index] & 0xFF) << 24) + ((dataBuffer[1 + j * 4 + index] & 0xFF) << 16) + ((dataBuffer[2 + j * 4 + index] & 0xFF) << 8) + ((dataBuffer[3 + j * 4 + index] & 0xFF) << 0);
            }
            recordSet.addNoneCalculationRecordsPoints(points, (double)(((dataBuffer[0 + i * 4] & 0xFF) << 24) + ((dataBuffer[1 + i * 4] & 0xFF) << 16) + ((dataBuffer[2 + i * 4] & 0xFF) << 8) + ((dataBuffer[3 + i * 4] & 0xFF) << 0)) / 10.0);
            if (!doUpdateProgressBar || i % 50 != 0) continue;
            application.setProgress(++progressCycle * 5000 / recordDataSize, sThreadId);
        }
        if (doUpdateProgressBar) {
            application.setProgress(100, sThreadId);
        }
        recordSet.syncScaleOfSyncableRecords();
    }

    public void addConvertedLovDataBufferAsRawDataPoints(RecordSet recordSet, byte[] dataBuffer, int recordDataSize, boolean doUpdateProgressBar) throws DataInconsitsentException {
    }

    public String[] prepareDataTableRow(RecordSet recordSet, String[] dataTableRow, int rowIndex) {
        try {
            int index = 0;
            for (Record record : recordSet.getVisibleAndDisplayableRecordsForTable()) {
                int ordinal = record.getOrdinal();
                dataTableRow[index + 1] = ordinal >= 3 && ordinal <= 10 ? String.format("%.0f", (double)record.realGet(rowIndex).intValue() / 1000.0) : record.getFormattedTableValue(rowIndex);
                ++index;
            }
        }
        catch (RuntimeException e) {
            log.log(java.util.logging.Level.SEVERE, e.getMessage(), e);
        }
        return dataTableRow;
    }

    public boolean isGPSCoordinates(Record record) {
        int latOrdinal = 21;
        int lonOrdinal = 22;
        return record.getOrdinal() == 21 || record.getOrdinal() == 22;
    }

    public boolean isActualRecordSetWithGpsData() {
        RecordSet activeRecordSet;
        boolean containsGPSdata = false;
        Channel activeChannel = channels.getActiveChannel();
        if (activeChannel != null && (activeRecordSet = activeChannel.getActiveRecordSet()) != null) {
            int latOrdinal = 21;
            int lonOrdinal = 22;
            containsGPSdata = activeRecordSet.get(21).hasReasonableData() && activeRecordSet.get(22).hasReasonableData();
        }
        return containsGPSdata;
    }

    public Integer getGPS2KMZMeasurementOrdinal() {
        if (this.kmzMeasurementOrdinal == null) {
            return 23;
        }
        return this.kmzMeasurementOrdinal;
    }

    public double translateValue(Record record, double value) {
        double factor = record.getFactor();
        double newValue = 0.0;
        int latOrdinal = 21;
        int lonOrdinal = 22;
        if (record.getOrdinal() == 21 || record.getOrdinal() == 22) {
            int grad = (int)(value / 1000.0);
            double minuten = (value - (double)grad * 1000.0) / 10.0;
            newValue = (double)grad + minuten / 60.0;
        } else {
            newValue = value * factor;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    public double reverseTranslateValue(Record record, double value) {
        double factor = record.getFactor();
        double newValue = 0.0;
        int latOrdinal = 21;
        int lonOrdinal = 22;
        if (record.getOrdinal() == 21 || record.getOrdinal() == 22) {
            int grad = (int)value;
            double minuten = (value - (double)grad * 1.0) * 60.0;
            newValue = ((double)grad + minuten / 100.0) * 1000.0;
        } else {
            newValue = value / factor;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "for " + record.getName() + " in value = " + value + " out value = " + newValue);
        }
        return newValue;
    }

    public void calculateInactiveRecords(RecordSet recordSet) {
        int latOrdinal = 15;
        int lonOrdinal = 16;
        int altOrdinal = 10;
        int tripOrdinal = 20;
        Record recordLatitude = recordSet.get(15);
        Record recordLongitude = recordSet.get(16);
        Record recordAlitude = recordSet.get(10);
        if (recordLatitude.hasReasonableData() && recordLongitude.hasReasonableData() && recordAlitude.hasReasonableData()) {
            int recordSize = recordLatitude.realSize();
            int startAltitude = recordAlitude.get(8);
            int indexGPS = 0;
            for (int i = 0; i < recordSize; ++i) {
                if (recordLatitude.get(i) == 0 || recordLongitude.get(i) == 0) continue;
                indexGPS = i++;
                break;
            }
            startAltitude = recordAlitude.get(indexGPS);
            GPSHelper.calculateTripLength((IDevice)this, (RecordSet)recordSet, (int)15, (int)16, (int)10, (int)startAltitude, (int)20);
        }
    }

    public void makeInActiveDisplayable(RecordSet recordSet) {
        if (recordSet != null) {
            int latOrdinal = 21;
            int lonOrdinal = 22;
            int altOrdinal = 20;
            int tripOrdinal = 28;
            GPSHelper.calculateTripLength((IDevice)this, (RecordSet)recordSet, (int)21, (int)22, (int)20, (int)0, (int)28);
            recordSet.syncScaleOfSyncableRecords();
            this.updateVisibilityStatus(recordSet, true);
            application.updateStatisticsData();
        }
    }

    public void updateVisibilityStatus(RecordSet recordSet, boolean includeReasonableDataCheck) {
        int channelConfigNumber = recordSet.getChannelConfigNumber();
        int displayableCounter = 0;
        boolean configChanged = this.isChangePropery();
        for (int i = 0; i < recordSet.size(); ++i) {
            Record record = recordSet.get(i);
            if (log.isLoggable(java.util.logging.Level.FINE)) {
                log.log(java.util.logging.Level.FINE, record.getName() + " = " + DeviceXmlResource.getInstance().getReplacement(this.getMeasurementNames(channelConfigNumber)[i]));
            }
            MeasurementType measurement = this.getMeasurement(channelConfigNumber, i);
            if (record.isActive() && record.isActive() != measurement.isActive()) {
                record.setActive(Boolean.valueOf(measurement.isActive()));
                record.setVisible(measurement.isActive());
                record.setDisplayable(measurement.isActive());
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, "switch " + record.getName() + " to " + measurement.isActive());
                }
            }
            if (includeReasonableDataCheck && record.getOrdinal() != 9 && record.getOrdinal() != 10) {
                record.setDisplayable(measurement.isActive() && record.hasReasonableData());
                if (log.isLoggable(java.util.logging.Level.FINE)) {
                    log.log(java.util.logging.Level.FINE, record.getName() + " hasReasonableData " + record.hasReasonableData());
                }
            }
            if (!record.isActive() || !record.isDisplayable()) continue;
            ++displayableCounter;
            if (!log.isLoggable(java.util.logging.Level.FINE)) continue;
            log.log(java.util.logging.Level.FINE, "add to displayable counter: " + record.getName());
        }
        if (log.isLoggable(java.util.logging.Level.FINE)) {
            log.log(java.util.logging.Level.FINE, "displayableCounter = " + displayableCounter);
        }
        recordSet.setConfiguredDisplayable(displayableCounter);
        this.setChangePropery(configChanged);
    }

    public String[] getUsedPropertyKeys() {
        return new String[]{FACTOR};
    }

    public void open_closeCommPort() {
        this.importDeviceData();
    }
}

