/*
 * Decompiled with CFR 0.152.
 */
package gde.config;

import gde.Analyzer;
import gde.GDE;
import gde.config.Settings;
import gde.device.DeviceConfiguration;
import gde.device.IDevice;
import gde.log.Level;
import gde.messages.Messages;
import gde.utils.StringHelper;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXParseException;

public final class DeviceConfigurations {
    private static final String $CLASS_NAME = DeviceConfigurations.class.getName();
    private static final Logger log = Logger.getLogger($CLASS_NAME);
    private final TreeMap<String, DeviceConfiguration> deviceConfigs = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private DeviceConfiguration selectedActiveDeviceConfig = null;

    public Set<String> deviceNames() {
        return this.deviceConfigs.keySet();
    }

    public int size() {
        return this.deviceConfigs.size();
    }

    public String get(int index) {
        return this.deviceConfigs.keySet().toArray(new String[0])[index];
    }

    public int indexOf(String deviceKey) {
        int index = -1;
        for (String key : this.deviceConfigs.keySet()) {
            ++index;
            if (!key.equals(deviceKey)) continue;
            return index;
        }
        return -1;
    }

    public synchronized void initialize(Analyzer analyzer) {
        String activeDeviceName = analyzer.getSettings().getActiveDevice();
        Objects.requireNonNull(activeDeviceName);
        this.deviceConfigs.clear();
        for (String fileName : analyzer.getDataAccess().getDeviceFolderList()) {
            this.add(analyzer, activeDeviceName, fileName, !analyzer.getSettings().isDevicePropertiesUpdated);
        }
        this.synchronizeDeviceUse();
        log.log(Level.TIME, "device init time = " + StringHelper.getFormatedTime("ss:SSS", new Date().getTime() - GDE.StartTime));
    }

    public void synchronizeDeviceUse() {
        String deviceUseCsv = Settings.getInstance().getDeviceUseCsv();
        if (!deviceUseCsv.isEmpty()) {
            for (String deviceName : deviceUseCsv.split(",")) {
                if (deviceName.isEmpty() || this.deviceConfigs.containsKey(deviceName.substring(0, deviceName.lastIndexOf(42)))) continue;
                log.log(Level.INFO, String.format("remove %s from device_use list", deviceName));
                Settings.getInstance().removeDeviceUse(deviceName.substring(0, deviceName.lastIndexOf(42)));
            }
        } else {
            for (String deviceKey : this.deviceConfigs.keySet()) {
                if (!this.deviceConfigs.get(deviceKey).isUsed()) continue;
                Settings.getInstance().addDeviceUse(this.deviceConfigs.get(deviceKey).getName(), 1);
            }
        }
    }

    public void add(Analyzer analyzer, String activeDeviceName, String fileName, boolean checkUsedFlag) {
        try {
            if (fileName.endsWith(".xml")) {
                String deviceKey = fileName.substring(0, fileName.length() - 4);
                DeviceConfiguration devConfig = new DeviceConfiguration(Paths.get("Devices", fileName), analyzer);
                if (checkUsedFlag && devConfig.isUsed() || !checkUsedFlag) {
                    String keyString;
                    if (devConfig.getName().equals(activeDeviceName) && devConfig.isUsed()) {
                        this.selectedActiveDeviceConfig = devConfig;
                    }
                    if (devConfig.getName() != null) {
                        keyString = devConfig.getName();
                    } else {
                        devConfig.setName(deviceKey);
                        keyString = deviceKey;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, deviceKey + " - " + keyString);
                    }
                    this.deviceConfigs.put(keyString, devConfig);
                }
            }
        }
        catch (JAXBException e) {
            log.log(Level.WARNING, fileName, e);
            if (e.getLinkedException() instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)e.getLinkedException();
                GDE.setInitError(Messages.getString("GDE_MSGW0038", new String[]{fileName, spe.getLocalizedMessage()}));
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public TreeMap<String, DeviceConfiguration> getAllConfigurations() {
        return this.deviceConfigs;
    }

    public boolean contains(String deviceName) {
        return this.deviceConfigs.containsKey(deviceName);
    }

    public DeviceConfiguration get(String deviceName) {
        return this.deviceConfigs.get(deviceName);
    }

    public DeviceConfiguration put(String deviceName, DeviceConfiguration tmpDeviceConfiguration) {
        return this.deviceConfigs.put(deviceName, tmpDeviceConfiguration);
    }

    public DeviceConfiguration remove(String deviceName) {
        return this.deviceConfigs.remove(deviceName);
    }

    public DeviceConfiguration getSelectedActiveDeviceConfig() {
        return this.selectedActiveDeviceConfig;
    }

    public Set<String> getValidLogExtentions() {
        Set<String> logExtensions = this.getImportExtentions();
        logExtensions.add(".osd");
        return logExtensions;
    }

    public Set<String> getImportExtentions() {
        Set<String> extentions = this.deviceConfigs.values().parallelStream().map(c -> Arrays.asList(c.getDataBlockPreferredFileExtention().split(",|;"))).flatMap(Collection::stream).map(s -> s.substring(s.lastIndexOf(46))).map(e -> e.toLowerCase()).collect(Collectors.toSet());
        return extentions;
    }

    public HashMap<String, IDevice> getAsDevices(Collection<String> deviceNames) {
        HashMap<String, IDevice> existingDevices = new HashMap<String, IDevice>();
        for (String deviceName : deviceNames) {
            existingDevices.put(deviceName, this.deviceConfigs.get(deviceName).getAsDevice());
        }
        log.log(Level.FINE, "Selected      size=", existingDevices.size());
        return existingDevices;
    }

    public DeviceConfiguration getConfiguration(String deviceName) {
        return this.deviceConfigs.get(deviceName);
    }

    public String toString() {
        return this.deviceConfigs.keySet().toString();
    }
}

