/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSResponder;
import org.eclipse.swt.internal.cocoa.NSSavePanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    NSSavePanel panel;
    NSPopUpButton popup;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    int filterIndex = -1;
    boolean overwrite = false;
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        if (Display.getSheetEnabled() && shell != null && (n & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        NSObject nSObject;
        NSObject nSObject2;
        NSResponder nSResponder;
        int n;
        Object object;
        String string = null;
        this.fileNames = new String[0];
        int n2 = 0;
        int n3 = 0;
        Callback callback = null;
        if ((this.style & 0x2000) != 0) {
            object = NSSavePanel.savePanel();
            this.panel = object;
            if (!this.overwrite) {
                callback = new Callback(this, "_overwriteExistingFileCheck", 3);
                n = callback.getAddress();
                if (n == 0) {
                    this.error(3);
                }
                if ((n2 = OS.class_getInstanceMethod(OS.class_NSSavePanel, OS.sel_overwriteExistingFileCheck)) != 0) {
                    n3 = OS.method_setImplementation(n2, n);
                }
            }
        } else {
            object = NSOpenPanel.openPanel();
            ((NSOpenPanel)object).setAllowsMultipleSelection((this.style & 2) != 0);
            this.panel = object;
        }
        object = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        this.panel.setCanCreateDirectories(true);
        OS.objc_msgSend(this.panel.id, OS.sel_setShowsHiddenFiles_, true);
        n = 0;
        SWTPanelDelegate sWTPanelDelegate = null;
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            sWTPanelDelegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
            n = OS.NewGlobalRef(this);
            if (n == 0) {
                this.error(2);
            }
            OS.object_setInstanceVariable(sWTPanelDelegate.id, Display.SWT_OBJECT, n);
            this.panel.setDelegate(sWTPanelDelegate);
            nSResponder = (NSPopUpButton)new NSPopUpButton().alloc();
            ((NSPopUpButton)nSResponder).initWithFrame(new NSRect(), false);
            ((NSControl)nSResponder).setTarget(sWTPanelDelegate);
            ((NSControl)nSResponder).setAction(OS.sel_sendSelection_);
            nSObject2 = ((NSPopUpButton)nSResponder).menu();
            ((NSMenu)nSObject2).setAutoenablesItems(false);
            for (int i = 0; i < this.filterExtensions.length; ++i) {
                String string2 = this.filterExtensions[i];
                if (this.filterNames != null && this.filterNames.length > i) {
                    string2 = this.filterNames[i];
                }
                nSObject = (NSMenuItem)new NSMenuItem().alloc();
                ((NSMenuItem)nSObject).initWithTitle(NSString.stringWith(string2), 0, NSString.string());
                ((NSMenu)nSObject2).addItem((NSMenuItem)nSObject);
                nSObject.release();
            }
            ((NSPopUpButton)nSResponder).selectItemAtIndex(0 <= this.filterIndex && this.filterIndex < this.filterExtensions.length ? this.filterIndex : 0);
            ((NSControl)nSResponder).sizeToFit();
            this.panel.setAccessoryView((NSView)nSResponder);
            this.popup = nSResponder;
            this.setAllowedFileType(this.filterExtensions[0]);
            this.panel.setAllowsOtherFileTypes(true);
        }
        this.panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        nSResponder = NSApplication.sharedApplication();
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            ((NSApplication)nSResponder).beginSheet(this.panel, this.parent.view.window(), null, 0, 0);
        }
        ((Display)object).setModalDialog(this, this.panel);
        nSObject2 = this.filterPath != null && this.filterPath.length() > 0 ? NSString.stringWith(this.filterPath) : null;
        NSString nSString = this.fileName != null && this.fileName.length() > 0 ? NSString.stringWith(this.fileName) : null;
        int n4 = this.panel.runModalForDirectory((NSString)nSObject2, nSString);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            ((NSApplication)nSResponder).endSheet(this.panel, 0);
        }
        ((Display)object).setModalDialog(null);
        if (!this.overwrite) {
            if (n2 != 0) {
                OS.method_setImplementation(n2, n3);
            }
            if (callback != null) {
                callback.dispose();
            }
        }
        this.filterIndex = this.popup != null ? this.popup.indexOfSelectedItem() : -1;
        if (n4 == 1) {
            nSObject = this.panel.filename();
            if ((this.style & 0x2000) != 0) {
                string = ((NSString)nSObject).getString();
                this.fileNames = new String[1];
                this.fileName = this.fileNames[0] = ((NSString)nSObject).lastPathComponent().getString();
                this.filterPath = ((NSString)nSObject).stringByDeletingLastPathComponent().getString();
            } else {
                string = ((NSString)nSObject).getString();
                NSArray nSArray = ((NSOpenPanel)this.panel).filenames();
                int n5 = nSArray.count();
                this.fileNames = new String[n5];
                for (int i = 0; i < n5; ++i) {
                    nSObject = new NSString(nSArray.objectAtIndex(i));
                    NSString nSString2 = ((NSString)nSObject).lastPathComponent();
                    NSString nSString3 = ((NSString)nSObject).stringByDeletingLastPathComponent();
                    if (i == 0) {
                        this.filterPath = nSString3.getString();
                        this.fileName = this.fileNames[0] = nSString2.getString();
                        continue;
                    }
                    this.fileNames[i] = nSString3.getString().equals(this.filterPath) ? nSString2.getString() : ((NSString)nSObject).getString();
                }
            }
        }
        if (this.popup != null) {
            this.panel.setAccessoryView(null);
            this.popup.release();
            this.popup = null;
        }
        if (sWTPanelDelegate != null) {
            this.panel.setDelegate(null);
            sWTPanelDelegate.release();
        }
        if (n != 0) {
            OS.DeleteGlobalRef(n);
        }
        this.panel = null;
        return string;
    }

    int _overwriteExistingFileCheck(int n, int n2, int n3) {
        return 1;
    }

    int panel_shouldShowFilename(int n, int n2, int n3, int n4) {
        NSString nSString = new NSString(n4);
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            NSFileManager nSFileManager = NSFileManager.defaultManager();
            int n5 = OS.malloc(1);
            boolean bl = nSFileManager.fileExistsAtPath(nSString, n5);
            byte[] byArray = new byte[1];
            OS.memmove(byArray, n5, 1);
            OS.free(n5);
            if (bl) {
                if (byArray[0] != 0) {
                    return 1;
                }
                String string = nSString.lastPathComponent().getString();
                int n6 = this.popup.indexOfSelectedItem();
                String string2 = this.filterExtensions[n6];
                int n7 = 0;
                int n8 = string2.length();
                while (n7 < n8) {
                    String string3;
                    int n9 = string2.indexOf(59, n7);
                    if (n9 == -1) {
                        n9 = n8;
                    }
                    if ((string3 = string2.substring(n7, n9).trim()).equalsIgnoreCase(string)) {
                        return 1;
                    }
                    if (string3.equals("*") || string3.equals("*.*")) {
                        return 1;
                    }
                    if (string3.startsWith("*.")) {
                        string3 = string3.substring(2);
                    }
                    if (string.toLowerCase().endsWith("." + string3.toLowerCase())) {
                        return 1;
                    }
                    n7 = n9 + 1;
                }
                return 0;
            }
        }
        return 1;
    }

    void sendSelection(int n, int n2, int n3) {
        this.panel.validateVisibleColumns();
        if (this.filterExtensions != null && this.filterExtensions.length > 0) {
            this.setAllowedFileType(this.filterExtensions[this.popup.indexOfSelectedItem()]);
        }
    }

    void setAllowedFileType(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("*") || string.equals("*.*")) {
            this.panel.setAllowedFileTypes(null);
            return;
        }
        if (string.startsWith("*.")) {
            string = string.substring(2);
        } else if (string.startsWith(".")) {
            string = string.substring(1);
        }
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(1);
        nSMutableArray.addObject(NSString.stringWith(string));
        this.panel.setAllowedFileTypes(nSMutableArray);
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }
}

