/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.logging;

import com.sun.javafx.logging.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;

public class PulseLogger {
    public static final boolean PULSE_LOGGING_ENABLED;
    private static final String[] DEFAULT_LOGGERS;
    private static final Logger[] loggers;

    public static void pulseStart() {
        for (Logger logger : loggers) {
            logger.pulseStart();
        }
    }

    public static void pulseEnd() {
        for (Logger logger : loggers) {
            logger.pulseEnd();
        }
    }

    public static void renderStart() {
        for (Logger logger : loggers) {
            logger.renderStart();
        }
    }

    public static void renderEnd() {
        for (Logger logger : loggers) {
            logger.renderEnd();
        }
    }

    public static void addMessage(String string2) {
        for (Logger logger : loggers) {
            logger.addMessage(string2);
        }
    }

    public static void incrementCounter(String string2) {
        for (Logger logger : loggers) {
            logger.incrementCounter(string2);
        }
    }

    public static void newPhase(String string2) {
        for (Logger logger : loggers) {
            logger.newPhase(string2);
        }
    }

    public static void newInput(String string2) {
        for (Logger logger : loggers) {
            logger.newInput(string2);
        }
    }

    public static boolean isPulseLoggingRequested() {
        return AccessController.doPrivileged(() -> Boolean.getBoolean("javafx.pulseLogger"));
    }

    private static Logger loadLogger(String string2) {
        try {
            Class<?> clazz = Class.forName(string2);
            if (clazz != null) {
                Method method = clazz.getDeclaredMethod("createInstance", new Class[0]);
                return (Logger)method.invoke(null, new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoClassDefFoundError | NoSuchMethodException | InvocationTargetException throwable) {
            // empty catch block
        }
        return null;
    }

    static {
        DEFAULT_LOGGERS = new String[]{"com.sun.javafx.logging.PrintLogger", "com.sun.javafx.logging.jfr.JFRPulseLogger"};
        ArrayList<Logger> arrayList = new ArrayList<Logger>();
        for (String string2 : DEFAULT_LOGGERS) {
            Logger logger = PulseLogger.loadLogger(string2);
            if (logger == null) continue;
            arrayList.add(logger);
        }
        loggers = arrayList.toArray(new Logger[arrayList.size()]);
        PULSE_LOGGING_ENABLED = loggers.length > 0;
    }
}

