# This script assumes that a "translations" file is present in the working 
# directory, with the translations of the English sentences in the 
# english_sentences list below, separated by newlines. Note that the 
# translations should not include the <big></big> in the first English
# sentence.

import os

def main():
    # Prompt user for language code
    lang_code = input("Please enter the language code (e.g., 'en', 'zh_CN'): ").strip()
    
    # Ask if the first letter should be in a larger font
    big_first_letter = input("Should the first letter of the document be in a larger font size? (y/n): ").strip().lower() == 'y'
    
    # Ask if the translation of 'n/a' should be in italics
    italic_na = input("Should the translation of 'n/a' be in italics? (y/n): ").strip().lower() == 'y'
    
    # Construct the file path for the hints file
    hints_file_path = f"../../txts/hints/{lang_code}/hints1_{lang_code}"
    
    # Check if the hints file exists
    if not os.path.isfile(hints_file_path):
        print(f"Error: The file {hints_file_path} does not exist.")
        return
    
    # Read the content of the hints file
    with open(hints_file_path, 'r', encoding='utf-8') as hints_file:
        hints_content = hints_file.read()
    
    # Read the translations from the "translations" file
    translations_file_path = "translations"
    if not os.path.isfile(translations_file_path):
        print(f"Error: The file {translations_file_path} does not exist.")
        return
    
    with open(translations_file_path, 'r', encoding='utf-8') as translations_file:
        translations_lines = translations_file.read().splitlines()
    
    # List of English sentences to be replaced
    english_sentences = [
        "<big>K</big>ickshaw accepts the following XML elements and attribute names, attribute values, and contents associated with these elements:",
        "Element",
        "Attribute Names",
        "Attribute Values",
        "Contents",
        "Menu IDs consisting of empty strings are valid, but like any other menu ID can only appear once in a menu.",
        "The following menus are equivalent and both accepted by Openbox and Kickshaw.",
        "A menu is always shown inside Kickshaw as it would appear in Openbox, so the latter of the two examples is closer to a WYSIWYG approach. The downside is that for large menus, this can make a menu file look somewhat confusing. For that reason, by default Kickshaw always saves the menu in the former format (this can be changed within the options). When saving a file, the program uses tabulators for indentations by default, but for reading the file, whether such indentations were done with spaces or tabulators is irrelevant, as is any whitespace.",
        "A menu can contain contradictory menu attributes, as in the following example:",
        "In this case, Kickshaw follows the example of Openbox and shows the icon attribute value from inside the root menu, while it shows the label and execute attribute values from outside the root menu.",
        "n/a"
    ]
    
    # Check if translations match the number of English sentences
    if len(translations_lines) != len(english_sentences):
        print("Error: The number of translations does not match the number of English sentences.")
        return
    
    # Perform the replacement
    for i, (eng_text, trans_text) in enumerate(zip(english_sentences, translations_lines)):
        if i == 0 and big_first_letter:  # For the first sentence
            if trans_text:
                trans_text = f"<big>{trans_text[0]}</big>{trans_text[1:]}"
        elif eng_text == "n/a":  # For 'n/a' replacements
            if italic_na:
                trans_text = f"<i>{trans_text}</i>"
        hints_content = hints_content.replace(eng_text, trans_text)
    
    # Output the modified content (or write back to file if needed)
    with open(hints_file_path, 'w', encoding='utf-8') as hints_file:
        hints_file.write(hints_content)
    
    print("The file has been updated with the translations.")

if __name__ == '__main__':
    main()
