# Replaces translations of the strings found below in the msgid list with 
# new translations that can be found in a file "translations" that is in the 
# current working directory.
# Also replaces the translation of "%i top-level items", the translation 
# for this has to be the last line of the "translations" file.

import os

def read_translations(translations_file_path):
    with open(translations_file_path, 'r', encoding='utf-8') as file:
        return file.read().splitlines()

def replace_translations(po_file_path, translations):
    # Read the po file content
    with open(po_file_path, 'r', encoding='utf-8') as file:
        lines = file.readlines()

    # Define msgid strings to replace
    msgids = [
        "One top-level item",
        "Two top-level items",
        "Three top-level items",
        "Four top-level items",
        "Five top-level items",
        "Six top-level items",
        "Seven top-level items",
        "Eight top-level items",
        "Nine top-level items"
    ]

    # Replace translations for the enumerated msgids
    for i, msgid in enumerate(msgids):
        msgid_line = f'msgid "{msgid}"'
        msgstr_prefix = 'msgstr '
        translation = translations[i] if i < len(translations) else ""
        
        for j, line in enumerate(lines):
            if line.strip() == msgid_line:
                if j+1 < len(lines) and lines[j+1].strip().startswith(msgstr_prefix):
                    lines[j+1] = f'{msgstr_prefix}"{translation}"\n'
                    break

    # Handle the special case
    special_msgid = 'msgid "%i top-level item"'
    special_msgid_plural = 'msgid_plural "%i top-level items"'
    special_translation = translations[-1] if translations else ""
    
    for i, line in enumerate(lines):
        if line.strip() == special_msgid and i+1 < len(lines) and lines[i+1].strip() == special_msgid_plural:
            if i+2 < len(lines) and lines[i+2].strip().startswith('msgstr[0]'):
                lines[i+2] = 'msgstr[0] "-"\n'
            if i+3 < len(lines) and lines[i+3].strip().startswith('msgstr[1]'):
                lines[i+3] = f'msgstr[1] "{special_translation}"\n'
            break

    # Write the modified content back to the po file
    with open(po_file_path, 'w', encoding='utf-8') as file:
        file.writelines(lines)

def main():
    # Ask for the language code
    lang_code = input("Enter the language code (e.g., 'en', 'zh_CN'): ").strip()

    # Define the path to the po file
    po_file_path = os.path.join('../../../po', f'{lang_code}.po')
    
    # Check if the po file exists
    if not os.path.isfile(po_file_path):
        print(f"File {po_file_path} does not exist.")
        return

    # Define the path to the translations file
    translations_file_path = 'translations'
    
    # Check if the translations file exists
    if not os.path.isfile(translations_file_path):
        print(f"File {translations_file_path} does not exist.")
        return
    
    # Read translations from the translations file
    translations = read_translations(translations_file_path)
    
    # Replace translations in the po file
    replace_translations(po_file_path, translations)
    print(f"Translations have been updated in {po_file_path}")

if __name__ == "__main__":
    main()
