<?php
/**
 * This defines autoloading handler for whole MediaWiki framework
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 * http://www.gnu.org/copyleft/gpl.html
 *
 * @file
 */

/**
 * Locations of core classes
 * Extension classes are specified with $wgAutoloadClasses
 * This array is a global instead of a static member of AutoLoader to work around a bug in APC
 */
global $wgAutoloadLocalClasses;

$wgAutoloadLocalClasses = array(
	# Includes
	'AjaxDispatcher' => 'includes/AjaxDispatcher.php',
	'AjaxResponse' => 'includes/AjaxResponse.php',
	'AtomFeed' => 'includes/Feed.php',
	'AuthPlugin' => 'includes/AuthPlugin.php',
	'AuthPluginUser' => 'includes/AuthPlugin.php',
	'Autopromote' => 'includes/Autopromote.php',
	'Block' => 'includes/Block.php',
	'BloomCache' => 'includes/cache/bloom/BloomCache.php',
	'BloomCacheRedis' => 'includes/cache/bloom/BloomCacheRedis.php',
	'BloomFilterTitleHasLogs' => 'includes/cache/bloom/BloomFilters.php',
	'CacheHelper' => 'includes/CacheHelper.php',
	'Category' => 'includes/Category.php',
	'CategoryFinder' => 'includes/CategoryFinder.php',
	'CategoryViewer' => 'includes/CategoryViewer.php',
	'ChangeTags' => 'includes/ChangeTags.php',
	'ChannelFeed' => 'includes/Feed.php',
	'Collation' => 'includes/Collation.php',
	'CollationCkb' => 'includes/Collation.php',
	'CollationEt' => 'includes/Collation.php',
	'ConcatenatedGzipHistoryBlob' => 'includes/HistoryBlob.php',
	'Cookie' => 'includes/Cookie.php',
	'CookieJar' => 'includes/Cookie.php',
	'CurlHttpRequest' => 'includes/HttpFunctions.php',
	'DeprecatedGlobal' => 'includes/DeprecatedGlobal.php',
	'DerivativeRequest' => 'includes/WebRequest.php',
	'DiffHistoryBlob' => 'includes/HistoryBlob.php',
	'DummyLinker' => 'includes/Linker.php',
	'Dump7ZipOutput' => 'includes/Export.php',
	'DumpBZip2Output' => 'includes/Export.php',
	'DumpFileOutput' => 'includes/Export.php',
	'DumpFilter' => 'includes/Export.php',
	'DumpGZipOutput' => 'includes/Export.php',
	'DumpLatestFilter' => 'includes/Export.php',
	'DumpMultiWriter' => 'includes/Export.php',
	'DumpNamespaceFilter' => 'includes/Export.php',
	'DumpNotalkFilter' => 'includes/Export.php',
	'DumpOutput' => 'includes/Export.php',
	'DumpPipeOutput' => 'includes/Export.php',
	'EditPage' => 'includes/EditPage.php',
	'EmptyBloomCache' => 'includes/cache/bloom/BloomCache.php',
	'Fallback' => 'includes/Fallback.php',
	'FauxRequest' => 'includes/WebRequest.php',
	'FauxResponse' => 'includes/WebResponse.php',
	'FeedItem' => 'includes/Feed.php',
	'FeedUtils' => 'includes/FeedUtils.php',
	'FileDeleteForm' => 'includes/FileDeleteForm.php',
	'ForkController' => 'includes/ForkController.php',
	'FormOptions' => 'includes/FormOptions.php',
	'GitInfo' => 'includes/GitInfo.php',
	'HistoryBlob' => 'includes/HistoryBlob.php',
	'HistoryBlobCurStub' => 'includes/HistoryBlob.php',
	'HistoryBlobStub' => 'includes/HistoryBlob.php',
	'Hooks' => 'includes/Hooks.php',
	'Html' => 'includes/Html.php',
	'HtmlFormatter' => 'includes/HtmlFormatter.php',
	'HTMLApiField' => 'includes/htmlform/HTMLApiField.php',
	'HTMLAutoCompleteSelectField' => 'includes/htmlform/HTMLAutoCompleteSelectField.php',
	'HTMLButtonField' => 'includes/htmlform/HTMLButtonField.php',
	'HTMLCheckField' => 'includes/htmlform/HTMLCheckField.php',
	'HTMLCheckMatrix' => 'includes/htmlform/HTMLCheckMatrix.php',
	'HTMLFormFieldCloner' => 'includes/htmlform/HTMLFormFieldCloner.php',
	'HTMLEditTools' => 'includes/htmlform/HTMLEditTools.php',
	'HTMLFloatField' => 'includes/htmlform/HTMLFloatField.php',
	'HTMLForm' => 'includes/htmlform/HTMLForm.php',
	'HTMLFormField' => 'includes/htmlform/HTMLFormField.php',
	'HTMLFormFieldRequiredOptionsException' =>
		'includes/htmlform/HTMLFormFieldRequiredOptionsException.php',
	'HTMLHiddenField' => 'includes/htmlform/HTMLHiddenField.php',
	'HTMLInfoField' => 'includes/htmlform/HTMLInfoField.php',
	'HTMLIntField' => 'includes/htmlform/HTMLIntField.php',
	'HTMLNestedFilterable' => 'includes/htmlform/HTMLNestedFilterable.php',
	'HTMLMultiSelectField' => 'includes/htmlform/HTMLMultiSelectField.php',
	'HTMLRadioField' => 'includes/htmlform/HTMLRadioField.php',
	'HTMLSelectAndOtherField' => 'includes/htmlform/HTMLSelectAndOtherField.php',
	'HTMLSelectField' => 'includes/htmlform/HTMLSelectField.php',
	'HTMLSelectLimitField' => 'includes/htmlform/HTMLSelectLimitField.php',
	'HTMLSelectOrOtherField' => 'includes/htmlform/HTMLSelectOrOtherField.php',
	'HTMLSubmitField' => 'includes/htmlform/HTMLSubmitField.php',
	'HTMLTextAreaField' => 'includes/htmlform/HTMLTextAreaField.php',
	'HTMLTextField' => 'includes/htmlform/HTMLTextField.php',
	'Http' => 'includes/HttpFunctions.php',
	'IcuCollation' => 'includes/Collation.php',
	'IdentityCollation' => 'includes/Collation.php',
	'ImportStreamSource' => 'includes/Import.php',
	'ImportStringSource' => 'includes/Import.php',
	'Interwiki' => 'includes/interwiki/Interwiki.php',
	'License' => 'includes/Licenses.php',
	'Licenses' => 'includes/Licenses.php',
	'Linker' => 'includes/Linker.php',
	'LinkFilter' => 'includes/LinkFilter.php',
	'MagicWord' => 'includes/MagicWord.php',
	'MagicWordArray' => 'includes/MagicWord.php',
	'MediaWiki' => 'includes/MediaWiki.php',
	'MediaWikiVersionFetcher' => 'includes/MediaWikiVersionFetcher.php',
	'Message' => 'includes/Message.php',
	'MessageBlobStore' => 'includes/MessageBlobStore.php',
	'MimeMagic' => 'includes/MimeMagic.php',
	'MovePage' => 'includes/MovePage.php',
	'MWHookException' => 'includes/Hooks.php',
	'MWHttpRequest' => 'includes/HttpFunctions.php',
	'MWNamespace' => 'includes/MWNamespace.php',
	'OutputPage' => 'includes/OutputPage.php',
	'PathRouter' => 'includes/PathRouter.php',
	'PathRouterPatternReplacer' => 'includes/PathRouter.php',
	'PhpHttpRequest' => 'includes/HttpFunctions.php',
	'PoolCounter' => 'includes/poolcounter/PoolCounter.php',
	'PoolCounter_Stub' => 'includes/poolcounter/PoolCounter.php',
	'PoolCounterRedis' => 'includes/poolcounter/PoolCounterRedis.php',
	'PoolCounterWork' => 'includes/poolcounter/PoolCounterWork.php',
	'PoolCounterWorkViaCallback' => 'includes/poolcounter/PoolCounterWorkViaCallback.php',
	'PoolWorkArticleView' => 'includes/poolcounter/PoolWorkArticleView.php',
	'Preferences' => 'includes/Preferences.php',
	'PreferencesForm' => 'includes/Preferences.php',
	'PrefixSearch' => 'includes/PrefixSearch.php',
	'ProtectionForm' => 'includes/ProtectionForm.php',
	'RawMessage' => 'includes/Message.php',
	'RevisionItem' => 'includes/RevisionList.php',
	'RevisionItemBase' => 'includes/RevisionList.php',
	'RevisionListBase' => 'includes/RevisionList.php',
	'Revision' => 'includes/Revision.php',
	'RevisionList' => 'includes/RevisionList.php',
	'RSSFeed' => 'includes/Feed.php',
	'Sanitizer' => 'includes/Sanitizer.php',
	'SiteConfiguration' => 'includes/SiteConfiguration.php',
	'SiteStats' => 'includes/SiteStats.php',
	'SiteStatsInit' => 'includes/SiteStats.php',
	'SquidPurgeClient' => 'includes/SquidPurgeClient.php',
	'SquidPurgeClientPool' => 'includes/SquidPurgeClient.php',
	'StatCounter' => 'includes/StatCounter.php',
	'Status' => 'includes/Status.php',
	'StreamFile' => 'includes/StreamFile.php',
	'StringPrefixSearch' => 'includes/PrefixSearch.php',
	'StubObject' => 'includes/StubObject.php',
	'StubUserLang' => 'includes/StubObject.php',
	'MWTimestamp' => 'includes/MWTimestamp.php',
	'TimestampException' => 'includes/TimestampException.php',
	'Title' => 'includes/Title.php',
	'TitleArray' => 'includes/TitleArray.php',
	'TitleArrayFromResult' => 'includes/TitleArrayFromResult.php',
	'TitlePrefixSearch' => 'includes/PrefixSearch.php',
	'UploadSourceAdapter' => 'includes/Import.php',
	'UppercaseCollation' => 'includes/Collation.php',
	'User' => 'includes/User.php',
	'UserArray' => 'includes/UserArray.php',
	'UserArrayFromResult' => 'includes/UserArrayFromResult.php',
	'UserRightsProxy' => 'includes/UserRightsProxy.php',
	'WatchedItem' => 'includes/WatchedItem.php',
	'WebRequest' => 'includes/WebRequest.php',
	'WebRequestUpload' => 'includes/WebRequest.php',
	'WebResponse' => 'includes/WebResponse.php',
	'WikiExporter' => 'includes/Export.php',
	'WikiImporter' => 'includes/Import.php',
	'WikiRevision' => 'includes/Import.php',
	'WikiMap' => 'includes/WikiMap.php',
	'WikiReference' => 'includes/WikiMap.php',
	'Xml' => 'includes/Xml.php',
	'XmlDumpWriter' => 'includes/Export.php',
	'XmlJsCode' => 'includes/Xml.php',
	'XmlSelect' => 'includes/Xml.php',

	# includes/actions
	'Action' => 'includes/actions/Action.php',
	'CachedAction' => 'includes/actions/CachedAction.php',
	'CreditsAction' => 'includes/actions/CreditsAction.php',
	'DeleteAction' => 'includes/actions/DeleteAction.php',
	'EditAction' => 'includes/actions/EditAction.php',
	'FormlessAction' => 'includes/actions/FormlessAction.php',
	'FormAction' => 'includes/actions/FormAction.php',
	'HistoryAction' => 'includes/actions/HistoryAction.php',
	'HistoryPager' => 'includes/actions/HistoryAction.php',
	'InfoAction' => 'includes/actions/InfoAction.php',
	'MarkpatrolledAction' => 'includes/actions/MarkpatrolledAction.php',
	'ProtectAction' => 'includes/actions/ProtectAction.php',
	'PurgeAction' => 'includes/actions/PurgeAction.php',
	'RawAction' => 'includes/actions/RawAction.php',
	'RenderAction' => 'includes/actions/RenderAction.php',
	'RevertAction' => 'includes/actions/RevertAction.php',
	'RevisiondeleteAction' => 'includes/actions/RevisiondeleteAction.php',
	'RollbackAction' => 'includes/actions/RollbackAction.php',
	'SubmitAction' => 'includes/actions/SubmitAction.php',
	'UnprotectAction' => 'includes/actions/UnprotectAction.php',
	'UnwatchAction' => 'includes/actions/UnwatchAction.php',
	'ViewAction' => 'includes/actions/ViewAction.php',
	'WatchAction' => 'includes/actions/WatchAction.php',

	# includes/api
	'ApiBase' => 'includes/api/ApiBase.php',
	'ApiBlock' => 'includes/api/ApiBlock.php',
	'ApiClearHasMsg' => 'includes/api/ApiClearHasMsg.php',
	'ApiComparePages' => 'includes/api/ApiComparePages.php',
	'ApiCreateAccount' => 'includes/api/ApiCreateAccount.php',
	'ApiDelete' => 'includes/api/ApiDelete.php',
	'ApiDisabled' => 'includes/api/ApiDisabled.php',
	'ApiEditPage' => 'includes/api/ApiEditPage.php',
	'ApiEmailUser' => 'includes/api/ApiEmailUser.php',
	'ApiExpandTemplates' => 'includes/api/ApiExpandTemplates.php',
	'ApiFeedContributions' => 'includes/api/ApiFeedContributions.php',
	'ApiFeedRecentChanges' => 'includes/api/ApiFeedRecentChanges.php',
	'ApiFeedWatchlist' => 'includes/api/ApiFeedWatchlist.php',
	'ApiFileRevert' => 'includes/api/ApiFileRevert.php',
	'ApiFormatBase' => 'includes/api/ApiFormatBase.php',
	'ApiFormatDbg' => 'includes/api/ApiFormatDbg.php',
	'ApiFormatDump' => 'includes/api/ApiFormatDump.php',
	'ApiFormatFeedWrapper' => 'includes/api/ApiFormatFeedWrapper.php',
	'ApiFormatJson' => 'includes/api/ApiFormatJson.php',
	'ApiFormatNone' => 'includes/api/ApiFormatNone.php',
	'ApiFormatPhp' => 'includes/api/ApiFormatPhp.php',
	'ApiFormatRaw' => 'includes/api/ApiFormatRaw.php',
	'ApiFormatTxt' => 'includes/api/ApiFormatTxt.php',
	'ApiFormatWddx' => 'includes/api/ApiFormatWddx.php',
	'ApiFormatXml' => 'includes/api/ApiFormatXml.php',
	'ApiFormatXmlRsd' => 'includes/api/ApiRsd.php',
	'ApiFormatYaml' => 'includes/api/ApiFormatYaml.php',
	'ApiHelp' => 'includes/api/ApiHelp.php',
	'ApiImageRotate' => 'includes/api/ApiImageRotate.php',
	'ApiImport' => 'includes/api/ApiImport.php',
	'ApiImportReporter' => 'includes/api/ApiImport.php',
	'ApiLogin' => 'includes/api/ApiLogin.php',
	'ApiLogout' => 'includes/api/ApiLogout.php',
	'ApiMain' => 'includes/api/ApiMain.php',
	'ApiModuleManager' => 'includes/api/ApiModuleManager.php',
	'ApiMove' => 'includes/api/ApiMove.php',
	'ApiOpenSearch' => 'includes/api/ApiOpenSearch.php',
	'ApiOptions' => 'includes/api/ApiOptions.php',
	'ApiPageSet' => 'includes/api/ApiPageSet.php',
	'ApiParamInfo' => 'includes/api/ApiParamInfo.php',
	'ApiParse' => 'includes/api/ApiParse.php',
	'ApiPatrol' => 'includes/api/ApiPatrol.php',
	'ApiProtect' => 'includes/api/ApiProtect.php',
	'ApiPurge' => 'includes/api/ApiPurge.php',
	'ApiQuery' => 'includes/api/ApiQuery.php',
	'ApiQueryAllCategories' => 'includes/api/ApiQueryAllCategories.php',
	'ApiQueryAllImages' => 'includes/api/ApiQueryAllImages.php',
	'ApiQueryAllLinks' => 'includes/api/ApiQueryAllLinks.php',
	'ApiQueryAllMessages' => 'includes/api/ApiQueryAllMessages.php',
	'ApiQueryAllPages' => 'includes/api/ApiQueryAllPages.php',
	'ApiQueryAllUsers' => 'includes/api/ApiQueryAllUsers.php',
	'ApiQueryBacklinks' => 'includes/api/ApiQueryBacklinks.php',
	'ApiQueryBase' => 'includes/api/ApiQueryBase.php',
	'ApiQueryBlocks' => 'includes/api/ApiQueryBlocks.php',
	'ApiQueryCategories' => 'includes/api/ApiQueryCategories.php',
	'ApiQueryCategoryInfo' => 'includes/api/ApiQueryCategoryInfo.php',
	'ApiQueryCategoryMembers' => 'includes/api/ApiQueryCategoryMembers.php',
	'ApiQueryContributions' => 'includes/api/ApiQueryUserContributions.php',
	'ApiQueryContributors' => 'includes/api/ApiQueryContributors.php',
	'ApiQueryDeletedrevs' => 'includes/api/ApiQueryDeletedrevs.php',
	'ApiQueryDisabled' => 'includes/api/ApiQueryDisabled.php',
	'ApiQueryDuplicateFiles' => 'includes/api/ApiQueryDuplicateFiles.php',
	'ApiQueryExternalLinks' => 'includes/api/ApiQueryExternalLinks.php',
	'ApiQueryExtLinksUsage' => 'includes/api/ApiQueryExtLinksUsage.php',
	'ApiQueryFilearchive' => 'includes/api/ApiQueryFilearchive.php',
	'ApiQueryGeneratorBase' => 'includes/api/ApiQueryBase.php',
	'ApiQueryImageInfo' => 'includes/api/ApiQueryImageInfo.php',
	'ApiQueryImages' => 'includes/api/ApiQueryImages.php',
	'ApiQueryInfo' => 'includes/api/ApiQueryInfo.php',
	'ApiQueryIWBacklinks' => 'includes/api/ApiQueryIWBacklinks.php',
	'ApiQueryIWLinks' => 'includes/api/ApiQueryIWLinks.php',
	'ApiQueryLangBacklinks' => 'includes/api/ApiQueryLangBacklinks.php',
	'ApiQueryLangLinks' => 'includes/api/ApiQueryLangLinks.php',
	'ApiQueryLinks' => 'includes/api/ApiQueryLinks.php',
	'ApiQueryLogEvents' => 'includes/api/ApiQueryLogEvents.php',
	'ApiQueryORM' => 'includes/api/ApiQueryORM.php',
	'ApiQueryPageProps' => 'includes/api/ApiQueryPageProps.php',
	'ApiQueryPagesWithProp' => 'includes/api/ApiQueryPagesWithProp.php',
	'ApiQueryPagePropNames' => 'includes/api/ApiQueryPagePropNames.php',
	'ApiQueryPrefixSearch' => 'includes/api/ApiQueryPrefixSearch.php',
	'ApiQueryProtectedTitles' => 'includes/api/ApiQueryProtectedTitles.php',
	'ApiQueryQueryPage' => 'includes/api/ApiQueryQueryPage.php',
	'ApiQueryRandom' => 'includes/api/ApiQueryRandom.php',
	'ApiQueryRecentChanges' => 'includes/api/ApiQueryRecentChanges.php',
	'ApiQueryFileRepoInfo' => 'includes/api/ApiQueryFileRepoInfo.php',
	'ApiQueryRedirects' => 'includes/api/ApiQueryRedirects.php',
	'ApiQueryRevisions' => 'includes/api/ApiQueryRevisions.php',
	'ApiQuerySearch' => 'includes/api/ApiQuerySearch.php',
	'ApiQuerySiteinfo' => 'includes/api/ApiQuerySiteinfo.php',
	'ApiQueryStashImageInfo' => 'includes/api/ApiQueryStashImageInfo.php',
	'ApiQueryTags' => 'includes/api/ApiQueryTags.php',
	'ApiQueryTokens' => 'includes/api/ApiQueryTokens.php',
	'ApiQueryUserInfo' => 'includes/api/ApiQueryUserInfo.php',
	'ApiQueryUsers' => 'includes/api/ApiQueryUsers.php',
	'ApiQueryWatchlist' => 'includes/api/ApiQueryWatchlist.php',
	'ApiQueryWatchlistRaw' => 'includes/api/ApiQueryWatchlistRaw.php',
	'ApiResult' => 'includes/api/ApiResult.php',
	'ApiRevisionDelete' => 'includes/api/ApiRevisionDelete.php',
	'ApiRollback' => 'includes/api/ApiRollback.php',
	'ApiRsd' => 'includes/api/ApiRsd.php',
	'ApiSetNotificationTimestamp' => 'includes/api/ApiSetNotificationTimestamp.php',
	'ApiTokens' => 'includes/api/ApiTokens.php',
	'ApiUnblock' => 'includes/api/ApiUnblock.php',
	'ApiUndelete' => 'includes/api/ApiUndelete.php',
	'ApiUpload' => 'includes/api/ApiUpload.php',
	'ApiUserrights' => 'includes/api/ApiUserrights.php',
	'ApiWatch' => 'includes/api/ApiWatch.php',
	'UsageException' => 'includes/api/ApiMain.php',

	# includes/cache
	'BacklinkCache' => 'includes/cache/BacklinkCache.php',
	'CacheDependency' => 'includes/cache/CacheDependency.php',
	'CacheHelper' => 'includes/cache/CacheHelper.php',
	'ConstantDependency' => 'includes/cache/CacheDependency.php',
	'DependencyWrapper' => 'includes/cache/CacheDependency.php',
	'FileCacheBase' => 'includes/cache/FileCacheBase.php',
	'FileDependency' => 'includes/cache/CacheDependency.php',
	'GenderCache' => 'includes/cache/GenderCache.php',
	'GlobalDependency' => 'includes/cache/CacheDependency.php',
	'HTMLFileCache' => 'includes/cache/HTMLFileCache.php',
	'ICacheHelper' => 'includes/cache/CacheHelper.php',
	'LCStore' => 'includes/cache/LocalisationCache.php',
	'LCStoreCDB' => 'includes/cache/LocalisationCache.php',
	'LCStoreDB' => 'includes/cache/LocalisationCache.php',
	'LCStoreNull' => 'includes/cache/LocalisationCache.php',
	'LinkBatch' => 'includes/cache/LinkBatch.php',
	'LinkCache' => 'includes/cache/LinkCache.php',
	'LocalisationCache' => 'includes/cache/LocalisationCache.php',
	'LocalisationCacheBulkLoad' => 'includes/cache/LocalisationCache.php',
	'MapCacheLRU' => 'includes/cache/MapCacheLRU.php',
	'MessageCache' => 'includes/cache/MessageCache.php',
	'ObjectFileCache' => 'includes/cache/ObjectFileCache.php',
	'ResourceFileCache' => 'includes/cache/ResourceFileCache.php',
	'UserCache' => 'includes/cache/UserCache.php',

	# includes/changes
	'ChangesFeed' => 'includes/changes/ChangesFeed.php',
	'ChangesList' => 'includes/changes/ChangesList.php',
	'EnhancedChangesList' => 'includes/changes/EnhancedChangesList.php',
	'OldChangesList' => 'includes/changes/OldChangesList.php',
	'RCCacheEntry' => 'includes/changes/RCCacheEntry.php',
	'RCCacheEntryFactory' => 'includes/changes/RCCacheEntryFactory.php',
	'RecentChange' => 'includes/changes/RecentChange.php',

	# includes/clientpool
	'RedisConnectionPool' => 'includes/clientpool/RedisConnectionPool.php',
	'RedisConnRef' => 'includes/clientpool/RedisConnectionPool.php',

	# includes/composer
	'ComposerPackageModifier' => 'includes/composer/ComposerPackageModifier.php',
	'ComposerVersionNormalizer' => 'includes/composer/ComposerVersionNormalizer.php',

	# includes/config
	'Config' => 'includes/config/Config.php',
	'ConfigException' => 'includes/config/ConfigException.php',
	'ConfigFactory' => 'includes/config/ConfigFactory.php',
	'GlobalVarConfig' => 'includes/config/GlobalVarConfig.php',
	'HashConfig' => 'includes/config/HashConfig.php',
	'MultiConfig' => 'includes/config/MultiConfig.php',
	'MutableConfig' => 'includes/config/MutableConfig.php',

	# includes/content
	'AbstractContent' => 'includes/content/AbstractContent.php',
	'CodeContentHandler' => 'includes/content/CodeContentHandler.php',
	'Content' => 'includes/content/Content.php',
	'ContentHandler' => 'includes/content/ContentHandler.php',
	'CssContent' => 'includes/content/CssContent.php',
	'CssContentHandler' => 'includes/content/CssContentHandler.php',
	'JavaScriptContent' => 'includes/content/JavaScriptContent.php',
	'JavaScriptContentHandler' => 'includes/content/JavaScriptContentHandler.php',
	'JsonContent' => 'includes/content/JsonContent.php',
	'JsonContentHandler' => 'includes/content/JsonContentHandler.php',
	'MessageContent' => 'includes/content/MessageContent.php',
	'MWContentSerializationException' => 'includes/content/ContentHandler.php',
	'TextContent' => 'includes/content/TextContent.php',
	'TextContentHandler' => 'includes/content/TextContentHandler.php',
	'WikitextContent' => 'includes/content/WikitextContent.php',
	'WikitextContentHandler' => 'includes/content/WikitextContentHandler.php',

	# includes/context
	'ContextSource' => 'includes/context/ContextSource.php',
	'DerivativeContext' => 'includes/context/DerivativeContext.php',
	'IContextSource' => 'includes/context/IContextSource.php',
	'RequestContext' => 'includes/context/RequestContext.php',

	# includes/dao
	'IDBAccessObject' => 'includes/dao/IDBAccessObject.php',
	'DBAccessBase' => 'includes/dao/DBAccessBase.php',

	# includes/db
	'Blob' => 'includes/db/DatabaseUtility.php',
	'ChronologyProtector' => 'includes/db/ChronologyProtector.php',
	'CloneDatabase' => 'includes/db/CloneDatabase.php',
	'DatabaseBase' => 'includes/db/Database.php',
	'DatabaseMssql' => 'includes/db/DatabaseMssql.php',
	'DatabaseMysql' => 'includes/db/DatabaseMysql.php',
	'DatabaseMysqlBase' => 'includes/db/DatabaseMysqlBase.php',
	'DatabaseMysqli' => 'includes/db/DatabaseMysqli.php',
	'DatabaseOracle' => 'includes/db/DatabaseOracle.php',
	'DatabasePostgres' => 'includes/db/DatabasePostgres.php',
	'DatabaseSqlite' => 'includes/db/DatabaseSqlite.php',
	'DatabaseSqliteStandalone' => 'includes/db/DatabaseSqlite.php',
	'DatabaseType' => 'includes/db/Database.php',
	'DBAccessError' => 'includes/db/LBFactory.php',
	'DBConnectionError' => 'includes/db/DatabaseError.php',
	'DBConnRef' => 'includes/db/LoadBalancer.php',
	'DBError' => 'includes/db/DatabaseError.php',
	'DBExpectedError' => 'includes/db/DatabaseError.php',
	'DBObject' => 'includes/db/DatabaseUtility.php',
	'IDatabase'  => 'includes/db/Database.php',
	'IORMRow' => 'includes/db/IORMRow.php',
	'IORMTable' => 'includes/db/IORMTable.php',
	'DBMasterPos' => 'includes/db/DatabaseUtility.php',
	'DBQueryError' => 'includes/db/DatabaseError.php',
	'DBUnexpectedError' => 'includes/db/DatabaseError.php',
	'FakeResultWrapper' => 'includes/db/DatabaseUtility.php',
	'Field' => 'includes/db/DatabaseUtility.php',
	'LBFactory' => 'includes/db/LBFactory.php',
	'LBFactoryFake' => 'includes/db/LBFactory.php',
	'LBFactoryMulti' => 'includes/db/LBFactoryMulti.php',
	'LBFactorySimple' => 'includes/db/LBFactory.php',
	'LBFactorySingle' => 'includes/db/LBFactorySingle.php',
	'LikeMatch' => 'includes/db/DatabaseUtility.php',
	'LoadBalancer' => 'includes/db/LoadBalancer.php',
	'LoadBalancerSingle' => 'includes/db/LBFactorySingle.php',
	'LoadMonitor' => 'includes/db/LoadMonitor.php',
	'LoadMonitorMySQL' => 'includes/db/LoadMonitor.php',
	'LoadMonitorNull' => 'includes/db/LoadMonitor.php',
	'MssqlField' => 'includes/db/DatabaseMssql.php',
	'MssqlBlob' => 'includes/db/DatabaseMssql.php',
	'MssqlResultWrapper' => 'includes/db/DatabaseMssql.php',
	'MySQLField' => 'includes/db/DatabaseMysqlBase.php',
	'MySQLMasterPos' => 'includes/db/DatabaseMysqlBase.php',
	'ORAField' => 'includes/db/DatabaseOracle.php',
	'ORAResult' => 'includes/db/DatabaseOracle.php',
	'ORMIterator' => 'includes/db/ORMIterator.php',
	'ORMResult' => 'includes/db/ORMResult.php',
	'ORMRow' => 'includes/db/ORMRow.php',
	'ORMTable' => 'includes/db/ORMTable.php',
	'PostgresField' => 'includes/db/DatabasePostgres.php',
	'PostgresTransactionState' => 'includes/db/DatabasePostgres.php',
	'ResultWrapper' => 'includes/db/DatabaseUtility.php',
	'SavepointPostgres' => 'includes/db/DatabasePostgres.php',
	'SQLiteField' => 'includes/db/DatabaseSqlite.php',

	# includes/debug
	'MWDebug' => 'includes/debug/MWDebug.php',

	# includes/deferred
	'DataUpdate' => 'includes/deferred/DataUpdate.php',
	'DeferrableUpdate' => 'includes/deferred/DeferredUpdates.php',
	'DeferredUpdates' => 'includes/deferred/DeferredUpdates.php',
	'HTMLCacheUpdate' => 'includes/deferred/HTMLCacheUpdate.php',
	'LinksDeletionUpdate' => 'includes/deferred/LinksUpdate.php',
	'LinksUpdate' => 'includes/deferred/LinksUpdate.php',
	'MWCallableUpdate' => 'includes/deferred/CallableUpdate.php',
	'SearchUpdate' => 'includes/deferred/SearchUpdate.php',
	'SiteStatsUpdate' => 'includes/deferred/SiteStatsUpdate.php',
	'SqlDataUpdate' => 'includes/deferred/SqlDataUpdate.php',
	'SquidUpdate' => 'includes/deferred/SquidUpdate.php',
	'ViewCountUpdate' => 'includes/deferred/ViewCountUpdate.php',

	# includes/diff
	'DiffEngine' => 'includes/diff/DairikiDiff.php',
	'DiffOp' => 'includes/diff/DairikiDiff.php',
	'DiffOpAdd' => 'includes/diff/DairikiDiff.php',
	'DiffOpChange' => 'includes/diff/DairikiDiff.php',
	'DiffOpCopy' => 'includes/diff/DairikiDiff.php',
	'DiffOpDelete' => 'includes/diff/DairikiDiff.php',
	'HWLDFWordAccumulator' => 'includes/diff/DairikiDiff.php',
	'ArrayDiffFormatter' => 'includes/diff/ArrayDiffFormatter.php',
	'Diff' => 'includes/diff/DairikiDiff.php',
	'DifferenceEngine' => 'includes/diff/DifferenceEngine.php',
	'DiffFormatter' => 'includes/diff/DiffFormatter.php',
	'MappedDiff' => 'includes/diff/DairikiDiff.php',
	'RangeDifference' => 'includes/diff/WikiDiff3.php',
	'TableDiffFormatter' => 'includes/diff/TableDiffFormatter.php',
	'UnifiedDiffFormatter' => 'includes/diff/UnifiedDiffFormatter.php',
	'WikiDiff3' => 'includes/diff/WikiDiff3.php',
	'WordLevelDiff' => 'includes/diff/DairikiDiff.php',

	# includes/exception
	'UserBlockedError' => 'includes/exception/UserBlockedError.php',
	'UserNotLoggedIn' => 'includes/exception/UserNotLoggedIn.php',
	'ThrottledError' => 'includes/exception/ThrottledError.php',
	'ReadOnlyError' => 'includes/exception/ReadOnlyError.php',
	'PermissionsError' => 'includes/exception/PermissionsError.php',
	'MWException' => 'includes/exception/MWException.php',
	'MWExceptionHandler' => 'includes/exception/MWExceptionHandler.php',
	'HttpError' => 'includes/exception/HttpError.php',
	'BadTitleError' => 'includes/exception/BadTitleError.php',
	'ErrorPageError' => 'includes/exception/ErrorPageError.php',
	'FatalError' => 'includes/exception/FatalError.php',

	# includes/externalstore
	'ExternalStore' => 'includes/externalstore/ExternalStore.php',
	'ExternalStoreDB' => 'includes/externalstore/ExternalStoreDB.php',
	'ExternalStoreHttp' => 'includes/externalstore/ExternalStoreHttp.php',
	'ExternalStoreMedium' => 'includes/externalstore/ExternalStoreMedium.php',
	'ExternalStoreMwstore' => 'includes/externalstore/ExternalStoreMwstore.php',

	# includes/filebackend
	'FileBackendGroup' => 'includes/filebackend/FileBackendGroup.php',
	'FileBackend' => 'includes/filebackend/FileBackend.php',
	'FileBackendError' => 'includes/filebackend/FileBackend.php',
	'FileBackendException' => 'includes/filebackend/FileBackend.php',
	'FileBackendStore' => 'includes/filebackend/FileBackendStore.php',
	'FileBackendStoreShardListIterator' => 'includes/filebackend/FileBackendStore.php',
	'FileBackendStoreShardDirIterator' => 'includes/filebackend/FileBackendStore.php',
	'FileBackendStoreShardFileIterator' => 'includes/filebackend/FileBackendStore.php',
	'FileBackendMultiWrite' => 'includes/filebackend/FileBackendMultiWrite.php',
	'FileBackendStoreOpHandle' => 'includes/filebackend/FileBackendStore.php',
	'FSFile' => 'includes/filebackend/FSFile.php',
	'FSFileBackend' => 'includes/filebackend/FSFileBackend.php',
	'FSFileBackendList' => 'includes/filebackend/FSFileBackend.php',
	'FSFileBackendDirList' => 'includes/filebackend/FSFileBackend.php',
	'FSFileBackendFileList' => 'includes/filebackend/FSFileBackend.php',
	'FSFileOpHandle' => 'includes/filebackend/FSFileBackend.php',
	'MemoryFileBackend' => 'includes/filebackend/MemoryFileBackend.php',
	'SwiftFileBackend' => 'includes/filebackend/SwiftFileBackend.php',
	'SwiftFileBackendList' => 'includes/filebackend/SwiftFileBackend.php',
	'SwiftFileBackendDirList' => 'includes/filebackend/SwiftFileBackend.php',
	'SwiftFileBackendFileList' => 'includes/filebackend/SwiftFileBackend.php',
	'SwiftFileOpHandle' => 'includes/filebackend/SwiftFileBackend.php',
	'TempFSFile' => 'includes/filebackend/TempFSFile.php',
	'FileJournal' => 'includes/filebackend/filejournal/FileJournal.php',
	'DBFileJournal' => 'includes/filebackend/filejournal/DBFileJournal.php',
	'NullFileJournal' => 'includes/filebackend/filejournal/FileJournal.php',
	'LockManagerGroup' => 'includes/filebackend/lockmanager/LockManagerGroup.php',
	'LockManager' => 'includes/filebackend/lockmanager/LockManager.php',
	'ScopedLock' => 'includes/filebackend/lockmanager/ScopedLock.php',
	'FSLockManager' => 'includes/filebackend/lockmanager/FSLockManager.php',
	'DBLockManager' => 'includes/filebackend/lockmanager/DBLockManager.php',
	'MemcLockManager' => 'includes/filebackend/lockmanager/MemcLockManager.php',
	'QuorumLockManager' => 'includes/filebackend/lockmanager/QuorumLockManager.php',
	'MySqlLockManager' => 'includes/filebackend/lockmanager/DBLockManager.php',
	'PostgreSqlLockManager' => 'includes/filebackend/lockmanager/DBLockManager.php',
	'RedisLockManager' => 'includes/filebackend/lockmanager/RedisLockManager.php',
	'NullLockManager' => 'includes/filebackend/lockmanager/LockManager.php',
	'FileOp' => 'includes/filebackend/FileOp.php',
	'FileOpBatch' => 'includes/filebackend/FileOpBatch.php',
	'StoreFileOp' => 'includes/filebackend/FileOp.php',
	'CopyFileOp' => 'includes/filebackend/FileOp.php',
	'MoveFileOp' => 'includes/filebackend/FileOp.php',
	'DeleteFileOp' => 'includes/filebackend/FileOp.php',
	'CreateFileOp' => 'includes/filebackend/FileOp.php',
	'DescribeFileOp' => 'includes/filebackend/FileOp.php',
	'NullFileOp' => 'includes/filebackend/FileOp.php',

	# includes/filerepo
	'FileRepo' => 'includes/filerepo/FileRepo.php',
	'FileRepoStatus' => 'includes/filerepo/FileRepoStatus.php',
	'ForeignAPIRepo' => 'includes/filerepo/ForeignAPIRepo.php',
	'ForeignDBRepo' => 'includes/filerepo/ForeignDBRepo.php',
	'ForeignDBViaLBRepo' => 'includes/filerepo/ForeignDBViaLBRepo.php',
	'FSRepo' => 'includes/filerepo/FSRepo.php',
	'LocalRepo' => 'includes/filerepo/LocalRepo.php',
	'NullRepo' => 'includes/filerepo/NullRepo.php',
	'RepoGroup' => 'includes/filerepo/RepoGroup.php',
	'TempFileRepo' => 'includes/filerepo/FileRepo.php',

	# includes/filerepo/file
	'ArchivedFile' => 'includes/filerepo/file/ArchivedFile.php',
	'File' => 'includes/filerepo/file/File.php',
	'ForeignAPIFile' => 'includes/filerepo/file/ForeignAPIFile.php',
	'ForeignDBFile' => 'includes/filerepo/file/ForeignDBFile.php',
	'LocalFile' => 'includes/filerepo/file/LocalFile.php',
	'LocalFileDeleteBatch' => 'includes/filerepo/file/LocalFile.php',
	'LocalFileMoveBatch' => 'includes/filerepo/file/LocalFile.php',
	'LocalFileRestoreBatch' => 'includes/filerepo/file/LocalFile.php',
	'OldLocalFile' => 'includes/filerepo/file/OldLocalFile.php',
	'UnregisteredLocalFile' => 'includes/filerepo/file/UnregisteredLocalFile.php',

	# includes/installer
	'CliInstaller' => 'includes/installer/CliInstaller.php',
	'DatabaseInstaller' => 'includes/installer/DatabaseInstaller.php',
	'DatabaseUpdater' => 'includes/installer/DatabaseUpdater.php',
	'InstallDocFormatter' => 'includes/installer/InstallDocFormatter.php',
	'Installer' => 'includes/installer/Installer.php',
	'LocalSettingsGenerator' => 'includes/installer/LocalSettingsGenerator.php',
	'MssqlInstaller' => 'includes/installer/MssqlInstaller.php',
	'MssqlUpdater' => 'includes/installer/MssqlUpdater.php',
	'MysqlInstaller' => 'includes/installer/MysqlInstaller.php',
	'MysqlUpdater' => 'includes/installer/MysqlUpdater.php',
	'OracleInstaller' => 'includes/installer/OracleInstaller.php',
	'OracleUpdater' => 'includes/installer/OracleUpdater.php',
	'PhpXmlBugTester' => 'includes/installer/PhpBugTests.php',
	'PostgresInstaller' => 'includes/installer/PostgresInstaller.php',
	'PostgresUpdater' => 'includes/installer/PostgresUpdater.php',
	'SqliteInstaller' => 'includes/installer/SqliteInstaller.php',
	'SqliteUpdater' => 'includes/installer/SqliteUpdater.php',
	'WebInstaller' => 'includes/installer/WebInstaller.php',
	'WebInstallerComplete' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerCopying' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerDBConnect' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerDBSettings' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerDocument' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerExistingWiki' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerInstall' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerLanguage' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerName' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerOptions' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerReadme' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerReleaseNotes' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerRestart' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerUpgrade' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerUpgradeDoc' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerWelcome' => 'includes/installer/WebInstallerPage.php',
	'WebInstallerOutput' => 'includes/installer/WebInstallerOutput.php',
	'WebInstallerPage' => 'includes/installer/WebInstallerPage.php',

	# includes/job
	'IJobSpecification' => 'includes/jobqueue/JobSpecification.php',
	'Job' => 'includes/jobqueue/Job.php',
	'JobQueue' => 'includes/jobqueue/JobQueue.php',
	'JobQueueAggregator' => 'includes/jobqueue/aggregator/JobQueueAggregator.php',
	'JobQueueAggregatorMemc' => 'includes/jobqueue/aggregator/JobQueueAggregatorMemc.php',
	'JobQueueAggregatorRedis' => 'includes/jobqueue/aggregator/JobQueueAggregatorRedis.php',
	'JobQueueDB' => 'includes/jobqueue/JobQueueDB.php',
	'JobQueueConnectionError' => 'includes/jobqueue/JobQueue.php',
	'JobQueueError' => 'includes/jobqueue/JobQueue.php',
	'JobQueueGroup' => 'includes/jobqueue/JobQueueGroup.php',
	'JobQueueFederated' => 'includes/jobqueue/JobQueueFederated.php',
	'JobQueueRedis' => 'includes/jobqueue/JobQueueRedis.php',
	'JobRunner' => 'includes/jobqueue/JobRunner.php',
	'JobSpecification' => 'includes/jobqueue/JobSpecification.php',

	# includes/jobqueue/jobs
	'DoubleRedirectJob' => 'includes/jobqueue/jobs/DoubleRedirectJob.php',
	'DuplicateJob' => 'includes/jobqueue/jobs/DuplicateJob.php',
	'EmaillingJob' => 'includes/jobqueue/jobs/EmaillingJob.php',
	'EnotifNotifyJob' => 'includes/jobqueue/jobs/EnotifNotifyJob.php',
	'HTMLCacheUpdateJob' => 'includes/jobqueue/jobs/HTMLCacheUpdateJob.php',
	'NullJob' => 'includes/jobqueue/jobs/NullJob.php',
	'RefreshLinksJob' => 'includes/jobqueue/jobs/RefreshLinksJob.php',
	'RefreshLinksJob2' => 'includes/jobqueue/jobs/RefreshLinksJob2.php',
	'UploadFromUrlJob' => 'includes/jobqueue/jobs/UploadFromUrlJob.php',
	'AssembleUploadChunksJob' => 'includes/jobqueue/jobs/AssembleUploadChunksJob.php',
	'PublishStashedFileJob' => 'includes/jobqueue/jobs/PublishStashedFileJob.php',

	# includes/jobqueue/utils
	'BacklinkJobUtils' => 'includes/jobqueue/utils/BacklinkJobUtils.php',

	# includes/json
	'FormatJson' => 'includes/json/FormatJson.php',

	# includes/libs
	'CSSJanus' => 'includes/libs/CSSJanus.php',
	'CSSJanusTokenizer' => 'includes/libs/CSSJanus.php',
	'CSSMin' => 'includes/libs/CSSMin.php',
	'GenericArrayObject' => 'includes/libs/GenericArrayObject.php',
	'HashRing' => 'includes/libs/HashRing.php',
	'HttpStatus' => 'includes/libs/HttpStatus.php',
	'IEContentAnalyzer' => 'includes/libs/IEContentAnalyzer.php',
	'IEUrlExtension' => 'includes/libs/IEUrlExtension.php',
	'MappedIterator' => 'includes/libs/MappedIterator.php',
	'IPSet' => 'includes/libs/IPSet.php',
	'JavaScriptMinifier' => 'includes/libs/JavaScriptMinifier.php',
	'JSCompilerContext' => 'includes/libs/jsminplus.php',
	'JSMinPlus' => 'includes/libs/jsminplus.php',
	'JSNode' => 'includes/libs/jsminplus.php',
	'JSParser' => 'includes/libs/jsminplus.php',
	'JSToken' => 'includes/libs/jsminplus.php',
	'JSTokenizer' => 'includes/libs/jsminplus.php',
	'MultiHttpClient' => 'includes/libs/MultiHttpClient.php',
	'MWMessagePack' => 'includes/libs/MWMessagePack.php',
	'ProcessCacheLRU' => 'includes/libs/ProcessCacheLRU.php',
	'RunningStat' => 'includes/libs/RunningStat.php',
	'ScopedCallback' => 'includes/libs/ScopedCallback.php',
	'ScopedPHPTimeout' => 'includes/libs/ScopedPHPTimeout.php',
	'SwiftVirtualRESTService' => 'includes/libs/virtualrest/SwiftVirtualRESTService.php',
	'VirtualRESTService' => 'includes/libs/virtualrest/VirtualRESTService.php',
	'VirtualRESTServiceClient' => 'includes/libs/virtualrest/VirtualRESTServiceClient.php',
	'XmlTypeCheck' => 'includes/libs/XmlTypeCheck.php',

	# includes/libs/lessphp
	'lessc' => 'includes/libs/lessc.inc.php',
	'lessc_parser' => 'includes/libs/lessc.inc.php',
	'lessc_formatter_classic' => 'includes/libs/lessc.inc.php',
	'lessc_formatter_compressed' => 'includes/libs/lessc.inc.php',
	'lessc_formatter_lessjs' => 'includes/libs/lessc.inc.php',

	# includes/logging
	'DatabaseLogEntry' => 'includes/logging/LogEntry.php',
	'DeleteLogFormatter' => 'includes/logging/DeleteLogFormatter.php',
	'LegacyLogFormatter' => 'includes/logging/LogFormatter.php',
	'LogEntry' => 'includes/logging/LogEntry.php',
	'LogEventsList' => 'includes/logging/LogEventsList.php',
	'LogEntryBase' => 'includes/logging/LogEntry.php',
	'LogFormatter' => 'includes/logging/LogFormatter.php',
	'LogPage' => 'includes/logging/LogPage.php',
	'LogPager' => 'includes/logging/LogPager.php',
	'ManualLogEntry' => 'includes/logging/LogEntry.php',
	'MoveLogFormatter' => 'includes/logging/MoveLogFormatter.php',
	'NewUsersLogFormatter' => 'includes/logging/NewUsersLogFormatter.php',
	'PageLangLogFormatter' => 'includes/logging/PageLangLogFormatter.php',
	'PatrolLog' => 'includes/logging/PatrolLog.php',
	'PatrolLogFormatter' => 'includes/logging/PatrolLogFormatter.php',
	'RCDatabaseLogEntry' => 'includes/logging/LogEntry.php',
	'RightsLogFormatter' => 'includes/logging/RightsLogFormatter.php',

	# Image gallery

	'ImageGallery' => 'includes/gallery/TraditionalImageGallery.php',
	'ImageGalleryBase' => 'includes/gallery/ImageGalleryBase.php',
	'NolinesImageGallery' => 'includes/gallery/NolinesImageGallery.php',
	'TraditionalImageGallery' => 'includes/gallery/TraditionalImageGallery.php',
	'PackedImageGallery' => 'includes/gallery/PackedImageGallery.php',
	'PackedHoverImageGallery' => 'includes/gallery/PackedOverlayImageGallery.php',
	'PackedOverlayImageGallery' => 'includes/gallery/PackedOverlayImageGallery.php',

	# includes/mail
	'EmailNotification' => 'includes/mail/EmailNotification.php',
	'MailAddress' => 'includes/mail/MailAddress.php',
	'UserMailer' => 'includes/mail/UserMailer.php',

	# includes/media
	'BitmapHandler' => 'includes/media/Bitmap.php',
	'BitmapHandler_ClientOnly' => 'includes/media/Bitmap_ClientOnly.php',
	'BitmapMetadataHandler' => 'includes/media/BitmapMetadataHandler.php',
	'BmpHandler' => 'includes/media/BMP.php',
	'DjVuHandler' => 'includes/media/DjVu.php',
	'DjVuImage' => 'includes/media/DjVuImage.php',
	'Exif' => 'includes/media/Exif.php',
	'ExifBitmapHandler' => 'includes/media/ExifBitmap.php',
	'FormatMetadata' => 'includes/media/FormatMetadata.php',
	'GIFHandler' => 'includes/media/GIF.php',
	'GIFMetadataExtractor' => 'includes/media/GIFMetadataExtractor.php',
	'ImageHandler' => 'includes/media/ImageHandler.php',
	'IPTC' => 'includes/media/IPTC.php',
	'JpegHandler' => 'includes/media/Jpeg.php',
	'JpegMetadataExtractor' => 'includes/media/JpegMetadataExtractor.php',
	'MediaHandler' => 'includes/media/MediaHandler.php',
	'MediaTransformError' => 'includes/media/MediaTransformOutput.php',
	'MediaTransformOutput' => 'includes/media/MediaTransformOutput.php',
	'PNGHandler' => 'includes/media/PNG.php',
	'PNGMetadataExtractor' => 'includes/media/PNGMetadataExtractor.php',
	'SvgHandler' => 'includes/media/SVG.php',
	'SVGMetadataExtractor' => 'includes/media/SVGMetadataExtractor.php',
	'SVGReader' => 'includes/media/SVGMetadataExtractor.php',
	'ThumbnailImage' => 'includes/media/MediaTransformOutput.php',
	'TiffHandler' => 'includes/media/Tiff.php',
	'TransformationalImageHandler' => 'includes/media/TransformationalImageHandler.php',
	'TransformParameterError' => 'includes/media/MediaTransformOutput.php',
	'XCFHandler' => 'includes/media/XCF.php',
	'XMPInfo' => 'includes/media/XMPInfo.php',
	'XMPReader' => 'includes/media/XMP.php',
	'XMPValidate' => 'includes/media/XMPValidate.php',

	# includes/normal
	'UtfNormal' => 'includes/normal/UtfNormal.php',

	# includes/objectcache
	'APCBagOStuff' => 'includes/objectcache/APCBagOStuff.php',
	'BagOStuff' => 'includes/objectcache/BagOStuff.php',
	'EmptyBagOStuff' => 'includes/objectcache/EmptyBagOStuff.php',
	'HashBagOStuff' => 'includes/objectcache/HashBagOStuff.php',
	'MediaWikiBagOStuff' => 'includes/objectcache/SqlBagOStuff.php',
	'MemCachedClientforWiki' => 'includes/objectcache/MemcachedClient.php',
	'MemcachedBagOStuff' => 'includes/objectcache/MemcachedBagOStuff.php',
	'MemcachedPeclBagOStuff' => 'includes/objectcache/MemcachedPeclBagOStuff.php',
	'MemcachedPhpBagOStuff' => 'includes/objectcache/MemcachedPhpBagOStuff.php',
	'MultiWriteBagOStuff' => 'includes/objectcache/MultiWriteBagOStuff.php',
	'MWMemcached' => 'includes/objectcache/MemcachedClient.php',
	'ObjectCache' => 'includes/objectcache/ObjectCache.php',
	'ObjectCacheSessionHandler' => 'includes/objectcache/ObjectCacheSessionHandler.php',
	'RedisBagOStuff' => 'includes/objectcache/RedisBagOStuff.php',
	'SqlBagOStuff' => 'includes/objectcache/SqlBagOStuff.php',
	'WinCacheBagOStuff' => 'includes/objectcache/WinCacheBagOStuff.php',
	'XCacheBagOStuff' => 'includes/objectcache/XCacheBagOStuff.php',

	# includes/page
	'Article' => 'includes/page/Article.php',
	'CategoryPage' => 'includes/page/CategoryPage.php',
	'ImageHistoryList' => 'includes/page/ImagePage.php',
	'ImageHistoryPseudoPager' => 'includes/page/ImagePage.php',
	'ImagePage' => 'includes/page/ImagePage.php',
	'Page' => 'includes/page/WikiPage.php',
	'WikiCategoryPage' => 'includes/page/WikiCategoryPage.php',
	'WikiFilePage' => 'includes/page/WikiFilePage.php',
	'WikiPage' => 'includes/page/WikiPage.php',

	# includes/pager
	'AlphabeticPager' => 'includes/pager/AlphabeticPager.php',
	'IndexPager' => 'includes/pager/IndexPager.php',
	'Pager' => 'includes/pager/Pager.php',
	'ReverseChronologicalPager' => 'includes/pager/ReverseChronologicalPager.php',
	'TablePager' => 'includes/pager/TablePager.php',

	# includes/parser
	'CacheTime' => 'includes/parser/CacheTime.php',
	'CoreParserFunctions' => 'includes/parser/CoreParserFunctions.php',
	'CoreTagHooks' => 'includes/parser/CoreTagHooks.php',
	'DateFormatter' => 'includes/parser/DateFormatter.php',
	'LinkHolderArray' => 'includes/parser/LinkHolderArray.php',
	'MWTidy' => 'includes/parser/MWTidy.php',
	'MWTidyWrapper' => 'includes/parser/MWTidy.php',
	'PPCustomFrame_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPCustomFrame_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDAccum_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDPart' => 'includes/parser/Preprocessor_DOM.php',
	'PPDPart_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDStack' => 'includes/parser/Preprocessor_DOM.php',
	'PPDStackElement' => 'includes/parser/Preprocessor_DOM.php',
	'PPDStackElement_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPDStack_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPFrame' => 'includes/parser/Preprocessor.php',
	'PPFrame_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPFrame_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode' => 'includes/parser/Preprocessor.php',
	'PPNode_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPNode_Hash_Array' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode_Hash_Attr' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode_Hash_Text' => 'includes/parser/Preprocessor_Hash.php',
	'PPNode_Hash_Tree' => 'includes/parser/Preprocessor_Hash.php',
	'PPTemplateFrame_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'PPTemplateFrame_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'Parser' => 'includes/parser/Parser.php',
	'ParserCache' => 'includes/parser/ParserCache.php',
	'ParserOptions' => 'includes/parser/ParserOptions.php',
	'ParserOutput' => 'includes/parser/ParserOutput.php',
	'ParserDiffTest' => 'includes/parser/ParserDiffTest.php',
	'Preprocessor' => 'includes/parser/Preprocessor.php',
	'Preprocessor_DOM' => 'includes/parser/Preprocessor_DOM.php',
	'Preprocessor_Hash' => 'includes/parser/Preprocessor_Hash.php',
	'StripState' => 'includes/parser/StripState.php',

	# includes/password
	'BcryptPassword' => 'includes/password/BcryptPassword.php',
	'InvalidPassword' => 'includes/password/InvalidPassword.php',
	'LayeredParameterizedPassword' => 'includes/password/LayeredParameterizedPassword.php',
	'MWSaltedPassword' => 'includes/password/MWSaltedPassword.php',
	'MWOldPassword' => 'includes/password/MWOldPassword.php',
	'ParameterizedPassword' => 'includes/password/ParameterizedPassword.php',
	'Password' => 'includes/password/Password.php',
	'PasswordError' => 'includes/password/PasswordError.php',
	'PasswordFactory' => 'includes/password/PasswordFactory.php',
	'Pbkdf2Password' => 'includes/password/Pbkdf2Password.php',
	'EncryptedPassword' => 'includes/password/EncryptedPassword.php',

	# includes/profiler
	'Profiler' => 'includes/profiler/Profiler.php',
	'ProfilerMwprof' => 'includes/profiler/ProfilerMwprof.php',
	'ProfilerSimpleDB' => 'includes/profiler/ProfilerSimpleDB.php',
	'ProfilerSimpleText' => 'includes/profiler/ProfilerSimpleText.php',
	'ProfilerSimpleTrace' => 'includes/profiler/ProfilerSimpleTrace.php',
	'ProfilerSimpleUDP' => 'includes/profiler/ProfilerSimpleUDP.php',
	'ProfilerStandard' => 'includes/profiler/ProfilerStandard.php',
	'ProfilerStub' => 'includes/profiler/ProfilerStub.php',
	'ProfileSection' => 'includes/profiler/Profiler.php',
	'TransactionProfiler' => 'includes/profiler/Profiler.php',

	# includes/rcfeed
	'RCFeedEngine' => 'includes/rcfeed/RCFeedEngine.php',
	'RedisPubSubFeedEngine' => 'includes/rcfeed/RedisPubSubFeedEngine.php',
	'UDPRCFeedEngine' => 'includes/rcfeed/UDPRCFeedEngine.php',
	'RCFeedFormatter' => 'includes/rcfeed/RCFeedFormatter.php',
	'IRCColourfulRCFeedFormatter' => 'includes/rcfeed/IRCColourfulRCFeedFormatter.php',
	'JSONRCFeedFormatter' => 'includes/rcfeed/JSONRCFeedFormatter.php',
	'XMLRCFeedFormatter' => 'includes/rcfeed/XMLRCFeedFormatter.php',
	'MachineReadableRCFeedFormatter' => 'includes/rcfeed/MachineReadableRCFeedFormatter.php',

	# includes/resourceloader
	'DerivativeResourceLoaderContext' =>
		'includes/resourceloader/DerivativeResourceLoaderContext.php',
	'ResourceLoader' => 'includes/resourceloader/ResourceLoader.php',
	'ResourceLoaderContext' => 'includes/resourceloader/ResourceLoaderContext.php',
	'ResourceLoaderEditToolbarModule' => 'includes/resourceloader/ResourceLoaderEditToolbarModule.php',
	'ResourceLoaderFileModule' => 'includes/resourceloader/ResourceLoaderFileModule.php',
	'ResourceLoaderFilePageModule' => 'includes/resourceloader/ResourceLoaderFilePageModule.php',
	'ResourceLoaderFilePath' => 'includes/resourceloader/ResourceLoaderFilePath.php',
	'ResourceLoaderLESSFunctions' => 'includes/resourceloader/ResourceLoaderLESSFunctions.php',
	'ResourceLoaderModule' => 'includes/resourceloader/ResourceLoaderModule.php',
	'ResourceLoaderNoscriptModule' => 'includes/resourceloader/ResourceLoaderNoscriptModule.php',
	'ResourceLoaderSiteModule' => 'includes/resourceloader/ResourceLoaderSiteModule.php',
	'ResourceLoaderStartUpModule' => 'includes/resourceloader/ResourceLoaderStartUpModule.php',
	'ResourceLoaderUserCSSPrefsModule' =>
		'includes/resourceloader/ResourceLoaderUserCSSPrefsModule.php',
	'ResourceLoaderUserGroupsModule' => 'includes/resourceloader/ResourceLoaderUserGroupsModule.php',
	'ResourceLoaderUserModule' => 'includes/resourceloader/ResourceLoaderUserModule.php',
	'ResourceLoaderUserOptionsModule' => 'includes/resourceloader/ResourceLoaderUserOptionsModule.php',
	'ResourceLoaderUserTokensModule' => 'includes/resourceloader/ResourceLoaderUserTokensModule.php',
	'ResourceLoaderLanguageDataModule' =>
		'includes/resourceloader/ResourceLoaderLanguageDataModule.php',
	'ResourceLoaderLanguageNamesModule' =>
		'includes/resourceloader/ResourceLoaderLanguageNamesModule.php',
	'ResourceLoaderWikiModule' => 'includes/resourceloader/ResourceLoaderWikiModule.php',

	# includes/revisiondelete
	'RevDelArchivedFileItem' => 'includes/revisiondelete/RevDelArchivedFileItem.php',
	'RevDelArchivedFileList' => 'includes/revisiondelete/RevDelArchivedFileList.php',
	'RevDelArchivedRevisionItem' => 'includes/revisiondelete/RevDelArchivedRevisionItem.php',
	'RevDelArchiveItem' => 'includes/revisiondelete/RevDelArchiveItem.php',
	'RevDelArchiveList' => 'includes/revisiondelete/RevDelArchiveList.php',
	'RevDelFileItem' => 'includes/revisiondelete/RevDelFileItem.php',
	'RevDelFileList' => 'includes/revisiondelete/RevDelFileList.php',
	'RevDelItem' => 'includes/revisiondelete/RevDelItem.php',
	'RevDelList' => 'includes/revisiondelete/RevDelList.php',
	'RevDelLogItem' => 'includes/revisiondelete/RevDelLogItem.php',
	'RevDelLogList' => 'includes/revisiondelete/RevDelLogList.php',
	'RevDelRevisionItem' => 'includes/revisiondelete/RevDelRevisionItem.php',
	'RevDelRevisionList' => 'includes/revisiondelete/RevDelRevisionList.php',
	'RevisionDeleter' => 'includes/revisiondelete/RevisionDeleter.php',
	'RevisionDeleteUser' => 'includes/revisiondelete/RevisionDeleteUser.php',

	# includes/search
	'SearchDatabase' => 'includes/search/SearchDatabase.php',
	'SearchEngine' => 'includes/search/SearchEngine.php',
	'SearchEngineDummy' => 'includes/search/SearchEngine.php',
	'SearchHighlighter' => 'includes/search/SearchHighlighter.php',
	'SearchMssql' => 'includes/search/SearchMssql.php',
	'SearchMySQL' => 'includes/search/SearchMySQL.php',
	'SearchNearMatchResultSet' => 'includes/search/SearchResultSet.php',
	'SearchOracle' => 'includes/search/SearchOracle.php',
	'SearchPostgres' => 'includes/search/SearchPostgres.php',
	'SearchResult' => 'includes/search/SearchResult.php',
	'SearchResultSet' => 'includes/search/SearchResultSet.php',
	'SearchSqlite' => 'includes/search/SearchSqlite.php',
	'SqlSearchResultSet' => 'includes/search/SearchResultSet.php',

	# includes/site
	'MediaWikiSite' => 'includes/site/MediaWikiSite.php',
	'Site' => 'includes/site/Site.php',
	'SiteObject' => 'includes/site/Site.php',
	'SiteArray' => 'includes/site/SiteList.php',
	'SiteList' => 'includes/site/SiteList.php',
	'SiteSQLStore' => 'includes/site/SiteSQLStore.php',
	'Sites' => 'includes/site/SiteSQLStore.php',
	'SiteStore' => 'includes/site/SiteStore.php',

	# includes/skins
	'BaseTemplate' => 'includes/skins/SkinTemplate.php',
	'MediaWikiI18N' => 'includes/skins/SkinTemplate.php',
	'QuickTemplate' => 'includes/skins/SkinTemplate.php',
	'Skin' => 'includes/skins/Skin.php',
	'SkinException' => 'includes/skins/SkinException.php',
	'SkinFactory' => 'includes/skins/SkinFactory.php',
	'SkinFallback' => 'includes/skins/SkinFallback.php',
	'SkinFallbackTemplate' => 'includes/skins/SkinFallbackTemplate.php',
	'SkinTemplate' => 'includes/skins/SkinTemplate.php',

	# includes/specialpage
	'ChangesListSpecialPage' => 'includes/specialpage/ChangesListSpecialPage.php',
	'FormSpecialPage' => 'includes/specialpage/FormSpecialPage.php',
	'ImageQueryPage' => 'includes/specialpage/ImageQueryPage.php',
	'IncludableSpecialPage' => 'includes/specialpage/IncludableSpecialPage.php',
	'PageQueryPage' => 'includes/specialpage/PageQueryPage.php',
	'QueryPage' => 'includes/specialpage/QueryPage.php',
	'RedirectSpecialArticle' => 'includes/specialpage/RedirectSpecialPage.php',
	'RedirectSpecialPage' => 'includes/specialpage/RedirectSpecialPage.php',
	'SpecialPage' => 'includes/specialpage/SpecialPage.php',
	'SpecialPageFactory' => 'includes/specialpage/SpecialPageFactory.php',
	'SpecialRedirectToSpecial' => 'includes/specialpage/RedirectSpecialPage.php',
	'UnlistedSpecialPage' => 'includes/specialpage/UnlistedSpecialPage.php',
	'WantedQueryPage' => 'includes/specialpage/WantedQueryPage.php',

	# includes/specials
	'ActiveUsersPager' => 'includes/specials/SpecialActiveusers.php',
	'AllMessagesTablePager' => 'includes/specials/SpecialAllMessages.php',
	'AncientPagesPage' => 'includes/specials/SpecialAncientpages.php',
	'BlockListPager' => 'includes/specials/SpecialBlockList.php',
	'BrokenRedirectsPage' => 'includes/specials/SpecialBrokenRedirects.php',
	'CategoryPager' => 'includes/specials/SpecialCategories.php',
	'ContribsPager' => 'includes/specials/SpecialContributions.php',
	'DeadendPagesPage' => 'includes/specials/SpecialDeadendpages.php',
	'DeletedContribsPager' => 'includes/specials/SpecialDeletedContributions.php',
	'DeletedContributionsPage' => 'includes/specials/SpecialDeletedContributions.php',
	'DoubleRedirectsPage' => 'includes/specials/SpecialDoubleRedirects.php',
	'EditWatchlistCheckboxSeriesField' => 'includes/specials/SpecialEditWatchlist.php',
	'EditWatchlistNormalHTMLForm' => 'includes/specials/SpecialEditWatchlist.php',
	'EmailConfirmation' => 'includes/specials/SpecialConfirmemail.php',
	'EmailInvalidation' => 'includes/specials/SpecialConfirmemail.php',
	'FewestrevisionsPage' => 'includes/specials/SpecialFewestrevisions.php',
	'FileDuplicateSearchPage' => 'includes/specials/SpecialFileDuplicateSearch.php',
	'ImageListPager' => 'includes/specials/SpecialListfiles.php',
	'ImportReporter' => 'includes/specials/SpecialImport.php',
	'LinkSearchPage' => 'includes/specials/SpecialLinkSearch.php',
	'ListredirectsPage' => 'includes/specials/SpecialListredirects.php',
	'ListDuplicatedFilesPage' => 'includes/specials/SpecialListDuplicatedFiles.php',
	'LoginForm' => 'includes/specials/SpecialUserlogin.php',
	'LonelyPagesPage' => 'includes/specials/SpecialLonelypages.php',
	'LongPagesPage' => 'includes/specials/SpecialLongpages.php',
	'MergeHistoryPager' => 'includes/specials/SpecialMergeHistory.php',
	'MIMEsearchPage' => 'includes/specials/SpecialMIMEsearch.php',
	'MostcategoriesPage' => 'includes/specials/SpecialMostcategories.php',
	'MostimagesPage' => 'includes/specials/SpecialMostimages.php',
	'MostinterwikisPage' => 'includes/specials/SpecialMostinterwikis.php',
	'MostlinkedCategoriesPage' => 'includes/specials/SpecialMostlinkedcategories.php',
	'MostlinkedPage' => 'includes/specials/SpecialMostlinked.php',
	'MostlinkedTemplatesPage' => 'includes/specials/SpecialMostlinkedtemplates.php',
	'MostrevisionsPage' => 'includes/specials/SpecialMostrevisions.php',
	'MovePageForm' => 'includes/specials/SpecialMovepage.php',
	'NewFilesPager' => 'includes/specials/SpecialNewimages.php',
	'NewPagesPager' => 'includes/specials/SpecialNewpages.php',
	'PageArchive' => 'includes/specials/SpecialUndelete.php',
	'PopularPagesPage' => 'includes/specials/SpecialPopularpages.php',
	'ProtectedPagesPager' => 'includes/specials/SpecialProtectedpages.php',
	'ProtectedTitlesPager' => 'includes/specials/SpecialProtectedtitles.php',
	'RandomPage' => 'includes/specials/SpecialRandompage.php',
	'ShortPagesPage' => 'includes/specials/SpecialShortpages.php',
	'SpecialActiveUsers' => 'includes/specials/SpecialActiveusers.php',
	'SpecialAllMessages' => 'includes/specials/SpecialAllMessages.php',
	'SpecialAllMyUploads' => 'includes/specials/SpecialMyRedirectPages.php',
	'SpecialAllPages' => 'includes/specials/SpecialAllPages.php',
	'SpecialBlankpage' => 'includes/specials/SpecialBlankpage.php',
	'SpecialBlock' => 'includes/specials/SpecialBlock.php',
	'SpecialBlockList' => 'includes/specials/SpecialBlockList.php',
	'SpecialBookSources' => 'includes/specials/SpecialBooksources.php',
	'SpecialCachedPage' => 'includes/specials/SpecialCachedPage.php',
	'SpecialCategories' => 'includes/specials/SpecialCategories.php',
	'SpecialChangeEmail' => 'includes/specials/SpecialChangeEmail.php',
	'SpecialChangePassword' => 'includes/specials/SpecialChangePassword.php',
	'SpecialComparePages' => 'includes/specials/SpecialComparePages.php',
	'SpecialContributions' => 'includes/specials/SpecialContributions.php',
	'SpecialCreateAccount' => 'includes/specials/SpecialCreateAccount.php',
	'SpecialDiff' => 'includes/specials/SpecialDiff.php',
	'SpecialEditWatchlist' => 'includes/specials/SpecialEditWatchlist.php',
	'SpecialEmailUser' => 'includes/specials/SpecialEmailuser.php',
	'SpecialExpandTemplates' => 'includes/specials/SpecialExpandTemplates.php',
	'SpecialExport' => 'includes/specials/SpecialExport.php',
	'SpecialFilepath' => 'includes/specials/SpecialFilepath.php',
	'SpecialImport' => 'includes/specials/SpecialImport.php',
	'SpecialJavaScriptTest' => 'includes/specials/SpecialJavaScriptTest.php',
	'SpecialListAdmins' => 'includes/specials/SpecialListusers.php',
	'SpecialListBots' => 'includes/specials/SpecialListusers.php',
	'SpecialListFiles' => 'includes/specials/SpecialListfiles.php',
	'SpecialListGroupRights' => 'includes/specials/SpecialListgrouprights.php',
	'SpecialListUsers' => 'includes/specials/SpecialListusers.php',
	'SpecialLockdb' => 'includes/specials/SpecialLockdb.php',
	'SpecialLog' => 'includes/specials/SpecialLog.php',
	'SpecialMergeHistory' => 'includes/specials/SpecialMergeHistory.php',
	'SpecialMycontributions' => 'includes/specials/SpecialMyRedirectPages.php',
	'SpecialMyLanguage' => 'includes/specials/SpecialMyLanguage.php',
	'SpecialMypage' => 'includes/specials/SpecialMyRedirectPages.php',
	'SpecialMytalk' => 'includes/specials/SpecialMyRedirectPages.php',
	'SpecialMyuploads' => 'includes/specials/SpecialMyRedirectPages.php',
	'SpecialNewFiles' => 'includes/specials/SpecialNewimages.php',
	'SpecialNewpages' => 'includes/specials/SpecialNewpages.php',
	'SpecialPageLanguage' => 'includes/specials/SpecialPageLanguage.php',
	'SpecialPasswordReset' => 'includes/specials/SpecialPasswordReset.php',
	'SpecialPagesWithProp' => 'includes/specials/SpecialPagesWithProp.php',
	'SpecialPermanentLink' => 'includes/specials/SpecialPermanentLink.php',
	'SpecialPreferences' => 'includes/specials/SpecialPreferences.php',
	'SpecialPrefixindex' => 'includes/specials/SpecialPrefixindex.php',
	'SpecialProtectedpages' => 'includes/specials/SpecialProtectedpages.php',
	'SpecialProtectedtitles' => 'includes/specials/SpecialProtectedtitles.php',
	'SpecialRandomInCategory' => 'includes/specials/SpecialRandomInCategory.php',
	'SpecialRandomredirect' => 'includes/specials/SpecialRandomredirect.php',
	'SpecialRecentChanges' => 'includes/specials/SpecialRecentchanges.php',
	'SpecialRecentChangesLinked' => 'includes/specials/SpecialRecentchangeslinked.php',
	'SpecialRedirect' => 'includes/specials/SpecialRedirect.php',
	'SpecialResetTokens' => 'includes/specials/SpecialResetTokens.php',
	'SpecialRevisionDelete' => 'includes/specials/SpecialRevisiondelete.php',
	'SpecialRunJobs' => 'includes/specials/SpecialRunJobs.php',
	'SpecialSearch' => 'includes/specials/SpecialSearch.php',
	'SpecialSpecialpages' => 'includes/specials/SpecialSpecialpages.php',
	'SpecialStatistics' => 'includes/specials/SpecialStatistics.php',
	'SpecialTags' => 'includes/specials/SpecialTags.php',
	'SpecialTrackingCategories' => 'includes/specials/SpecialTrackingCategories.php',
	'SpecialUnblock' => 'includes/specials/SpecialUnblock.php',
	'SpecialUndelete' => 'includes/specials/SpecialUndelete.php',
	'SpecialUnlockdb' => 'includes/specials/SpecialUnlockdb.php',
	'SpecialUpload' => 'includes/specials/SpecialUpload.php',
	'SpecialUploadStash' => 'includes/specials/SpecialUploadStash.php',
	'SpecialUploadStashTooLargeException' => 'includes/specials/SpecialUploadStash.php',
	'SpecialUserlogout' => 'includes/specials/SpecialUserlogout.php',
	'SpecialVersion' => 'includes/specials/SpecialVersion.php',
	'SpecialWatchlist' => 'includes/specials/SpecialWatchlist.php',
	'SpecialWhatLinksHere' => 'includes/specials/SpecialWhatlinkshere.php',
	'UncategorizedCategoriesPage' => 'includes/specials/SpecialUncategorizedcategories.php',
	'UncategorizedImagesPage' => 'includes/specials/SpecialUncategorizedimages.php',
	'UncategorizedPagesPage' => 'includes/specials/SpecialUncategorizedpages.php',
	'UncategorizedTemplatesPage' => 'includes/specials/SpecialUncategorizedtemplates.php',
	'UnusedCategoriesPage' => 'includes/specials/SpecialUnusedcategories.php',
	'UnusedimagesPage' => 'includes/specials/SpecialUnusedimages.php',
	'UnusedtemplatesPage' => 'includes/specials/SpecialUnusedtemplates.php',
	'UnwatchedpagesPage' => 'includes/specials/SpecialUnwatchedpages.php',
	'UploadChunkFileException' => 'includes/upload/UploadFromChunks.php',
	'UploadChunkZeroLengthFileException' => 'includes/upload/UploadFromChunks.php',
	'UploadChunkVerificationException' => 'includes/upload/UploadFromChunks.php',
	'UploadForm' => 'includes/specials/SpecialUpload.php',
	'UploadSourceField' => 'includes/specials/SpecialUpload.php',
	'UserrightsPage' => 'includes/specials/SpecialUserrights.php',
	'UsersPager' => 'includes/specials/SpecialListusers.php',
	'WantedCategoriesPage' => 'includes/specials/SpecialWantedcategories.php',
	'WantedFilesPage' => 'includes/specials/SpecialWantedfiles.php',
	'WantedPagesPage' => 'includes/specials/SpecialWantedpages.php',
	'WantedTemplatesPage' => 'includes/specials/SpecialWantedtemplates.php',
	'WithoutInterwikiPage' => 'includes/specials/SpecialWithoutinterwiki.php',

	# includes/templates
	'UserloginTemplate' => 'includes/templates/Userlogin.php',
	'UsercreateTemplate' => 'includes/templates/Usercreate.php',

	# includes/title
	'PageLinkRenderer' => 'includes/title/PageLinkRenderer.php',
	'TitleFormatter' => 'includes/title/TitleFormatter.php',
	'TitleParser' => 'includes/title/TitleParser.php',
	'TitleValue' => 'includes/title/TitleValue.php',
	'MalformedTitleException' => 'includes/title/MalformedTitleException.php',
	'MediaWikiPageLinkRenderer' => 'includes/title/MediaWikiPageLinkRenderer.php',
	'MediaWikiTitleCodec' => 'includes/title/MediaWikiTitleCodec.php',

	# includes/upload
	'UploadBase' => 'includes/upload/UploadBase.php',
	'UploadFromFile' => 'includes/upload/UploadFromFile.php',
	'UploadFromChunks' => 'includes/upload/UploadFromChunks.php',
	'UploadFromStash' => 'includes/upload/UploadFromStash.php',
	'UploadFromUrl' => 'includes/upload/UploadFromUrl.php',
	'UploadStash' => 'includes/upload/UploadStash.php',
	'UploadStashBadPathException' => 'includes/upload/UploadStash.php',
	'UploadStashException' => 'includes/upload/UploadStash.php',
	'UploadStashFile' => 'includes/upload/UploadStash.php',
	'UploadStashFileException' => 'includes/upload/UploadStash.php',
	'UploadStashFileNotFoundException' => 'includes/upload/UploadStash.php',
	'UploadStashNotAvailableException' => 'includes/upload/UploadStash.php',
	'UploadStashZeroLengthFileException' => 'includes/upload/UploadStash.php',
	'UploadStashNotLoggedInException' => 'includes/upload/UploadStash.php',
	'UploadStashWrongOwnerException' => 'includes/upload/UploadStash.php',
	'UploadStashNoSuchKeyException' => 'includes/upload/UploadStash.php',

	# includes/utils
	'ArrayUtils' => 'includes/utils/ArrayUtils.php',
	'CdbException' => 'includes/utils/Cdb.php',
	'CdbFunctions' => 'includes/utils/CdbPHP.php',
	'CdbReader' => 'includes/utils/Cdb.php',
	'CdbReaderDBA' => 'includes/utils/CdbDBA.php',
	'CdbReaderPHP' => 'includes/utils/CdbPHP.php',
	'CdbWriter' => 'includes/utils/Cdb.php',
	'CdbWriterDBA' => 'includes/utils/CdbDBA.php',
	'CdbWriterPHP' => 'includes/utils/CdbPHP.php',
	'DoubleReplacer' => 'includes/utils/StringUtils.php',
	'ExplodeIterator' => 'includes/utils/StringUtils.php',
	'HashtableReplacer' => 'includes/utils/StringUtils.php',
	'IP' => 'includes/utils/IP.php',
	'MWCryptRand' => 'includes/utils/MWCryptRand.php',
	'MWCryptHKDF' => 'includes/utils/MWCryptHKDF.php',
	'MWFunction' => 'includes/utils/MWFunction.php',
	'RegexlikeReplacer' => 'includes/utils/StringUtils.php',
	'ReplacementArray' => 'includes/utils/StringUtils.php',
	'Replacer' => 'includes/utils/StringUtils.php',
	'StringUtils' => 'includes/utils/StringUtils.php',
	'UIDGenerator' => 'includes/utils/UIDGenerator.php',
	'ZipDirectoryReader' => 'includes/utils/ZipDirectoryReader.php',
	'ZipDirectoryReaderError' => 'includes/utils/ZipDirectoryReader.php',

	# languages
	'ConverterRule' => 'languages/ConverterRule.php',
	'FakeConverter' => 'languages/FakeConverter.php',
	'Language' => 'languages/Language.php',
	'LanguageConverter' => 'languages/LanguageConverter.php',
	'CLDRPluralRuleConverter' => 'languages/utils/CLDRPluralRuleConverter.php',
	'CLDRPluralRuleConverterExpression' => 'languages/utils/CLDRPluralRuleConverterExpression.php',
	'CLDRPluralRuleConverterFragment' => 'languages/utils/CLDRPluralRuleConverterFragment.php',
	'CLDRPluralRuleConverterOperator' => 'languages/utils/CLDRPluralRuleConverterOperator.php',
	'CLDRPluralRuleEvaluator' => 'languages/utils/CLDRPluralRuleEvaluator.php',
	'CLDRPluralRuleEvaluatorRange' => 'languages/utils/CLDRPluralRuleEvaluatorRange.php',
	'CLDRPluralRuleError' => 'languages/utils/CLDRPluralRuleError.php',

	# maintenance
	'BackupDumper' => 'maintenance/backup.inc',
	'ConvertLinks' => 'maintenance/convertLinks.php',
	'DeleteArchivedFilesImplementation' => 'maintenance/deleteArchivedFiles.inc',
	'DeleteArchivedRevisionsImplementation' => 'maintenance/deleteArchivedRevisions.inc',
	'DeleteDefaultMessages' => 'maintenance/deleteDefaultMessages.php',
	'DumpDBZip2Output' => 'maintenance/backup.inc',
	'ExportProgressFilter' => 'maintenance/backup.inc',
	'FakeMaintenance' => 'maintenance/Maintenance.php',
	'FixExtLinksProtocolRelative' => 'maintenance/fixExtLinksProtocolRelative.php',
	'LoggedUpdateMaintenance' => 'maintenance/Maintenance.php',
	'Maintenance' => 'maintenance/Maintenance.php',
	'PopulateBacklinkNamespace' => 'maintenance/populateBacklinkNamespace.php',
	'PopulateCategory' => 'maintenance/populateCategory.php',
	'PopulateImageSha1' => 'maintenance/populateImageSha1.php',
	'PopulateFilearchiveSha1' => 'maintenance/populateFilearchiveSha1.php',
	'PopulateLogSearch' => 'maintenance/populateLogSearch.php',
	'PopulateLogUsertext' => 'maintenance/populateLogUsertext.php',
	'PopulateParentId' => 'maintenance/populateParentId.php',
	'PopulateRevisionLength' => 'maintenance/populateRevisionLength.php',
	'PopulateRevisionSha1' => 'maintenance/populateRevisionSha1.php',
	'RefreshLinks' => 'maintenance/refreshLinks.php',
	'SevenZipStream' => 'maintenance/7zip.inc',
	'Sqlite' => 'maintenance/sqlite.inc',
	'UpdateCollation' => 'maintenance/updateCollation.php',
	'UpdateRestrictions' => 'maintenance/updateRestrictions.php',
	'UserDupes' => 'maintenance/userDupes.inc',

	# maintenance/language
	'CsvStatsOutput' => 'maintenance/language/StatOutputs.php',
	'ExtensionLanguages' => 'maintenance/language/languages.inc',
	'Languages' => 'maintenance/language/languages.inc',
	'StatsOutput' => 'maintenance/language/StatOutputs.php',
	'TextStatsOutput' => 'maintenance/language/StatOutputs.php',
	'WikiStatsOutput' => 'maintenance/language/StatOutputs.php',

	# maintenance/term
	'AnsiTermColorer' => 'maintenance/term/MWTerm.php',
	'DummyTermColorer' => 'maintenance/term/MWTerm.php',

	# mw-config
	'InstallerOverrides' => 'mw-config/overrides.php',
	'MyLocalSettingsGenerator' => 'mw-config/overrides.php',
);

class AutoLoader {
	static protected $autoloadLocalClassesLower = null;

	/**
	 * autoload - take a class name and attempt to load it
	 *
	 * @param string $className Name of class we're looking for.
	 */
	static function autoload( $className ) {
		global $wgAutoloadClasses, $wgAutoloadLocalClasses,
			$wgAutoloadAttemptLowercase;

		// Workaround for PHP bug <https://bugs.php.net/bug.php?id=49143> (5.3.2. is broken, it's
		// fixed in 5.3.6). Strip leading backslashes from class names. When namespaces are used,
		// leading backslashes are used to indicate the top-level namespace, e.g. \foo\Bar. When
		// used like this in the code, the leading backslash isn't passed to the auto-loader
		// ($className would be 'foo\Bar'). However, if a class is accessed using a string instead
		// of a class literal (e.g. $class = '\foo\Bar'; new $class()), then some versions of PHP
		// do not strip the leading backlash in this case, causing autoloading to fail.
		$className = ltrim( $className, '\\' );

		$filename = false;

		if ( isset( $wgAutoloadLocalClasses[$className] ) ) {
			$filename = $wgAutoloadLocalClasses[$className];
		} elseif ( isset( $wgAutoloadClasses[$className] ) ) {
			$filename = $wgAutoloadClasses[$className];
		} elseif ( $wgAutoloadAttemptLowercase ) {
			/*
			 * Try a different capitalisation.
			 *
			 * PHP 4 objects are always serialized with the classname coerced to lowercase,
			 * and we are plagued with several legacy uses created by MediaWiki < 1.5, see
			 * https://wikitech.wikimedia.org/wiki/Text_storage_data
			 */
			$lowerClass = strtolower( $className );

			if ( self::$autoloadLocalClassesLower === null ) {
				self::$autoloadLocalClassesLower = array_change_key_case( $wgAutoloadLocalClasses, CASE_LOWER );
			}

			if ( isset( self::$autoloadLocalClassesLower[$lowerClass] ) ) {
				if ( function_exists( 'wfDebugLog' ) ) {
					wfDebugLog( 'autoloader', "Class {$className} was loaded using incorrect case" );
				}
				$filename = self::$autoloadLocalClassesLower[$lowerClass];
			}
		}

		if ( !$filename ) {
			// Class not found; let the next autoloader try to find it
			return;
		}

		// Make an absolute path, this improves performance by avoiding some stat calls
		if ( substr( $filename, 0, 1 ) != '/' && substr( $filename, 1, 1 ) != ':' ) {
			global $IP;
			$filename = "$IP/$filename";
		}

		require $filename;
	}

	/**
	 * Force a class to be run through the autoloader, helpful for things like
	 * Sanitizer that have define()s outside of their class definition. Of course
	 * this wouldn't be necessary if everything in MediaWiki was class-based. Sigh.
	 *
	 * @param string $class
	 * @return bool Return the results of class_exists() so we know if we were successful
	 */
	static function loadClass( $class ) {
		return class_exists( $class );
	}

	/**
	 * Method to clear the protected class property $autoloadLocalClassesLower.
	 * Used in tests.
	 */
	static function resetAutoloadLocalClassesLower() {
		self::$autoloadLocalClassesLower = null;
	}
}

spl_autoload_register( array( 'AutoLoader', 'autoload' ) );
