use strict;
use warnings FATAL => 'all';

use Apache::Test;
use Apache::TestRequest;
use Apache::TestUtil;

plan tests => 3, need 'proxy', need_min_apache_version('2.2.5');

Apache::TestRequest::module("cve_2011_3368");
         
my $sock = Apache::TestRequest::vhost_socket();
ok $sock && $sock->connected;

my $req = "GET @"."localhost/foobar.html HTTP/1.1\r\n".
   "Host: " . Apache::TestRequest::hostport() . "\r\n".
    "\r\n"; 

ok $sock->print($req);

my $line = Apache::TestRequest::getline($sock) || '';

ok t_cmp($line, qr{^HTTP/1\.. 400 Bad Request}, "got 400 error");
