/* { dg-options "-mlasx -w -fno-strict-aliasing" } */
#include "../simd_correctness_check.h"
#include <lasxintrin.h>

int
main ()
{
  __m256i __m256i_op0, __m256i_op1, __m256i_op2, __m256i_out, __m256i_result;
  __m256 __m256_op0, __m256_op1, __m256_op2, __m256_out, __m256_result;
  __m256d __m256d_op0, __m256d_op1, __m256d_op2, __m256d_out, __m256d_result;

  int int_op0, int_op1, int_op2, int_out, int_result, i = 1, fail;
  long int long_op0, long_op1, long_op2, lont_out, lont_result;
  long int long_int_out, long_int_result;
  unsigned int unsigned_int_out, unsigned_int_result;
  unsigned long int unsigned_long_int_out, unsigned_long_int_result;

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000009;
  __m256i_out = __lasx_xvsub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000ffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000ffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000ffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000010100000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000010100000000;
  __m256i_out = __lasx_xvsub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000ffbe20fc;
  *((unsigned long *)&__m256i_op0[2]) = 0x000000001cc7ee87;
  *((unsigned long *)&__m256i_op0[1]) = 0x000000010bb83239;
  *((unsigned long *)&__m256i_op0[0]) = 0x00000000c409ed87;
  *((unsigned long *)&__m256i_op1[3]) = 0xff00fe00feff02ff;
  *((unsigned long *)&__m256i_op1[2]) = 0xff00fe00feff02ff;
  *((unsigned long *)&__m256i_op1[1]) = 0xff00fe00feff02ff;
  *((unsigned long *)&__m256i_op1[0]) = 0xff00fe00feff02ff;
  *((unsigned long *)&__m256i_result[3]) = 0x0100020001bf1efd;
  *((unsigned long *)&__m256i_result[2]) = 0x010002001ec8ec88;
  *((unsigned long *)&__m256i_result[1]) = 0x010002010db9303a;
  *((unsigned long *)&__m256i_result[0]) = 0x01000200c60aeb88;
  __m256i_out = __lasx_xvsub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_result[2]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_result[1]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_result[0]) = 0x0101010101010101;
  __m256i_out = __lasx_xvsub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_op0[2]) = 0x0101010200000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_op0[0]) = 0x0101010200000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_result[2]) = 0x0101010200000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0101010101010101;
  *((unsigned long *)&__m256i_result[0]) = 0x0101010200000000;
  __m256i_out = __lasx_xvsub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x000000007e1c7e1c;
  *((unsigned long *)&__m256i_op0[2]) = 0x7e00000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x000000007e1c7e1c;
  *((unsigned long *)&__m256i_op0[0]) = 0x7e00000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x000000007e1c7e1c;
  *((unsigned long *)&__m256i_result[2]) = 0x7e00000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x000000007e1c7e1c;
  *((unsigned long *)&__m256i_result[0]) = 0x7e00000000000000;
  __m256i_out = __lasx_xvsub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000040004000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000004000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000040004000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000004000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0100010001000100;
  *((unsigned long *)&__m256i_op1[2]) = 0x01ffff4300ffff00;
  *((unsigned long *)&__m256i_op1[1]) = 0x0100010001000100;
  *((unsigned long *)&__m256i_op1[0]) = 0x01ffff4300ffff00;
  *((unsigned long *)&__m256i_result[3]) = 0xff00ff003f003f00;
  *((unsigned long *)&__m256i_result[2]) = 0xff0101fd00010100;
  *((unsigned long *)&__m256i_result[1]) = 0xff00ff003f003f00;
  *((unsigned long *)&__m256i_result[0]) = 0xff0101fd00010100;
  __m256i_out = __lasx_xvsub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsub_b (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op0[0]) = 0x0001000100010001;
  *((unsigned long *)&__m256i_op1[3]) = 0x00ff00ff00000007;
  *((unsigned long *)&__m256i_op1[2]) = 0x00000000000000e7;
  *((unsigned long *)&__m256i_op1[1]) = 0x00ff00ff00000007;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000007;
  *((unsigned long *)&__m256i_result[3]) = 0xff01ff010000fff9;
  *((unsigned long *)&__m256i_result[2]) = 0x000000000000ff19;
  *((unsigned long *)&__m256i_result[1]) = 0xff02ff020001fffa;
  *((unsigned long *)&__m256i_result[0]) = 0x000100010001fffa;
  __m256i_out = __lasx_xvsub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x43d03bfff827ea21;
  *((unsigned long *)&__m256i_op1[2]) = 0x43dac1f2a3804ff0;
  *((unsigned long *)&__m256i_op1[1]) = 0x43d03bfff827e9f9;
  *((unsigned long *)&__m256i_op1[0]) = 0x43e019c657c7d050;
  *((unsigned long *)&__m256i_result[3]) = 0xbc30c40107d915df;
  *((unsigned long *)&__m256i_result[2]) = 0xbc263e0e5c80b010;
  *((unsigned long *)&__m256i_result[1]) = 0xbc30c40107d91607;
  *((unsigned long *)&__m256i_result[0]) = 0xbc20e63aa8392fb0;
  __m256i_out = __lasx_xvsub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xff21c241ff21c241;
  *((unsigned long *)&__m256i_op0[2]) = 0xff21c241ff21c241;
  *((unsigned long *)&__m256i_op0[1]) = 0xff21c241ff21c241;
  *((unsigned long *)&__m256i_op0[0]) = 0xff21c241ff21c241;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000009;
  *((unsigned long *)&__m256i_result[3]) = 0xff21c241ff21c241;
  *((unsigned long *)&__m256i_result[2]) = 0xff21c241ff21c238;
  *((unsigned long *)&__m256i_result[1]) = 0xff21c241ff21c241;
  *((unsigned long *)&__m256i_result[0]) = 0xff21c241ff21c238;
  __m256i_out = __lasx_xvsub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0808080808080808;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0808080808080808;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xf7f8f7f8f7f8f7f8;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0xf7f8f7f8f7f8f7f8;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000e000e000e;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000e0000000d;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000e000e000e;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000e0000000d;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000e000e000e;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000e0000000d;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000e000e000e;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000e0000000d;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x207f207f207f2000;
  *((unsigned long *)&__m256i_op1[2]) = 0x7f7f7f7f7f7f7f7f;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000207f2000;
  *((unsigned long *)&__m256i_op1[0]) = 0x7f7f7f7f7f7f7f7f;
  *((unsigned long *)&__m256i_result[3]) = 0xdf80df80df80dfff;
  *((unsigned long *)&__m256i_result[2]) = 0x8080808080808080;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffdf80dfff;
  *((unsigned long *)&__m256i_result[0]) = 0x8080808080808080;
  __m256i_out = __lasx_xvsub_h (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xc5c5c5c4c5c5c5c4;
  *((unsigned long *)&__m256i_op0[2]) = 0x45c5c5c545c5c5c5;
  *((unsigned long *)&__m256i_op0[1]) = 0xc5c5c5c4c5c5c5c4;
  *((unsigned long *)&__m256i_op0[0]) = 0x45c5c5c545c5c5c5;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0xc5c5c5c5c5c5c5c5;
  *((unsigned long *)&__m256i_result[2]) = 0x45c5c5c645c5c5c6;
  *((unsigned long *)&__m256i_result[1]) = 0xc5c5c5c5c5c5c5c5;
  *((unsigned long *)&__m256i_result[0]) = 0x45c5c5c645c5c5c6;
  __m256i_out = __lasx_xvsub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x1f0fdf7f3e3b31d4;
  *((unsigned long *)&__m256i_op1[2]) = 0x7ff8000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x1f0fdf7f3e3b31d4;
  *((unsigned long *)&__m256i_op1[0]) = 0x7ff8000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xe0f02081c1c4ce2c;
  *((unsigned long *)&__m256i_result[2]) = 0x8008000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0xe0f02081c1c4ce2c;
  *((unsigned long *)&__m256i_result[0]) = 0x8008000000000000;
  __m256i_out = __lasx_xvsub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0xff3eff3eff3eff3e;
  *((unsigned long *)&__m256i_op0[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0xff3eff3eff3eff3e;
  *((unsigned long *)&__m256i_op0[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0xff3eff3eff3eff3e;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0xff3eff3eff3eff3e;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffffffff;
  __m256i_out = __lasx_xvsub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000000001c9880;
  *((unsigned long *)&__m256i_op1[2]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000001c9880;
  *((unsigned long *)&__m256i_op1[0]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000ffe36780;
  *((unsigned long *)&__m256i_result[2]) = 0x8000000100000001;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000ffe36780;
  *((unsigned long *)&__m256i_result[0]) = 0x8000000100000001;
  __m256i_out = __lasx_xvsub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00b213171dff0606;
  *((unsigned long *)&__m256i_op0[2]) = 0x00e9a80014ff0000;
  *((unsigned long *)&__m256i_op0[1]) = 0x00b213171dff0606;
  *((unsigned long *)&__m256i_op0[0]) = 0x00e9a80014ff0000;
  *((unsigned long *)&__m256i_op1[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[3]) = 0x00b213181dff0607;
  *((unsigned long *)&__m256i_result[2]) = 0x00e9a80114ff0001;
  *((unsigned long *)&__m256i_result[1]) = 0x00b213181dff0607;
  *((unsigned long *)&__m256i_result[0]) = 0x00e9a80114ff0001;
  __m256i_out = __lasx_xvsub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000fdfdfe;
  *((unsigned long *)&__m256i_op1[3]) = 0x0001fffe0001fffe;
  *((unsigned long *)&__m256i_op1[2]) = 0x0001fffe00010000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x7ffe0001fffe0001;
  *((unsigned long *)&__m256i_result[2]) = 0x7ffe0001fffeffff;
  *((unsigned long *)&__m256i_result[1]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000fdfdfe;
  __m256i_out = __lasx_xvsub_w (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x7fffffffffffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xffffff90ffffff80;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xffffff90ffffff80;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x8000006f0000007f;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x8000006f0000007f;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x7f7f7f7f7f7f7f7f;
  *((unsigned long *)&__m256i_op1[1]) = 0x7f7f7f7f7f7f7f7f;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x8080808080808081;
  *((unsigned long *)&__m256i_result[1]) = 0x8080808080808081;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00ff00ff00ff00ff;
  *((unsigned long *)&__m256i_op0[2]) = 0x00ff00ff017e01fe;
  *((unsigned long *)&__m256i_op0[1]) = 0x017e00ff017e00ff;
  *((unsigned long *)&__m256i_op0[0]) = 0x00ff00ff017e01fe;
  *((unsigned long *)&__m256i_op1[3]) = 0xe1616161e1614e60;
  *((unsigned long *)&__m256i_op1[2]) = 0xe1616161e1614e60;
  *((unsigned long *)&__m256i_op1[1]) = 0xe1616161e1614e60;
  *((unsigned long *)&__m256i_op1[0]) = 0xe1616161e1614e60;
  *((unsigned long *)&__m256i_result[3]) = 0x1f9d9f9d1f9db29f;
  *((unsigned long *)&__m256i_result[2]) = 0x1f9d9f9d201cb39e;
  *((unsigned long *)&__m256i_result[1]) = 0x201c9f9d201cb29f;
  *((unsigned long *)&__m256i_result[0]) = 0x1f9d9f9d201cb39e;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0xfffeffebfb7afb62;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0xfffeffebfb7afb62;
  *((unsigned long *)&__m256i_op1[3]) = 0xbff0000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0xc192181230000000;
  *((unsigned long *)&__m256i_op1[1]) = 0xbff0000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0xc192181230000000;
  *((unsigned long *)&__m256i_result[3]) = 0x4010000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x3e6ce7d9cb7afb62;
  *((unsigned long *)&__m256i_result[1]) = 0x4010000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x3e6ce7d9cb7afb62;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_result[2]) = 0x0000ffff00000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000ffff0000ffff;
  *((unsigned long *)&__m256i_result[0]) = 0x0000ffff00000000;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000013;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000013;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000013;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000013;
  *((unsigned long *)&__m256i_result[3]) = 0xffffffffffffffed;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffffffffed;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffffffffed;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffffffed;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0fffffff0fffffff;
  *((unsigned long *)&__m256i_op0[2]) = 0x0fffffff0fffffff;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0fffffff0fffffff;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x7fff7fff7fff7fff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x000000007fff7fff;
  *((unsigned long *)&__m256i_result[3]) = 0x0fffffff0fffffff;
  *((unsigned long *)&__m256i_result[2]) = 0x90007fff90008000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0ffffffe90008000;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_result[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffffffff;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x8000000080000000;
  *((unsigned long *)&__m256i_result[3]) = 0x7fffffff80000000;
  *((unsigned long *)&__m256i_result[2]) = 0x7fffffff80000000;
  *((unsigned long *)&__m256i_result[1]) = 0x7fffffff80000000;
  *((unsigned long *)&__m256i_result[0]) = 0x7fffffff80000000;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op1[2]) = 0x05ea05ea05ea05ec;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000001;
  *((unsigned long *)&__m256i_op1[0]) = 0x05ea05ea05ea05ec;
  *((unsigned long *)&__m256i_result[3]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[2]) = 0xfa15fa15fa15fa14;
  *((unsigned long *)&__m256i_result[1]) = 0xffffffffffffffff;
  *((unsigned long *)&__m256i_result[0]) = 0xfa15fa15fa15fa14;
  __m256i_out = __lasx_xvsub_d (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[3]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[2]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[1]) = 0x0000000000000000;
  *((unsigned long *)&__m256i_result[0]) = 0x0000000000000000;
  __m256i_out = __lasx_xvsub_q (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x0505070804040404;
  *((unsigned long *)&__m256i_op0[2]) = 0x0504070804040404;
  *((unsigned long *)&__m256i_op0[1]) = 0x0505070804040404;
  *((unsigned long *)&__m256i_op0[0]) = 0x0504070804040404;
  *((unsigned long *)&__m256i_op1[3]) = 0x0000ff000000ffff;
  *((unsigned long *)&__m256i_op1[2]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_op1[1]) = 0x0000ff000000ffff;
  *((unsigned long *)&__m256i_op1[0]) = 0x000000ff000000ff;
  *((unsigned long *)&__m256i_result[3]) = 0x0504080804030405;
  *((unsigned long *)&__m256i_result[2]) = 0x0504060904040305;
  *((unsigned long *)&__m256i_result[1]) = 0x0504080804030405;
  *((unsigned long *)&__m256i_result[0]) = 0x0504060904040305;
  __m256i_out = __lasx_xvsub_q (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  *((unsigned long *)&__m256i_op0[3]) = 0x00000000fff8fff8;
  *((unsigned long *)&__m256i_op0[2]) = 0x0000ff00fff8ffc0;
  *((unsigned long *)&__m256i_op0[1]) = 0x00000000fff8fff8;
  *((unsigned long *)&__m256i_op0[0]) = 0x0000ff00fff8ffc0;
  *((unsigned long *)&__m256i_op1[3]) = 0x00000000fff8ff40;
  *((unsigned long *)&__m256i_op1[2]) = 0x0000ff0100090040;
  *((unsigned long *)&__m256i_op1[1]) = 0x00000000fff8ff40;
  *((unsigned long *)&__m256i_op1[0]) = 0x0000ff0100090040;
  *((unsigned long *)&__m256i_result[3]) = 0x00000000000000b7;
  *((unsigned long *)&__m256i_result[2]) = 0xffffffffffefff80;
  *((unsigned long *)&__m256i_result[1]) = 0x00000000000000b7;
  *((unsigned long *)&__m256i_result[0]) = 0xffffffffffefff80;
  __m256i_out = __lasx_xvsub_q (__m256i_op0, __m256i_op1);
  ASSERTEQ_64 (__LINE__, __m256i_result, __m256i_out);

  return 0;
}
