; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: llc < %s -mtriple=armv7-linux-gnueabihf -o - | FileCheck %s
; RUN: llc < %s -mtriple=thumbv7em-none-eabi -mcpu=cortex-m4 | FileCheck %s --check-prefix=CHECK-M4F

target datalayout = "e-m:e-p:32:32-i64:64-v128:64:128-n32-S64"

define arm_aapcs_vfpcc void @test_1float({ float } %a) {
; CHECK-LABEL: test_1float:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    vmov.f32 s0, #1.000000e+00
; CHECK-NEXT:    bl test_1float
; CHECK-NEXT:    pop {r11, pc}
;
; CHECK-M4F-LABEL: test_1float:
; CHECK-M4F:       @ %bb.0:
; CHECK-M4F-NEXT:    .save {r7, lr}
; CHECK-M4F-NEXT:    push {r7, lr}
; CHECK-M4F-NEXT:    vmov.f32 s0, #1.000000e+00
; CHECK-M4F-NEXT:    bl test_1float
; CHECK-M4F-NEXT:    pop {r7, pc}
  call arm_aapcs_vfpcc void @test_1float({ float } { float 1.0 })
  ret void
}

define arm_aapcs_vfpcc void @test_2float({ float, float } %a) {
; CHECK-LABEL: test_2float:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    vmov.f32 s0, #1.000000e+00
; CHECK-NEXT:    vmov.f32 s1, #2.000000e+00
; CHECK-NEXT:    bl test_2float
; CHECK-NEXT:    pop {r11, pc}
;
; CHECK-M4F-LABEL: test_2float:
; CHECK-M4F:       @ %bb.0:
; CHECK-M4F-NEXT:    .save {r7, lr}
; CHECK-M4F-NEXT:    push {r7, lr}
; CHECK-M4F-NEXT:    vmov.f32 s0, #1.000000e+00
; CHECK-M4F-NEXT:    vmov.f32 s1, #2.000000e+00
; CHECK-M4F-NEXT:    bl test_2float
; CHECK-M4F-NEXT:    pop {r7, pc}
  call arm_aapcs_vfpcc void @test_2float({ float, float } { float 1.0, float 2.0 })
  ret void
}

define arm_aapcs_vfpcc void @test_3float({ float, float, float } %a) {
; CHECK-LABEL: test_3float:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    vmov.f32 s0, #1.000000e+00
; CHECK-NEXT:    vmov.f32 s1, #2.000000e+00
; CHECK-NEXT:    vmov.f32 s2, #3.000000e+00
; CHECK-NEXT:    bl test_3float
; CHECK-NEXT:    pop {r11, pc}
;
; CHECK-M4F-LABEL: test_3float:
; CHECK-M4F:       @ %bb.0:
; CHECK-M4F-NEXT:    .save {r7, lr}
; CHECK-M4F-NEXT:    push {r7, lr}
; CHECK-M4F-NEXT:    vmov.f32 s0, #1.000000e+00
; CHECK-M4F-NEXT:    vmov.f32 s1, #2.000000e+00
; CHECK-M4F-NEXT:    vmov.f32 s2, #3.000000e+00
; CHECK-M4F-NEXT:    bl test_3float
; CHECK-M4F-NEXT:    pop {r7, pc}
  call arm_aapcs_vfpcc void @test_3float({ float, float, float } { float 1.0, float 2.0, float 3.0 })
  ret void
}

define arm_aapcs_vfpcc void @test_1double({ double } %a) {
; CHECK-LABEL: test_1double:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    vmov.f64 d0, #1.000000e+00
; CHECK-NEXT:    bl test_1double
; CHECK-NEXT:    pop {r11, pc}
;
; CHECK-M4F-LABEL: test_1double:
; CHECK-M4F:       @ %bb.0:
; CHECK-M4F-NEXT:    .save {r7, lr}
; CHECK-M4F-NEXT:    push {r7, lr}
; CHECK-M4F-NEXT:    vldr d0, .LCPI3_0
; CHECK-M4F-NEXT:    bl test_1double
; CHECK-M4F-NEXT:    pop {r7, pc}
; CHECK-M4F-NEXT:    .p2align 3
; CHECK-M4F-NEXT:  @ %bb.1:
; CHECK-M4F-NEXT:  .LCPI3_0:
; CHECK-M4F-NEXT:    .long 0 @ double 1
; CHECK-M4F-NEXT:    .long 1072693248
  call arm_aapcs_vfpcc void @test_1double({ double } { double 1.0 })
  ret void
}

; Final double argument might be put in s15 & [sp] if we're careless. It should
; go all on the stack.
define arm_aapcs_vfpcc void @test_1double_nosplit([4 x float], [4 x double], [3 x float], double %a) {
; CHECK-LABEL: test_1double_nosplit:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, sp, #8
; CHECK-NEXT:    vmov.f64 d16, #1.000000e+00
; CHECK-NEXT:    vstr d16, [sp]
; CHECK-NEXT:    bl test_1double_nosplit
; CHECK-NEXT:    add sp, sp, #8
; CHECK-NEXT:    pop {r11, pc}
;
; CHECK-M4F-LABEL: test_1double_nosplit:
; CHECK-M4F:       @ %bb.0:
; CHECK-M4F-NEXT:    .save {r7, lr}
; CHECK-M4F-NEXT:    push {r7, lr}
; CHECK-M4F-NEXT:    .pad #8
; CHECK-M4F-NEXT:    sub sp, #8
; CHECK-M4F-NEXT:    movs r0, #0
; CHECK-M4F-NEXT:    movt r0, #16368
; CHECK-M4F-NEXT:    movs r1, #0
; CHECK-M4F-NEXT:    strd r1, r0, [sp]
; CHECK-M4F-NEXT:    bl test_1double_nosplit
; CHECK-M4F-NEXT:    add sp, #8
; CHECK-M4F-NEXT:    pop {r7, pc}
  call arm_aapcs_vfpcc void @test_1double_nosplit([4 x float] undef, [4 x double] undef, [3 x float] undef, double 1.0)
  ret void
}

; Final double argument might go at [sp, #4] if we're careless. Should go at
; [sp, #8] to preserve alignment.
define arm_aapcs_vfpcc void @test_1double_misaligned([4 x double], [4 x double], float, double) {
; CHECK-LABEL: test_1double_misaligned:
; CHECK:       @ %bb.0:
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    .pad #16
; CHECK-NEXT:    sub sp, sp, #16
; CHECK-NEXT:    vmov.f64 d16, #1.000000e+00
; CHECK-NEXT:    vstr d16, [sp, #8]
; CHECK-NEXT:    bl test_1double_misaligned
; CHECK-NEXT:    add sp, sp, #16
; CHECK-NEXT:    pop {r11, pc}
;
; CHECK-M4F-LABEL: test_1double_misaligned:
; CHECK-M4F:       @ %bb.0:
; CHECK-M4F-NEXT:    .save {r7, lr}
; CHECK-M4F-NEXT:    push {r7, lr}
; CHECK-M4F-NEXT:    .pad #16
; CHECK-M4F-NEXT:    sub sp, #16
; CHECK-M4F-NEXT:    movs r0, #0
; CHECK-M4F-NEXT:    movt r0, #16368
; CHECK-M4F-NEXT:    movs r1, #0
; CHECK-M4F-NEXT:    strd r1, r0, [sp, #8]
; CHECK-M4F-NEXT:    bl test_1double_misaligned
; CHECK-M4F-NEXT:    add sp, #16
; CHECK-M4F-NEXT:    pop {r7, pc}
  call arm_aapcs_vfpcc void @test_1double_misaligned([4 x double] undef, [4 x double] undef, float undef, double 1.0)

  ret void
}
