/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_dev_riscv_pri_h__
#define __ls10_dev_riscv_pri_h__
/* This file is autogenerated.  Do not edit */
#define NV_FALCON2_SOE_BASE 0x00841000
#define NV_PRISCV_RISCV_IRQMASK                                                                        0x00000528     /* R--4R */
#define NV_PRISCV_RISCV_IRQDEST                                                                        0x0000052c     /* RW-4R */
#define NV_PRISCV_RISCV_IRQDELEG                                                                       0x00000534     /* RW-4R */
#define NV_PRISCV_RISCV_CPUCTL                                                                         0x00000388     /* RW-4R */
#define NV_PRISCV_RISCV_RPC                                                                            0x000003ec     /* R--4R */
#define NV_PRISCV_RISCV_TRACECTL                                                                       0x00000400     /* RW-4R */
#define NV_PRISCV_RISCV_TRACECTL_LOW_THSHD                                                             7:0            /* RWIVF */
#define NV_PRISCV_RISCV_TRACECTL_LOW_THSHD_INIT                                                        0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACECTL_HIGH_THSHD                                                            15:8           /* RWIVF */
#define NV_PRISCV_RISCV_TRACECTL_HIGH_THSHD_INIT                                                       0x000000ff     /* RWI-V */
#define NV_PRISCV_RISCV_TRACECTL_UMODE_ENABLE                                                          20:20          /* RWIVF */
#define NV_PRISCV_RISCV_TRACECTL_UMODE_ENABLE_FALSE                                                    0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACECTL_UMODE_ENABLE_TRUE                                                     0x00000001     /* RW--V */
#define NV_PRISCV_RISCV_TRACECTL_SMODE_ENABLE                                                          21:21          /* RWIVF */
#define NV_PRISCV_RISCV_TRACECTL_SMODE_ENABLE_FALSE                                                    0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACECTL_SMODE_ENABLE_TRUE                                                     0x00000001     /* RW--V */
#define NV_PRISCV_RISCV_TRACECTL_MMODE_ENABLE                                                          23:23          /* RWIVF */
#define NV_PRISCV_RISCV_TRACECTL_MMODE_ENABLE_FALSE                                                    0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACECTL_MMODE_ENABLE_TRUE                                                     0x00000001     /* RW--V */
#define NV_PRISCV_RISCV_TRACECTL_MODE                                                                  25:24          /* RWIVF */
#define NV_PRISCV_RISCV_TRACECTL_MODE_FULL                                                             0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACECTL_MODE_REDUCED                                                          0x00000001     /* RW--V */
#define NV_PRISCV_RISCV_TRACECTL_MODE_STACK                                                            0x00000002     /* RW--V */
#define NV_PRISCV_RISCV_TRACECTL_BELOW_LO                                                              27:27          /* RWIVF */
#define NV_PRISCV_RISCV_TRACECTL_BELOW_LO_INIT                                                         0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACECTL_ABOVE_HI                                                              28:28          /* RWIVF */
#define NV_PRISCV_RISCV_TRACECTL_ABOVE_HI_INIT                                                         0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACECTL_INTR_ENABLE                                                           29:29          /* R-IVF */
#define NV_PRISCV_RISCV_TRACECTL_INTR_ENABLE_FALSE                                                     0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_TRACECTL_INTR_ENABLE_TRUE                                                      0x00000001     /* R---V */
#define NV_PRISCV_RISCV_TRACECTL_FULL                                                                  30:30          /* RWIVF */
#define NV_PRISCV_RISCV_TRACECTL_FULL_INIT                                                             0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACECTL_EMPTY                                                                 31:31          /* RWIVF */
#define NV_PRISCV_RISCV_TRACECTL_EMPTY_INIT                                                            0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACE_RDIDX                                                                    0x00000404     /* RW-4R */
#define NV_PRISCV_RISCV_TRACE_RDIDX_RDIDX                                                              7:0            /* RWIVF */
#define NV_PRISCV_RISCV_TRACE_RDIDX_RDIDX_INIT                                                         0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACE_RDIDX_RSVD0                                                              15:8           /* R-IVF */
#define NV_PRISCV_RISCV_TRACE_RDIDX_RSVD0_INIT                                                         0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_TRACE_RDIDX_MAXIDX                                                             23:16          /* R-IVF */
#define NV_PRISCV_RISCV_TRACE_RDIDX_MAXIDX_INIT                                                        0x0000003f     /* R-I-V */
#define NV_PRISCV_RISCV_TRACE_RDIDX_RSVD1                                                              31:24          /* R-IVF */
#define NV_PRISCV_RISCV_TRACE_RDIDX_RSVD1_INIT                                                         0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_TRACE_WTIDX                                                                    0x00000408     /* RW-4R */
#define NV_PRISCV_RISCV_TRACE_WTIDX_WTIDX                                                              31:24          /* RWIVF */
#define NV_PRISCV_RISCV_TRACE_WTIDX_WTIDX_INIT                                                         0x00000000     /* RWI-V */
#define NV_PRISCV_RISCV_TRACE_WTIDX_RSVD1                                                              23:0           /* R-IVF */
#define NV_PRISCV_RISCV_TRACE_WTIDX_RSVD1_INIT                                                         0x00000000     /* R-I-V */
#define NV_PRISCV_RISCV_TRACEPC_HI                                                                     0x00000410     /* RW-4R */
#define NV_PRISCV_RISCV_TRACEPC_LO                                                                     0x0000040c     /* RW-4R */
#define NV_PRISCV_RISCV_PRIV_ERR_STAT                                                                  0x00000500     /* RW-4R */
#define NV_PRISCV_RISCV_PRIV_ERR_INFO                                                                  0x00000504     /* R--4R */
#define NV_PRISCV_RISCV_PRIV_ERR_ADDR                                                                  0x00000508     /* R--4R */
#define NV_PRISCV_RISCV_PRIV_ERR_ADDR_HI                                                               0x0000050c     /* R--4R */
#define NV_PRISCV_RISCV_HUB_ERR_STAT                                                                   0x00000510     /* RW-4R */
#define NV_PRISCV_RISCV_BCR_CTRL                                                                       0x00000668     /* RW-4R */
#endif // __ls10_dev_riscv_pri_h__
