#!/usr/bin/awk -f
#
#    Converts units.csv into units.i
#
#    Copyright (C) 2011-2019 Alois Schloegl <alois.schloegl@gmail.com>
#    This file is part of the "BioSig for C/C++" repository
#    (biosig4c++) at http://biosig.sf.net/
#
#    BioSig is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 3
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.


BEGIN { FS = ","; 
	print "#if 0\n### This file is autogenerated - Do not modify it !!! ###\n"; 
}

{
	if (NR < 14) {
		printf("%s\n", $0);
	} else if (NR == 14) {
		printf("#endif\n");
	}
}

/^[^#,]/ { 
	split( $0, a, "\""); 
	sub(/\[.*\]/, "",a[2]); 
	sub(/ *$/, "",a[2]); 
	printf("\t{ %i, \"%s\" }, \n",$1, a[2]);

}


