1;

% The N, M and R should be even and positive (note: R != 0).
% ft=fft(f)/(sqrt(2*pi)*M)
N=2^16;
M=2^12;
R=1*2^11+2^10;
%N=2^3;
%M=2^2;
%R=2^1;

%t=j/M; omega =(2*pi*M*j)/N;
T=N/M;
domega=(2*pi*M)/N;
Omega=2*pi*M;
dt=1/M;
r=R/M;

function result = sa(x);
  result = sinc(x./pi);
endfunction;

t=[-N/2:N/2-1]/M;
omega=[-N/2:N/2-1]*(M/N)*2*pi;
Lambda_ramp=[0:1:R]/R;
Psi_ramp=(1+sin([-R:2:R]*(pi/(2*R))))./2;
midflat=ones(1,M-R-1);
wingflat=zeros(1,(N-M-R)/2-1);
Lambda=[0, wingflat, Lambda_ramp, midflat, fliplr(Lambda_ramp), wingflat];
Psi=[0, wingflat, Psi_ramp, midflat, fliplr(Psi_ramp), wingflat];
ft_Lambda=fftshift(fft(ifftshift(Lambda)))/(sqrt(2*pi)*M);
ft_Psi=fftshift(fft(ifftshift(Psi)))/(sqrt(2*pi)*M);

function result = jt(N, M, t1);
  result = round(N/2+M*t1)+1;
endfunction;

function result = jomega(N, M, omega1);
  result = round(N/2+(N*omega1)/(2*pi*M))+1;
endfunction;

function result = ft_Lambda_anal(r, v);
  result = (sa(r*v/2) .* sa(v/2)) / sqrt(2*pi);
endfunction;

function result = ft_Psi_anal(r, v);
  result = (cos(r*v/2) .* sa(v/2)) ./ (sqrt(2*pi) * (1-((r*v)/pi).^2));
endfunction;

ft_Lambda2 = ft_Lambda_anal(r, omega);
ft_Psi2 = ft_Psi_anal(r, omega);

subplot(2, 1, 1);
plot(omega, real(ft_Lambda), omega, ft_Lambda2, omega, real(ft_Lambda) - ft_Lambda2); xl=30; xlim([-xl xl]);
subplot(2, 1, 2);
plot(omega, real(ft_Psi), omega, ft_Psi2, omega, real(ft_Psi) - ft_Psi2); xl=30; xlim([-xl xl]);

