// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using Microsoft.EntityFrameworkCore.Internal;

namespace Microsoft.EntityFrameworkCore.Metadata.Internal;

/// <summary>
///     This is an internal API that supports the Entity Framework Core infrastructure and not subject to
///     the same compatibility standards as public APIs. It may be changed or removed without notice in
///     any release. You should only use it directly in your code with extreme caution and knowing that
///     doing so can result in application failures when updating to a new Entity Framework Core release.
/// </summary>
public static class RelationalTypeBaseExtensions
{
    /// <summary>
    ///     This is an internal API that supports the Entity Framework Core infrastructure and not subject to
    ///     the same compatibility standards as public APIs. It may be changed or removed without notice in
    ///     any release. You should only use it directly in your code with extreme caution and knowing that
    ///     doing so can result in application failures when updating to a new Entity Framework Core release.
    /// </summary>
    public static IEnumerable<ITableMappingBase> GetViewOrTableMappings(this ITypeBase typeBase)
    {
        typeBase.Model.EnsureRelationalModel();
        return (IEnumerable<ITableMappingBase>?)(typeBase.FindRuntimeAnnotationValue(
                    RelationalAnnotationNames.ViewMappings)
                ?? typeBase.FindRuntimeAnnotationValue(RelationalAnnotationNames.TableMappings))
            ?? Enumerable.Empty<ITableMappingBase>();
    }
}
