/*
 * Copyright 2024-2025 Nico Sonack <nsonack@herrhotzenplotz.de>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided
 * with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef GCLI_PATH_H
#define GCLI_PATH_H

#include <gcli/gcli.h>

struct gcli_path {
	gcli_forge_type forge_type;
	enum {
		GCLI_PATH_DEFAULT = 0,
		GCLI_PATH_URL,
		GCLI_PATH_BUGZILLA,
		GCLI_PATH_ID,
		GCLI_PATH_PID_ID,
		GCLI_PATH_NAMED, /* owner, repo, string-id, required for Github labels */
	} kind;

	union {
		struct {
			char *owner;
			char *repo;
			gcli_id id;
		} as_default;

		struct {
			gcli_id project_id;
			gcli_id id;
		} as_pid_id;

		struct {
			char *product;
			char *component;
		} as_bugzilla;

		gcli_id as_id;
		char *as_url;

		struct {
			char *owner;
			char *repo;
			char *id;
		} as_named;
	};
};

void gcli_path_free(struct gcli_path *);

#endif /* GCLI_PATH_H */
