/**
 * Provides classes and interfaces for the main picocli {@linkplain picocli.CommandLine command line parsing} and
 * {@link picocli.AutoComplete autocompletion} functionality.
 * <p>
 * The {@link picocli.CommandLine CommandLine} class is a one-file framework for creating Java command line
 * applications with almost zero code.
 *
 * {@code CommandLine} is in a single file, so it can be included in source form.
 * This lets users run picocli-based applications without requiring picocli as an external dependency.
 * </p>
 * <h2>Classes and Interfaces for Defining a CommandSpec Model</h2>
 * <p>
 * <img src="doc-files/class-diagram-definition.png" alt="Classes and Interfaces for Defining a CommandSpec Model">
 * </p>
 * <h2>Classes Related to Parsing Command Line Arguments</h2>
 * <p>
 * <img src="doc-files/class-diagram-parsing.png" alt="Classes Related to Parsing Command Line Arguments">
 * </p>
 * <h2>Class Diagram of the Picocli Exceptions</h2>
 * <p>
 * <img src="doc-files/class-diagram-exceptions.png" alt="Class Diagram of the Picocli Exceptions">
 * </p>
 * <h2>Class Diagram of the CommandLine.Help API</h2>
 * <p>
 * <img src="doc-files/class-diagram-help-api.png" alt="Class Diagram of the CommandLine.Help API">
 * </p>
 */
package picocli;
