; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=mips -mcpu=mips32r2 -mattr=+micromips -verify-machineinstrs \
; RUN:     -show-mc-encoding < %s | FileCheck --check-prefix=MM2 %s
; RUN: llc -mtriple=mips -mcpu=mips32r6 -mattr=+micromips -verify-machineinstrs \
; RUN:     -show-mc-encoding < %s | FileCheck --check-prefix=MM6 %s

define double @foo(double %a, double %b) {
; MM2-LABEL: foo:
; MM2:       # %bb.0: # %entry
; MM2-NEXT:    mov.d $f0, $f12 # encoding: [0x54,0x0c,0x20,0x7b]
; MM2-NEXT:    mtc1 $zero, $f2 # encoding: [0x54,0x02,0x28,0x3b]
; MM2-NEXT:    mthc1 $zero, $f2 # encoding: [0x54,0x02,0x38,0x3b]
; MM2-NEXT:    c.ule.d $f12, $f2 # encoding: [0x54,0x4c,0x05,0xfc]
; MM2-NEXT:    bc1t $BB0_2 # encoding: [0x43,0xa0,A,A]
; MM2-NEXT:    # fixup A - offset: 0, value: $BB0_2, kind: fixup_MICROMIPS_PC16_S1
; MM2-NEXT:    nop # encoding: [0x00,0x00,0x00,0x00]
; MM2-NEXT:  # %bb.1: # %entry
; MM2-NEXT:    j $BB0_2 # encoding: [0b110101AA,A,A,A]
; MM2-NEXT:    # fixup A - offset: 0, value: $BB0_2, kind: fixup_MICROMIPS_26_S1
; MM2-NEXT:    nop # encoding: [0x00,0x00,0x00,0x00]
; MM2-NEXT:  $BB0_2: # %return
; MM2-NEXT:    jrc $ra # encoding: [0x45,0xbf]
;
; MM6-LABEL: foo:
; MM6:       # %bb.0: # %entry
; MM6-NEXT:    mov.d $f0, $f12 # encoding: [0x54,0x0c,0x20,0x7b]
; MM6-NEXT:    mtc1 $zero, $f1 # encoding: [0x54,0x01,0x28,0x3b]
; MM6-NEXT:    mthc1 $zero, $f1 # encoding: [0x54,0x01,0x38,0x3b]
; MM6-NEXT:    cmp.ule.d $f1, $f12, $f1 # encoding: [0x54,0x2c,0x09,0xd5]
; MM6-NEXT:    mfc1 $2, $f1 # encoding: [0x54,0x41,0x20,0x3b]
; MM6-NEXT:    andi16 $2, $2, 1 # encoding: [0x2d,0x21]
; MM6-NEXT:    jrc $ra # encoding: [0x45,0xbf]
entry:
  %cmp = fcmp ogt double %a, 0.000000e+00
  br i1 %cmp, label %if.end, label %if.else

if.else:
  br label %return

if.end:
  %mul = fmul double %a, 2.000000e+00
  br label %return

return:
  ret double %a
}

define double @bar(double %x, double %y) {
; MM2-LABEL: bar:
; MM2:       # %bb.0: # %entry
; MM2-NEXT:    mov.d $f0, $f14 # encoding: [0x54,0x0e,0x20,0x7b]
; MM2-NEXT:    c.olt.d $f12, $f14 # encoding: [0x55,0xcc,0x05,0x3c]
; MM2-NEXT:    jr $ra # encoding: [0x00,0x1f,0x0f,0x3c]
; MM2-NEXT:    movt.d $f0, $f12, $fcc0 # encoding: [0x54,0x0c,0x02,0x60]
;
; MM6-LABEL: bar:
; MM6:       # %bb.0: # %entry
; MM6-NEXT:    cmp.lt.d $f0, $f12, $f14 # encoding: [0x55,0xcc,0x01,0x15]
; MM6-NEXT:    mfc1 $1, $f0 # encoding: [0x54,0x20,0x20,0x3b]
; MM6-NEXT:    mtc1 $1, $f0 # encoding: [0x54,0x20,0x28,0x3b]
; MM6-NEXT:    sel.d $f0, $f14, $f12 # encoding: [0x55,0x8e,0x02,0xb8]
; MM6-NEXT:    jrc $ra # encoding: [0x45,0xbf]
entry:
  %z = fcmp olt double %x, %y
  %r = select i1 %z, double %x, double %y
  ret double %r
}
