; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; Verify that we get the code sequence needed to avoid double-rounding.
; Note that only parts of the sequence are checked for here, to allow
; for minor code generation differences.
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-fpcvt < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-fpcvt -mattr=-isel < %s | FileCheck %s --check-prefix=CHECK-NO-ISEL
; Also check that with -enable-unsafe-fp-math we do not get that extra
; code sequence.  Simply verify that there is no "isel" present.
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-fpcvt -enable-unsafe-fp-math < %s | FileCheck %s -check-prefix=CHECK-UNSAFE
; CHECK-UNSAFE-NOT: isel
target datalayout = "E-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v128:128:128-n32:64"
target triple = "powerpc64-unknown-linux-gnu"

define float @test(i64 %x) nounwind readnone {
; Verify that we get the code sequence needed to avoid double-rounding.
; Note that only parts of the sequence are checked for here, to allow
; for minor code generation differences.
; Also check that with -enable-unsafe-fp-math we do not get that extra
; code sequence.  Simply verify that there is no "isel" present.
; RUN: llc -verify-machineinstrs -mcpu=pwr7 -mattr=-fpcvt -enable-unsafe-fp-math < %s | FileCheck %s -check-prefix=CHECK-UNSAFE
; CHECK-LABEL: test:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrldi 4, 3, 53
; CHECK-NEXT:    sradi 5, 3, 53
; CHECK-NEXT:    addi 4, 4, 2047
; CHECK-NEXT:    addi 5, 5, 1
; CHECK-NEXT:    or 4, 4, 3
; CHECK-NEXT:    cmpldi 5, 1
; CHECK-NEXT:    rldicr 4, 4, 0, 52
; CHECK-NEXT:    iselgt 3, 4, 3
; CHECK-NEXT:    std 3, -8(1)
; CHECK-NEXT:    lfd 0, -8(1)
; CHECK-NEXT:    xscvsxddp 0, 0
; CHECK-NEXT:    frsp 1, 0
; CHECK-NEXT:    blr
;
; CHECK-NO-ISEL-LABEL: test:
; CHECK-NO-ISEL:       # %bb.0: # %entry
; CHECK-NO-ISEL-NEXT:    sradi 4, 3, 53
; CHECK-NO-ISEL-NEXT:    addi 4, 4, 1
; CHECK-NO-ISEL-NEXT:    cmpldi 4, 1
; CHECK-NO-ISEL-NEXT:    bc 4, 1, .LBB0_2
; CHECK-NO-ISEL-NEXT:  # %bb.1:
; CHECK-NO-ISEL-NEXT:    clrldi 4, 3, 53
; CHECK-NO-ISEL-NEXT:    addi 4, 4, 2047
; CHECK-NO-ISEL-NEXT:    or 3, 4, 3
; CHECK-NO-ISEL-NEXT:    rldicr 3, 3, 0, 52
; CHECK-NO-ISEL-NEXT:  .LBB0_2: # %entry
; CHECK-NO-ISEL-NEXT:    std 3, -8(1)
; CHECK-NO-ISEL-NEXT:    lfd 0, -8(1)
; CHECK-NO-ISEL-NEXT:    xscvsxddp 0, 0
; CHECK-NO-ISEL-NEXT:    frsp 1, 0
; CHECK-NO-ISEL-NEXT:    blr
;
; CHECK-UNSAFE-LABEL: test:
; CHECK-UNSAFE:       # %bb.0: # %entry
; CHECK-UNSAFE-NEXT:    std 3, -8(1)
; CHECK-UNSAFE-NEXT:    lfd 0, -8(1)
; CHECK-UNSAFE-NEXT:    xscvsxddp 0, 0
; CHECK-UNSAFE-NEXT:    frsp 1, 0
; CHECK-UNSAFE-NEXT:    blr

entry:
  %conv = sitofp i64 %x to float
  ret float %conv
}


