; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s | FileCheck %s
; RUN: llc < %s -fast-isel -fast-isel-abort=1 | FileCheck %s --check-prefix=FAST

target triple = "wasm32-unknown-unknown"

define void @return_void() {
; CHECK-LABEL: return_void:
; CHECK:         .functype return_void () -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    # fallthrough-return
;
; FAST-LABEL: return_void:
; FAST:         .functype return_void () -> ()
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    # fallthrough-return
  ret void
}

define void @return_void_twice(i32 %a) {
; CHECK-LABEL: return_void_twice:
; CHECK:         .functype return_void_twice (i32) -> ()
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    block
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    i32.eqz
; CHECK-NEXT:    br_if 0 # 0: down to label0
; CHECK-NEXT:  # %bb.1: # %true
; CHECK-NEXT:    i32.const 0
; CHECK-NEXT:    i32.const 0
; CHECK-NEXT:    i32.store 0
; CHECK-NEXT:    return
; CHECK-NEXT:  .LBB1_2: # %false
; CHECK-NEXT:    end_block # label0:
; CHECK-NEXT:    i32.const 0
; CHECK-NEXT:    i32.const 1
; CHECK-NEXT:    i32.store 0
; CHECK-NEXT:    # fallthrough-return
;
; FAST-LABEL: return_void_twice:
; FAST:         .functype return_void_twice (i32) -> ()
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    block
; FAST-NEXT:    local.get 0
; FAST-NEXT:    i32.eqz
; FAST-NEXT:    br_if 0 # 0: down to label0
; FAST-NEXT:  # %bb.1: # %true
; FAST-NEXT:    i32.const 0
; FAST-NEXT:    i32.const 0
; FAST-NEXT:    i32.store 0
; FAST-NEXT:    return
; FAST-NEXT:  .LBB1_2: # %false
; FAST-NEXT:    end_block # label0:
; FAST-NEXT:    i32.const 0
; FAST-NEXT:    i32.const 1
; FAST-NEXT:    i32.store 0
; FAST-NEXT:    # fallthrough-return
  %b = icmp ne i32 %a, 0
  br i1 %b, label %true, label %false

true:
  store i32 0, ptr null
  ret void

false:
  store i32 1, ptr null
  ret void
}
