; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers | FileCheck %s
; RUN: llc < %s -disable-wasm-fallthrough-return-opt -wasm-disable-explicit-locals -wasm-keep-registers -fast-isel -fast-isel-abort=1 | FileCheck %s --check-prefix=FAST

; Test that wasm select instruction is selected from LLVM select instruction.

target triple = "wasm32-unknown-unknown"

define i32 @select_i32_bool(i1 zeroext %a, i32 %b, i32 %c) {
; CHECK-LABEL: select_i32_bool:
; CHECK:         .functype select_i32_bool (i32, i32, i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.select $push0=, $1, $2, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_i32_bool:
; FAST:         .functype select_i32_bool (i32, i32, i32) -> (i32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i32.select $push0=, $1, $2, $0
; FAST-NEXT:    return $pop0
  %cond = select i1 %a, i32 %b, i32 %c
  ret i32 %cond
}

define i32 @select_i32_bool_nozext(i1 %a, i32 %b, i32 %c) {
; CHECK-LABEL: select_i32_bool_nozext:
; CHECK:         .functype select_i32_bool_nozext (i32, i32, i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 1
; CHECK-NEXT:    i32.and $push1=, $0, $pop0
; CHECK-NEXT:    i32.select $push2=, $1, $2, $pop1
; CHECK-NEXT:    return $pop2
;
; FAST-LABEL: select_i32_bool_nozext:
; FAST:         .functype select_i32_bool_nozext (i32, i32, i32) -> (i32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i32.const $push0=, 1
; FAST-NEXT:    i32.and $push1=, $0, $pop0
; FAST-NEXT:    i32.select $push2=, $1, $2, $pop1
; FAST-NEXT:    return $pop2
  %cond = select i1 %a, i32 %b, i32 %c
  ret i32 %cond
}

define i32 @select_i32_eq(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: select_i32_eq:
; CHECK:         .functype select_i32_eq (i32, i32, i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.select $push0=, $2, $1, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_i32_eq:
; FAST:         .functype select_i32_eq (i32, i32, i32) -> (i32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i32.select $push0=, $2, $1, $0
; FAST-NEXT:    return $pop0
  %cmp = icmp eq i32 %a, 0
  %cond = select i1 %cmp, i32 %b, i32 %c
  ret i32 %cond
}

define i32 @select_i32_ne(i32 %a, i32 %b, i32 %c) {
; CHECK-LABEL: select_i32_ne:
; CHECK:         .functype select_i32_ne (i32, i32, i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.select $push0=, $1, $2, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_i32_ne:
; FAST:         .functype select_i32_ne (i32, i32, i32) -> (i32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i32.select $push0=, $1, $2, $0
; FAST-NEXT:    return $pop0
  %cmp = icmp ne i32 %a, 0
  %cond = select i1 %cmp, i32 %b, i32 %c
  ret i32 %cond
}

define i64 @select_i64_bool(i1 zeroext %a, i64 %b, i64 %c) {
; CHECK-LABEL: select_i64_bool:
; CHECK:         .functype select_i64_bool (i32, i64, i64) -> (i64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i64.select $push0=, $1, $2, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_i64_bool:
; FAST:         .functype select_i64_bool (i32, i64, i64) -> (i64)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i64.select $push0=, $1, $2, $0
; FAST-NEXT:    return $pop0
  %cond = select i1 %a, i64 %b, i64 %c
  ret i64 %cond
}

define i64 @select_i64_bool_nozext(i1 %a, i64 %b, i64 %c) {
; CHECK-LABEL: select_i64_bool_nozext:
; CHECK:         .functype select_i64_bool_nozext (i32, i64, i64) -> (i64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 1
; CHECK-NEXT:    i32.and $push1=, $0, $pop0
; CHECK-NEXT:    i64.select $push2=, $1, $2, $pop1
; CHECK-NEXT:    return $pop2
;
; FAST-LABEL: select_i64_bool_nozext:
; FAST:         .functype select_i64_bool_nozext (i32, i64, i64) -> (i64)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i32.const $push0=, 1
; FAST-NEXT:    i32.and $push1=, $0, $pop0
; FAST-NEXT:    i64.select $push2=, $1, $2, $pop1
; FAST-NEXT:    return $pop2
  %cond = select i1 %a, i64 %b, i64 %c
  ret i64 %cond
}

define i64 @select_i64_eq(i32 %a, i64 %b, i64 %c) {
; CHECK-LABEL: select_i64_eq:
; CHECK:         .functype select_i64_eq (i32, i64, i64) -> (i64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i64.select $push0=, $2, $1, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_i64_eq:
; FAST:         .functype select_i64_eq (i32, i64, i64) -> (i64)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i64.select $push0=, $2, $1, $0
; FAST-NEXT:    return $pop0
  %cmp = icmp eq i32 %a, 0
  %cond = select i1 %cmp, i64 %b, i64 %c
  ret i64 %cond
}

define i64 @select_i64_ne(i32 %a, i64 %b, i64 %c) {
; CHECK-LABEL: select_i64_ne:
; CHECK:         .functype select_i64_ne (i32, i64, i64) -> (i64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i64.select $push0=, $1, $2, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_i64_ne:
; FAST:         .functype select_i64_ne (i32, i64, i64) -> (i64)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i64.select $push0=, $1, $2, $0
; FAST-NEXT:    return $pop0
  %cmp = icmp ne i32 %a, 0
  %cond = select i1 %cmp, i64 %b, i64 %c
  ret i64 %cond
}

define float @select_f32_bool(i1 zeroext %a, float %b, float %c) {
; CHECK-LABEL: select_f32_bool:
; CHECK:         .functype select_f32_bool (i32, f32, f32) -> (f32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    f32.select $push0=, $1, $2, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_f32_bool:
; FAST:         .functype select_f32_bool (i32, f32, f32) -> (f32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    f32.select $push0=, $1, $2, $0
; FAST-NEXT:    return $pop0
  %cond = select i1 %a, float %b, float %c
  ret float %cond
}

define float @select_f32_bool_nozext(i1 %a, float %b, float %c) {
; CHECK-LABEL: select_f32_bool_nozext:
; CHECK:         .functype select_f32_bool_nozext (i32, f32, f32) -> (f32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 1
; CHECK-NEXT:    i32.and $push1=, $0, $pop0
; CHECK-NEXT:    f32.select $push2=, $1, $2, $pop1
; CHECK-NEXT:    return $pop2
;
; FAST-LABEL: select_f32_bool_nozext:
; FAST:         .functype select_f32_bool_nozext (i32, f32, f32) -> (f32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i32.const $push0=, 1
; FAST-NEXT:    i32.and $push1=, $0, $pop0
; FAST-NEXT:    f32.select $push2=, $1, $2, $pop1
; FAST-NEXT:    return $pop2
  %cond = select i1 %a, float %b, float %c
  ret float %cond
}

define float @select_f32_eq(i32 %a, float %b, float %c) {
; CHECK-LABEL: select_f32_eq:
; CHECK:         .functype select_f32_eq (i32, f32, f32) -> (f32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    f32.select $push0=, $2, $1, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_f32_eq:
; FAST:         .functype select_f32_eq (i32, f32, f32) -> (f32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    f32.select $push0=, $2, $1, $0
; FAST-NEXT:    return $pop0
  %cmp = icmp eq i32 %a, 0
  %cond = select i1 %cmp, float %b, float %c
  ret float %cond
}

define float @select_f32_ne(i32 %a, float %b, float %c) {
; CHECK-LABEL: select_f32_ne:
; CHECK:         .functype select_f32_ne (i32, f32, f32) -> (f32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    f32.select $push0=, $1, $2, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_f32_ne:
; FAST:         .functype select_f32_ne (i32, f32, f32) -> (f32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    f32.select $push0=, $1, $2, $0
; FAST-NEXT:    return $pop0
  %cmp = icmp ne i32 %a, 0
  %cond = select i1 %cmp, float %b, float %c
  ret float %cond
}

define double @select_f64_bool(i1 zeroext %a, double %b, double %c) {
; CHECK-LABEL: select_f64_bool:
; CHECK:         .functype select_f64_bool (i32, f64, f64) -> (f64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    f64.select $push0=, $1, $2, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_f64_bool:
; FAST:         .functype select_f64_bool (i32, f64, f64) -> (f64)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    f64.select $push0=, $1, $2, $0
; FAST-NEXT:    return $pop0
  %cond = select i1 %a, double %b, double %c
  ret double %cond
}

define double @select_f64_bool_nozext(i1 %a, double %b, double %c) {
; CHECK-LABEL: select_f64_bool_nozext:
; CHECK:         .functype select_f64_bool_nozext (i32, f64, f64) -> (f64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 1
; CHECK-NEXT:    i32.and $push1=, $0, $pop0
; CHECK-NEXT:    f64.select $push2=, $1, $2, $pop1
; CHECK-NEXT:    return $pop2
;
; FAST-LABEL: select_f64_bool_nozext:
; FAST:         .functype select_f64_bool_nozext (i32, f64, f64) -> (f64)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i32.const $push0=, 1
; FAST-NEXT:    i32.and $push1=, $0, $pop0
; FAST-NEXT:    f64.select $push2=, $1, $2, $pop1
; FAST-NEXT:    return $pop2
  %cond = select i1 %a, double %b, double %c
  ret double %cond
}

define double @select_f64_eq(i32 %a, double %b, double %c) {
; CHECK-LABEL: select_f64_eq:
; CHECK:         .functype select_f64_eq (i32, f64, f64) -> (f64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    f64.select $push0=, $2, $1, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_f64_eq:
; FAST:         .functype select_f64_eq (i32, f64, f64) -> (f64)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    f64.select $push0=, $2, $1, $0
; FAST-NEXT:    return $pop0
  %cmp = icmp eq i32 %a, 0
  %cond = select i1 %cmp, double %b, double %c
  ret double %cond
}

define double @select_f64_ne(i32 %a, double %b, double %c) {
; CHECK-LABEL: select_f64_ne:
; CHECK:         .functype select_f64_ne (i32, f64, f64) -> (f64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    f64.select $push0=, $1, $2, $0
; CHECK-NEXT:    return $pop0
;
; FAST-LABEL: select_f64_ne:
; FAST:         .functype select_f64_ne (i32, f64, f64) -> (f64)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    f64.select $push0=, $1, $2, $0
; FAST-NEXT:    return $pop0
  %cmp = icmp ne i32 %a, 0
  %cond = select i1 %cmp, double %b, double %c
  ret double %cond
}

define i32 @pr40805_i32(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: pr40805_i32:
; CHECK:         .functype pr40805_i32 (i32, i32, i32) -> (i32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 1
; CHECK-NEXT:    i32.and $push1=, $0, $pop0
; CHECK-NEXT:    i32.select $push2=, $1, $2, $pop1
; CHECK-NEXT:    return $pop2
;
; FAST-LABEL: pr40805_i32:
; FAST:         .functype pr40805_i32 (i32, i32, i32) -> (i32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i32.const $push1=, 1
; FAST-NEXT:    i32.and $push2=, $0, $pop1
; FAST-NEXT:    i32.select $push0=, $1, $2, $pop2
; FAST-NEXT:    return $pop0
  %a = and i32 %x, 1
  %b = icmp ne i32 %a, 0
  %c = select i1 %b, i32 %y, i32 %z
  ret i32 %c
}

define i64 @pr40805_i64(i64 %x, i64 %y, i64 %z) {
; CHECK-LABEL: pr40805_i64:
; CHECK:         .functype pr40805_i64 (i64, i64, i64) -> (i64)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.wrap_i64 $push0=, $0
; CHECK-NEXT:    i32.const $push1=, 1
; CHECK-NEXT:    i32.and $push2=, $pop0, $pop1
; CHECK-NEXT:    i64.select $push3=, $1, $2, $pop2
; CHECK-NEXT:    return $pop3
;
; FAST-LABEL: pr40805_i64:
; FAST:         .functype pr40805_i64 (i64, i64, i64) -> (i64)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i64.const $push5=, 1
; FAST-NEXT:    i64.and $push6=, $0, $pop5
; FAST-NEXT:    i64.const $push3=, 0
; FAST-NEXT:    i64.ne $push4=, $pop6, $pop3
; FAST-NEXT:    i32.const $push0=, 1
; FAST-NEXT:    i32.and $push1=, $pop4, $pop0
; FAST-NEXT:    i64.select $push2=, $1, $2, $pop1
; FAST-NEXT:    return $pop2
  %a = and i64 %x, 1
  %b = icmp ne i64 %a, 0
  %c = select i1 %b, i64 %y, i64 %z
  ret i64 %c
}

define float @pr44012_i32(i32 %x, float %y, float %z) {
; CHECK-LABEL: pr44012_i32:
; CHECK:         .functype pr44012_i32 (i32, f32, f32) -> (f32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.const $push0=, 1
; CHECK-NEXT:    i32.and $push1=, $0, $pop0
; CHECK-NEXT:    f32.select $push2=, $1, $2, $pop1
; CHECK-NEXT:    return $pop2
;
; FAST-LABEL: pr44012_i32:
; FAST:         .functype pr44012_i32 (i32, f32, f32) -> (f32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i32.const $push1=, 1
; FAST-NEXT:    i32.and $push2=, $0, $pop1
; FAST-NEXT:    f32.select $push0=, $1, $2, $pop2
; FAST-NEXT:    return $pop0
  %a = and i32 %x, 1
  %b = icmp ne i32 %a, 0
  %c = select i1 %b, float %y, float %z
  ret float %c
}

define float @pr44012_i64(i64 %x, float %y, float %z) {
; CHECK-LABEL: pr44012_i64:
; CHECK:         .functype pr44012_i64 (i64, f32, f32) -> (f32)
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    i32.wrap_i64 $push0=, $0
; CHECK-NEXT:    i32.const $push1=, 1
; CHECK-NEXT:    i32.and $push2=, $pop0, $pop1
; CHECK-NEXT:    f32.select $push3=, $1, $2, $pop2
; CHECK-NEXT:    return $pop3
;
; FAST-LABEL: pr44012_i64:
; FAST:         .functype pr44012_i64 (i64, f32, f32) -> (f32)
; FAST-NEXT:  # %bb.0:
; FAST-NEXT:    i64.const $push5=, 1
; FAST-NEXT:    i64.and $push6=, $0, $pop5
; FAST-NEXT:    i64.const $push3=, 0
; FAST-NEXT:    i64.ne $push4=, $pop6, $pop3
; FAST-NEXT:    i32.const $push0=, 1
; FAST-NEXT:    i32.and $push1=, $pop4, $pop0
; FAST-NEXT:    f32.select $push2=, $1, $2, $pop1
; FAST-NEXT:    return $pop2
  %a = and i64 %x, 1
  %b = icmp ne i64 %a, 0
  %c = select i1 %b, float %y, float %z
  ret float %c
}
